/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.kawa.functions.ObjectFormat;
import gnu.kawa.io.OutPort;
import gnu.kawa.io.PrettyWriter;
import gnu.text.PadFormat;
import gnu.text.ReportFormat;
import java.io.IOException;
import java.text.FieldPosition;

class LispObjectFormat
extends ReportFormat {
    int minWidth;
    int colInc;
    int minPad;
    int padChar;
    int where;
    ObjectFormat base;

    public LispObjectFormat(ObjectFormat base2, int minWidth, int colInc, int minPad, int padChar, int where) {
        this.base = base2;
        this.minWidth = minWidth;
        this.colInc = colInc;
        this.minPad = minPad;
        this.padChar = padChar;
        this.where = where;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int format(Object[] args, int start, Appendable dst, FieldPosition fpos) throws IOException {
        int minWidth = LispObjectFormat.getParam(this.minWidth, 0, args, start);
        if (this.minWidth == -1610612736) {
            ++start;
        }
        int colInc = LispObjectFormat.getParam(this.colInc, 1, args, start);
        if (this.colInc == -1610612736) {
            ++start;
        }
        int minPad = LispObjectFormat.getParam(this.minPad, 0, args, start);
        if (this.minPad == -1610612736) {
            ++start;
        }
        char padChar = LispObjectFormat.getParam(this.padChar, ' ', args, start);
        if (this.padChar == -1610612736) {
            ++start;
        }
        if (this.base.readable && dst instanceof OutPort && minWidth == 0) {
            PrettyWriter pdst = ((OutPort)dst).getPrettyWriter();
            pdst.initialiseIDHash();
            pdst.setSharing(true);
            try {
                int n = this.base.format(args, start, dst, fpos);
                return n;
            }
            finally {
                pdst.setSharing(false);
                pdst.finishIDHash();
            }
        }
        return PadFormat.format(this.base, args, start, dst, padChar, minWidth, colInc, minPad, this.where, fpos);
    }
}

