/**
* GNU LibreJS - A browser add-on to block nonfree nontrivial JavaScript.
* *
* Copyright (C) 2017 Nathan Nichols
*
* This file is part of GNU LibreJS.
*
* GNU LibreJS is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* GNU LibreJS is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with GNU LibreJS.  If not, see <http://www.gnu.org/licenses/>.
*/

/**
*	
*	Sets global variable "webex" to either "chrome" or "browser" for
*	use on Chrome or a Firefox variant.
*
*	Change this to support a new browser that isn't Chrome or Firefox,
*	given that it supports webExtensions.
*
*	(Use the variable "webex" for all API calls after calling this)
*/
var store;
function set_webex(){
	if(typeof(browser) == "undefined"){
		webex = chrome;
	} else{
		webex = browser;
	}
}
set_webex();

function storage_got(items){
	var inputs = document.getElementsByTagName("input");

	if(items["pref_whitelist"] == "undefined"){
			items["pref_whitelist"] = "";
	}

	if(items["pref_subject"] == "undefined" || items["pref_subject"] == ""){
			items["pref_subject"] = "Issues with Javascript on your website";
	}

	if(items["pref_body"] == "undefined" || items["pref_body"] == ""){
			items["pref_body"] = "Please consider using a free license for the Javascript on your website. [Message generated by LibreJS. See https://www.gnu.org/software/librejs/ for more information]";
	}

	for(var i = 0; i < inputs.length; i++){
		if(inputs[i].id.indexOf("pref_") != -1){
			if(inputs[i].type == "checkbox" && items[inputs[i].id]){
				inputs[i].checked = true;
			}
			if(inputs[i].type == "text" && items[inputs[i].id] != undefined){
				inputs[i].value = items[inputs[i].id];
			} 
		}
	}


}
webex.storage.local.get(storage_got);

document.getElementById("save_changes").addEventListener("click", function(){
	var inputs = document.getElementsByTagName("input");
	// TODO: validate/sanitize the user inputs
	var data = {};
	for(var i = 0; i < inputs.length; i++){
		if(inputs[i].id.indexOf("pref_") != -1){
			var input_val = "";
			if(inputs[i].type == "checkbox"){
				input_val = inputs[i].checked;
			} else{
				if(inputs[i.value] != "undefined"){
					input_val = inputs[i].value;
				} else{
					input_val = "";
				}
			}
			var input_id = inputs[i].id;
			data[input_id] = input_val;
		}
	}
	console.log(data);

	webex.storage.local.set(data);
});


