/*
 GNU Maverik - a system for managing display and interaction in 
               Virtual Environment applications.
 Copyright (C) 1999-2001 Advanced Interfaces Group

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA


 The authors can be contacted via:
 www   - http://aig.cs.man.ac.uk
 email - maverik@aig.cs.man.ac.uk
 mail  - Advanced Interfaces Group, Room 2.94, Computer Science Building, 
         University of Manchester, Manchester, M13 9PL, UK
*/

#ifndef _MAVLIB_D3D_INCLUDE
#define _MAVLIB_D3D_INCLUDE

#include <ddraw.h>
#include <d3d.h>


#ifdef __cplusplus
extern "C" {
#endif

#define MAVLIB_WIDTH 640
#define MAVLIB_HEIGHT 480
#define MAVLIB_BITS 16
#define MAVLIB_ZBITS 16
#define GFX_MAX_TEXTURE 1000

/* Direct Draw globals */
extern LPDIRECTDRAW7 mavlib_DD;
extern LPDIRECT3D7 mavlib_D3D;
extern LPDIRECT3DDEVICE7 mavlib_D3DDevice;
extern LPDIRECTDRAWSURFACE7 mavlib_D3DSurface;
extern LPDIRECTDRAWSURFACE7 mavlib_backBuffer;
extern LPDIRECTDRAWSURFACE7 mavlib_ZBuffer;
extern DDPIXELFORMAT mavlib_texRGB;
extern DDPIXELFORMAT mavlib_tex1A;
extern DDPIXELFORMAT mavlib_texRGBA;
extern int mavlib_gfx_software;
extern int mavlib_gfx_aa;
extern LPDIRECTDRAWSURFACE7 mavlib_textures[GFX_MAX_TEXTURE];
extern int mavlib_2d_x;
extern int mavlib_2d_y;
extern int mavlib_col_r;
extern int mavlib_col_g;
extern int mavlib_col_b;

/* D3D error traps */
/* call without checking */
#define MAVD3D(a,b) a;
/* exit on error */
#define MAVD3DERR(a,b) if (a != D3D_OK) {fprintf(stderr, "Error: %s\n",b); exit (1);}
/* warn on error */
#define MAVD3DWARN(a,b) if (a != D3D_OK) {fprintf(stderr, "Warning: %s\n",b);}

/* end of Direct Draw globals */

#ifdef __cplusplus
}
#endif

#endif


