/* debug.h

   written by Don R. Maszle
   21 April 1992
   
   Copyright (c) 1993.  Don Maszle, Frederic Bois.  All rights reserved.

   -- Revisions -----
     Logfile:  SCCS/s.debug.h
    Revision:  1.1
        Date:  7/14/93
     Modtime:  19:14:58
      Author:  @a
   -- SCCS  ---------

   Macros for quick debugging
*/

#include "stdio.h"

#ifdef NDEBUG                   /*-- Turn DEBUGging off */
#ifdef DEBUG
#undef DEBUG
#endif
#endif

typedef struct tagDEBUGINFO {
  FILE *pfileDebug;

} DEBUGINFO, DBI;  /* tagDEBUGINFO */


#ifdef DEBUG
#include "time.h"

#define OpenDebug(filename) \
  {if (!(vdbi.pfileDebug = fopen(filename, "a"))) { \
    fprintf (stderr, "* Can't open file \"%s\" for debugging\n", filename); \
    exit(-1); \
  }  /* if */ \
  else { \
    time_t tt; \
    time(&tt); \
    fprintf (vdbi.pfileDebug, \
             "-- Opened \"%s\"  %s\n", filename, ctime(&tt));}}
  
#define DebugF(szFormat, var) \
  {fprintf(vdbi.pfileDebug, "File: \"%s\"  line:%4d:", __FILE__, __LINE__); \
   fprintf(vdbi.pfileDebug, szFormat, var); \
   fflush(vdbi.pfileDebug);}
#define Debug(szFormat, var) fprintf(vdbi.pfileDebug, szFormat, var)
#define FlushDebug() fflush(vdbi.pfileDebug)

#define Debugi(var) fprintf(vdbi.pfileDebug, #var "=%-d ", var)
#define Debugl(var) fprintf(vdbi.pfileDebug, #var "=%-ld ", var)
#define Debugx(var) fprintf(vdbi.pfileDebug, #var "=%-x ", var)
#define Debugd(var) fprintf(vdbi.pfileDebug, #var "=%-g ", var)

#define Debugrg(var, cElem, lStart, szFormatOne) \
  {long __DBRG_i; \
   fprintf(vdbi.pfileDebug, #var "[]"); \
   for (__DBRG_i=(lStart); __DBRG_i < (lStart)+(cElem); __DBRG_i++) \
     fprintf(vdbi.pfileDebug, " %2ld:" szFormatOne, __DBRG_i, (var)[__DBRG_i]); \
   fprintf(vdbi.pfileDebug, "\n");}

#define Debugin(var) fprintf(vdbi.pfileDebug, #var "=%-d \n", var)
#define Debugln(var) fprintf(vdbi.pfileDebug, #var "=%-ld \n", var)
#define Debugxn(var) fprintf(vdbi.pfileDebug, #var "=%-x \n", var)
#define Debugdn(var) fprintf(vdbi.pfileDebug, #var "=%-g \n", var)
#define Debugn() fprintf(vdbi.pfileDebug, "\n")

#else
#define OpenDebug(filename)         
#define Debugf(szFormat, var)
#define Debug(szFormat, var)
#define FlushDebug()
#define Debugi(var)
#define Debugl(var)
#define Debugx(var)
#define Debugd(var)
#define Debugin(var)
#define Debugln(var)
#define Debugxn(var)
#define Debugdn(var)
#define Debugrg(var, cElem, lStart, szFormatOne)
#define Debugn()
#endif
