/* mdb.c: -*- C -*-  Meta-HTML Debugger. */

/* Author: Brian J. Fox (bfox@ai.mit.edu) Sat Sep 30 07:10:16 1995.

   This file is part of <Meta-HTML>(tm), a system for the rapid deployment
   of Internet and Intranet applications via the use of the Meta-HTML
   language.

   Copyright (c) 1995, 1996, Brian J. Fox (bfox@ai.mit.edu).
   Copyright (c) 1996, Universal Access Inc. (http://www.ua.com).

   Meta-HTML is free software; you can redistribute it and/or modify
   it under the terms of the UAI Free Software License as published
   by Universal Access Inc.; either version 1, or (at your option) any
   later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   UAI Free Software License for more details.

   You should have received a copy of the UAI Free Software License
   along with this program; if you have not, you may obtain one by
   writing to:

   Universal Access Inc.
   129 El Paseo Court
   Santa Barbara, CA
   93101  */

#if defined (HAVE_CONFIG_H)
#  include <config.h>
#endif

#if !defined (MHTML_SYSTEM_TYPE)
#  define MHTML_SYSTEM_TYPE "Incorrectly Compiled"
#endif

#define LANGUAGE_DEFINITIONS_FILE 1

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <setjmp.h>
#include <bprintf/bprintf.h>
#include <xmalloc/xmalloc.h>
#include "pages.h"
#include "session_data.h"
#include "parser.h"
#include "mdb.h"
#include "commands.h"

extern char *readline (char *prompt);
extern void add_history (char *string);
extern void mdb_initialize_readline (void);

extern char **environ;

static void initialize_mdb (int argc, char *argv[]);
PAGE *mdb_page;

#if !defined (MHTML_VERSION_STRING)
static char *mhtml_version_string = "";
#else
static char *mhtml_version_string = MHTML_VERSION_STRING;
#endif

/* Non-zero when --config has been seen. */
static int config_arg_given = 0;

int MDB_Interrupted = 0;

jmp_buf mdb_top_level_jmp_buffer;

int mdb_loop_level = 0;
void mdb_loop (void);

int
main (int argc, char *argv[])
{
  if (!*metahtml_copyright_string)
    abort ();

  printf ("MDB 2.0: Interactive Debugger for Meta-HTMLv%s, by Brian J. Fox.",
	  mhtml_version_string);
  printf ("%s\n", metahtml_copyright_string);
  printf ("Compiled for (%s)\n", MHTML_SYSTEM_TYPE);
  printf ("CAUTION!  This is experimental software; bugs certainly exist.\n");

  initialize_mdb (argc, argv);

  if (setjmp (mdb_top_level_jmp_buffer))
    {
      if (MDB_Interrupted)
	printf ("Quit\n");
      mdb_loop_level = 0;
    }

  while (!MDB_QuitFlag)
    mdb_loop ();

  return (0);
}

void
mdb_loop (void)
{
  register int i, j;
  char prompt[100];
  char *line;
  int done = 0;

  mdb_loop_level++;

  for (i = 0, j = 0; j < mdb_loop_level; j++)
    prompt[i++] = '(';

  prompt[i++] = 'm';
  prompt[i++] = 'd';
  prompt[i++] = 'b';

  for (j = 0; j < mdb_loop_level; j++)
    prompt[i++] = ')';

  prompt[i++] = ' ';
  prompt[i++] = '\0';

  while (!done)
    {
      char *result = (char *)NULL;

      line = readline (prompt);

      if (line == (char *)NULL)
	line = strdup ("quit");

      printf ("\r");
      fflush (stdout);

      if (*line)
	{
	  result = mdb_command (line);

	  add_history (line);
	}
      else
	result = mdb_redo ();

      if (result)
	{
	  for (i = strlen (result) - 1;
	       (i > -1) && (whitespace (result[i])); i--);

	  if ((i == -1) || !whitespace (result[i]))
	    result[i + 1] = '\0';
	  else
	    result[i] = '\0';

	  if (*result && !MDB_QuitFlag)
	    printf ("%s\n", result);

	  free (result);
	}

      free (line);

      if (MDB_QuitFlag || MDB_ContFlag)
	break;
    }

  if (MDB_ContFlag)
    MDB_ContFlag--;

  mdb_loop_level--;
}

static void
restart (int sig)
{
  MDB_Interrupted++;
  mdb_throw_to_top_level ();
}

void
mdb_throw_to_top_level (void)
{
  longjmp (mdb_top_level_jmp_buffer, 1);
}

static void
initialize_mdb (int argc, char *argv[])
{
  char working_dir[1024];
  char *result = getcwd (working_dir, 1023);

  signal (SIGINT, restart);

  /* Generate PAGEFUNC_FUNCTION_PACKAGE by evaluating something. */
  {
    PAGE *page = page_create_page ();
    bprintf (page, "<defsubst *mdb-version*>1.0</defsubst>\n");
    page_process_page (page);
    if (page)
      page_free_page (page);
  }

  mdb_initialize_readline ();

  pagefunc_set_variable ("mhtml::version", mhtml_version_string);
  pagefunc_set_variable ("mhtml::system-type", MHTML_SYSTEM_TYPE);
  pagefunc_set_variable ("mhtml::path-info", "");
  pagefunc_set_variable ("mhtml::http-to-host", "");
  pagefunc_set_variable ("mhtml::current-doc", "");
  pagefunc_set_variable ("mhtml::include-prefix", result);
#if 0
  pagefunc_set_variable ("mhtml::relative-prefix", "");
#endif
  pagefunc_set_variable ("mhtml::current-url", "");
  pagefunc_set_variable ("mhtml::current-url-sans-sid", "");
  pagefunc_set_variable ("mhtml::full-url", "");
  pagefunc_set_variable ("mhtml::full-url-sans-sid", "");
  pagefunc_set_variable ("mhtml::http-prefix", "");
  pagefunc_set_variable ("mhtml::http-prefix-sans-sid", "");
  pagefunc_set_variable ("mhtml::cookie-compatible", "true");
  pagefunc_set_variable ("mhtml::url-to-dir", "");
  pagefunc_set_variable ("mhtml::url-to-dir-sans-sid", "");
  pagefunc_set_variable ("mhtml::version", mhtml_version_string);

  {
    PAGE *page = page_read_template (".mdb_init");

    if (!page)
      page = page_read_template (".mdbinit");

    if (page)
      {
	page_process_page (page);
	page_free_page (page);
      }

  }

  if (argc > 1)
    {
      register int i;
      char load_command[1000];
      char *temp;

      for (i = 1; i < argc; i++)
	{
	  char *filename = argv[i];

	  if (strcmp (filename, "--config") == 0)
	    {
	      PAGE *page;

	      config_arg_given++;

	      if ((i + 1) < argc)
		{
		  filename = argv[++i];

		  page = page_read_template (filename);
		  if (page != (PAGE *)NULL)
		    {
		      char *orig_dir = strdup (result);

		      fprintf (stderr, "Processing %s...", filename);
		      page_process_page (page);
		      temp = pagefunc_get_variable ("mhtml::document-root");

		      if (temp != (char *)NULL)
			{
			  int tlen;

			  chdir (temp);
			  result = getcwd (working_dir, 1023);
			  chdir (orig_dir);
			  temp = result;
			  tlen = strlen (temp);

			  pagefunc_set_variable
			    ("mhtml::include-prefix", temp);

			  if (strncmp (orig_dir, temp, tlen) == 0)
			    pagefunc_set_variable
			      ("mhtml::relative-prefix", orig_dir + tlen);
			}
		      free (orig_dir);
		    }
		  else
		    {
		      fprintf (stderr, "Couldn't locate config file %s!",
			       filename);
		    }
		  fprintf (stderr, "\n");
		}
	      else
		{
		  fprintf (stderr, "`--config' requires a filename!\n");
		}
	    }
	  else
	    {
	      sprintf (load_command, "load %s", filename);
	      temp = mdb_command (load_command);
	      if (temp)
		free (temp);
	    }
	}
    }
}

