#include <iostream.h>
#include <MmmExecEnv/stub/MmmExecEnv.h>
#include <MmmBaseClasses/MmmSerEngParas.h>
#include <MmmActor/StringStringTbl.h>

int main(){	 
         MmmNodeObj no; // data structure containing information 
	                // about the Script
	 
         no._serEng()= "Gauss";//name of the execution engine
	                       //for instance "Matlab", "XploRe"
			       

         no._src()="x = MYFUNC(y,z);";// the call you want to do at 
	                          // the engine

	 
	 StringStringTbl osst; // a Table describing the output 
	                       // parameter
	 osst.evaluate();      // necessary if there are no output parameters
         osst[GCString("x")]="GCInt";// x is the parameter name, GCInt
o	                             // is the type (for possible types
				     // look below
				     // You can have more then one parameter
	 no._outTypes()&=osst; 
	 

	 StringTextTbl stt; // a table containing the script and needed
	                    // libraries (all needed source code)
	 stt.evaluate();
	 stt[GCString("MYFUNC")]="PROC(1)=MYFUNC(y,z);\n LOCAL x;\n x=y+z;\n  RETP(x);\nENDP;";
	 //Here you can add needed libraries
	 // if the script calls #include VARML you should add the entry
	 // stt[GCString("VARML")]=...
	 // example: AIC   (ask kathrin gayer)
	 //
	 // to add the entries of the table you can also do
	 //    GCText t;
	 //    t.stream().write(data, length);  data is a char*
	 //    stt[GCString("VARML")] &= t;
	 no._libraries()&=stt;


	 StringDataTbl sdt; // a table including the input data
	 sdt.evaluate();
	 GCInt y=123;
	 GCInt z=456;
	 sdt[GCString("y")]<<=y;    
	 sdt[GCString("z")]<<=z; 


	 GCInt UserId=99;            // UserId and UserName have to be
	 GCString(UserName)="Asche"; // valid for the system, they are checked
	 MmmSerEngParas sep;
	 sep._method()=no;
	 sep._inParas()=sdt;
	 sep._libraries()=stt;
	 sep._outParas()=osst;
         MmmExecEnv EE(UserId,UserName);//creating the stub, logging in
         GCInt RetValue=EE.execScript(sep);
	 if ((int)RetValue == 0){
	    StringDataTbl SDT=EE.getOutput();// getting the result
	    cerr<<SDT[GCString("x")]<<endl;
	 } else {
	    cerr<<EE.getErrorMsg();
	 }   
}

/* Possible data types for input and output are
   integer   ---> GCInt
   double    ---> GCDouble
   matrix    ---> GCText
   string    ---> GCString
   plot      ---> MmmFile

 GCInt, GCDouble, GCText, GCString are basic types 
 GCString can not include newlines, GCText can do so
 
 GCInt x;GCDouble y;GCString z;
 you can get the corresponding c-types via
   (int)x, (double)y,(char*)z, z.str(), z.stream()
   
 access to strings goes through           
        char* GCString::str()
	ostream &GCString::stream()
 for GCText dito;

 MmmFile is a structure representing a file
    MmmFile mf;
    mf._fileName()  gives a GCString containing the name
    mf._data()      gives a GCByte containing the content of the file

 GCByte is a container for bytes
 GCByte b;
 b.length()  gives the size of the container
 b.stream()  gives an ostream with the bytes (such like GCString)



in case of problems contact gerrit, he can figure out, what data
do you really send to the engine, and he knows the semantics 
of the parameter of the operations on MmmExecEnv
 */
