/*  Motti -- a strategy game
    Copyright (C) 1999-2010 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#pragma once
#include <string>
#include "Board.h"
#include "Drawer.h" 
#include "BoxElement.h"

class StringDrawer : public Drawer 
{
public:
	StringDrawer(Board &b);
	virtual ~StringDrawer(void);
	
	 std::string drawSimpleBoard( int x,int y,int width,int height,bool aroundSelected=true);
	 
	 std::string drawCase( Case &c);
	 void drawScreen( );
	void setCoord( int x, int y);
	void setCursor( int x, int y);
	void setCursorPlacement( int x, int y);
	 void clears( );
	 void drawDirectConsoe( );
	 void setClearScreen(bool);
	 int &getWidth();
	 int &getHeight();
	 void right();
	 void left();
	 void up();
	 void down();
	 void redrawCursor();
	 int getXMap();
	 int getYMap();
	 void draw(Drawable *dr) ;
	 void draw() ;
	 void  refreshConfig();
	 MessageBoxDrawable *createMessageBox(std::string title,std::string message);
	 MenuDrawable *createMenu(std::vector<BoxElement *>,std::string title);
	 void writeStringXY(int X,int Y,std::string &a);
	void writeXY(int X,int Y, char a);
private:
	int x_;
	int y_;
	int cursorx_;
	int cursory_;
	int precursorx_;
	int precursory_;
	int rectifiedx_;
	int rectifiedy_;
	int realScreenWidth_;
	int realScreenHeight_;
	int mapWidth_;
	int mapHeight_;
	void calculateWidthHeight();
    void calculateRectifiedCoordinate( ) ;
	void drawCoordinatedSimpleBoard( int, int, int, int, bool);
	void drawCoordinatedCompleteBoard(int, int, int, int, bool);
	void drawCoordinatedBoard( int startX,int startY,int screenWidth,int xBoard,int yBoard,int width,int height);
	bool contour_;
	bool clear_;
	Board *actualBoard_;
	//std::string actualScreen_;
	void drawAllByCursor();
	void drawByCursor(int x,int y,char a) ;
	void drawEmpty(  int width,int height);
};

