/*  Motti -- a strategy game
    Copyright (C) 1999-2014 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef GAMEDISPATCHER_H
#define GAMEDISPATCHER_H
#include <string>
#include <map>

class InAction{
    public : 
      virtual std::string dispatch(bool secured,std::string msg,std::string session="")=0;
      
    protected:
      virtual std::string internalDispatch(std::string msg,std::string session="")=0;
  };

class IndividualAction :public InAction{
    public : 
      virtual std::string dispatch(bool secured,std::string msg,std::string session="")
      {
	if (secured)
	  return internalDispatch(msg,session);
	else
	  return "Need secured action!";
      };
    protected:
    virtual std::string internalDispatch(std::string msg,std::string session=""){return "pong";};
  };
  
  class UnSecuredIndividualAction: public InAction{
      virtual std::string dispatch(bool secured,std::string msg,std::string session=""){
	return internalDispatch(msg,session);
      };
  };
class GameDispatcher
{
  private:
  
  static std::map<std::string,InAction*> actionsMap;
  public : 
    GameDispatcher();
    static std::string dispatch(std::string session,std::string action,std::string msg);

};

#endif // GAMEDISPATCHER_H
