/* header used when running the main lexer in debug mode
   Copyright (C) 1992-2000 Michigan State University

   The CAPA system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CAPA system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with the CAPA system; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   As a special exception, you have permission to link this program
   with the TtH/TtM library and distribute executables, as long as you
   follow the requirements of the GNU GPL in regard to all of the
   software in the executable aside from TtH/TtM.
*/

/* by Isaac Tsai 1996, 1997, 1998, 1999 */

#define PR(xxx) {    switch(xxx) { \
    case HINT_LINE:    printf("[HINT]");    break; \
    case EXPLAIN_LINE: printf("[EXPLAIN]"); break; \
    case IMPORT_LINE:  printf("[IMPORT]");  break; \
    case CAPA_LET:     printf("[LET]");     break; \
    case CAPA_DEF:     printf("[DEF]");     break; \
    case CAPA_DIS:     printf("[DIS");       break; \
    case CAPA_MAP:     printf("[MAP");      break; \
    case CAPA_ANS:     printf("[ANS]");     break; \
    case CAPA_END:     printf("[QUIT]");    break; \
    case CAPA_FIG:     printf("[FIG]");     break; \
    case TEXT_LINE:    printf("[TEXT]");    break; \
    case R_CONSTANT:   printf("[REAL]");    break; \
    case I_CONSTANT:    printf("[INTEGER]"); break; \
    case S_CONSTANT:    printf("[STRING]");  break; \
    case IDENTIFIER:   printf("[IDENTIFIER]"); break; \
    case FUNCTION_ID:  printf("[FUNCTION]"); break; \
    case CAPA_VAR:     printf("[VAR!");    break; \
    case CAPA_ESC:     printf("[ESC]");    break; \
    case ANS_SIG:      printf("[SIG]");    break; \
    case ANS_COMPARE:      printf("[STR]");    break; \
    case ANS_TOLERANCE:    printf("[TOLERANCE]");    break; \
    case ANS_WEIGHT:   printf("[WEIGHT]");    break; \
    case ANS_PLUS:     printf("[PLUS]");    break; \
    case ANS_MINUS:    printf("[MINUS]");    break; \
    case ANS_CS:       printf("[CS]");    break; \
    case ANS_CI:       printf("[CI]");    break; \
    case ANS_MC:       printf("[MC]");    break; \
    case ANS_PCREDIT:  printf("[HGR]");    break; \
    case ANS_ON:       printf("[ON]");    break; \
    case ANS_OFF:      printf("[OFF]");    break; \
    case ANS_TRY:      printf("[TRY]");    break; \
    case ANS_RANGE:    printf("[RANGE]");    break; \
    case EQ_op:        printf("[EQ]");    break; \
    case NE_op:        printf("[NE]");    break; \
    case GT_op:        printf("[GT]");    break; \
    case GE_op:        printf("[GE]");    break; \
    case LT_op:        printf("[LT]");    break; \
    case LE_op:        printf("[LE]");    break; \
    case AND_op:       printf("[AND]");   break; \
    case OR_op:        printf("[OR]");    break; \
    case FORMAT:       printf("[FORMAT]");    break; \
    case SLASH:        printf("[/]");    break; \
    default:           printf("[%c]",xxx);  break; \
  } }

#ifdef  DBUG_LEXER
#define RETURN(yyy) { PR(yyy); return(yyy); }
#else  
#define RETURN(xxx) { return(xxx);  }
#endif
