@c  Copyright (C) 2000--2001 by Tom Cato Amundsen
@c  Dutch translation by Freddy Spierenburg <freddy@dusktilldawn.nl>, 2001.
@c  Permission is granted to copy, distribute and/or modify this document
@c  under the terms of the GNU Free Documentation License, Version 1.1
@c  or any later version published by the Free Software Foundation;
@c  with no Invariant Sections.

@c vim: set nolinebreak
m4_include(texidefinitions.m4)

@settitle Helpbestanden
@section  Helpbestanden

De broncode voor de online-documentatie is geschreven in texinfo en is
daarna geconventeerd naar standaard html.

Naast dat je verwijzingen kunt aanmaken naar andere helpbestanden, kun je ook
verwijzingen aanmaken die een oefening starten en configureren als je er op
klikt. Zoals bijvoorbeeld: ahref(solfege:/harmonic-intervall, deze verwijzing).

Stel mij gerust vragen als je documentatie voor GNU Solfege wilt schrijven.
Eventueel kan ik je ook een snelle prive cursus texinfo via email geven als
je daar behoefte aan hebt...

@subsection De speciale @code{solfege:} verwijzingen

De speciale @code{solfege:} verwijzingen zijn als volgt opgebouwd:
@code{[protocol:][actie/]oefening/[lescollectie/lesbestand?configuratie]}

@table @code
@item protocol
Het protocol is optioneel. Als je hier niets invuld is het een verwijzing
naar een html-bestand. De enige andere waarde is: @code{solfege}.

@item actie
De actie is optioneel. Als je hier niets invuld krijg je het scherm te zien
zoals je het in deze sessie het laatst hebt achtergelaten. Als je deze
oefening echter nog niet hebt gedaan krijg je het beginscherm van de
oefening. Mogelijke waardens zijn: @code{practise}, @code{config} of
@code{statistics}.

@item oefening
@code{chord}(Akkoorden),
@code{harmonic-intervall}(Harmonische intervallen),
@code{melodic-intervall}(Melodische intervallen),
@code{sing-intervall}(Zing het interval),
@code{identify-scale}(Identificeer de toonladder),
@code{dictation}(Dicteren),
@code{id-by-name}(Identificeer via naam),
@code{twelve-tone}(Zing de twaalfde toon),
@code{sing-chord}(Zing het akkoord),
@code{id-tone}(Identificeer de toon),
@code{compare-intervalls}(Vergelijk de intervallen),
@code{rhythm}(Ritme)

@item lescollectie
Gebruik de waarde @code{solfege} voor de bestanden die meegeleverd worden
met GNU Solfege of gebruik @code{user} voor jouw eigen collectie van
lesbestanden die in @code{$HOME/lessonfiles} staan.
Dit veld is optioneel en wordt alleen gebruikt bij oefeningen waar
men gebruik kan maken van lesbestanden.

@item lesbestand
De naam van het lesbestand. Dit veld is optioneel en wordt alleen
gebruikt bij oefeningen waar men gebruik kan maken van lesbestanden.

@item configuratie
Optioneel. Dit is een lijst van toekenningen die met een puntcomma zijn
gescheiden. Voorbeeld:
@example
highest_instrumnt=80; intervalls=[1, 2, 3, 4]
@end example
@end table


@subsection Lijst van variabelen
Deze twee variabelen kunnen bij alle oefeningen worden gebruikt die een
@emph{Stel automatisch een nieuwe vraag} optie hebben in het
configuratiescherm.

@table @code
@item new_question_automatically = true | false
@item seconds_Before_question = float
@end table

@subsubsection Chord(Akkoorden)
@table @code
@item highest_instrument, middle_instrument, lowest_instrument
integer 0-127

@item highest_instrument_velocity, middle_instrument_velocity, lowest_instrument_velocity
integer 0-127
@item override_default_instrument
boolean
@end table

@subsubsection Harmonic intervall(Harmonische intervallen)
@table @code
@item highest_instrument, lowest_instrument
integer 0-127

@item highest_instrument_velocity, lowest_instrument_velocity
integer 0-127

@item override_default_instrument
boolean

@item intervalls
lijst van integers, [1, 2, ... 15, 16]

@item highest_tone, lowest_tone
Nootnamen zoals @code{c}, @code{fis,},  or @code{d''}

@item new_question_automatically
boolean

@item seconds_before_new_question
float
@end table

@subsubsection Melodic intervall(Melodische intervallen), sing intervall(Zing het interval)
@table @code
@item number_of_intervalls
integer

@item ask_for_intervalls_nn, waar nn is groter of gelijk aan 0
lijst van integers: [-16, -15 ... 15, 16]

@end table

@subsubsection Identify scale(Identificeer toonladder)
@table @code
@item scales
Lijst van toonladdersoorten: ['ionian', 'dorian', 'phrygian', 'lydian',
'mixolydian', 'aeolian', 'lokrisk', 'harmonic_minor', 'melodic_minor']
@end table

@subsubsection Id by name(Identificeer via naam), dictation(Dicteren), harmonic progression dictation(Harmonische progressie dicteren)
Hier kun je alleen het lesbestand opgeven.

@subsubsection Id tone(Identificeer de noot)
@table @code
@item c_weight, cis_weight etc..
0..1000

@item one_chance_only
boolean

@item warning_sound
boolean

@item repeat_question
boolean
@end table

@subsection @code{solfegescript}

Een tijdje terug heb ik een experimentele functie aan GNU Solfege
toegevoegd. Deze functie zorgt er voor dat de documentatie de juiste
toetsbindingen toont. Ook al wijzigt de gebruiker deze. Je kunt dit
bereiken met de onderstaande code:

@example
<script type="text/solfegescript">
  get_string("chord/new_ak")
</script>
@end example

