/* swicat.h -- installed software catalog files.

   Copyright (C) 2004 Jim Lowe
   All Rights Reserved.
  
   COPYING TERMS AND CONDITIONS:
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef swicat_h_20040322
#define swicat_h_20040322


#include "swuser_config.h"
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "swi.h"
#include "swevents.h"

#define SWINSTALL_INCAT_VERSION		"0.8"
#define SWINSTALL_INCAT_NAME		"export" 
#define SWINSTALL_INCAT_CATFILE		"catalog.archive"
#define SWINSTALL_INCAT_SIGFILE		"catalog.archive.sig"
#define SWINSTALL_INCAT_INDEX		"ISF"
#define SWINSTALL_INCAT_OPTIONS		"session_options"

int swicat_write_installed_software(SWI * swi, int ofd);
int swicat_isf_all_scripts(STROB * buf, SWI_SCRIPTS * xx, int do_if_active);
int swicat_isf_control_script(STROB * buf, SWI_CONTROL_SCRIPT * xx, int do_if_active);

int swicat_isf_fileset(SWI * swi, STROB * buf, SWI_XFILE * xx, int do_if_active);
int swicat_isf_product(SWI * swi, STROB * buf, SWI_PRODUCT * xx, int do_if_active);
int swicat_isf_installed_software(STROB * buf, SWI * xx);
int swicat_env(STROB * buf, SWI * swi, char * control_script_pkg_dir, char * tag);
int swicat_isf_installed_software(STROB * buf, SWI * swi);
void swicat_write_auto_comment(STROB * buf, char * filename);
int swicat_write_script_cases(SWI * swi, STROB * buf, char * sw_selection);
void swicat_construct_controlsh_taglist(SWI * swi, char * sw_selections, STROB * list);

#endif
