#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/stat.h>
#include "swparser_global.h"
#include "usgetopt.h"
#include "swlib.h"
#include "swi.h"
#include "xformat.h"

int 
main (int argc, char ** argv ) {
	int fd;
	int ret = 0;
	int nofile = 0;
	char digest[100];
	char sha1[100];
	char * name;

	digest[0] = '\0';
	sha1[0] = '\0';

	/* 
	ret = swlib_sha1(STDIN_FILENO, sha1);
	*/

	if (strcmp(argv[1+nofile], "--no-name") == 0) {
		nofile = 1;
	}

	if (argc < 3+nofile || strcmp(argv[2+nofile], "-") == 0) {
		fd = STDIN_FILENO;
		name = "-";
	} else {
		fd = open(argv[2+nofile], O_RDONLY, 0);
		name = argv[2+nofile];
		if (fd < 0) exit(2);
	}

	


	ret = swlib_digests(fd, digest, sha1);

	if (ret < 0) {
		fprintf(stderr, "error %d\n", ret);
	}
	if (nofile == 0) {
		if (strcmp(argv[1+nofile], "md5") == 0) 
			fprintf(stdout, "%s  %s\n",  digest, name);
		else 
			fprintf(stdout, "%s  %s\n", sha1, name);
	} else {
		if (strcmp(argv[1+nofile], "md5") == 0) 
			fprintf(stdout, "%s\n",  digest);
		else 
			fprintf(stdout, "%s\n", sha1);
	}

	close(fd);
	exit(0);
}

