/*  pax_commands.h -- */
/*
   Copyright (C) 2004 Jim Lowe
   All Rights Reserved.
  
   COPYING TERMS AND CONDITIONS:
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include "swcommon0.h"

struct 
g_pax_write_command g_pax_write_commands[] = {
	{"pax",  
		"pax -x ustar -w"
	},
	{"star", 
		"star cf - -H ustar"
	},
	{"tar",  
		"tar cf -"
	},
	{"gtar", 
		"gtar cf -"
	},
	{"swbistar",
		SWBISLIBEXECDIR "/swbis/swbistar"
	},
		{(char*)NULL, (char*)NULL}
	};

struct 
g_pax_read_command g_pax_read_commands[] = {
	{"pax", 
		"pax -pe -r",
		"pax -pe -r -v",
		"pax -pe -r -k"
	},
	{"star",
		"star xpf - -U",
		"star xpvf - -U 1>&2", /* use of stdout breaks swcopy piping*/
		"star xpf - --keep-old-files 1>&2"
	},
	{"tar", 
		"tar xpf -",
		"tar xpvf - 1>&2", /*  use of stdout breaks swcopy piping. */
		"tar xpkf - 1>&2" /* use of stdout breaks swcopy piping. */
	},
	{"gtar",
		"gtar xpf - --overwrite",
		"gtar xpvf - --overwrite 1>&2",
		"gtar xpkf - --overwrite 1>&2"
	},
		{(char*)NULL, (char*)NULL, (char*)NULL, (char*)NULL}
	};

