/* vplob: void pointer list object.

   Copyright (C) 2006  James H. Lowe, Jr.
  
   COPYING TERMS AND CONDITIONS
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef vplob_h_
#define vplob_h_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "cplob.h"

typedef union {
	CPLOB cplob;
} VPLOB;

VPLOB * vplob_open(void);
void vplob_close(VPLOB * vplob);
void vplob_shallow_close(VPLOB * vplob);
void vplob_add(VPLOB * vplob, void * addr);
void ** vplob_get_list(VPLOB * vplob);
void * vplob_val(VPLOB * vplob, int index);
int vplob_get_nstore(VPLOB * vplob);

#endif
