--
-- This file is part of TALER
-- Copyright (C) 2024 Taler Systems SA
--
-- TALER is free software; you can redistribute it and/or modify it under the
-- terms of the GNU General Public License as published by the Free Software
-- Foundation; either version 3, or (at your option) any later version.
--
-- TALER is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
-- A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
--

CREATE TABLE IF NOT EXISTS auditor_early_aggregations
(
    row_id BIGINT GENERATED BY DEFAULT AS IDENTITY UNIQUE PRIMARY KEY,
    batch_deposit_serial_id BIGINT UNIQUE NOT NULL,
    tracking_serial_id BIGINT UNIQUE NOT NULL,
    amount taler_amount NOT NULL,
    suppressed BOOLEAN NOT NULL DEFAULT FALSE
);

COMMENT ON TABLE auditor_early_aggregations
  IS 'Reports when aggregations/transfers are encountered before their justifications (can be harmless, if the justifications appear shortly afterwards).';

COMMENT ON COLUMN auditor_early_aggregations.row_id
  IS 'Unique identifier of the report in the auditor database';
COMMENT ON COLUMN auditor_early_aggregations.batch_deposit_serial_id
  IS 'FIXME';
COMMENT ON COLUMN auditor_early_aggregations.tracking_serial_id
  IS 'FIXME';
COMMENT ON COLUMN auditor_early_aggregations.amount
  IS 'Total transaction amount impacted';
COMMENT ON COLUMN auditor_early_aggregations.suppressed
  IS 'True if the report was suppressed by an administrator';
