/*
 This file is part of GNU Taler
 (C) 2022-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { TranslatedString } from "@gnu-taler/taler-util";
import { Attention, useTranslationContext } from "@gnu-taler/web-util/browser";
import { Fragment, VNode, h } from "preact";
import { Transactions } from "../../components/Transactions/index.js";
import { useBankState } from "../../hooks/bank-state.js";
import { usePreferences } from "../../hooks/preferences.js";
import { PaymentOptions } from "../PaymentOptions.js";
import { State } from "./index.js";
import { RouteDefinition } from "@gnu-taler/web-util/browser";
import { useSettingsContext } from "../../context/settings.js";

const TALER_SCREEN_ID = 5;

export function InvalidIbanView({ error }: State.InvalidIban) {
  return (
    <div>
      Payto from server is not valid &quot;
      {error.payto_uri}&quot;
    </div>
  );
}

const IS_PUBLIC_ACCOUNT_ENABLED = false;

function ShowDemoInfo({
  routePublicAccounts,
}: {
  routePublicAccounts: RouteDefinition;
}): VNode {
  const { i18n } = useTranslationContext();
  const settings = useSettingsContext();
  const [preferences, updatePreferences] = usePreferences();
  if (!settings.showDemoDescription || preferences.hideDemo)
    return <Fragment />;
  return (
    <Attention
      title={i18n.str`This is a demo`}
      onClose={() => {
        updatePreferences("hideDemo", true);
      }}
    >
      {IS_PUBLIC_ACCOUNT_ENABLED ? (
        <i18n.Translate>
          This part of the demo shows how a bank that supports Taler directly
          would work. In addition to using your own bank account, you can also
          see the transaction history of some{" "}
          <a name="public account" href={routePublicAccounts.url({})}>
            Public Accounts
          </a>
          .
        </i18n.Translate>
      ) : (
        <i18n.Translate>
          Here you will be able to see how a bank that supports Taler directly
          would work.
        </i18n.Translate>
      )}
    </Attention>
  );
}

export function ReadyView({
  tab,
  account,
  routeChargeWallet,
  routeWireTransfer,
  limit,
  balance,
  routeCashout,
  routeCreateWireTransfer,
  routePublicAccounts,
  routeOperationDetails,
  onClose,
  routeClose,
  onOperationCreated,
}: State.Ready): VNode {
  return (
    <Fragment>
      <ShowDemoInfo routePublicAccounts={routePublicAccounts} />
      <PaymentOptions
        tab={tab}
        routeOperationDetails={routeOperationDetails}
        routeCashout={routeCashout}
        routeChargeWallet={routeChargeWallet}
        routeWireTransfer={routeWireTransfer}
        limit={limit}
        balance={balance}
        routeClose={routeClose}
        onClose={onClose}
        onOperationCreated={onOperationCreated}
      />
      <Transactions
        account={account}
        routeCreateWireTransfer={routeCreateWireTransfer}
      />
    </Fragment>
  );
}
