/*
 This file is part of GNU Taler
 (C) 2022-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
import type { FormState, InternationalizationAPI } from "@gnu-taler/web-util/browser";
import { BaseForm } from "../context/ui-forms.js";
import { resolutionSection } from "./simplest.js";

export const v1 = (i18n: InternationalizationAPI) => ({
  design: [
    {
      title:
        i18n.str`Establishing of the controlling person of operating legal entities and partnerships both not quoted on the stock exchange`,
      description:
        i18n.str`for operating legal entities and partnership that are contracting partner as well as analogously for operating legal entities and partnership that are beneficial owners.`,
      fields: [
        {
          type: "textArea",
          properties: {
            name: "contractingPartner",
            label: i18n.str`Contracting partner`,
          },
        },
        {
          type: "choiceStacked",
          properties: {
            name: "declares",
            label:
              i18n.str`The contracting partner hereby declares that`,
            required: true,
            choices: [
              {
                label:
                  i18n.str`the person(s) listed below is/are holding 25% or more of the contracting partner's shares (capital shares or voting rights)`,
                value: "25-or-more",
              },
              {
                label:
                  i18n.str`if the capital shares or voting rights cannot be determined or in case there are no capital shares or voting rights 25% or more, the contracting partner hereby declares that the person(s) listed below is/are controlling the contracting partner in other ways`,
                value: "controlling-in-other-ways",
              },
              {
                label:
                  i18n.str`in case this/these person(s) cannot be determined or this/these person(s) does/do not exist, the contracting partner hereby declares that the person(s) listed below is/are the managing director(s)`,
                value: "managing-director",
              },
            ],
          },
        },
        {
          type: "array",
          properties: {
            name: "people",
            label: i18n.str`People`,
            required: true,
            placeholder: i18n.str`this is the placeholder`,
            fields: [
              {
                type: "text",
                properties: {
                  name: "lastName",
                  label: i18n.str`Last name(s)`,
                  required: true,
                },
              },
              {
                type: "text",
                properties: {
                  name: "firstName",
                  label: i18n.str`First name(s)`,
                  required: true,
                },
              },
              {
                type: "text",
                properties: {
                  name: "address",
                  label: i18n.str`Actual address of domicile`,
                  required: true,
                },
              },
            ],
            labelField: "lastName",
          },
        },
        {
          type: "choiceStacked",
          properties: {
            name: "fiduciaryAssets",
            label: i18n.str`Fiduciary holding assets`,
            help: i18n.str`Is a third person the beneficial owner of the assets held in the account/securities account?`,
            required: true,
            choices: [
              {
                label: i18n.str`No`,
                value: "no",
              },
              {
                label: i18n.str`Yes`,
                value: "yes",
                description:
                  i18n.str`The relevant information regarding the beneficial owner has to be obtained by filling in a separate VQF doc. No. 902.9`,
              },
            ],
          },
        },
      ],
    },
    resolutionSection(i18n),
  ],
  behavior: function formBehavior(
    v: Partial<Form902_11.Form>,
  ): FormState<Form902_11.Form> {
    return {
      people: {
        hidden: v.declares !== "controlling-in-other-ways" &&
          v.declares !== "managing-director",
      }
    };
  }
});

namespace Form902_11 {
  interface Person {
    lastName: string;
    firstName: string;
    address: string;
  }
  export interface Form extends BaseForm {
    contractingPartner: string;
    declares: "25-or-more" | "controlling-in-other-ways" | "managing-director";
    people: Person[];
    fiduciaryAssets: "no" | "yes";
    signature: string;
  }
}
