/*
 This file is part of GNU Taler
 (C) 2022-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import type {
  DoubleColumnForm,
  DoubleColumnFormSection,
  InternationalizationAPI,
  UIHandlerId,
} from "@gnu-taler/web-util/browser";

export const personalInfo = (
  i18n: InternationalizationAPI,
): DoubleColumnForm => ({
  type: "double-column" as const,
  design: [
    {
      title: i18n.str`Simple form`,
      fields: [
        // {
        //   type: "absoluteTimeText",
        //   name: "dateOfDeath",
        //   label: i18n.str`Date of death`,
        //   pattern: "dd/MM/yyyy",
        //   // help: i18n.str`if deceased. format 'dd/MM/yyyy'`,
        //   help: i18n.str`if deceased'`,
        //   id: ".birthdate" as UIHandlerId,
        // },
        {
          type: "choiceStacked",
          name: "trucker",
          id: ".trucker" as UIHandlerId,
          required: true,
          label: i18n.str`Are you a cross-border truck driver?`,
          choices: [
            {
              label: i18n.str`Yes`,
              value: "yes",
            },
            {
              label: i18n.str`No`,
              value: "no",
            },
          ],
        },
        {
          type: "amount",
          id: ".money" as UIHandlerId,
          currency: "YEIN",
          name: "money",
          converterId: "Taler.Amount",
          label: i18n.str`How much is in your pockets?`,
        },
      ],
    },
  ],
});
