/*
 This file is part of GNU Taler
 (C) 2022-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
import {
  AccessToken,
  TalerExchangeResultByMethod,
  TalerHttpError,
} from "@gnu-taler/taler-util";
import { useExchangeApiContext } from "@gnu-taler/web-util/browser";
import _useSWR, { SWRHook, mutate } from "swr";
import { SessionId } from "./session.js";
const useSWR = _useSWR as unknown as SWRHook;

export function revalidateKycInfo() {
  return mutate(
    (key) => Array.isArray(key) && key[key.length - 1] === "checkKycInfo",
    undefined,
    { revalidate: true },
  );
}

export function useKycInfo(token: AccessToken) {
  const {
    lib: { exchange: api },
  } = useExchangeApiContext();

  async function fetcher([ac]: [AccessToken]) {
    return await api.checkKycInfo(ac, [], { timeout: 1000 });
  }
  const { data, error } = useSWR<
    TalerExchangeResultByMethod<"checkKycInfo">,
    TalerHttpError
  >([token, "checkKycInfo"], fetcher, {
    revalidateIfStale: false,
    errorRetryCount: 0,
    errorRetryInterval: 1,
    shouldRetryOnError: false,
    keepPreviousData: true,
  });

  if (data) return data;
  if (error) return error;
  return undefined;
}
