/*
 This file is part of GNU Taler
 (C) 2022-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import {
  AccessToken,
  Codec,
  buildCodecForObject,
  codecForAccessToken,
  codecOptional,
} from "@gnu-taler/taler-util";
import { buildStorageKey, useLocalStorage } from "@gnu-taler/web-util/browser";

/**
 * Has the information to reach and
 * authenticate at the bank's backend.
 */
export type SessionId = {
  // accessToken: AccessToken;
};

export type SessionState = {
  // accessToken: AccessToken;
};

export const codecForSessionState = (): Codec<SessionState> =>
  buildCodecForObject<SessionState>()
    // .property("accessToken", codecForAccessToken())
    //     .property("lastAddress", codecOptional(codecForList(codecForLastAddress())))
    .build("SessionState");

export interface SessionStateHandler {
  state: SessionState | undefined;
  start(s: SessionId): void;
}

const SESSION_STATE_KEY = buildStorageKey(
  "kyc-session",
  codecForSessionState(),
);

/**
 * Return getters and setters for
 * login credentials and backend's
 * base URL.
 */
export function useSessionState(): SessionStateHandler {
  const { value: state, update } = useLocalStorage(SESSION_STATE_KEY);

  return {
    state,
    start(s) {},
  };
}
