webpackJsonp([4],{

/***/ 167:
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*
 This file is part of TALER
 (C) 2017 GNUnet e.V.

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Page shown to the user to confirm creation
 * of a reserve, usually requested by the bank.
 *
 * @author Florian Dold
 */
const React = __webpack_require__(1);
const ReactDOM = __webpack_require__(3);
const URI = __webpack_require__(6);
const i18n = __webpack_require__(7);
const wxApi_1 = __webpack_require__(2);
const renderHtml_1 = __webpack_require__(5);
const Amounts = __webpack_require__(4);
const talerTypes_1 = __webpack_require__(137);
class TipDisplay extends React.Component {
    constructor(props) {
        super(props);
        this.state = { working: false, discarded: false };
    }
    update() {
        return __awaiter(this, void 0, void 0, function* () {
            const tipStatus = yield wxApi_1.getTipStatus(this.props.tipToken);
            this.setState({ tipStatus });
            const rci = yield wxApi_1.getReserveCreationInfo(tipStatus.exchangeUrl, tipStatus.amount);
            this.setState({ rci });
        });
    }
    componentDidMount() {
        this.update();
        const port = chrome.runtime.connect();
        port.onMessage.addListener((msg) => {
            if (msg.notify) {
                console.log("got notified");
                this.update();
            }
        });
        this.update();
    }
    renderExchangeInfo() {
        const rci = this.state.rci;
        if (!rci) {
            return React.createElement("p", null, "Waiting for info about exchange ...");
        }
        const totalCost = Amounts.add(rci.overhead, rci.withdrawFee).amount;
        return (React.createElement("div", null,
            React.createElement("p", null,
                "The tip is handled by the exchange ",
                React.createElement("strong", null, rci.exchangeInfo.baseUrl),
                ".",
                " ",
                "The exchange provider will charge",
                " ",
                React.createElement("strong", null, renderHtml_1.renderAmount(totalCost)),
                " ",
                "."),
            React.createElement(renderHtml_1.WithdrawDetailView, { rci: rci })));
    }
    accept() {
        this.setState({ working: true });
        wxApi_1.acceptTip(this.props.tipToken);
    }
    discard() {
        this.setState({ discarded: true });
    }
    render() {
        const ts = this.state.tipStatus;
        if (!ts) {
            return React.createElement("p", null, "Processing ...");
        }
        const renderAccepted = () => (React.createElement(React.Fragment, null,
            React.createElement("p", null,
                "You've accepted this tip! ",
                React.createElement("a", { href: ts.nextUrl }, "Go back to merchant")),
            this.renderExchangeInfo()));
        const renderButtons = () => (React.createElement(React.Fragment, null,
            React.createElement("form", { className: "pure-form" },
                React.createElement("button", { className: "pure-button pure-button-primary", type: "button", disabled: !(this.state.rci && this.state.tipStatus && this.state.tipStatus.tipRecord), onClick: () => this.accept() },
                    this.state.working
                        ? React.createElement("span", null,
                            React.createElement("object", { className: "svg-icon svg-baseline", data: "/img/spinner-bars.svg" }),
                            " ")
                        : null,
                    "Accept tip"),
                " ",
                React.createElement("button", { className: "pure-button", type: "button", onClick: () => this.discard() }, "Discard tip")),
            this.renderExchangeInfo()));
        const renderDiscarded = () => (React.createElement("p", null,
            "You've discarded this tip. ",
            React.createElement("a", { href: ts.nextUrl }, "Go back to merchant.")));
        return (React.createElement("div", null,
            React.createElement("h2", null, "Tip Received!"),
            React.createElement("p", null,
                "You received a tip of ",
                React.createElement("strong", null, renderHtml_1.renderAmount(ts.amount)),
                " from ",
                React.createElement("span", null, " "),
                React.createElement("strong", null, ts.merchantDomain),
                "."),
            this.state.discarded
                ? renderDiscarded()
                : ts.accepted
                    ? renderAccepted()
                    : renderButtons()));
    }
}
function main() {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const url = new URI(document.location.href);
            const query = URI.parseQuery(url.query());
            const tipToken = talerTypes_1.TipToken.checked(JSON.parse(query.tip_token));
            ReactDOM.render(React.createElement(TipDisplay, { tipToken: tipToken }), document.getElementById("container"));
        }
        catch (e) {
            // TODO: provide more context information, maybe factor it out into a
            // TODO:generic error reporting function or component.
            document.body.innerText = i18n.str `Fatal error: "${e.message}".`;
            console.error(`got error "${e.message}"`, e);
        }
    });
}
document.addEventListener("DOMContentLoaded", () => {
    main();
});


/***/ })

},[167]);
//# sourceMappingURL=tip-bundle.js.map