/*
 * DCE_8_0 Register documentation
 *
 * Copyright (C) 2014  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef DCE_8_0_D_H
#define DCE_8_0_D_H

#define mmPIPE0_PG_CONFIG                                                       0x1760
#define mmPIPE0_PG_ENABLE                                                       0x1761
#define mmPIPE0_PG_STATUS                                                       0x1762
#define mmPIPE1_PG_CONFIG                                                       0x1764
#define mmPIPE1_PG_ENABLE                                                       0x1765
#define mmPIPE1_PG_STATUS                                                       0x1766
#define mmPIPE2_PG_CONFIG                                                       0x1768
#define mmPIPE2_PG_ENABLE                                                       0x1769
#define mmPIPE2_PG_STATUS                                                       0x176a
#define mmPIPE3_PG_CONFIG                                                       0x176c
#define mmPIPE3_PG_ENABLE                                                       0x176d
#define mmPIPE3_PG_STATUS                                                       0x176e
#define mmPIPE4_PG_CONFIG                                                       0x1770
#define mmPIPE4_PG_ENABLE                                                       0x1771
#define mmPIPE4_PG_STATUS                                                       0x1772
#define mmPIPE5_PG_CONFIG                                                       0x1774
#define mmPIPE5_PG_ENABLE                                                       0x1775
#define mmPIPE5_PG_STATUS                                                       0x1776
#define mmDC_IP_REQUEST_CNTL                                                    0x1778
#define mmDC_PGFSM_CONFIG_REG                                                   0x177c
#define mmDC_PGFSM_WRITE_REG                                                    0x177d
#define mmDC_PGCNTL_STATUS_REG                                                  0x177e
#define mmDCPG_TEST_DEBUG_INDEX                                                 0x1779
#define mmDCPG_TEST_DEBUG_DATA                                                  0x177b
#define mmBL1_PWM_AMBIENT_LIGHT_LEVEL                                           0x1628
#define mmBL1_PWM_USER_LEVEL                                                    0x1629
#define mmBL1_PWM_TARGET_ABM_LEVEL                                              0x162a
#define mmBL1_PWM_CURRENT_ABM_LEVEL                                             0x162b
#define mmBL1_PWM_FINAL_DUTY_CYCLE                                              0x162c
#define mmBL1_PWM_MINIMUM_DUTY_CYCLE                                            0x162d
#define mmBL1_PWM_ABM_CNTL                                                      0x162e
#define mmBL1_PWM_BL_UPDATE_SAMPLE_RATE                                         0x162f
#define mmBL1_PWM_GRP2_REG_LOCK                                                 0x1630
#define mmDC_ABM1_CNTL                                                          0x1638
#define mmDC_ABM1_IPCSC_COEFF_SEL                                               0x1639
#define mmDC_ABM1_ACE_OFFSET_SLOPE_0                                            0x163a
#define mmDC_ABM1_ACE_OFFSET_SLOPE_1                                            0x163b
#define mmDC_ABM1_ACE_OFFSET_SLOPE_2                                            0x163c
#define mmDC_ABM1_ACE_OFFSET_SLOPE_3                                            0x163d
#define mmDC_ABM1_ACE_OFFSET_SLOPE_4                                            0x163e
#define mmDC_ABM1_ACE_THRES_12                                                  0x163f
#define mmDC_ABM1_ACE_THRES_34                                                  0x1640
#define mmDC_ABM1_ACE_CNTL_MISC                                                 0x1641
#define mmDC_ABM1_DEBUG_MISC                                                    0x1649
#define mmDC_ABM1_HGLS_REG_READ_PROGRESS                                        0x164a
#define mmDC_ABM1_HG_MISC_CTRL                                                  0x164b
#define mmDC_ABM1_LS_SUM_OF_LUMA                                                0x164c
#define mmDC_ABM1_LS_MIN_MAX_LUMA                                               0x164d
#define mmDC_ABM1_LS_FILTERED_MIN_MAX_LUMA                                      0x164e
#define mmDC_ABM1_LS_PIXEL_COUNT                                                0x164f
#define mmDC_ABM1_LS_OVR_SCAN_BIN                                               0x1650
#define mmDC_ABM1_LS_MIN_MAX_PIXEL_VALUE_THRES                                  0x1651
#define mmDC_ABM1_LS_MIN_PIXEL_VALUE_COUNT                                      0x1652
#define mmDC_ABM1_LS_MAX_PIXEL_VALUE_COUNT                                      0x1653
#define mmDC_ABM1_HG_SAMPLE_RATE                                                0x1654
#define mmDC_ABM1_LS_SAMPLE_RATE                                                0x1655
#define mmDC_ABM1_HG_BIN_1_32_SHIFT_FLAG                                        0x1656
#define mmDC_ABM1_HG_BIN_1_8_SHIFT_INDEX                                        0x1657
#define mmDC_ABM1_HG_BIN_9_16_SHIFT_INDEX                                       0x1658
#define mmDC_ABM1_HG_BIN_17_24_SHIFT_INDEX                                      0x1659
#define mmDC_ABM1_HG_BIN_25_32_SHIFT_INDEX                                      0x165a
#define mmDC_ABM1_HG_RESULT_1                                                   0x165b
#define mmDC_ABM1_HG_RESULT_2                                                   0x165c
#define mmDC_ABM1_HG_RESULT_3                                                   0x165d
#define mmDC_ABM1_HG_RESULT_4                                                   0x165e
#define mmDC_ABM1_HG_RESULT_5                                                   0x165f
#define mmDC_ABM1_HG_RESULT_6                                                   0x1660
#define mmDC_ABM1_HG_RESULT_7                                                   0x1661
#define mmDC_ABM1_HG_RESULT_8                                                   0x1662
#define mmDC_ABM1_HG_RESULT_9                                                   0x1663
#define mmDC_ABM1_HG_RESULT_10                                                  0x1664
#define mmDC_ABM1_HG_RESULT_11                                                  0x1665
#define mmDC_ABM1_HG_RESULT_12                                                  0x1666
#define mmDC_ABM1_HG_RESULT_13                                                  0x1667
#define mmDC_ABM1_HG_RESULT_14                                                  0x1668
#define mmDC_ABM1_HG_RESULT_15                                                  0x1669
#define mmDC_ABM1_HG_RESULT_16                                                  0x166a
#define mmDC_ABM1_HG_RESULT_17                                                  0x166b
#define mmDC_ABM1_HG_RESULT_18                                                  0x166c
#define mmDC_ABM1_HG_RESULT_19                                                  0x166d
#define mmDC_ABM1_HG_RESULT_20                                                  0x166e
#define mmDC_ABM1_HG_RESULT_21                                                  0x166f
#define mmDC_ABM1_HG_RESULT_22                                                  0x1670
#define mmDC_ABM1_HG_RESULT_23                                                  0x1671
#define mmDC_ABM1_HG_RESULT_24                                                  0x1672
#define mmDC_ABM1_OVERSCAN_PIXEL_VALUE                                          0x169b
#define mmDC_ABM1_BL_MASTER_LOCK                                                0x169c
#define mmABM_TEST_DEBUG_INDEX                                                  0x169e
#define mmABM_TEST_DEBUG_DATA                                                   0x169f
#define mmCRTC_DCFE_CLOCK_CONTROL                                               0x1b7c
#define mmCRTC0_CRTC_DCFE_CLOCK_CONTROL                                         0x1b7c
#define mmCRTC1_CRTC_DCFE_CLOCK_CONTROL                                         0x1e7c
#define mmCRTC2_CRTC_DCFE_CLOCK_CONTROL                                         0x417c
#define mmCRTC3_CRTC_DCFE_CLOCK_CONTROL                                         0x447c
#define mmCRTC4_CRTC_DCFE_CLOCK_CONTROL                                         0x477c
#define mmCRTC5_CRTC_DCFE_CLOCK_CONTROL                                         0x4a7c
#define mmCRTC_H_BLANK_EARLY_NUM                                                0x1b7d
#define mmCRTC0_CRTC_H_BLANK_EARLY_NUM                                          0x1b7d
#define mmCRTC1_CRTC_H_BLANK_EARLY_NUM                                          0x1e7d
#define mmCRTC2_CRTC_H_BLANK_EARLY_NUM                                          0x417d
#define mmCRTC3_CRTC_H_BLANK_EARLY_NUM                                          0x447d
#define mmCRTC4_CRTC_H_BLANK_EARLY_NUM                                          0x477d
#define mmCRTC5_CRTC_H_BLANK_EARLY_NUM                                          0x4a7d
#define mmDCFE_DBG_SEL                                                          0x1b7e
#define mmCRTC0_DCFE_DBG_SEL                                                    0x1b7e
#define mmCRTC1_DCFE_DBG_SEL                                                    0x1e7e
#define mmCRTC2_DCFE_DBG_SEL                                                    0x417e
#define mmCRTC3_DCFE_DBG_SEL                                                    0x447e
#define mmCRTC4_DCFE_DBG_SEL                                                    0x477e
#define mmCRTC5_DCFE_DBG_SEL                                                    0x4a7e
#define mmDCFE_MEM_LIGHT_SLEEP_CNTL                                             0x1b7f
#define mmCRTC0_DCFE_MEM_LIGHT_SLEEP_CNTL                                       0x1b7f
#define mmCRTC1_DCFE_MEM_LIGHT_SLEEP_CNTL                                       0x1e7f
#define mmCRTC2_DCFE_MEM_LIGHT_SLEEP_CNTL                                       0x417f
#define mmCRTC3_DCFE_MEM_LIGHT_SLEEP_CNTL                                       0x447f
#define mmCRTC4_DCFE_MEM_LIGHT_SLEEP_CNTL                                       0x477f
#define mmCRTC5_DCFE_MEM_LIGHT_SLEEP_CNTL                                       0x4a7f
#define mmCRTC_H_TOTAL                                                          0x1b80
#define mmCRTC0_CRTC_H_TOTAL                                                    0x1b80
#define mmCRTC1_CRTC_H_TOTAL                                                    0x1e80
#define mmCRTC2_CRTC_H_TOTAL                                                    0x4180
#define mmCRTC3_CRTC_H_TOTAL                                                    0x4480
#define mmCRTC4_CRTC_H_TOTAL                                                    0x4780
#define mmCRTC5_CRTC_H_TOTAL                                                    0x4a80
#define mmCRTC_H_BLANK_START_END                                                0x1b81
#define mmCRTC0_CRTC_H_BLANK_START_END                                          0x1b81
#define mmCRTC1_CRTC_H_BLANK_START_END                                          0x1e81
#define mmCRTC2_CRTC_H_BLANK_START_END                                          0x4181
#define mmCRTC3_CRTC_H_BLANK_START_END                                          0x4481
#define mmCRTC4_CRTC_H_BLANK_START_END                                          0x4781
#define mmCRTC5_CRTC_H_BLANK_START_END                                          0x4a81
#define mmCRTC_H_SYNC_A                                                         0x1b82
#define mmCRTC0_CRTC_H_SYNC_A                                                   0x1b82
#define mmCRTC1_CRTC_H_SYNC_A                                                   0x1e82
#define mmCRTC2_CRTC_H_SYNC_A                                                   0x4182
#define mmCRTC3_CRTC_H_SYNC_A                                                   0x4482
#define mmCRTC4_CRTC_H_SYNC_A                                                   0x4782
#define mmCRTC5_CRTC_H_SYNC_A                                                   0x4a82
#define mmCRTC_H_SYNC_A_CNTL                                                    0x1b83
#define mmCRTC0_CRTC_H_SYNC_A_CNTL                                              0x1b83
#define mmCRTC1_CRTC_H_SYNC_A_CNTL                                              0x1e83
#define mmCRTC2_CRTC_H_SYNC_A_CNTL                                              0x4183
#define mmCRTC3_CRTC_H_SYNC_A_CNTL                                              0x4483
#define mmCRTC4_CRTC_H_SYNC_A_CNTL                                              0x4783
#define mmCRTC5_CRTC_H_SYNC_A_CNTL                                              0x4a83
#define mmCRTC_H_SYNC_B                                                         0x1b84
#define mmCRTC0_CRTC_H_SYNC_B                                                   0x1b84
#define mmCRTC1_CRTC_H_SYNC_B                                                   0x1e84
#define mmCRTC2_CRTC_H_SYNC_B                                                   0x4184
#define mmCRTC3_CRTC_H_SYNC_B                                                   0x4484
#define mmCRTC4_CRTC_H_SYNC_B                                                   0x4784
#define mmCRTC5_CRTC_H_SYNC_B                                                   0x4a84
#define mmCRTC_H_SYNC_B_CNTL                                                    0x1b85
#define mmCRTC0_CRTC_H_SYNC_B_CNTL                                              0x1b85
#define mmCRTC1_CRTC_H_SYNC_B_CNTL                                              0x1e85
#define mmCRTC2_CRTC_H_SYNC_B_CNTL                                              0x4185
#define mmCRTC3_CRTC_H_SYNC_B_CNTL                                              0x4485
#define mmCRTC4_CRTC_H_SYNC_B_CNTL                                              0x4785
#define mmCRTC5_CRTC_H_SYNC_B_CNTL                                              0x4a85
#define mmCRTC_VBI_END                                                          0x1b86
#define mmCRTC0_CRTC_VBI_END                                                    0x1b86
#define mmCRTC1_CRTC_VBI_END                                                    0x1e86
#define mmCRTC2_CRTC_VBI_END                                                    0x4186
#define mmCRTC3_CRTC_VBI_END                                                    0x4486
#define mmCRTC4_CRTC_VBI_END                                                    0x4786
#define mmCRTC5_CRTC_VBI_END                                                    0x4a86
#define mmCRTC_V_TOTAL                                                          0x1b87
#define mmCRTC0_CRTC_V_TOTAL                                                    0x1b87
#define mmCRTC1_CRTC_V_TOTAL                                                    0x1e87
#define mmCRTC2_CRTC_V_TOTAL                                                    0x4187
#define mmCRTC3_CRTC_V_TOTAL                                                    0x4487
#define mmCRTC4_CRTC_V_TOTAL                                                    0x4787
#define mmCRTC5_CRTC_V_TOTAL                                                    0x4a87
#define mmCRTC_V_TOTAL_MIN                                                      0x1b88
#define mmCRTC0_CRTC_V_TOTAL_MIN                                                0x1b88
#define mmCRTC1_CRTC_V_TOTAL_MIN                                                0x1e88
#define mmCRTC2_CRTC_V_TOTAL_MIN                                                0x4188
#define mmCRTC3_CRTC_V_TOTAL_MIN                                                0x4488
#define mmCRTC4_CRTC_V_TOTAL_MIN                                                0x4788
#define mmCRTC5_CRTC_V_TOTAL_MIN                                                0x4a88
#define mmCRTC_V_TOTAL_MAX                                                      0x1b89
#define mmCRTC0_CRTC_V_TOTAL_MAX                                                0x1b89
#define mmCRTC1_CRTC_V_TOTAL_MAX                                                0x1e89
#define mmCRTC2_CRTC_V_TOTAL_MAX                                                0x4189
#define mmCRTC3_CRTC_V_TOTAL_MAX                                                0x4489
#define mmCRTC4_CRTC_V_TOTAL_MAX                                                0x4789
#define mmCRTC5_CRTC_V_TOTAL_MAX                                                0x4a89
#define mmCRTC_V_TOTAL_CONTROL                                                  0x1b8a
#define mmCRTC0_CRTC_V_TOTAL_CONTROL                                            0x1b8a
#define mmCRTC1_CRTC_V_TOTAL_CONTROL                                            0x1e8a
#define mmCRTC2_CRTC_V_TOTAL_CONTROL                                            0x418a
#define mmCRTC3_CRTC_V_TOTAL_CONTROL                                            0x448a
#define mmCRTC4_CRTC_V_TOTAL_CONTROL                                            0x478a
#define mmCRTC5_CRTC_V_TOTAL_CONTROL                                            0x4a8a
#define mmCRTC_V_TOTAL_INT_STATUS                                               0x1b8b
#define mmCRTC0_CRTC_V_TOTAL_INT_STATUS                                         0x1b8b
#define mmCRTC1_CRTC_V_TOTAL_INT_STATUS                                         0x1e8b
#define mmCRTC2_CRTC_V_TOTAL_INT_STATUS                                         0x418b
#define mmCRTC3_CRTC_V_TOTAL_INT_STATUS                                         0x448b
#define mmCRTC4_CRTC_V_TOTAL_INT_STATUS                                         0x478b
#define mmCRTC5_CRTC_V_TOTAL_INT_STATUS                                         0x4a8b
#define mmCRTC_VSYNC_NOM_INT_STATUS                                             0x1b8c
#define mmCRTC0_CRTC_VSYNC_NOM_INT_STATUS                                       0x1b8c
#define mmCRTC1_CRTC_VSYNC_NOM_INT_STATUS                                       0x1e8c
#define mmCRTC2_CRTC_VSYNC_NOM_INT_STATUS                                       0x418c
#define mmCRTC3_CRTC_VSYNC_NOM_INT_STATUS                                       0x448c
#define mmCRTC4_CRTC_VSYNC_NOM_INT_STATUS                                       0x478c
#define mmCRTC5_CRTC_VSYNC_NOM_INT_STATUS                                       0x4a8c
#define mmCRTC_V_BLANK_START_END                                                0x1b8d
#define mmCRTC0_CRTC_V_BLANK_START_END                                          0x1b8d
#define mmCRTC1_CRTC_V_BLANK_START_END                                          0x1e8d
#define mmCRTC2_CRTC_V_BLANK_START_END                                          0x418d
#define mmCRTC3_CRTC_V_BLANK_START_END                                          0x448d
#define mmCRTC4_CRTC_V_BLANK_START_END                                          0x478d
#define mmCRTC5_CRTC_V_BLANK_START_END                                          0x4a8d
#define mmCRTC_V_SYNC_A                                                         0x1b8e
#define mmCRTC0_CRTC_V_SYNC_A                                                   0x1b8e
#define mmCRTC1_CRTC_V_SYNC_A                                                   0x1e8e
#define mmCRTC2_CRTC_V_SYNC_A                                                   0x418e
#define mmCRTC3_CRTC_V_SYNC_A                                                   0x448e
#define mmCRTC4_CRTC_V_SYNC_A                                                   0x478e
#define mmCRTC5_CRTC_V_SYNC_A                                                   0x4a8e
#define mmCRTC_V_SYNC_A_CNTL                                                    0x1b8f
#define mmCRTC0_CRTC_V_SYNC_A_CNTL                                              0x1b8f
#define mmCRTC1_CRTC_V_SYNC_A_CNTL                                              0x1e8f
#define mmCRTC2_CRTC_V_SYNC_A_CNTL                                              0x418f
#define mmCRTC3_CRTC_V_SYNC_A_CNTL                                              0x448f
#define mmCRTC4_CRTC_V_SYNC_A_CNTL                                              0x478f
#define mmCRTC5_CRTC_V_SYNC_A_CNTL                                              0x4a8f
#define mmCRTC_V_SYNC_B                                                         0x1b90
#define mmCRTC0_CRTC_V_SYNC_B                                                   0x1b90
#define mmCRTC1_CRTC_V_SYNC_B                                                   0x1e90
#define mmCRTC2_CRTC_V_SYNC_B                                                   0x4190
#define mmCRTC3_CRTC_V_SYNC_B                                                   0x4490
#define mmCRTC4_CRTC_V_SYNC_B                                                   0x4790
#define mmCRTC5_CRTC_V_SYNC_B                                                   0x4a90
#define mmCRTC_V_SYNC_B_CNTL                                                    0x1b91
#define mmCRTC0_CRTC_V_SYNC_B_CNTL                                              0x1b91
#define mmCRTC1_CRTC_V_SYNC_B_CNTL                                              0x1e91
#define mmCRTC2_CRTC_V_SYNC_B_CNTL                                              0x4191
#define mmCRTC3_CRTC_V_SYNC_B_CNTL                                              0x4491
#define mmCRTC4_CRTC_V_SYNC_B_CNTL                                              0x4791
#define mmCRTC5_CRTC_V_SYNC_B_CNTL                                              0x4a91
#define mmCRTC_DTMTEST_CNTL                                                     0x1b92
#define mmCRTC0_CRTC_DTMTEST_CNTL                                               0x1b92
#define mmCRTC1_CRTC_DTMTEST_CNTL                                               0x1e92
#define mmCRTC2_CRTC_DTMTEST_CNTL                                               0x4192
#define mmCRTC3_CRTC_DTMTEST_CNTL                                               0x4492
#define mmCRTC4_CRTC_DTMTEST_CNTL                                               0x4792
#define mmCRTC5_CRTC_DTMTEST_CNTL                                               0x4a92
#define mmCRTC_DTMTEST_STATUS_POSITION                                          0x1b93
#define mmCRTC0_CRTC_DTMTEST_STATUS_POSITION                                    0x1b93
#define mmCRTC1_CRTC_DTMTEST_STATUS_POSITION                                    0x1e93
#define mmCRTC2_CRTC_DTMTEST_STATUS_POSITION                                    0x4193
#define mmCRTC3_CRTC_DTMTEST_STATUS_POSITION                                    0x4493
#define mmCRTC4_CRTC_DTMTEST_STATUS_POSITION                                    0x4793
#define mmCRTC5_CRTC_DTMTEST_STATUS_POSITION                                    0x4a93
#define mmCRTC_TRIGA_CNTL                                                       0x1b94
#define mmCRTC0_CRTC_TRIGA_CNTL                                                 0x1b94
#define mmCRTC1_CRTC_TRIGA_CNTL                                                 0x1e94
#define mmCRTC2_CRTC_TRIGA_CNTL                                                 0x4194
#define mmCRTC3_CRTC_TRIGA_CNTL                                                 0x4494
#define mmCRTC4_CRTC_TRIGA_CNTL                                                 0x4794
#define mmCRTC5_CRTC_TRIGA_CNTL                                                 0x4a94
#define mmCRTC_TRIGA_MANUAL_TRIG                                                0x1b95
#define mmCRTC0_CRTC_TRIGA_MANUAL_TRIG                                          0x1b95
#define mmCRTC1_CRTC_TRIGA_MANUAL_TRIG                                          0x1e95
#define mmCRTC2_CRTC_TRIGA_MANUAL_TRIG                                          0x4195
#define mmCRTC3_CRTC_TRIGA_MANUAL_TRIG                                          0x4495
#define mmCRTC4_CRTC_TRIGA_MANUAL_TRIG                                          0x4795
#define mmCRTC5_CRTC_TRIGA_MANUAL_TRIG                                          0x4a95
#define mmCRTC_TRIGB_CNTL                                                       0x1b96
#define mmCRTC0_CRTC_TRIGB_CNTL                                                 0x1b96
#define mmCRTC1_CRTC_TRIGB_CNTL                                                 0x1e96
#define mmCRTC2_CRTC_TRIGB_CNTL                                                 0x4196
#define mmCRTC3_CRTC_TRIGB_CNTL                                                 0x4496
#define mmCRTC4_CRTC_TRIGB_CNTL                                                 0x4796
#define mmCRTC5_CRTC_TRIGB_CNTL                                                 0x4a96
#define mmCRTC_TRIGB_MANUAL_TRIG                                                0x1b97
#define mmCRTC0_CRTC_TRIGB_MANUAL_TRIG                                          0x1b97
#define mmCRTC1_CRTC_TRIGB_MANUAL_TRIG                                          0x1e97
#define mmCRTC2_CRTC_TRIGB_MANUAL_TRIG                                          0x4197
#define mmCRTC3_CRTC_TRIGB_MANUAL_TRIG                                          0x4497
#define mmCRTC4_CRTC_TRIGB_MANUAL_TRIG                                          0x4797
#define mmCRTC5_CRTC_TRIGB_MANUAL_TRIG                                          0x4a97
#define mmCRTC_FORCE_COUNT_NOW_CNTL                                             0x1b98
#define mmCRTC0_CRTC_FORCE_COUNT_NOW_CNTL                                       0x1b98
#define mmCRTC1_CRTC_FORCE_COUNT_NOW_CNTL                                       0x1e98
#define mmCRTC2_CRTC_FORCE_COUNT_NOW_CNTL                                       0x4198
#define mmCRTC3_CRTC_FORCE_COUNT_NOW_CNTL                                       0x4498
#define mmCRTC4_CRTC_FORCE_COUNT_NOW_CNTL                                       0x4798
#define mmCRTC5_CRTC_FORCE_COUNT_NOW_CNTL                                       0x4a98
#define mmCRTC_FLOW_CONTROL                                                     0x1b99
#define mmCRTC0_CRTC_FLOW_CONTROL                                               0x1b99
#define mmCRTC1_CRTC_FLOW_CONTROL                                               0x1e99
#define mmCRTC2_CRTC_FLOW_CONTROL                                               0x4199
#define mmCRTC3_CRTC_FLOW_CONTROL                                               0x4499
#define mmCRTC4_CRTC_FLOW_CONTROL                                               0x4799
#define mmCRTC5_CRTC_FLOW_CONTROL                                               0x4a99
#define mmCRTC_STEREO_FORCE_NEXT_EYE                                            0x1b9b
#define mmCRTC0_CRTC_STEREO_FORCE_NEXT_EYE                                      0x1b9b
#define mmCRTC1_CRTC_STEREO_FORCE_NEXT_EYE                                      0x1e9b
#define mmCRTC2_CRTC_STEREO_FORCE_NEXT_EYE                                      0x419b
#define mmCRTC3_CRTC_STEREO_FORCE_NEXT_EYE                                      0x449b
#define mmCRTC4_CRTC_STEREO_FORCE_NEXT_EYE                                      0x479b
#define mmCRTC5_CRTC_STEREO_FORCE_NEXT_EYE                                      0x4a9b
#define mmCRTC_CONTROL                                                          0x1b9c
#define mmCRTC0_CRTC_CONTROL                                                    0x1b9c
#define mmCRTC1_CRTC_CONTROL                                                    0x1e9c
#define mmCRTC2_CRTC_CONTROL                                                    0x419c
#define mmCRTC3_CRTC_CONTROL                                                    0x449c
#define mmCRTC4_CRTC_CONTROL                                                    0x479c
#define mmCRTC5_CRTC_CONTROL                                                    0x4a9c
#define mmCRTC_BLANK_CONTROL                                                    0x1b9d
#define mmCRTC0_CRTC_BLANK_CONTROL                                              0x1b9d
#define mmCRTC1_CRTC_BLANK_CONTROL                                              0x1e9d
#define mmCRTC2_CRTC_BLANK_CONTROL                                              0x419d
#define mmCRTC3_CRTC_BLANK_CONTROL                                              0x449d
#define mmCRTC4_CRTC_BLANK_CONTROL                                              0x479d
#define mmCRTC5_CRTC_BLANK_CONTROL                                              0x4a9d
#define mmCRTC_INTERLACE_CONTROL                                                0x1b9e
#define mmCRTC0_CRTC_INTERLACE_CONTROL                                          0x1b9e
#define mmCRTC1_CRTC_INTERLACE_CONTROL                                          0x1e9e
#define mmCRTC2_CRTC_INTERLACE_CONTROL                                          0x419e
#define mmCRTC3_CRTC_INTERLACE_CONTROL                                          0x449e
#define mmCRTC4_CRTC_INTERLACE_CONTROL                                          0x479e
#define mmCRTC5_CRTC_INTERLACE_CONTROL                                          0x4a9e
#define mmCRTC_INTERLACE_STATUS                                                 0x1b9f
#define mmCRTC0_CRTC_INTERLACE_STATUS                                           0x1b9f
#define mmCRTC1_CRTC_INTERLACE_STATUS                                           0x1e9f
#define mmCRTC2_CRTC_INTERLACE_STATUS                                           0x419f
#define mmCRTC3_CRTC_INTERLACE_STATUS                                           0x449f
#define mmCRTC4_CRTC_INTERLACE_STATUS                                           0x479f
#define mmCRTC5_CRTC_INTERLACE_STATUS                                           0x4a9f
#define mmCRTC_FIELD_INDICATION_CONTROL                                         0x1ba0
#define mmCRTC0_CRTC_FIELD_INDICATION_CONTROL                                   0x1ba0
#define mmCRTC1_CRTC_FIELD_INDICATION_CONTROL                                   0x1ea0
#define mmCRTC2_CRTC_FIELD_INDICATION_CONTROL                                   0x41a0
#define mmCRTC3_CRTC_FIELD_INDICATION_CONTROL                                   0x44a0
#define mmCRTC4_CRTC_FIELD_INDICATION_CONTROL                                   0x47a0
#define mmCRTC5_CRTC_FIELD_INDICATION_CONTROL                                   0x4aa0
#define mmCRTC_PIXEL_DATA_READBACK0                                             0x1ba1
#define mmCRTC0_CRTC_PIXEL_DATA_READBACK0                                       0x1ba1
#define mmCRTC1_CRTC_PIXEL_DATA_READBACK0                                       0x1ea1
#define mmCRTC2_CRTC_PIXEL_DATA_READBACK0                                       0x41a1
#define mmCRTC3_CRTC_PIXEL_DATA_READBACK0                                       0x44a1
#define mmCRTC4_CRTC_PIXEL_DATA_READBACK0                                       0x47a1
#define mmCRTC5_CRTC_PIXEL_DATA_READBACK0                                       0x4aa1
#define mmCRTC_PIXEL_DATA_READBACK1                                             0x1ba2
#define mmCRTC0_CRTC_PIXEL_DATA_READBACK1                                       0x1ba2
#define mmCRTC1_CRTC_PIXEL_DATA_READBACK1                                       0x1ea2
#define mmCRTC2_CRTC_PIXEL_DATA_READBACK1                                       0x41a2
#define mmCRTC3_CRTC_PIXEL_DATA_READBACK1                                       0x44a2
#define mmCRTC4_CRTC_PIXEL_DATA_READBACK1                                       0x47a2
#define mmCRTC5_CRTC_PIXEL_DATA_READBACK1                                       0x4aa2
#define mmCRTC_STATUS                                                           0x1ba3
#define mmCRTC0_CRTC_STATUS                                                     0x1ba3
#define mmCRTC1_CRTC_STATUS                                                     0x1ea3
#define mmCRTC2_CRTC_STATUS                                                     0x41a3
#define mmCRTC3_CRTC_STATUS                                                     0x44a3
#define mmCRTC4_CRTC_STATUS                                                     0x47a3
#define mmCRTC5_CRTC_STATUS                                                     0x4aa3
#define mmCRTC_STATUS_POSITION                                                  0x1ba4
#define mmCRTC0_CRTC_STATUS_POSITION                                            0x1ba4
#define mmCRTC1_CRTC_STATUS_POSITION                                            0x1ea4
#define mmCRTC2_CRTC_STATUS_POSITION                                            0x41a4
#define mmCRTC3_CRTC_STATUS_POSITION                                            0x44a4
#define mmCRTC4_CRTC_STATUS_POSITION                                            0x47a4
#define mmCRTC5_CRTC_STATUS_POSITION                                            0x4aa4
#define mmCRTC_NOM_VERT_POSITION                                                0x1ba5
#define mmCRTC0_CRTC_NOM_VERT_POSITION                                          0x1ba5
#define mmCRTC1_CRTC_NOM_VERT_POSITION                                          0x1ea5
#define mmCRTC2_CRTC_NOM_VERT_POSITION                                          0x41a5
#define mmCRTC3_CRTC_NOM_VERT_POSITION                                          0x44a5
#define mmCRTC4_CRTC_NOM_VERT_POSITION                                          0x47a5
#define mmCRTC5_CRTC_NOM_VERT_POSITION                                          0x4aa5
#define mmCRTC_STATUS_FRAME_COUNT                                               0x1ba6
#define mmCRTC0_CRTC_STATUS_FRAME_COUNT                                         0x1ba6
#define mmCRTC1_CRTC_STATUS_FRAME_COUNT                                         0x1ea6
#define mmCRTC2_CRTC_STATUS_FRAME_COUNT                                         0x41a6
#define mmCRTC3_CRTC_STATUS_FRAME_COUNT                                         0x44a6
#define mmCRTC4_CRTC_STATUS_FRAME_COUNT                                         0x47a6
#define mmCRTC5_CRTC_STATUS_FRAME_COUNT                                         0x4aa6
#define mmCRTC_STATUS_VF_COUNT                                                  0x1ba7
#define mmCRTC0_CRTC_STATUS_VF_COUNT                                            0x1ba7
#define mmCRTC1_CRTC_STATUS_VF_COUNT                                            0x1ea7
#define mmCRTC2_CRTC_STATUS_VF_COUNT                                            0x41a7
#define mmCRTC3_CRTC_STATUS_VF_COUNT                                            0x44a7
#define mmCRTC4_CRTC_STATUS_VF_COUNT                                            0x47a7
#define mmCRTC5_CRTC_STATUS_VF_COUNT                                            0x4aa7
#define mmCRTC_STATUS_HV_COUNT                                                  0x1ba8
#define mmCRTC0_CRTC_STATUS_HV_COUNT                                            0x1ba8
#define mmCRTC1_CRTC_STATUS_HV_COUNT                                            0x1ea8
#define mmCRTC2_CRTC_STATUS_HV_COUNT                                            0x41a8
#define mmCRTC3_CRTC_STATUS_HV_COUNT                                            0x44a8
#define mmCRTC4_CRTC_STATUS_HV_COUNT                                            0x47a8
#define mmCRTC5_CRTC_STATUS_HV_COUNT                                            0x4aa8
#define mmCRTC_COUNT_CONTROL                                                    0x1ba9
#define mmCRTC0_CRTC_COUNT_CONTROL                                              0x1ba9
#define mmCRTC1_CRTC_COUNT_CONTROL                                              0x1ea9
#define mmCRTC2_CRTC_COUNT_CONTROL                                              0x41a9
#define mmCRTC3_CRTC_COUNT_CONTROL                                              0x44a9
#define mmCRTC4_CRTC_COUNT_CONTROL                                              0x47a9
#define mmCRTC5_CRTC_COUNT_CONTROL                                              0x4aa9
#define mmCRTC_COUNT_RESET                                                      0x1baa
#define mmCRTC0_CRTC_COUNT_RESET                                                0x1baa
#define mmCRTC1_CRTC_COUNT_RESET                                                0x1eaa
#define mmCRTC2_CRTC_COUNT_RESET                                                0x41aa
#define mmCRTC3_CRTC_COUNT_RESET                                                0x44aa
#define mmCRTC4_CRTC_COUNT_RESET                                                0x47aa
#define mmCRTC5_CRTC_COUNT_RESET                                                0x4aaa
#define mmCRTC_MANUAL_FORCE_VSYNC_NEXT_LINE                                     0x1bab
#define mmCRTC0_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE                               0x1bab
#define mmCRTC1_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE                               0x1eab
#define mmCRTC2_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE                               0x41ab
#define mmCRTC3_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE                               0x44ab
#define mmCRTC4_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE                               0x47ab
#define mmCRTC5_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE                               0x4aab
#define mmCRTC_VERT_SYNC_CONTROL                                                0x1bac
#define mmCRTC0_CRTC_VERT_SYNC_CONTROL                                          0x1bac
#define mmCRTC1_CRTC_VERT_SYNC_CONTROL                                          0x1eac
#define mmCRTC2_CRTC_VERT_SYNC_CONTROL                                          0x41ac
#define mmCRTC3_CRTC_VERT_SYNC_CONTROL                                          0x44ac
#define mmCRTC4_CRTC_VERT_SYNC_CONTROL                                          0x47ac
#define mmCRTC5_CRTC_VERT_SYNC_CONTROL                                          0x4aac
#define mmCRTC_STEREO_STATUS                                                    0x1bad
#define mmCRTC0_CRTC_STEREO_STATUS                                              0x1bad
#define mmCRTC1_CRTC_STEREO_STATUS                                              0x1ead
#define mmCRTC2_CRTC_STEREO_STATUS                                              0x41ad
#define mmCRTC3_CRTC_STEREO_STATUS                                              0x44ad
#define mmCRTC4_CRTC_STEREO_STATUS                                              0x47ad
#define mmCRTC5_CRTC_STEREO_STATUS                                              0x4aad
#define mmCRTC_STEREO_CONTROL                                                   0x1bae
#define mmCRTC0_CRTC_STEREO_CONTROL                                             0x1bae
#define mmCRTC1_CRTC_STEREO_CONTROL                                             0x1eae
#define mmCRTC2_CRTC_STEREO_CONTROL                                             0x41ae
#define mmCRTC3_CRTC_STEREO_CONTROL                                             0x44ae
#define mmCRTC4_CRTC_STEREO_CONTROL                                             0x47ae
#define mmCRTC5_CRTC_STEREO_CONTROL                                             0x4aae
#define mmCRTC_SNAPSHOT_STATUS                                                  0x1baf
#define mmCRTC0_CRTC_SNAPSHOT_STATUS                                            0x1baf
#define mmCRTC1_CRTC_SNAPSHOT_STATUS                                            0x1eaf
#define mmCRTC2_CRTC_SNAPSHOT_STATUS                                            0x41af
#define mmCRTC3_CRTC_SNAPSHOT_STATUS                                            0x44af
#define mmCRTC4_CRTC_SNAPSHOT_STATUS                                            0x47af
#define mmCRTC5_CRTC_SNAPSHOT_STATUS                                            0x4aaf
#define mmCRTC_SNAPSHOT_CONTROL                                                 0x1bb0
#define mmCRTC0_CRTC_SNAPSHOT_CONTROL                                           0x1bb0
#define mmCRTC1_CRTC_SNAPSHOT_CONTROL                                           0x1eb0
#define mmCRTC2_CRTC_SNAPSHOT_CONTROL                                           0x41b0
#define mmCRTC3_CRTC_SNAPSHOT_CONTROL                                           0x44b0
#define mmCRTC4_CRTC_SNAPSHOT_CONTROL                                           0x47b0
#define mmCRTC5_CRTC_SNAPSHOT_CONTROL                                           0x4ab0
#define mmCRTC_SNAPSHOT_POSITION                                                0x1bb1
#define mmCRTC0_CRTC_SNAPSHOT_POSITION                                          0x1bb1
#define mmCRTC1_CRTC_SNAPSHOT_POSITION                                          0x1eb1
#define mmCRTC2_CRTC_SNAPSHOT_POSITION                                          0x41b1
#define mmCRTC3_CRTC_SNAPSHOT_POSITION                                          0x44b1
#define mmCRTC4_CRTC_SNAPSHOT_POSITION                                          0x47b1
#define mmCRTC5_CRTC_SNAPSHOT_POSITION                                          0x4ab1
#define mmCRTC_SNAPSHOT_FRAME                                                   0x1bb2
#define mmCRTC0_CRTC_SNAPSHOT_FRAME                                             0x1bb2
#define mmCRTC1_CRTC_SNAPSHOT_FRAME                                             0x1eb2
#define mmCRTC2_CRTC_SNAPSHOT_FRAME                                             0x41b2
#define mmCRTC3_CRTC_SNAPSHOT_FRAME                                             0x44b2
#define mmCRTC4_CRTC_SNAPSHOT_FRAME                                             0x47b2
#define mmCRTC5_CRTC_SNAPSHOT_FRAME                                             0x4ab2
#define mmCRTC_START_LINE_CONTROL                                               0x1bb3
#define mmCRTC0_CRTC_START_LINE_CONTROL                                         0x1bb3
#define mmCRTC1_CRTC_START_LINE_CONTROL                                         0x1eb3
#define mmCRTC2_CRTC_START_LINE_CONTROL                                         0x41b3
#define mmCRTC3_CRTC_START_LINE_CONTROL                                         0x44b3
#define mmCRTC4_CRTC_START_LINE_CONTROL                                         0x47b3
#define mmCRTC5_CRTC_START_LINE_CONTROL                                         0x4ab3
#define mmCRTC_INTERRUPT_CONTROL                                                0x1bb4
#define mmCRTC0_CRTC_INTERRUPT_CONTROL                                          0x1bb4
#define mmCRTC1_CRTC_INTERRUPT_CONTROL                                          0x1eb4
#define mmCRTC2_CRTC_INTERRUPT_CONTROL                                          0x41b4
#define mmCRTC3_CRTC_INTERRUPT_CONTROL                                          0x44b4
#define mmCRTC4_CRTC_INTERRUPT_CONTROL                                          0x47b4
#define mmCRTC5_CRTC_INTERRUPT_CONTROL                                          0x4ab4
#define mmCRTC_UPDATE_LOCK                                                      0x1bb5
#define mmCRTC0_CRTC_UPDATE_LOCK                                                0x1bb5
#define mmCRTC1_CRTC_UPDATE_LOCK                                                0x1eb5
#define mmCRTC2_CRTC_UPDATE_LOCK                                                0x41b5
#define mmCRTC3_CRTC_UPDATE_LOCK                                                0x44b5
#define mmCRTC4_CRTC_UPDATE_LOCK                                                0x47b5
#define mmCRTC5_CRTC_UPDATE_LOCK                                                0x4ab5
#define mmCRTC_DOUBLE_BUFFER_CONTROL                                            0x1bb6
#define mmCRTC0_CRTC_DOUBLE_BUFFER_CONTROL                                      0x1bb6
#define mmCRTC1_CRTC_DOUBLE_BUFFER_CONTROL                                      0x1eb6
#define mmCRTC2_CRTC_DOUBLE_BUFFER_CONTROL                                      0x41b6
#define mmCRTC3_CRTC_DOUBLE_BUFFER_CONTROL                                      0x44b6
#define mmCRTC4_CRTC_DOUBLE_BUFFER_CONTROL                                      0x47b6
#define mmCRTC5_CRTC_DOUBLE_BUFFER_CONTROL                                      0x4ab6
#define mmCRTC_VGA_PARAMETER_CAPTURE_MODE                                       0x1bb7
#define mmCRTC0_CRTC_VGA_PARAMETER_CAPTURE_MODE                                 0x1bb7
#define mmCRTC1_CRTC_VGA_PARAMETER_CAPTURE_MODE                                 0x1eb7
#define mmCRTC2_CRTC_VGA_PARAMETER_CAPTURE_MODE                                 0x41b7
#define mmCRTC3_CRTC_VGA_PARAMETER_CAPTURE_MODE                                 0x44b7
#define mmCRTC4_CRTC_VGA_PARAMETER_CAPTURE_MODE                                 0x47b7
#define mmCRTC5_CRTC_VGA_PARAMETER_CAPTURE_MODE                                 0x4ab7
#define mmCRTC_TEST_PATTERN_CONTROL                                             0x1bba
#define mmCRTC0_CRTC_TEST_PATTERN_CONTROL                                       0x1bba
#define mmCRTC1_CRTC_TEST_PATTERN_CONTROL                                       0x1eba
#define mmCRTC2_CRTC_TEST_PATTERN_CONTROL                                       0x41ba
#define mmCRTC3_CRTC_TEST_PATTERN_CONTROL                                       0x44ba
#define mmCRTC4_CRTC_TEST_PATTERN_CONTROL                                       0x47ba
#define mmCRTC5_CRTC_TEST_PATTERN_CONTROL                                       0x4aba
#define mmCRTC_TEST_PATTERN_PARAMETERS                                          0x1bbb
#define mmCRTC0_CRTC_TEST_PATTERN_PARAMETERS                                    0x1bbb
#define mmCRTC1_CRTC_TEST_PATTERN_PARAMETERS                                    0x1ebb
#define mmCRTC2_CRTC_TEST_PATTERN_PARAMETERS                                    0x41bb
#define mmCRTC3_CRTC_TEST_PATTERN_PARAMETERS                                    0x44bb
#define mmCRTC4_CRTC_TEST_PATTERN_PARAMETERS                                    0x47bb
#define mmCRTC5_CRTC_TEST_PATTERN_PARAMETERS                                    0x4abb
#define mmCRTC_TEST_PATTERN_COLOR                                               0x1bbc
#define mmCRTC0_CRTC_TEST_PATTERN_COLOR                                         0x1bbc
#define mmCRTC1_CRTC_TEST_PATTERN_COLOR                                         0x1ebc
#define mmCRTC2_CRTC_TEST_PATTERN_COLOR                                         0x41bc
#define mmCRTC3_CRTC_TEST_PATTERN_COLOR                                         0x44bc
#define mmCRTC4_CRTC_TEST_PATTERN_COLOR                                         0x47bc
#define mmCRTC5_CRTC_TEST_PATTERN_COLOR                                         0x4abc
#define mmMASTER_UPDATE_LOCK                                                    0x1bbd
#define mmCRTC0_MASTER_UPDATE_LOCK                                              0x1bbd
#define mmCRTC1_MASTER_UPDATE_LOCK                                              0x1ebd
#define mmCRTC2_MASTER_UPDATE_LOCK                                              0x41bd
#define mmCRTC3_MASTER_UPDATE_LOCK                                              0x44bd
#define mmCRTC4_MASTER_UPDATE_LOCK                                              0x47bd
#define mmCRTC5_MASTER_UPDATE_LOCK                                              0x4abd
#define mmMASTER_UPDATE_MODE                                                    0x1bbe
#define mmCRTC0_MASTER_UPDATE_MODE                                              0x1bbe
#define mmCRTC1_MASTER_UPDATE_MODE                                              0x1ebe
#define mmCRTC2_MASTER_UPDATE_MODE                                              0x41be
#define mmCRTC3_MASTER_UPDATE_MODE                                              0x44be
#define mmCRTC4_MASTER_UPDATE_MODE                                              0x47be
#define mmCRTC5_MASTER_UPDATE_MODE                                              0x4abe
#define mmCRTC_MVP_INBAND_CNTL_INSERT                                           0x1bbf
#define mmCRTC0_CRTC_MVP_INBAND_CNTL_INSERT                                     0x1bbf
#define mmCRTC1_CRTC_MVP_INBAND_CNTL_INSERT                                     0x1ebf
#define mmCRTC2_CRTC_MVP_INBAND_CNTL_INSERT                                     0x41bf
#define mmCRTC3_CRTC_MVP_INBAND_CNTL_INSERT                                     0x44bf
#define mmCRTC4_CRTC_MVP_INBAND_CNTL_INSERT                                     0x47bf
#define mmCRTC5_CRTC_MVP_INBAND_CNTL_INSERT                                     0x4abf
#define mmCRTC_MVP_INBAND_CNTL_INSERT_TIMER                                     0x1bc0
#define mmCRTC0_CRTC_MVP_INBAND_CNTL_INSERT_TIMER                               0x1bc0
#define mmCRTC1_CRTC_MVP_INBAND_CNTL_INSERT_TIMER                               0x1ec0
#define mmCRTC2_CRTC_MVP_INBAND_CNTL_INSERT_TIMER                               0x41c0
#define mmCRTC3_CRTC_MVP_INBAND_CNTL_INSERT_TIMER                               0x44c0
#define mmCRTC4_CRTC_MVP_INBAND_CNTL_INSERT_TIMER                               0x47c0
#define mmCRTC5_CRTC_MVP_INBAND_CNTL_INSERT_TIMER                               0x4ac0
#define mmCRTC_MVP_STATUS                                                       0x1bc1
#define mmCRTC0_CRTC_MVP_STATUS                                                 0x1bc1
#define mmCRTC1_CRTC_MVP_STATUS                                                 0x1ec1
#define mmCRTC2_CRTC_MVP_STATUS                                                 0x41c1
#define mmCRTC3_CRTC_MVP_STATUS                                                 0x44c1
#define mmCRTC4_CRTC_MVP_STATUS                                                 0x47c1
#define mmCRTC5_CRTC_MVP_STATUS                                                 0x4ac1
#define mmCRTC_MASTER_EN                                                        0x1bc2
#define mmCRTC0_CRTC_MASTER_EN                                                  0x1bc2
#define mmCRTC1_CRTC_MASTER_EN                                                  0x1ec2
#define mmCRTC2_CRTC_MASTER_EN                                                  0x41c2
#define mmCRTC3_CRTC_MASTER_EN                                                  0x44c2
#define mmCRTC4_CRTC_MASTER_EN                                                  0x47c2
#define mmCRTC5_CRTC_MASTER_EN                                                  0x4ac2
#define mmCRTC_ALLOW_STOP_OFF_V_CNT                                             0x1bc3
#define mmCRTC0_CRTC_ALLOW_STOP_OFF_V_CNT                                       0x1bc3
#define mmCRTC1_CRTC_ALLOW_STOP_OFF_V_CNT                                       0x1ec3
#define mmCRTC2_CRTC_ALLOW_STOP_OFF_V_CNT                                       0x41c3
#define mmCRTC3_CRTC_ALLOW_STOP_OFF_V_CNT                                       0x44c3
#define mmCRTC4_CRTC_ALLOW_STOP_OFF_V_CNT                                       0x47c3
#define mmCRTC5_CRTC_ALLOW_STOP_OFF_V_CNT                                       0x4ac3
#define mmCRTC_V_UPDATE_INT_STATUS                                              0x1bc4
#define mmCRTC0_CRTC_V_UPDATE_INT_STATUS                                        0x1bc4
#define mmCRTC1_CRTC_V_UPDATE_INT_STATUS                                        0x1ec4
#define mmCRTC2_CRTC_V_UPDATE_INT_STATUS                                        0x41c4
#define mmCRTC3_CRTC_V_UPDATE_INT_STATUS                                        0x44c4
#define mmCRTC4_CRTC_V_UPDATE_INT_STATUS                                        0x47c4
#define mmCRTC5_CRTC_V_UPDATE_INT_STATUS                                        0x4ac4
#define mmCRTC_OVERSCAN_COLOR                                                   0x1bc8
#define mmCRTC0_CRTC_OVERSCAN_COLOR                                             0x1bc8
#define mmCRTC1_CRTC_OVERSCAN_COLOR                                             0x1ec8
#define mmCRTC2_CRTC_OVERSCAN_COLOR                                             0x41c8
#define mmCRTC3_CRTC_OVERSCAN_COLOR                                             0x44c8
#define mmCRTC4_CRTC_OVERSCAN_COLOR                                             0x47c8
#define mmCRTC5_CRTC_OVERSCAN_COLOR                                             0x4ac8
#define mmCRTC_OVERSCAN_COLOR_EXT                                               0x1bc9
#define mmCRTC0_CRTC_OVERSCAN_COLOR_EXT                                         0x1bc9
#define mmCRTC1_CRTC_OVERSCAN_COLOR_EXT                                         0x1ec9
#define mmCRTC2_CRTC_OVERSCAN_COLOR_EXT                                         0x41c9
#define mmCRTC3_CRTC_OVERSCAN_COLOR_EXT                                         0x44c9
#define mmCRTC4_CRTC_OVERSCAN_COLOR_EXT                                         0x47c9
#define mmCRTC5_CRTC_OVERSCAN_COLOR_EXT                                         0x4ac9
#define mmCRTC_BLANK_DATA_COLOR                                                 0x1bca
#define mmCRTC0_CRTC_BLANK_DATA_COLOR                                           0x1bca
#define mmCRTC1_CRTC_BLANK_DATA_COLOR                                           0x1eca
#define mmCRTC2_CRTC_BLANK_DATA_COLOR                                           0x41ca
#define mmCRTC3_CRTC_BLANK_DATA_COLOR                                           0x44ca
#define mmCRTC4_CRTC_BLANK_DATA_COLOR                                           0x47ca
#define mmCRTC5_CRTC_BLANK_DATA_COLOR                                           0x4aca
#define mmCRTC_BLANK_DATA_COLOR_EXT                                             0x1bcb
#define mmCRTC0_CRTC_BLANK_DATA_COLOR_EXT                                       0x1bcb
#define mmCRTC1_CRTC_BLANK_DATA_COLOR_EXT                                       0x1ecb
#define mmCRTC2_CRTC_BLANK_DATA_COLOR_EXT                                       0x41cb
#define mmCRTC3_CRTC_BLANK_DATA_COLOR_EXT                                       0x44cb
#define mmCRTC4_CRTC_BLANK_DATA_COLOR_EXT                                       0x47cb
#define mmCRTC5_CRTC_BLANK_DATA_COLOR_EXT                                       0x4acb
#define mmCRTC_BLACK_COLOR                                                      0x1bcc
#define mmCRTC0_CRTC_BLACK_COLOR                                                0x1bcc
#define mmCRTC1_CRTC_BLACK_COLOR                                                0x1ecc
#define mmCRTC2_CRTC_BLACK_COLOR                                                0x41cc
#define mmCRTC3_CRTC_BLACK_COLOR                                                0x44cc
#define mmCRTC4_CRTC_BLACK_COLOR                                                0x47cc
#define mmCRTC5_CRTC_BLACK_COLOR                                                0x4acc
#define mmCRTC_BLACK_COLOR_EXT                                                  0x1bcd
#define mmCRTC0_CRTC_BLACK_COLOR_EXT                                            0x1bcd
#define mmCRTC1_CRTC_BLACK_COLOR_EXT                                            0x1ecd
#define mmCRTC2_CRTC_BLACK_COLOR_EXT                                            0x41cd
#define mmCRTC3_CRTC_BLACK_COLOR_EXT                                            0x44cd
#define mmCRTC4_CRTC_BLACK_COLOR_EXT                                            0x47cd
#define mmCRTC5_CRTC_BLACK_COLOR_EXT                                            0x4acd
#define mmCRTC_VERTICAL_INTERRUPT0_POSITION                                     0x1bce
#define mmCRTC0_CRTC_VERTICAL_INTERRUPT0_POSITION                               0x1bce
#define mmCRTC1_CRTC_VERTICAL_INTERRUPT0_POSITION                               0x1ece
#define mmCRTC2_CRTC_VERTICAL_INTERRUPT0_POSITION                               0x41ce
#define mmCRTC3_CRTC_VERTICAL_INTERRUPT0_POSITION                               0x44ce
#define mmCRTC4_CRTC_VERTICAL_INTERRUPT0_POSITION                               0x47ce
#define mmCRTC5_CRTC_VERTICAL_INTERRUPT0_POSITION                               0x4ace
#define mmCRTC_VERTICAL_INTERRUPT0_CONTROL                                      0x1bcf
#define mmCRTC0_CRTC_VERTICAL_INTERRUPT0_CONTROL                                0x1bcf
#define mmCRTC1_CRTC_VERTICAL_INTERRUPT0_CONTROL                                0x1ecf
#define mmCRTC2_CRTC_VERTICAL_INTERRUPT0_CONTROL                                0x41cf
#define mmCRTC3_CRTC_VERTICAL_INTERRUPT0_CONTROL                                0x44cf
#define mmCRTC4_CRTC_VERTICAL_INTERRUPT0_CONTROL                                0x47cf
#define mmCRTC5_CRTC_VERTICAL_INTERRUPT0_CONTROL                                0x4acf
#define mmCRTC_VERTICAL_INTERRUPT1_POSITION                                     0x1bd0
#define mmCRTC0_CRTC_VERTICAL_INTERRUPT1_POSITION                               0x1bd0
#define mmCRTC1_CRTC_VERTICAL_INTERRUPT1_POSITION                               0x1ed0
#define mmCRTC2_CRTC_VERTICAL_INTERRUPT1_POSITION                               0x41d0
#define mmCRTC3_CRTC_VERTICAL_INTERRUPT1_POSITION                               0x44d0
#define mmCRTC4_CRTC_VERTICAL_INTERRUPT1_POSITION                               0x47d0
#define mmCRTC5_CRTC_VERTICAL_INTERRUPT1_POSITION                               0x4ad0
#define mmCRTC_VERTICAL_INTERRUPT1_CONTROL                                      0x1bd1
#define mmCRTC0_CRTC_VERTICAL_INTERRUPT1_CONTROL                                0x1bd1
#define mmCRTC1_CRTC_VERTICAL_INTERRUPT1_CONTROL                                0x1ed1
#define mmCRTC2_CRTC_VERTICAL_INTERRUPT1_CONTROL                                0x41d1
#define mmCRTC3_CRTC_VERTICAL_INTERRUPT1_CONTROL                                0x44d1
#define mmCRTC4_CRTC_VERTICAL_INTERRUPT1_CONTROL                                0x47d1
#define mmCRTC5_CRTC_VERTICAL_INTERRUPT1_CONTROL                                0x4ad1
#define mmCRTC_VERTICAL_INTERRUPT2_POSITION                                     0x1bd2
#define mmCRTC0_CRTC_VERTICAL_INTERRUPT2_POSITION                               0x1bd2
#define mmCRTC1_CRTC_VERTICAL_INTERRUPT2_POSITION                               0x1ed2
#define mmCRTC2_CRTC_VERTICAL_INTERRUPT2_POSITION                               0x41d2
#define mmCRTC3_CRTC_VERTICAL_INTERRUPT2_POSITION                               0x44d2
#define mmCRTC4_CRTC_VERTICAL_INTERRUPT2_POSITION                               0x47d2
#define mmCRTC5_CRTC_VERTICAL_INTERRUPT2_POSITION                               0x4ad2
#define mmCRTC_VERTICAL_INTERRUPT2_CONTROL                                      0x1bd3
#define mmCRTC0_CRTC_VERTICAL_INTERRUPT2_CONTROL                                0x1bd3
#define mmCRTC1_CRTC_VERTICAL_INTERRUPT2_CONTROL                                0x1ed3
#define mmCRTC2_CRTC_VERTICAL_INTERRUPT2_CONTROL                                0x41d3
#define mmCRTC3_CRTC_VERTICAL_INTERRUPT2_CONTROL                                0x44d3
#define mmCRTC4_CRTC_VERTICAL_INTERRUPT2_CONTROL                                0x47d3
#define mmCRTC5_CRTC_VERTICAL_INTERRUPT2_CONTROL                                0x4ad3
#define mmCRTC_CRC_CNTL                                                         0x1bd4
#define mmCRTC0_CRTC_CRC_CNTL                                                   0x1bd4
#define mmCRTC1_CRTC_CRC_CNTL                                                   0x1ed4
#define mmCRTC2_CRTC_CRC_CNTL                                                   0x41d4
#define mmCRTC3_CRTC_CRC_CNTL                                                   0x44d4
#define mmCRTC4_CRTC_CRC_CNTL                                                   0x47d4
#define mmCRTC5_CRTC_CRC_CNTL                                                   0x4ad4
#define mmCRTC_CRC0_WINDOWA_X_CONTROL                                           0x1bd5
#define mmCRTC0_CRTC_CRC0_WINDOWA_X_CONTROL                                     0x1bd5
#define mmCRTC1_CRTC_CRC0_WINDOWA_X_CONTROL                                     0x1ed5
#define mmCRTC2_CRTC_CRC0_WINDOWA_X_CONTROL                                     0x41d5
#define mmCRTC3_CRTC_CRC0_WINDOWA_X_CONTROL                                     0x44d5
#define mmCRTC4_CRTC_CRC0_WINDOWA_X_CONTROL                                     0x47d5
#define mmCRTC5_CRTC_CRC0_WINDOWA_X_CONTROL                                     0x4ad5
#define mmCRTC_CRC0_WINDOWA_Y_CONTROL                                           0x1bd6
#define mmCRTC0_CRTC_CRC0_WINDOWA_Y_CONTROL                                     0x1bd6
#define mmCRTC1_CRTC_CRC0_WINDOWA_Y_CONTROL                                     0x1ed6
#define mmCRTC2_CRTC_CRC0_WINDOWA_Y_CONTROL                                     0x41d6
#define mmCRTC3_CRTC_CRC0_WINDOWA_Y_CONTROL                                     0x44d6
#define mmCRTC4_CRTC_CRC0_WINDOWA_Y_CONTROL                                     0x47d6
#define mmCRTC5_CRTC_CRC0_WINDOWA_Y_CONTROL                                     0x4ad6
#define mmCRTC_CRC0_WINDOWB_X_CONTROL                                           0x1bd7
#define mmCRTC0_CRTC_CRC0_WINDOWB_X_CONTROL                                     0x1bd7
#define mmCRTC1_CRTC_CRC0_WINDOWB_X_CONTROL                                     0x1ed7
#define mmCRTC2_CRTC_CRC0_WINDOWB_X_CONTROL                                     0x41d7
#define mmCRTC3_CRTC_CRC0_WINDOWB_X_CONTROL                                     0x44d7
#define mmCRTC4_CRTC_CRC0_WINDOWB_X_CONTROL                                     0x47d7
#define mmCRTC5_CRTC_CRC0_WINDOWB_X_CONTROL                                     0x4ad7
#define mmCRTC_CRC0_WINDOWB_Y_CONTROL                                           0x1bd8
#define mmCRTC0_CRTC_CRC0_WINDOWB_Y_CONTROL                                     0x1bd8
#define mmCRTC1_CRTC_CRC0_WINDOWB_Y_CONTROL                                     0x1ed8
#define mmCRTC2_CRTC_CRC0_WINDOWB_Y_CONTROL                                     0x41d8
#define mmCRTC3_CRTC_CRC0_WINDOWB_Y_CONTROL                                     0x44d8
#define mmCRTC4_CRTC_CRC0_WINDOWB_Y_CONTROL                                     0x47d8
#define mmCRTC5_CRTC_CRC0_WINDOWB_Y_CONTROL                                     0x4ad8
#define mmCRTC_CRC0_DATA_RG                                                     0x1bd9
#define mmCRTC0_CRTC_CRC0_DATA_RG                                               0x1bd9
#define mmCRTC1_CRTC_CRC0_DATA_RG                                               0x1ed9
#define mmCRTC2_CRTC_CRC0_DATA_RG                                               0x41d9
#define mmCRTC3_CRTC_CRC0_DATA_RG                                               0x44d9
#define mmCRTC4_CRTC_CRC0_DATA_RG                                               0x47d9
#define mmCRTC5_CRTC_CRC0_DATA_RG                                               0x4ad9
#define mmCRTC_CRC0_DATA_B                                                      0x1bda
#define mmCRTC0_CRTC_CRC0_DATA_B                                                0x1bda
#define mmCRTC1_CRTC_CRC0_DATA_B                                                0x1eda
#define mmCRTC2_CRTC_CRC0_DATA_B                                                0x41da
#define mmCRTC3_CRTC_CRC0_DATA_B                                                0x44da
#define mmCRTC4_CRTC_CRC0_DATA_B                                                0x47da
#define mmCRTC5_CRTC_CRC0_DATA_B                                                0x4ada
#define mmCRTC_CRC1_WINDOWA_X_CONTROL                                           0x1bdb
#define mmCRTC0_CRTC_CRC1_WINDOWA_X_CONTROL                                     0x1bdb
#define mmCRTC1_CRTC_CRC1_WINDOWA_X_CONTROL                                     0x1edb
#define mmCRTC2_CRTC_CRC1_WINDOWA_X_CONTROL                                     0x41db
#define mmCRTC3_CRTC_CRC1_WINDOWA_X_CONTROL                                     0x44db
#define mmCRTC4_CRTC_CRC1_WINDOWA_X_CONTROL                                     0x47db
#define mmCRTC5_CRTC_CRC1_WINDOWA_X_CONTROL                                     0x4adb
#define mmCRTC_CRC1_WINDOWA_Y_CONTROL                                           0x1bdc
#define mmCRTC0_CRTC_CRC1_WINDOWA_Y_CONTROL                                     0x1bdc
#define mmCRTC1_CRTC_CRC1_WINDOWA_Y_CONTROL                                     0x1edc
#define mmCRTC2_CRTC_CRC1_WINDOWA_Y_CONTROL                                     0x41dc
#define mmCRTC3_CRTC_CRC1_WINDOWA_Y_CONTROL                                     0x44dc
#define mmCRTC4_CRTC_CRC1_WINDOWA_Y_CONTROL                                     0x47dc
#define mmCRTC5_CRTC_CRC1_WINDOWA_Y_CONTROL                                     0x4adc
#define mmCRTC_CRC1_WINDOWB_X_CONTROL                                           0x1bdd
#define mmCRTC0_CRTC_CRC1_WINDOWB_X_CONTROL                                     0x1bdd
#define mmCRTC1_CRTC_CRC1_WINDOWB_X_CONTROL                                     0x1edd
#define mmCRTC2_CRTC_CRC1_WINDOWB_X_CONTROL                                     0x41dd
#define mmCRTC3_CRTC_CRC1_WINDOWB_X_CONTROL                                     0x44dd
#define mmCRTC4_CRTC_CRC1_WINDOWB_X_CONTROL                                     0x47dd
#define mmCRTC5_CRTC_CRC1_WINDOWB_X_CONTROL                                     0x4add
#define mmCRTC_CRC1_WINDOWB_Y_CONTROL                                           0x1bde
#define mmCRTC0_CRTC_CRC1_WINDOWB_Y_CONTROL                                     0x1bde
#define mmCRTC1_CRTC_CRC1_WINDOWB_Y_CONTROL                                     0x1ede
#define mmCRTC2_CRTC_CRC1_WINDOWB_Y_CONTROL                                     0x41de
#define mmCRTC3_CRTC_CRC1_WINDOWB_Y_CONTROL                                     0x44de
#define mmCRTC4_CRTC_CRC1_WINDOWB_Y_CONTROL                                     0x47de
#define mmCRTC5_CRTC_CRC1_WINDOWB_Y_CONTROL                                     0x4ade
#define mmCRTC_CRC1_DATA_RG                                                     0x1bdf
#define mmCRTC0_CRTC_CRC1_DATA_RG                                               0x1bdf
#define mmCRTC1_CRTC_CRC1_DATA_RG                                               0x1edf
#define mmCRTC2_CRTC_CRC1_DATA_RG                                               0x41df
#define mmCRTC3_CRTC_CRC1_DATA_RG                                               0x44df
#define mmCRTC4_CRTC_CRC1_DATA_RG                                               0x47df
#define mmCRTC5_CRTC_CRC1_DATA_RG                                               0x4adf
#define mmCRTC_CRC1_DATA_B                                                      0x1be0
#define mmCRTC0_CRTC_CRC1_DATA_B                                                0x1be0
#define mmCRTC1_CRTC_CRC1_DATA_B                                                0x1ee0
#define mmCRTC2_CRTC_CRC1_DATA_B                                                0x41e0
#define mmCRTC3_CRTC_CRC1_DATA_B                                                0x44e0
#define mmCRTC4_CRTC_CRC1_DATA_B                                                0x47e0
#define mmCRTC5_CRTC_CRC1_DATA_B                                                0x4ae0
#define mmCRTC_EXT_TIMING_SYNC_CONTROL                                          0x1be1
#define mmCRTC0_CRTC_EXT_TIMING_SYNC_CONTROL                                    0x1be1
#define mmCRTC1_CRTC_EXT_TIMING_SYNC_CONTROL                                    0x1ee1
#define mmCRTC2_CRTC_EXT_TIMING_SYNC_CONTROL                                    0x41e1
#define mmCRTC3_CRTC_EXT_TIMING_SYNC_CONTROL                                    0x44e1
#define mmCRTC4_CRTC_EXT_TIMING_SYNC_CONTROL                                    0x47e1
#define mmCRTC5_CRTC_EXT_TIMING_SYNC_CONTROL                                    0x4ae1
#define mmCRTC_EXT_TIMING_SYNC_WINDOW_START                                     0x1be2
#define mmCRTC0_CRTC_EXT_TIMING_SYNC_WINDOW_START                               0x1be2
#define mmCRTC1_CRTC_EXT_TIMING_SYNC_WINDOW_START                               0x1ee2
#define mmCRTC2_CRTC_EXT_TIMING_SYNC_WINDOW_START                               0x41e2
#define mmCRTC3_CRTC_EXT_TIMING_SYNC_WINDOW_START                               0x44e2
#define mmCRTC4_CRTC_EXT_TIMING_SYNC_WINDOW_START                               0x47e2
#define mmCRTC5_CRTC_EXT_TIMING_SYNC_WINDOW_START                               0x4ae2
#define mmCRTC_EXT_TIMING_SYNC_WINDOW_END                                       0x1be3
#define mmCRTC0_CRTC_EXT_TIMING_SYNC_WINDOW_END                                 0x1be3
#define mmCRTC1_CRTC_EXT_TIMING_SYNC_WINDOW_END                                 0x1ee3
#define mmCRTC2_CRTC_EXT_TIMING_SYNC_WINDOW_END                                 0x41e3
#define mmCRTC3_CRTC_EXT_TIMING_SYNC_WINDOW_END                                 0x44e3
#define mmCRTC4_CRTC_EXT_TIMING_SYNC_WINDOW_END                                 0x47e3
#define mmCRTC5_CRTC_EXT_TIMING_SYNC_WINDOW_END                                 0x4ae3
#define mmCRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL                           0x1be4
#define mmCRTC0_CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL                     0x1be4
#define mmCRTC1_CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL                     0x1ee4
#define mmCRTC2_CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL                     0x41e4
#define mmCRTC3_CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL                     0x44e4
#define mmCRTC4_CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL                     0x47e4
#define mmCRTC5_CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL                     0x4ae4
#define mmCRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL                                0x1be5
#define mmCRTC0_CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL                          0x1be5
#define mmCRTC1_CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL                          0x1ee5
#define mmCRTC2_CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL                          0x41e5
#define mmCRTC3_CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL                          0x44e5
#define mmCRTC4_CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL                          0x47e5
#define mmCRTC5_CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL                          0x4ae5
#define mmCRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL                         0x1be6
#define mmCRTC0_CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL                   0x1be6
#define mmCRTC1_CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL                   0x1ee6
#define mmCRTC2_CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL                   0x41e6
#define mmCRTC3_CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL                   0x44e6
#define mmCRTC4_CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL                   0x47e6
#define mmCRTC5_CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL                   0x4ae6
#define mmCRTC_STATIC_SCREEN_CONTROL                                            0x1be7
#define mmCRTC0_CRTC_STATIC_SCREEN_CONTROL                                      0x1be7
#define mmCRTC1_CRTC_STATIC_SCREEN_CONTROL                                      0x1ee7
#define mmCRTC2_CRTC_STATIC_SCREEN_CONTROL                                      0x41e7
#define mmCRTC3_CRTC_STATIC_SCREEN_CONTROL                                      0x44e7
#define mmCRTC4_CRTC_STATIC_SCREEN_CONTROL                                      0x47e7
#define mmCRTC5_CRTC_STATIC_SCREEN_CONTROL                                      0x4ae7
#define mmCRTC_3D_STRUCTURE_CONTROL                                             0x1b78
#define mmCRTC0_CRTC_3D_STRUCTURE_CONTROL                                       0x1b78
#define mmCRTC1_CRTC_3D_STRUCTURE_CONTROL                                       0x1e78
#define mmCRTC2_CRTC_3D_STRUCTURE_CONTROL                                       0x4178
#define mmCRTC3_CRTC_3D_STRUCTURE_CONTROL                                       0x4478
#define mmCRTC4_CRTC_3D_STRUCTURE_CONTROL                                       0x4778
#define mmCRTC5_CRTC_3D_STRUCTURE_CONTROL                                       0x4a78
#define mmCRTC_GSL_VSYNC_GAP                                                    0x1b79
#define mmCRTC0_CRTC_GSL_VSYNC_GAP                                              0x1b79
#define mmCRTC1_CRTC_GSL_VSYNC_GAP                                              0x1e79
#define mmCRTC2_CRTC_GSL_VSYNC_GAP                                              0x4179
#define mmCRTC3_CRTC_GSL_VSYNC_GAP                                              0x4479
#define mmCRTC4_CRTC_GSL_VSYNC_GAP                                              0x4779
#define mmCRTC5_CRTC_GSL_VSYNC_GAP                                              0x4a79
#define mmCRTC_GSL_WINDOW                                                       0x1b7a
#define mmCRTC0_CRTC_GSL_WINDOW                                                 0x1b7a
#define mmCRTC1_CRTC_GSL_WINDOW                                                 0x1e7a
#define mmCRTC2_CRTC_GSL_WINDOW                                                 0x417a
#define mmCRTC3_CRTC_GSL_WINDOW                                                 0x447a
#define mmCRTC4_CRTC_GSL_WINDOW                                                 0x477a
#define mmCRTC5_CRTC_GSL_WINDOW                                                 0x4a7a
#define mmCRTC_GSL_CONTROL                                                      0x1b7b
#define mmCRTC0_CRTC_GSL_CONTROL                                                0x1b7b
#define mmCRTC1_CRTC_GSL_CONTROL                                                0x1e7b
#define mmCRTC2_CRTC_GSL_CONTROL                                                0x417b
#define mmCRTC3_CRTC_GSL_CONTROL                                                0x447b
#define mmCRTC4_CRTC_GSL_CONTROL                                                0x477b
#define mmCRTC5_CRTC_GSL_CONTROL                                                0x4a7b
#define mmCRTC_TEST_DEBUG_INDEX                                                 0x1bc6
#define mmCRTC0_CRTC_TEST_DEBUG_INDEX                                           0x1bc6
#define mmCRTC1_CRTC_TEST_DEBUG_INDEX                                           0x1ec6
#define mmCRTC2_CRTC_TEST_DEBUG_INDEX                                           0x41c6
#define mmCRTC3_CRTC_TEST_DEBUG_INDEX                                           0x44c6
#define mmCRTC4_CRTC_TEST_DEBUG_INDEX                                           0x47c6
#define mmCRTC5_CRTC_TEST_DEBUG_INDEX                                           0x4ac6
#define mmCRTC_TEST_DEBUG_DATA                                                  0x1bc7
#define mmCRTC0_CRTC_TEST_DEBUG_DATA                                            0x1bc7
#define mmCRTC1_CRTC_TEST_DEBUG_DATA                                            0x1ec7
#define mmCRTC2_CRTC_TEST_DEBUG_DATA                                            0x41c7
#define mmCRTC3_CRTC_TEST_DEBUG_DATA                                            0x44c7
#define mmCRTC4_CRTC_TEST_DEBUG_DATA                                            0x47c7
#define mmCRTC5_CRTC_TEST_DEBUG_DATA                                            0x4ac7
#define mmDAC_ENABLE                                                            0x19e4
#define mmDAC_SOURCE_SELECT                                                     0x19e5
#define mmDAC_CRC_EN                                                            0x19e6
#define mmDAC_CRC_CONTROL                                                       0x19e7
#define mmDAC_CRC_SIG_RGB_MASK                                                  0x19e8
#define mmDAC_CRC_SIG_CONTROL_MASK                                              0x19e9
#define mmDAC_CRC_SIG_RGB                                                       0x19ea
#define mmDAC_CRC_SIG_CONTROL                                                   0x19eb
#define mmDAC_SYNC_TRISTATE_CONTROL                                             0x19ec
#define mmDAC_STEREOSYNC_SELECT                                                 0x19ed
#define mmDAC_AUTODETECT_CONTROL                                                0x19ee
#define mmDAC_AUTODETECT_CONTROL2                                               0x19ef
#define mmDAC_AUTODETECT_CONTROL3                                               0x19f0
#define mmDAC_AUTODETECT_STATUS                                                 0x19f1
#define mmDAC_AUTODETECT_INT_CONTROL                                            0x19f2
#define mmDAC_FORCE_OUTPUT_CNTL                                                 0x19f3
#define mmDAC_FORCE_DATA                                                        0x19f4
#define mmDAC_POWERDOWN                                                         0x19f5
#define mmDAC_CONTROL                                                           0x19f6
#define mmDAC_COMPARATOR_ENABLE                                                 0x19f7
#define mmDAC_COMPARATOR_OUTPUT                                                 0x19f8
#define mmDAC_PWR_CNTL                                                          0x19f9
#define mmDAC_DFT_CONFIG                                                        0x19fa
#define mmDAC_FIFO_STATUS                                                       0x19fb
#define mmPERFCOUNTER_CNTL                                                      0x170
#define mmDC_PERFMON0_PERFCOUNTER_CNTL                                          0x170
#define mmDC_PERFMON1_PERFCOUNTER_CNTL                                          0x1870
#define mmDC_PERFMON2_PERFCOUNTER_CNTL                                          0x1b24
#define mmDC_PERFMON3_PERFCOUNTER_CNTL                                          0x1e24
#define mmDC_PERFMON4_PERFCOUNTER_CNTL                                          0x4124
#define mmDC_PERFMON5_PERFCOUNTER_CNTL                                          0x4424
#define mmDC_PERFMON6_PERFCOUNTER_CNTL                                          0x4724
#define mmDC_PERFMON7_PERFCOUNTER_CNTL                                          0x4a24
#define mmDC_PERFMON8_PERFCOUNTER_CNTL                                          0x4c40
#define mmDC_PERFMON9_PERFCOUNTER_CNTL                                          0x4d14
#define mmPERFCOUNTER_STATE                                                     0x171
#define mmDC_PERFMON0_PERFCOUNTER_STATE                                         0x171
#define mmDC_PERFMON1_PERFCOUNTER_STATE                                         0x1871
#define mmDC_PERFMON2_PERFCOUNTER_STATE                                         0x1b25
#define mmDC_PERFMON3_PERFCOUNTER_STATE                                         0x1e25
#define mmDC_PERFMON4_PERFCOUNTER_STATE                                         0x4125
#define mmDC_PERFMON5_PERFCOUNTER_STATE                                         0x4425
#define mmDC_PERFMON6_PERFCOUNTER_STATE                                         0x4725
#define mmDC_PERFMON7_PERFCOUNTER_STATE                                         0x4a25
#define mmDC_PERFMON8_PERFCOUNTER_STATE                                         0x4c41
#define mmDC_PERFMON9_PERFCOUNTER_STATE                                         0x4d15
#define mmPERFMON_CNTL                                                          0x173
#define mmDC_PERFMON0_PERFMON_CNTL                                              0x173
#define mmDC_PERFMON1_PERFMON_CNTL                                              0x1873
#define mmDC_PERFMON2_PERFMON_CNTL                                              0x1b27
#define mmDC_PERFMON3_PERFMON_CNTL                                              0x1e27
#define mmDC_PERFMON4_PERFMON_CNTL                                              0x4127
#define mmDC_PERFMON5_PERFMON_CNTL                                              0x4427
#define mmDC_PERFMON6_PERFMON_CNTL                                              0x4727
#define mmDC_PERFMON7_PERFMON_CNTL                                              0x4a27
#define mmDC_PERFMON8_PERFMON_CNTL                                              0x4c43
#define mmDC_PERFMON9_PERFMON_CNTL                                              0x4d17
#define mmPERFMON_CVALUE_INT_MISC                                               0x172
#define mmDC_PERFMON0_PERFMON_CVALUE_INT_MISC                                   0x172
#define mmDC_PERFMON1_PERFMON_CVALUE_INT_MISC                                   0x1872
#define mmDC_PERFMON2_PERFMON_CVALUE_INT_MISC                                   0x1b26
#define mmDC_PERFMON3_PERFMON_CVALUE_INT_MISC                                   0x1e26
#define mmDC_PERFMON4_PERFMON_CVALUE_INT_MISC                                   0x4126
#define mmDC_PERFMON5_PERFMON_CVALUE_INT_MISC                                   0x4426
#define mmDC_PERFMON6_PERFMON_CVALUE_INT_MISC                                   0x4726
#define mmDC_PERFMON7_PERFMON_CVALUE_INT_MISC                                   0x4a26
#define mmDC_PERFMON8_PERFMON_CVALUE_INT_MISC                                   0x4c42
#define mmDC_PERFMON9_PERFMON_CVALUE_INT_MISC                                   0x4d16
#define mmPERFMON_CVALUE_LOW                                                    0x174
#define mmDC_PERFMON0_PERFMON_CVALUE_LOW                                        0x174
#define mmDC_PERFMON1_PERFMON_CVALUE_LOW                                        0x1874
#define mmDC_PERFMON2_PERFMON_CVALUE_LOW                                        0x1b28
#define mmDC_PERFMON3_PERFMON_CVALUE_LOW                                        0x1e28
#define mmDC_PERFMON4_PERFMON_CVALUE_LOW                                        0x4128
#define mmDC_PERFMON5_PERFMON_CVALUE_LOW                                        0x4428
#define mmDC_PERFMON6_PERFMON_CVALUE_LOW                                        0x4728
#define mmDC_PERFMON7_PERFMON_CVALUE_LOW                                        0x4a28
#define mmDC_PERFMON8_PERFMON_CVALUE_LOW                                        0x4c44
#define mmDC_PERFMON9_PERFMON_CVALUE_LOW                                        0x4d18
#define mmPERFMON_HI                                                            0x175
#define mmDC_PERFMON0_PERFMON_HI                                                0x175
#define mmDC_PERFMON1_PERFMON_HI                                                0x1875
#define mmDC_PERFMON2_PERFMON_HI                                                0x1b29
#define mmDC_PERFMON3_PERFMON_HI                                                0x1e29
#define mmDC_PERFMON4_PERFMON_HI                                                0x4129
#define mmDC_PERFMON5_PERFMON_HI                                                0x4429
#define mmDC_PERFMON6_PERFMON_HI                                                0x4729
#define mmDC_PERFMON7_PERFMON_HI                                                0x4a29
#define mmDC_PERFMON8_PERFMON_HI                                                0x4c45
#define mmDC_PERFMON9_PERFMON_HI                                                0x4d19
#define mmPERFMON_LOW                                                           0x176
#define mmDC_PERFMON0_PERFMON_LOW                                               0x176
#define mmDC_PERFMON1_PERFMON_LOW                                               0x1876
#define mmDC_PERFMON2_PERFMON_LOW                                               0x1b2a
#define mmDC_PERFMON3_PERFMON_LOW                                               0x1e2a
#define mmDC_PERFMON4_PERFMON_LOW                                               0x412a
#define mmDC_PERFMON5_PERFMON_LOW                                               0x442a
#define mmDC_PERFMON6_PERFMON_LOW                                               0x472a
#define mmDC_PERFMON7_PERFMON_LOW                                               0x4a2a
#define mmDC_PERFMON8_PERFMON_LOW                                               0x4c46
#define mmDC_PERFMON9_PERFMON_LOW                                               0x4d1a
#define mmPERFMON_TEST_DEBUG_INDEX                                              0x177
#define mmDC_PERFMON0_PERFMON_TEST_DEBUG_INDEX                                  0x177
#define mmDC_PERFMON1_PERFMON_TEST_DEBUG_INDEX                                  0x1877
#define mmDC_PERFMON2_PERFMON_TEST_DEBUG_INDEX                                  0x1b2b
#define mmDC_PERFMON3_PERFMON_TEST_DEBUG_INDEX                                  0x1e2b
#define mmDC_PERFMON4_PERFMON_TEST_DEBUG_INDEX                                  0x412b
#define mmDC_PERFMON5_PERFMON_TEST_DEBUG_INDEX                                  0x442b
#define mmDC_PERFMON6_PERFMON_TEST_DEBUG_INDEX                                  0x472b
#define mmDC_PERFMON7_PERFMON_TEST_DEBUG_INDEX                                  0x4a2b
#define mmDC_PERFMON8_PERFMON_TEST_DEBUG_INDEX                                  0x4c47
#define mmDC_PERFMON9_PERFMON_TEST_DEBUG_INDEX                                  0x4d1b
#define mmPERFMON_TEST_DEBUG_DATA                                               0x178
#define mmDC_PERFMON0_PERFMON_TEST_DEBUG_DATA                                   0x178
#define mmDC_PERFMON1_PERFMON_TEST_DEBUG_DATA                                   0x1878
#define mmDC_PERFMON2_PERFMON_TEST_DEBUG_DATA                                   0x1b2c
#define mmDC_PERFMON3_PERFMON_TEST_DEBUG_DATA                                   0x1e2c
#define mmDC_PERFMON4_PERFMON_TEST_DEBUG_DATA                                   0x412c
#define mmDC_PERFMON5_PERFMON_TEST_DEBUG_DATA                                   0x442c
#define mmDC_PERFMON6_PERFMON_TEST_DEBUG_DATA                                   0x472c
#define mmDC_PERFMON7_PERFMON_TEST_DEBUG_DATA                                   0x4a2c
#define mmDC_PERFMON8_PERFMON_TEST_DEBUG_DATA                                   0x4c48
#define mmDC_PERFMON9_PERFMON_TEST_DEBUG_DATA                                   0x4d1c
#define mmVGA25_PPLL_REF_DIV                                                    0xd8
#define mmVGA28_PPLL_REF_DIV                                                    0xd9
#define mmVGA41_PPLL_REF_DIV                                                    0xda
#define mmVGA25_PPLL_FB_DIV                                                     0xdc
#define mmVGA28_PPLL_FB_DIV                                                     0xdd
#define mmVGA41_PPLL_FB_DIV                                                     0xde
#define mmVGA25_PPLL_POST_DIV                                                   0xe0
#define mmVGA28_PPLL_POST_DIV                                                   0xe1
#define mmVGA41_PPLL_POST_DIV                                                   0xe2
#define mmVGA25_PPLL_ANALOG                                                     0xe4
#define mmVGA28_PPLL_ANALOG                                                     0xe5
#define mmVGA41_PPLL_ANALOG                                                     0xe6
#define mmDPREFCLK_CNTL                                                         0x118
#define mmSCANIN_SOFT_RESET                                                     0x11e
#define mmDCCG_GTC_CNTL                                                         0x120
#define mmDCCG_GTC_DTO_INCR                                                     0x121
#define mmDCCG_GTC_DTO_MODULO                                                   0x122
#define mmDCCG_GTC_CURRENT                                                      0x123
#define mmDCCG_DS_DTO_INCR                                                      0x113
#define mmDCCG_DS_DTO_MODULO                                                    0x114
#define mmDCCG_DS_CNTL                                                          0x115
#define mmDCCG_DS_HW_CAL_INTERVAL                                               0x116
#define mmDCCG_DS_DEBUG_CNTL                                                    0x112
#define mmDMCU_SMU_INTERRUPT_CNTL                                               0x12c
#define mmSMU_CONTROL                                                           0x12d
#define mmSMU_INTERRUPT_CONTROL                                                 0x12e
#define mmDAC_CLK_ENABLE                                                        0x128
#define mmDVO_CLK_ENABLE                                                        0x129
#define mmDCCG_GATE_DISABLE_CNTL                                                0x134
#define mmDISPCLK_CGTT_BLK_CTRL_REG                                             0x135
#define mmSCLK_CGTT_BLK_CTRL_REG                                                0x136
#define mmDCCG_CAC_STATUS                                                       0x137
#define mmPIXCLK1_RESYNC_CNTL                                                   0x138
#define mmPIXCLK2_RESYNC_CNTL                                                   0x139
#define mmPIXCLK0_RESYNC_CNTL                                                   0x13a
#define mmMICROSECOND_TIME_BASE_DIV                                             0x13b
#define mmDCCG_DISP_CNTL_REG                                                    0x13f
#define mmDISPPLL_BG_CNTL                                                       0x13c
#define mmDIG_SOFT_RESET                                                        0x13d
#define mmMILLISECOND_TIME_BASE_DIV                                             0x130
#define mmDISPCLK_FREQ_CHANGE_CNTL                                              0x131
#define mmLIGHT_SLEEP_CNTL                                                      0x132
#define mmDCCG_PERFMON_CNTL                                                     0x133
#define mmCRTC0_PIXEL_RATE_CNTL                                                 0x140
#define mmDP_DTO0_PHASE                                                         0x141
#define mmDP_DTO0_MODULO                                                        0x142
#define mmCRTC1_PIXEL_RATE_CNTL                                                 0x144
#define mmDP_DTO1_PHASE                                                         0x145
#define mmDP_DTO1_MODULO                                                        0x146
#define mmCRTC2_PIXEL_RATE_CNTL                                                 0x148
#define mmDP_DTO2_PHASE                                                         0x149
#define mmDP_DTO2_MODULO                                                        0x14a
#define mmCRTC3_PIXEL_RATE_CNTL                                                 0x14c
#define mmDP_DTO3_PHASE                                                         0x14d
#define mmDP_DTO3_MODULO                                                        0x14e
#define mmCRTC4_PIXEL_RATE_CNTL                                                 0x150
#define mmDP_DTO4_PHASE                                                         0x151
#define mmDP_DTO4_MODULO                                                        0x152
#define mmCRTC5_PIXEL_RATE_CNTL                                                 0x154
#define mmDP_DTO5_PHASE                                                         0x155
#define mmDP_DTO5_MODULO                                                        0x156
#define mmDCFE0_SOFT_RESET                                                      0x158
#define mmDCFE1_SOFT_RESET                                                      0x159
#define mmDCFE2_SOFT_RESET                                                      0x15a
#define mmDCFE3_SOFT_RESET                                                      0x15b
#define mmDCFE4_SOFT_RESET                                                      0x15c
#define mmDCFE5_SOFT_RESET                                                      0x15d
#define mmDCI_SOFT_RESET                                                        0x15e
#define mmDCCG_SOFT_RESET                                                       0x15f
#define mmSYMCLKA_CLOCK_ENABLE                                                  0x160
#define mmSYMCLKB_CLOCK_ENABLE                                                  0x161
#define mmSYMCLKC_CLOCK_ENABLE                                                  0x162
#define mmSYMCLKD_CLOCK_ENABLE                                                  0x163
#define mmSYMCLKE_CLOCK_ENABLE                                                  0x164
#define mmSYMCLKF_CLOCK_ENABLE                                                  0x165
#define mmSYMCLKG_CLOCK_ENABLE                                                  0x117
#define mmUNIPHY_SOFT_RESET                                                     0x166
#define mmDCO_SOFT_RESET                                                        0x167
#define mmDVOACLKD_CNTL                                                         0x168
#define mmDVOACLKC_MVP_CNTL                                                     0x169
#define mmDVOACLKC_CNTL                                                         0x16a
#define mmDCCG_AUDIO_DTO_SOURCE                                                 0x16b
#define mmDCCG_AUDIO_DTO0_PHASE                                                 0x16c
#define mmDCCG_AUDIO_DTO0_MODULE                                                0x16d
#define mmDCCG_AUDIO_DTO1_PHASE                                                 0x16e
#define mmDCCG_AUDIO_DTO1_MODULE                                                0x16f
#define mmDCCG_TEST_DEBUG_INDEX                                                 0x17c
#define mmDCCG_TEST_DEBUG_DATA                                                  0x17d
#define mmDCCG_TEST_CLK_SEL                                                     0x17e
#define mmPLL_REF_DIV                                                           0x1700
#define mmDCCG_PLL0_PLL_REF_DIV                                                 0x1700
#define mmDCCG_PLL1_PLL_REF_DIV                                                 0x1714
#define mmDCCG_PLL2_PLL_REF_DIV                                                 0x1728
#define mmDCCG_PLL3_PLL_REF_DIV                                                 0x173c
#define mmPLL_FB_DIV                                                            0x1701
#define mmDCCG_PLL0_PLL_FB_DIV                                                  0x1701
#define mmDCCG_PLL1_PLL_FB_DIV                                                  0x1715
#define mmDCCG_PLL2_PLL_FB_DIV                                                  0x1729
#define mmDCCG_PLL3_PLL_FB_DIV                                                  0x173d
#define mmPLL_POST_DIV                                                          0x1702
#define mmDCCG_PLL0_PLL_POST_DIV                                                0x1702
#define mmDCCG_PLL1_PLL_POST_DIV                                                0x1716
#define mmDCCG_PLL2_PLL_POST_DIV                                                0x172a
#define mmDCCG_PLL3_PLL_POST_DIV                                                0x173e
#define mmPLL_SS_AMOUNT_DSFRAC                                                  0x1703
#define mmDCCG_PLL0_PLL_SS_AMOUNT_DSFRAC                                        0x1703
#define mmDCCG_PLL1_PLL_SS_AMOUNT_DSFRAC                                        0x1717
#define mmDCCG_PLL2_PLL_SS_AMOUNT_DSFRAC                                        0x172b
#define mmDCCG_PLL3_PLL_SS_AMOUNT_DSFRAC                                        0x173f
#define mmPLL_SS_CNTL                                                           0x1704
#define mmDCCG_PLL0_PLL_SS_CNTL                                                 0x1704
#define mmDCCG_PLL1_PLL_SS_CNTL                                                 0x1718
#define mmDCCG_PLL2_PLL_SS_CNTL                                                 0x172c
#define mmDCCG_PLL3_PLL_SS_CNTL                                                 0x1740
#define mmPLL_DS_CNTL                                                           0x1705
#define mmDCCG_PLL0_PLL_DS_CNTL                                                 0x1705
#define mmDCCG_PLL1_PLL_DS_CNTL                                                 0x1719
#define mmDCCG_PLL2_PLL_DS_CNTL                                                 0x172d
#define mmDCCG_PLL3_PLL_DS_CNTL                                                 0x1741
#define mmPLL_IDCLK_CNTL                                                        0x1706
#define mmDCCG_PLL0_PLL_IDCLK_CNTL                                              0x1706
#define mmDCCG_PLL1_PLL_IDCLK_CNTL                                              0x171a
#define mmDCCG_PLL2_PLL_IDCLK_CNTL                                              0x172e
#define mmDCCG_PLL3_PLL_IDCLK_CNTL                                              0x1742
#define mmPLL_CNTL                                                              0x1707
#define mmDCCG_PLL0_PLL_CNTL                                                    0x1707
#define mmDCCG_PLL1_PLL_CNTL                                                    0x171b
#define mmDCCG_PLL2_PLL_CNTL                                                    0x172f
#define mmDCCG_PLL3_PLL_CNTL                                                    0x1743
#define mmPLL_ANALOG                                                            0x1708
#define mmDCCG_PLL0_PLL_ANALOG                                                  0x1708
#define mmDCCG_PLL1_PLL_ANALOG                                                  0x171c
#define mmDCCG_PLL2_PLL_ANALOG                                                  0x1730
#define mmDCCG_PLL3_PLL_ANALOG                                                  0x1744
#define mmPLL_ANALOG_CNTL                                                       0x1711
#define mmDCCG_PLL0_PLL_ANALOG_CNTL                                             0x1711
#define mmDCCG_PLL1_PLL_ANALOG_CNTL                                             0x1725
#define mmDCCG_PLL2_PLL_ANALOG_CNTL                                             0x1739
#define mmDCCG_PLL3_PLL_ANALOG_CNTL                                             0x174d
#define mmPLL_VREG_CNTL                                                         0x1709
#define mmDCCG_PLL0_PLL_VREG_CNTL                                               0x1709
#define mmDCCG_PLL1_PLL_VREG_CNTL                                               0x171d
#define mmDCCG_PLL2_PLL_VREG_CNTL                                               0x1731
#define mmDCCG_PLL3_PLL_VREG_CNTL                                               0x1745
#define mmPLL_XOR_LOCK                                                          0x1710
#define mmDCCG_PLL0_PLL_XOR_LOCK                                                0x1710
#define mmDCCG_PLL1_PLL_XOR_LOCK                                                0x1724
#define mmDCCG_PLL2_PLL_XOR_LOCK                                                0x1738
#define mmDCCG_PLL3_PLL_XOR_LOCK                                                0x174c
#define mmPLL_UNLOCK_DETECT_CNTL                                                0x170a
#define mmDCCG_PLL0_PLL_UNLOCK_DETECT_CNTL                                      0x170a
#define mmDCCG_PLL1_PLL_UNLOCK_DETECT_CNTL                                      0x171e
#define mmDCCG_PLL2_PLL_UNLOCK_DETECT_CNTL                                      0x1732
#define mmDCCG_PLL3_PLL_UNLOCK_DETECT_CNTL                                      0x1746
#define mmPLL_DEBUG_CNTL                                                        0x170b
#define mmDCCG_PLL0_PLL_DEBUG_CNTL                                              0x170b
#define mmDCCG_PLL1_PLL_DEBUG_CNTL                                              0x171f
#define mmDCCG_PLL2_PLL_DEBUG_CNTL                                              0x1733
#define mmDCCG_PLL3_PLL_DEBUG_CNTL                                              0x1747
#define mmPLL_UPDATE_LOCK                                                       0x170c
#define mmDCCG_PLL0_PLL_UPDATE_LOCK                                             0x170c
#define mmDCCG_PLL1_PLL_UPDATE_LOCK                                             0x1720
#define mmDCCG_PLL2_PLL_UPDATE_LOCK                                             0x1734
#define mmDCCG_PLL3_PLL_UPDATE_LOCK                                             0x1748
#define mmPLL_UPDATE_CNTL                                                       0x170d
#define mmDCCG_PLL0_PLL_UPDATE_CNTL                                             0x170d
#define mmDCCG_PLL1_PLL_UPDATE_CNTL                                             0x1721
#define mmDCCG_PLL2_PLL_UPDATE_CNTL                                             0x1735
#define mmDCCG_PLL3_PLL_UPDATE_CNTL                                             0x1749
#define mmPLL_DISPCLK_DTO_CNTL                                                  0x170e
#define mmDCCG_PLL0_PLL_DISPCLK_DTO_CNTL                                        0x170e
#define mmDCCG_PLL1_PLL_DISPCLK_DTO_CNTL                                        0x1722
#define mmDCCG_PLL2_PLL_DISPCLK_DTO_CNTL                                        0x1736
#define mmDCCG_PLL3_PLL_DISPCLK_DTO_CNTL                                        0x174a
#define mmPLL_DISPCLK_CURRENT_DTO_PHASE                                         0x170f
#define mmDCCG_PLL0_PLL_DISPCLK_CURRENT_DTO_PHASE                               0x170f
#define mmDCCG_PLL1_PLL_DISPCLK_CURRENT_DTO_PHASE                               0x1723
#define mmDCCG_PLL2_PLL_DISPCLK_CURRENT_DTO_PHASE                               0x1737
#define mmDCCG_PLL3_PLL_DISPCLK_CURRENT_DTO_PHASE                               0x174b
#define mmDENTIST_DISPCLK_CNTL                                                  0x124
#define mmDCDEBUG_BUS_CLK1_SEL                                                  0x1860
#define mmDCDEBUG_BUS_CLK2_SEL                                                  0x1861
#define mmDCDEBUG_BUS_CLK3_SEL                                                  0x1862
#define mmDCDEBUG_BUS_CLK4_SEL                                                  0x1863
#define mmDCDEBUG_OUT_PIN_OVERRIDE                                              0x186a
#define mmDCDEBUG_OUT_CNTL                                                      0x186b
#define mmDCDEBUG_OUT_DATA                                                      0x186e
#define mmDMIF_ADDR_CONFIG                                                      0x2f5
#define mmDMIF_CONTROL                                                          0x2f6
#define mmDMIF_STATUS                                                           0x2f7
#define mmDMIF_HW_DEBUG                                                         0x2f8
#define mmDMIF_ARBITRATION_CONTROL                                              0x2f9
#define mmPIPE0_ARBITRATION_CONTROL3                                            0x2fa
#define mmPIPE1_ARBITRATION_CONTROL3                                            0x2fb
#define mmPIPE2_ARBITRATION_CONTROL3                                            0x2fc
#define mmPIPE3_ARBITRATION_CONTROL3                                            0x2fd
#define mmPIPE4_ARBITRATION_CONTROL3                                            0x2fe
#define mmPIPE5_ARBITRATION_CONTROL3                                            0x2ff
#define mmDMIF_TEST_DEBUG_INDEX                                                 0x312
#define mmDMIF_TEST_DEBUG_DATA                                                  0x313
#define ixDMIF_DEBUG02_CORE0                                                    0x2
#define ixDMIF_DEBUG02_CORE1                                                    0xa
#define mmDMIF_ADDR_CALC                                                        0x300
#define mmDMIF_STATUS2                                                          0x301
#define mmPIPE0_MAX_REQUESTS                                                    0x302
#define mmPIPE1_MAX_REQUESTS                                                    0x303
#define mmPIPE2_MAX_REQUESTS                                                    0x304
#define mmPIPE3_MAX_REQUESTS                                                    0x305
#define mmPIPE4_MAX_REQUESTS                                                    0x306
#define mmPIPE5_MAX_REQUESTS                                                    0x307
#define mmLOW_POWER_TILING_CONTROL                                              0x325
#define mmMCIF_CONTROL                                                          0x314
#define mmMCIF_WRITE_COMBINE_CONTROL                                            0x315
#define mmMCIF_TEST_DEBUG_INDEX                                                 0x316
#define mmMCIF_TEST_DEBUG_DATA                                                  0x317
#define ixIDDCCIF02_DBG_DCCIF_C                                                 0x9
#define ixIDDCCIF04_DBG_DCCIF_E                                                 0xb
#define ixIDDCCIF05_DBG_DCCIF_F                                                 0xc
#define mmMCIF_VMID                                                             0x318
#define mmMCIF_MEM_CONTROL                                                      0x319
#define mmCC_DC_PIPE_DIS                                                        0x177f
#define mmMC_DC_INTERFACE_NACK_STATUS                                           0x31c
#define mmDC_RBBMIF_RDWR_CNTL1                                                  0x31a
#define mmDC_RBBMIF_RDWR_CNTL2                                                  0x31d
#define mmDC_RBBMIF_RDWR_CNTL3                                                  0x311
#define mmDCI_MEM_PWR_STATE                                                     0x31b
#define mmDCI_MEM_PWR_STATE2                                                    0x322
#define mmDCI_CLK_CNTL                                                          0x31e
#define mmDCCG_VPCLK_CNTL                                                       0x31f
#define mmDCI_MEM_PWR_CNTL                                                      0x326
#define mmDC_XDMA_INTERFACE_CNTL                                                0x327
#define mmDCI_TEST_DEBUG_INDEX                                                  0x320
#define mmDCI_TEST_DEBUG_DATA                                                   0x321
#define mmDCI_DEBUG_CONFIG                                                      0x323
#define mmPIPE0_DMIF_BUFFER_CONTROL                                             0x328
#define mmPIPE1_DMIF_BUFFER_CONTROL                                             0x330
#define mmPIPE2_DMIF_BUFFER_CONTROL                                             0x338
#define mmPIPE3_DMIF_BUFFER_CONTROL                                             0x340
#define mmPIPE4_DMIF_BUFFER_CONTROL                                             0x348
#define mmPIPE5_DMIF_BUFFER_CONTROL                                             0x350
#define mmMCIF_BUFMGR_SW_CONTROL                                                0x358
#define mmMCIF_BUFMGR_STATUS                                                    0x35a
#define mmMCIF_BUF_PITCH                                                        0x35b
#define mmMCIF_BUF_1_ADDR_Y_LOW                                                 0x35c
#define mmMCIF_BUF_2_ADDR_Y_LOW                                                 0x360
#define mmMCIF_BUF_3_ADDR_Y_LOW                                                 0x364
#define mmMCIF_BUF_4_ADDR_Y_LOW                                                 0x368
#define mmMCIF_BUF_1_ADDR_UP                                                    0x35d
#define mmMCIF_BUF_2_ADDR_UP                                                    0x361
#define mmMCIF_BUF_3_ADDR_UP                                                    0x365
#define mmMCIF_BUF_4_ADDR_UP                                                    0x369
#define mmMCIF_BUF_1_ADDR_C_LOW                                                 0x35e
#define mmMCIF_BUF_2_ADDR_C_LOW                                                 0x362
#define mmMCIF_BUF_3_ADDR_C_LOW                                                 0x366
#define mmMCIF_BUF_4_ADDR_C_LOW                                                 0x36a
#define mmMCIF_BUF_1_STATUS                                                     0x35f
#define mmMCIF_BUF_2_STATUS                                                     0x363
#define mmMCIF_BUF_3_STATUS                                                     0x367
#define mmMCIF_BUF_4_STATUS                                                     0x36b
#define mmMCIF_SI_ARBITRATION_CONTROL                                           0x36c
#define mmMCIF_URGENCY_WATERMARK                                                0x36d
#define mmDC_GENERICA                                                           0x1900
#define mmDC_GENERICB                                                           0x1901
#define mmDC_PAD_EXTERN_SIG                                                     0x1902
#define mmDC_REF_CLK_CNTL                                                       0x1903
#define mmDC_GPIO_DEBUG                                                         0x1904
#define mmDCO_MEM_POWER_STATE                                                   0x1906
#define mmDCO_MEM_POWER_STATE_2                                                 0x193a
#define mmDCO_LIGHT_SLEEP_DIS                                                   0x1907
#define mmUNIPHY_IMPCAL_LINKA                                                   0x1908
#define mmUNIPHY_IMPCAL_LINKB                                                   0x1909
#define mmUNIPHY_IMPCAL_PERIOD                                                  0x190a
#define mmAUXP_IMPCAL                                                           0x190b
#define mmAUXN_IMPCAL                                                           0x190c
#define mmDCIO_IMPCAL_CNTL_AB                                                   0x190d
#define mmUNIPHY_IMPCAL_PSW_AB                                                  0x190e
#define mmUNIPHY_IMPCAL_LINKC                                                   0x190f
#define mmUNIPHY_IMPCAL_LINKD                                                   0x1910
#define mmDCIO_IMPCAL_CNTL_CD                                                   0x1911
#define mmUNIPHY_IMPCAL_PSW_CD                                                  0x1912
#define mmUNIPHY_IMPCAL_LINKE                                                   0x1913
#define mmUNIPHY_IMPCAL_LINKF                                                   0x1914
#define mmDCIO_IMPCAL_CNTL_EF                                                   0x1915
#define mmUNIPHY_IMPCAL_PSW_EF                                                  0x1916
#define mmDC_PINSTRAPS                                                          0x1917
#define mmDC_DVODATA_CONFIG                                                     0x1905
#define mmLVTMA_PWRSEQ_CNTL                                                     0x1919
#define mmLVTMA_PWRSEQ_STATE                                                    0x191a
#define mmLVTMA_PWRSEQ_REF_DIV                                                  0x191b
#define mmLVTMA_PWRSEQ_DELAY1                                                   0x191c
#define mmLVTMA_PWRSEQ_DELAY2                                                   0x191d
#define mmBL_PWM_CNTL                                                           0x191e
#define mmBL_PWM_CNTL2                                                          0x191f
#define mmBL_PWM_PERIOD_CNTL                                                    0x1920
#define mmBL_PWM_GRP1_REG_LOCK                                                  0x1921
#define mmDCIO_GSL_GENLK_PAD_CNTL                                               0x1922
#define mmDCIO_GSL_SWAPLOCK_PAD_CNTL                                            0x1923
#define mmDCIO_GSL0_CNTL                                                        0x1924
#define mmDCIO_GSL1_CNTL                                                        0x1925
#define mmDCIO_GSL2_CNTL                                                        0x1926
#define mmDC_GPU_TIMER_START_POSITION_V_UPDATE                                  0x1927
#define mmDC_GPU_TIMER_START_POSITION_P_FLIP                                    0x1928
#define mmDC_GPU_TIMER_READ                                                     0x1929
#define mmDC_GPU_TIMER_READ_CNTL                                                0x192a
#define mmDCO_CLK_CNTL                                                          0x192b
#define mmDCO_CLK_RAMP_CNTL                                                     0x192c
#define mmDCIO_DEBUG                                                            0x192e
#define mmDCO_DCFE_EXT_VSYNC_CNTL                                               0x1937
#define mmDCIO_TEST_DEBUG_INDEX                                                 0x192f
#define mmDCIO_TEST_DEBUG_DATA                                                  0x1930
#define ixDCIO_DEBUG1                                                           0x1
#define ixDCIO_DEBUG2                                                           0x2
#define ixDCIO_DEBUG3                                                           0x3
#define ixDCIO_DEBUG4                                                           0x4
#define ixDCIO_DEBUG5                                                           0x5
#define ixDCIO_DEBUG6                                                           0x6
#define ixDCIO_DEBUG7                                                           0x7
#define ixDCIO_DEBUG8                                                           0x8
#define ixDCIO_DEBUG9                                                           0x9
#define ixDCIO_DEBUGA                                                           0xa
#define ixDCIO_DEBUGB                                                           0xb
#define ixDCIO_DEBUGC                                                           0xc
#define ixDCIO_DEBUGD                                                           0xd
#define ixDCIO_DEBUGE                                                           0xe
#define ixDCIO_DEBUGF                                                           0xf
#define ixDCIO_DEBUG10                                                          0x10
#define ixDCIO_DEBUG11                                                          0x11
#define ixDCIO_DEBUG12                                                          0x12
#define ixDCIO_DEBUG13                                                          0x13
#define ixDCIO_DEBUG14                                                          0x14
#define ixDCIO_DEBUG15                                                          0x15
#define ixDCIO_DEBUG_ID                                                         0x0
#define mmDC_GPIO_GENERIC_MASK                                                  0x1944
#define mmDC_GPIO_GENERIC_A                                                     0x1945
#define mmDC_GPIO_GENERIC_EN                                                    0x1946
#define mmDC_GPIO_GENERIC_Y                                                     0x1947
#define mmDC_GPIO_DVODATA_MASK                                                  0x1948
#define mmDC_GPIO_DVODATA_A                                                     0x1949
#define mmDC_GPIO_DVODATA_EN                                                    0x194a
#define mmDC_GPIO_DVODATA_Y                                                     0x194b
#define mmDC_GPIO_DDC1_MASK                                                     0x194c
#define mmDC_GPIO_DDC1_A                                                        0x194d
#define mmDC_GPIO_DDC1_EN                                                       0x194e
#define mmDC_GPIO_DDC1_Y                                                        0x194f
#define mmDC_GPIO_DDC2_MASK                                                     0x1950
#define mmDC_GPIO_DDC2_A                                                        0x1951
#define mmDC_GPIO_DDC2_EN                                                       0x1952
#define mmDC_GPIO_DDC2_Y                                                        0x1953
#define mmDC_GPIO_DDC3_MASK                                                     0x1954
#define mmDC_GPIO_DDC3_A                                                        0x1955
#define mmDC_GPIO_DDC3_EN                                                       0x1956
#define mmDC_GPIO_DDC3_Y                                                        0x1957
#define mmDC_GPIO_DDC4_MASK                                                     0x1958
#define mmDC_GPIO_DDC4_A                                                        0x1959
#define mmDC_GPIO_DDC4_EN                                                       0x195a
#define mmDC_GPIO_DDC4_Y                                                        0x195b
#define mmDC_GPIO_DDC5_MASK                                                     0x195c
#define mmDC_GPIO_DDC5_A                                                        0x195d
#define mmDC_GPIO_DDC5_EN                                                       0x195e
#define mmDC_GPIO_DDC5_Y                                                        0x195f
#define mmDC_GPIO_DDC6_MASK                                                     0x1960
#define mmDC_GPIO_DDC6_A                                                        0x1961
#define mmDC_GPIO_DDC6_EN                                                       0x1962
#define mmDC_GPIO_DDC6_Y                                                        0x1963
#define mmDC_GPIO_DDCVGA_MASK                                                   0x1970
#define mmDC_GPIO_DDCVGA_A                                                      0x1971
#define mmDC_GPIO_DDCVGA_EN                                                     0x1972
#define mmDC_GPIO_DDCVGA_Y                                                      0x1973
#define mmDC_GPIO_SYNCA_MASK                                                    0x1964
#define mmDC_GPIO_SYNCA_A                                                       0x1965
#define mmDC_GPIO_SYNCA_EN                                                      0x1966
#define mmDC_GPIO_SYNCA_Y                                                       0x1967
#define mmDC_GPIO_GENLK_MASK                                                    0x1968
#define mmDC_GPIO_GENLK_A                                                       0x1969
#define mmDC_GPIO_GENLK_EN                                                      0x196a
#define mmDC_GPIO_GENLK_Y                                                       0x196b
#define mmDC_GPIO_HPD_MASK                                                      0x196c
#define mmDC_GPIO_HPD_A                                                         0x196d
#define mmDC_GPIO_HPD_EN                                                        0x196e
#define mmDC_GPIO_HPD_Y                                                         0x196f
#define mmDC_GPIO_PWRSEQ_MASK                                                   0x1940
#define mmDC_GPIO_PWRSEQ_A                                                      0x1941
#define mmDC_GPIO_PWRSEQ_EN                                                     0x1942
#define mmDC_GPIO_PWRSEQ_Y                                                      0x1943
#define mmDC_GPIO_PAD_STRENGTH_1                                                0x1978
#define mmDC_GPIO_PAD_STRENGTH_2                                                0x1979
#define mmPHY_AUX_CNTL                                                          0x197f
#define mmDC_GPIO_I2CPAD_MASK                                                   0x1974
#define mmDC_GPIO_I2CPAD_A                                                      0x1975
#define mmDC_GPIO_I2CPAD_EN                                                     0x1976
#define mmDC_GPIO_I2CPAD_Y                                                      0x1977
#define mmDC_GPIO_I2CPAD_STRENGTH                                               0x197a
#define mmDVO_STRENGTH_CONTROL                                                  0x197b
#define mmDVO_VREF_CONTROL                                                      0x197c
#define mmDVO_SKEW_ADJUST                                                       0x197d
#define mmUNIPHYAB_TPG_CONTROL                                                  0x1931
#define mmUNIPHYAB_TPG_SEED                                                     0x1932
#define mmUNIPHYCD_TPG_CONTROL                                                  0x1933
#define mmUNIPHYCD_TPG_SEED                                                     0x1934
#define mmUNIPHYEF_TPG_CONTROL                                                  0x1935
#define mmUNIPHYEF_TPG_SEED                                                     0x1936
#define mmUNIPHYGH_TPG_CONTROL                                                  0x1938
#define mmUNIPHYGH_TPG_SEED                                                     0x1939
#define mmDC_GPIO_I2S_SPDIF_MASK                                                0x193c
#define mmDC_GPIO_I2S_SPDIF_A                                                   0x193d
#define mmDC_GPIO_I2S_SPDIF_EN                                                  0x193e
#define mmDC_GPIO_I2S_SPDIF_Y                                                   0x193f
#define mmDC_GPIO_I2S_SPDIF_STRENGTH                                            0x193b
#define mmDAC_MACRO_CNTL_RESERVED0                                              0x19fc
#define mmDAC_MACRO_CNTL_RESERVED1                                              0x19fd
#define mmDAC_MACRO_CNTL_RESERVED2                                              0x19fe
#define mmDAC_MACRO_CNTL_RESERVED3                                              0x19ff
#define mmUNIPHY_TX_CONTROL1                                                    0x1980
#define mmDCIO_UNIPHY0_UNIPHY_TX_CONTROL1                                       0x1980
#define mmDCIO_UNIPHY1_UNIPHY_TX_CONTROL1                                       0x1990
#define mmDCIO_UNIPHY2_UNIPHY_TX_CONTROL1                                       0x19a0
#define mmDCIO_UNIPHY3_UNIPHY_TX_CONTROL1                                       0x19b0
#define mmDCIO_UNIPHY4_UNIPHY_TX_CONTROL1                                       0x19c0
#define mmDCIO_UNIPHY5_UNIPHY_TX_CONTROL1                                       0x19d0
#define mmDCIO_UNIPHY6_UNIPHY_TX_CONTROL1                                       0x4df0
#define mmUNIPHY_TX_CONTROL2                                                    0x1981
#define mmDCIO_UNIPHY0_UNIPHY_TX_CONTROL2                                       0x1981
#define mmDCIO_UNIPHY1_UNIPHY_TX_CONTROL2                                       0x1991
#define mmDCIO_UNIPHY2_UNIPHY_TX_CONTROL2                                       0x19a1
#define mmDCIO_UNIPHY3_UNIPHY_TX_CONTROL2                                       0x19b1
#define mmDCIO_UNIPHY4_UNIPHY_TX_CONTROL2                                       0x19c1
#define mmDCIO_UNIPHY5_UNIPHY_TX_CONTROL2                                       0x19d1
#define mmDCIO_UNIPHY6_UNIPHY_TX_CONTROL2                                       0x4df1
#define mmUNIPHY_TX_CONTROL3                                                    0x1982
#define mmDCIO_UNIPHY0_UNIPHY_TX_CONTROL3                                       0x1982
#define mmDCIO_UNIPHY1_UNIPHY_TX_CONTROL3                                       0x1992
#define mmDCIO_UNIPHY2_UNIPHY_TX_CONTROL3                                       0x19a2
#define mmDCIO_UNIPHY3_UNIPHY_TX_CONTROL3                                       0x19b2
#define mmDCIO_UNIPHY4_UNIPHY_TX_CONTROL3                                       0x19c2
#define mmDCIO_UNIPHY5_UNIPHY_TX_CONTROL3                                       0x19d2
#define mmDCIO_UNIPHY6_UNIPHY_TX_CONTROL3                                       0x4df2
#define mmUNIPHY_TX_CONTROL4                                                    0x1983
#define mmDCIO_UNIPHY0_UNIPHY_TX_CONTROL4                                       0x1983
#define mmDCIO_UNIPHY1_UNIPHY_TX_CONTROL4                                       0x1993
#define mmDCIO_UNIPHY2_UNIPHY_TX_CONTROL4                                       0x19a3
#define mmDCIO_UNIPHY3_UNIPHY_TX_CONTROL4                                       0x19b3
#define mmDCIO_UNIPHY4_UNIPHY_TX_CONTROL4                                       0x19c3
#define mmDCIO_UNIPHY5_UNIPHY_TX_CONTROL4                                       0x19d3
#define mmDCIO_UNIPHY6_UNIPHY_TX_CONTROL4                                       0x4df3
#define mmUNIPHY_POWER_CONTROL                                                  0x1984
#define mmDCIO_UNIPHY0_UNIPHY_POWER_CONTROL                                     0x1984
#define mmDCIO_UNIPHY1_UNIPHY_POWER_CONTROL                                     0x1994
#define mmDCIO_UNIPHY2_UNIPHY_POWER_CONTROL                                     0x19a4
#define mmDCIO_UNIPHY3_UNIPHY_POWER_CONTROL                                     0x19b4
#define mmDCIO_UNIPHY4_UNIPHY_POWER_CONTROL                                     0x19c4
#define mmDCIO_UNIPHY5_UNIPHY_POWER_CONTROL                                     0x19d4
#define mmDCIO_UNIPHY6_UNIPHY_POWER_CONTROL                                     0x4df4
#define mmUNIPHY_PLL_FBDIV                                                      0x1985
#define mmDCIO_UNIPHY0_UNIPHY_PLL_FBDIV                                         0x1985
#define mmDCIO_UNIPHY1_UNIPHY_PLL_FBDIV                                         0x1995
#define mmDCIO_UNIPHY2_UNIPHY_PLL_FBDIV                                         0x19a5
#define mmDCIO_UNIPHY3_UNIPHY_PLL_FBDIV                                         0x19b5
#define mmDCIO_UNIPHY4_UNIPHY_PLL_FBDIV                                         0x19c5
#define mmDCIO_UNIPHY5_UNIPHY_PLL_FBDIV                                         0x19d5
#define mmDCIO_UNIPHY6_UNIPHY_PLL_FBDIV                                         0x4df5
#define mmUNIPHY_PLL_CONTROL1                                                   0x1986
#define mmDCIO_UNIPHY0_UNIPHY_PLL_CONTROL1                                      0x1986
#define mmDCIO_UNIPHY1_UNIPHY_PLL_CONTROL1                                      0x1996
#define mmDCIO_UNIPHY2_UNIPHY_PLL_CONTROL1                                      0x19a6
#define mmDCIO_UNIPHY3_UNIPHY_PLL_CONTROL1                                      0x19b6
#define mmDCIO_UNIPHY4_UNIPHY_PLL_CONTROL1                                      0x19c6
#define mmDCIO_UNIPHY5_UNIPHY_PLL_CONTROL1                                      0x19d6
#define mmDCIO_UNIPHY6_UNIPHY_PLL_CONTROL1                                      0x4df6
#define mmUNIPHY_PLL_CONTROL2                                                   0x1987
#define mmDCIO_UNIPHY0_UNIPHY_PLL_CONTROL2                                      0x1987
#define mmDCIO_UNIPHY1_UNIPHY_PLL_CONTROL2                                      0x1997
#define mmDCIO_UNIPHY2_UNIPHY_PLL_CONTROL2                                      0x19a7
#define mmDCIO_UNIPHY3_UNIPHY_PLL_CONTROL2                                      0x19b7
#define mmDCIO_UNIPHY4_UNIPHY_PLL_CONTROL2                                      0x19c7
#define mmDCIO_UNIPHY5_UNIPHY_PLL_CONTROL2                                      0x19d7
#define mmDCIO_UNIPHY6_UNIPHY_PLL_CONTROL2                                      0x4df7
#define mmUNIPHY_PLL_SS_STEP_SIZE                                               0x1988
#define mmDCIO_UNIPHY0_UNIPHY_PLL_SS_STEP_SIZE                                  0x1988
#define mmDCIO_UNIPHY1_UNIPHY_PLL_SS_STEP_SIZE                                  0x1998
#define mmDCIO_UNIPHY2_UNIPHY_PLL_SS_STEP_SIZE                                  0x19a8
#define mmDCIO_UNIPHY3_UNIPHY_PLL_SS_STEP_SIZE                                  0x19b8
#define mmDCIO_UNIPHY4_UNIPHY_PLL_SS_STEP_SIZE                                  0x19c8
#define mmDCIO_UNIPHY5_UNIPHY_PLL_SS_STEP_SIZE                                  0x19d8
#define mmDCIO_UNIPHY6_UNIPHY_PLL_SS_STEP_SIZE                                  0x4df8
#define mmUNIPHY_PLL_SS_CNTL                                                    0x1989
#define mmDCIO_UNIPHY0_UNIPHY_PLL_SS_CNTL                                       0x1989
#define mmDCIO_UNIPHY1_UNIPHY_PLL_SS_CNTL                                       0x1999
#define mmDCIO_UNIPHY2_UNIPHY_PLL_SS_CNTL                                       0x19a9
#define mmDCIO_UNIPHY3_UNIPHY_PLL_SS_CNTL                                       0x19b9
#define mmDCIO_UNIPHY4_UNIPHY_PLL_SS_CNTL                                       0x19c9
#define mmDCIO_UNIPHY5_UNIPHY_PLL_SS_CNTL                                       0x19d9
#define mmDCIO_UNIPHY6_UNIPHY_PLL_SS_CNTL                                       0x4df9
#define mmUNIPHY_DATA_SYNCHRONIZATION                                           0x198a
#define mmDCIO_UNIPHY0_UNIPHY_DATA_SYNCHRONIZATION                              0x198a
#define mmDCIO_UNIPHY1_UNIPHY_DATA_SYNCHRONIZATION                              0x199a
#define mmDCIO_UNIPHY2_UNIPHY_DATA_SYNCHRONIZATION                              0x19aa
#define mmDCIO_UNIPHY3_UNIPHY_DATA_SYNCHRONIZATION                              0x19ba
#define mmDCIO_UNIPHY4_UNIPHY_DATA_SYNCHRONIZATION                              0x19ca
#define mmDCIO_UNIPHY5_UNIPHY_DATA_SYNCHRONIZATION                              0x19da
#define mmDCIO_UNIPHY6_UNIPHY_DATA_SYNCHRONIZATION                              0x4dfa
#define mmUNIPHY_REG_TEST_OUTPUT                                                0x198b
#define mmDCIO_UNIPHY0_UNIPHY_REG_TEST_OUTPUT                                   0x198b
#define mmDCIO_UNIPHY1_UNIPHY_REG_TEST_OUTPUT                                   0x199b
#define mmDCIO_UNIPHY2_UNIPHY_REG_TEST_OUTPUT                                   0x19ab
#define mmDCIO_UNIPHY3_UNIPHY_REG_TEST_OUTPUT                                   0x19bb
#define mmDCIO_UNIPHY4_UNIPHY_REG_TEST_OUTPUT                                   0x19cb
#define mmDCIO_UNIPHY5_UNIPHY_REG_TEST_OUTPUT                                   0x19db
#define mmDCIO_UNIPHY6_UNIPHY_REG_TEST_OUTPUT                                   0x4dfb
#define mmUNIPHY_ANG_BIST_CNTL                                                  0x198c
#define mmDCIO_UNIPHY0_UNIPHY_ANG_BIST_CNTL                                     0x198c
#define mmDCIO_UNIPHY1_UNIPHY_ANG_BIST_CNTL                                     0x199c
#define mmDCIO_UNIPHY2_UNIPHY_ANG_BIST_CNTL                                     0x19ac
#define mmDCIO_UNIPHY3_UNIPHY_ANG_BIST_CNTL                                     0x19bc
#define mmDCIO_UNIPHY4_UNIPHY_ANG_BIST_CNTL                                     0x19cc
#define mmDCIO_UNIPHY5_UNIPHY_ANG_BIST_CNTL                                     0x19dc
#define mmDCIO_UNIPHY6_UNIPHY_ANG_BIST_CNTL                                     0x4dfc
#define mmUNIPHY_LINK_CNTL                                                      0x198d
#define mmDCIO_UNIPHY0_UNIPHY_LINK_CNTL                                         0x198d
#define mmDCIO_UNIPHY1_UNIPHY_LINK_CNTL                                         0x199d
#define mmDCIO_UNIPHY2_UNIPHY_LINK_CNTL                                         0x19ad
#define mmDCIO_UNIPHY3_UNIPHY_LINK_CNTL                                         0x19bd
#define mmDCIO_UNIPHY4_UNIPHY_LINK_CNTL                                         0x19cd
#define mmDCIO_UNIPHY5_UNIPHY_LINK_CNTL                                         0x19dd
#define mmDCIO_UNIPHY6_UNIPHY_LINK_CNTL                                         0x4dfd
#define mmUNIPHY_CHANNEL_XBAR_CNTL                                              0x198e
#define mmDCIO_UNIPHY0_UNIPHY_CHANNEL_XBAR_CNTL                                 0x198e
#define mmDCIO_UNIPHY1_UNIPHY_CHANNEL_XBAR_CNTL                                 0x199e
#define mmDCIO_UNIPHY2_UNIPHY_CHANNEL_XBAR_CNTL                                 0x19ae
#define mmDCIO_UNIPHY3_UNIPHY_CHANNEL_XBAR_CNTL                                 0x19be
#define mmDCIO_UNIPHY4_UNIPHY_CHANNEL_XBAR_CNTL                                 0x19ce
#define mmDCIO_UNIPHY5_UNIPHY_CHANNEL_XBAR_CNTL                                 0x19de
#define mmDCIO_UNIPHY6_UNIPHY_CHANNEL_XBAR_CNTL                                 0x4dfe
#define mmUNIPHY_REG_TEST_OUTPUT2                                               0x198f
#define mmDCIO_UNIPHY0_UNIPHY_REG_TEST_OUTPUT2                                  0x198f
#define mmDCIO_UNIPHY1_UNIPHY_REG_TEST_OUTPUT2                                  0x199f
#define mmDCIO_UNIPHY2_UNIPHY_REG_TEST_OUTPUT2                                  0x19af
#define mmDCIO_UNIPHY3_UNIPHY_REG_TEST_OUTPUT2                                  0x19bf
#define mmDCIO_UNIPHY4_UNIPHY_REG_TEST_OUTPUT2                                  0x19cf
#define mmDCIO_UNIPHY5_UNIPHY_REG_TEST_OUTPUT2                                  0x19df
#define mmDCIO_UNIPHY6_UNIPHY_REG_TEST_OUTPUT2                                  0x4dff
#define mmGRPH_ENABLE                                                           0x1a00
#define mmDCP0_GRPH_ENABLE                                                      0x1a00
#define mmDCP1_GRPH_ENABLE                                                      0x1d00
#define mmDCP2_GRPH_ENABLE                                                      0x4000
#define mmDCP3_GRPH_ENABLE                                                      0x4300
#define mmDCP4_GRPH_ENABLE                                                      0x4600
#define mmDCP5_GRPH_ENABLE                                                      0x4900
#define mmGRPH_CONTROL                                                          0x1a01
#define mmDCP0_GRPH_CONTROL                                                     0x1a01
#define mmDCP1_GRPH_CONTROL                                                     0x1d01
#define mmDCP2_GRPH_CONTROL                                                     0x4001
#define mmDCP3_GRPH_CONTROL                                                     0x4301
#define mmDCP4_GRPH_CONTROL                                                     0x4601
#define mmDCP5_GRPH_CONTROL                                                     0x4901
#define mmGRPH_LUT_10BIT_BYPASS                                                 0x1a02
#define mmDCP0_GRPH_LUT_10BIT_BYPASS                                            0x1a02
#define mmDCP1_GRPH_LUT_10BIT_BYPASS                                            0x1d02
#define mmDCP2_GRPH_LUT_10BIT_BYPASS                                            0x4002
#define mmDCP3_GRPH_LUT_10BIT_BYPASS                                            0x4302
#define mmDCP4_GRPH_LUT_10BIT_BYPASS                                            0x4602
#define mmDCP5_GRPH_LUT_10BIT_BYPASS                                            0x4902
#define mmGRPH_SWAP_CNTL                                                        0x1a03
#define mmDCP0_GRPH_SWAP_CNTL                                                   0x1a03
#define mmDCP1_GRPH_SWAP_CNTL                                                   0x1d03
#define mmDCP2_GRPH_SWAP_CNTL                                                   0x4003
#define mmDCP3_GRPH_SWAP_CNTL                                                   0x4303
#define mmDCP4_GRPH_SWAP_CNTL                                                   0x4603
#define mmDCP5_GRPH_SWAP_CNTL                                                   0x4903
#define mmGRPH_PRIMARY_SURFACE_ADDRESS                                          0x1a04
#define mmDCP0_GRPH_PRIMARY_SURFACE_ADDRESS                                     0x1a04
#define mmDCP1_GRPH_PRIMARY_SURFACE_ADDRESS                                     0x1d04
#define mmDCP2_GRPH_PRIMARY_SURFACE_ADDRESS                                     0x4004
#define mmDCP3_GRPH_PRIMARY_SURFACE_ADDRESS                                     0x4304
#define mmDCP4_GRPH_PRIMARY_SURFACE_ADDRESS                                     0x4604
#define mmDCP5_GRPH_PRIMARY_SURFACE_ADDRESS                                     0x4904
#define mmGRPH_SECONDARY_SURFACE_ADDRESS                                        0x1a05
#define mmDCP0_GRPH_SECONDARY_SURFACE_ADDRESS                                   0x1a05
#define mmDCP1_GRPH_SECONDARY_SURFACE_ADDRESS                                   0x1d05
#define mmDCP2_GRPH_SECONDARY_SURFACE_ADDRESS                                   0x4005
#define mmDCP3_GRPH_SECONDARY_SURFACE_ADDRESS                                   0x4305
#define mmDCP4_GRPH_SECONDARY_SURFACE_ADDRESS                                   0x4605
#define mmDCP5_GRPH_SECONDARY_SURFACE_ADDRESS                                   0x4905
#define mmGRPH_PITCH                                                            0x1a06
#define mmDCP0_GRPH_PITCH                                                       0x1a06
#define mmDCP1_GRPH_PITCH                                                       0x1d06
#define mmDCP2_GRPH_PITCH                                                       0x4006
#define mmDCP3_GRPH_PITCH                                                       0x4306
#define mmDCP4_GRPH_PITCH                                                       0x4606
#define mmDCP5_GRPH_PITCH                                                       0x4906
#define mmGRPH_PRIMARY_SURFACE_ADDRESS_HIGH                                     0x1a07
#define mmDCP0_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH                                0x1a07
#define mmDCP1_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH                                0x1d07
#define mmDCP2_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH                                0x4007
#define mmDCP3_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH                                0x4307
#define mmDCP4_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH                                0x4607
#define mmDCP5_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH                                0x4907
#define mmGRPH_SECONDARY_SURFACE_ADDRESS_HIGH                                   0x1a08
#define mmDCP0_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH                              0x1a08
#define mmDCP1_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH                              0x1d08
#define mmDCP2_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH                              0x4008
#define mmDCP3_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH                              0x4308
#define mmDCP4_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH                              0x4608
#define mmDCP5_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH                              0x4908
#define mmGRPH_SURFACE_OFFSET_X                                                 0x1a09
#define mmDCP0_GRPH_SURFACE_OFFSET_X                                            0x1a09
#define mmDCP1_GRPH_SURFACE_OFFSET_X                                            0x1d09
#define mmDCP2_GRPH_SURFACE_OFFSET_X                                            0x4009
#define mmDCP3_GRPH_SURFACE_OFFSET_X                                            0x4309
#define mmDCP4_GRPH_SURFACE_OFFSET_X                                            0x4609
#define mmDCP5_GRPH_SURFACE_OFFSET_X                                            0x4909
#define mmGRPH_SURFACE_OFFSET_Y                                                 0x1a0a
#define mmDCP0_GRPH_SURFACE_OFFSET_Y                                            0x1a0a
#define mmDCP1_GRPH_SURFACE_OFFSET_Y                                            0x1d0a
#define mmDCP2_GRPH_SURFACE_OFFSET_Y                                            0x400a
#define mmDCP3_GRPH_SURFACE_OFFSET_Y                                            0x430a
#define mmDCP4_GRPH_SURFACE_OFFSET_Y                                            0x460a
#define mmDCP5_GRPH_SURFACE_OFFSET_Y                                            0x490a
#define mmGRPH_X_START                                                          0x1a0b
#define mmDCP0_GRPH_X_START                                                     0x1a0b
#define mmDCP1_GRPH_X_START                                                     0x1d0b
#define mmDCP2_GRPH_X_START                                                     0x400b
#define mmDCP3_GRPH_X_START                                                     0x430b
#define mmDCP4_GRPH_X_START                                                     0x460b
#define mmDCP5_GRPH_X_START                                                     0x490b
#define mmGRPH_Y_START                                                          0x1a0c
#define mmDCP0_GRPH_Y_START                                                     0x1a0c
#define mmDCP1_GRPH_Y_START                                                     0x1d0c
#define mmDCP2_GRPH_Y_START                                                     0x400c
#define mmDCP3_GRPH_Y_START                                                     0x430c
#define mmDCP4_GRPH_Y_START                                                     0x460c
#define mmDCP5_GRPH_Y_START                                                     0x490c
#define mmGRPH_X_END                                                            0x1a0d
#define mmDCP0_GRPH_X_END                                                       0x1a0d
#define mmDCP1_GRPH_X_END                                                       0x1d0d
#define mmDCP2_GRPH_X_END                                                       0x400d
#define mmDCP3_GRPH_X_END                                                       0x430d
#define mmDCP4_GRPH_X_END                                                       0x460d
#define mmDCP5_GRPH_X_END                                                       0x490d
#define mmGRPH_Y_END                                                            0x1a0e
#define mmDCP0_GRPH_Y_END                                                       0x1a0e
#define mmDCP1_GRPH_Y_END                                                       0x1d0e
#define mmDCP2_GRPH_Y_END                                                       0x400e
#define mmDCP3_GRPH_Y_END                                                       0x430e
#define mmDCP4_GRPH_Y_END                                                       0x460e
#define mmDCP5_GRPH_Y_END                                                       0x490e
#define mmINPUT_GAMMA_CONTROL                                                   0x1a10
#define mmDCP0_INPUT_GAMMA_CONTROL                                              0x1a10
#define mmDCP1_INPUT_GAMMA_CONTROL                                              0x1d10
#define mmDCP2_INPUT_GAMMA_CONTROL                                              0x4010
#define mmDCP3_INPUT_GAMMA_CONTROL                                              0x4310
#define mmDCP4_INPUT_GAMMA_CONTROL                                              0x4610
#define mmDCP5_INPUT_GAMMA_CONTROL                                              0x4910
#define mmGRPH_UPDATE                                                           0x1a11
#define mmDCP0_GRPH_UPDATE                                                      0x1a11
#define mmDCP1_GRPH_UPDATE                                                      0x1d11
#define mmDCP2_GRPH_UPDATE                                                      0x4011
#define mmDCP3_GRPH_UPDATE                                                      0x4311
#define mmDCP4_GRPH_UPDATE                                                      0x4611
#define mmDCP5_GRPH_UPDATE                                                      0x4911
#define mmGRPH_FLIP_CONTROL                                                     0x1a12
#define mmDCP0_GRPH_FLIP_CONTROL                                                0x1a12
#define mmDCP1_GRPH_FLIP_CONTROL                                                0x1d12
#define mmDCP2_GRPH_FLIP_CONTROL                                                0x4012
#define mmDCP3_GRPH_FLIP_CONTROL                                                0x4312
#define mmDCP4_GRPH_FLIP_CONTROL                                                0x4612
#define mmDCP5_GRPH_FLIP_CONTROL                                                0x4912
#define mmGRPH_SURFACE_ADDRESS_INUSE                                            0x1a13
#define mmDCP0_GRPH_SURFACE_ADDRESS_INUSE                                       0x1a13
#define mmDCP1_GRPH_SURFACE_ADDRESS_INUSE                                       0x1d13
#define mmDCP2_GRPH_SURFACE_ADDRESS_INUSE                                       0x4013
#define mmDCP3_GRPH_SURFACE_ADDRESS_INUSE                                       0x4313
#define mmDCP4_GRPH_SURFACE_ADDRESS_INUSE                                       0x4613
#define mmDCP5_GRPH_SURFACE_ADDRESS_INUSE                                       0x4913
#define mmGRPH_DFQ_CONTROL                                                      0x1a14
#define mmDCP0_GRPH_DFQ_CONTROL                                                 0x1a14
#define mmDCP1_GRPH_DFQ_CONTROL                                                 0x1d14
#define mmDCP2_GRPH_DFQ_CONTROL                                                 0x4014
#define mmDCP3_GRPH_DFQ_CONTROL                                                 0x4314
#define mmDCP4_GRPH_DFQ_CONTROL                                                 0x4614
#define mmDCP5_GRPH_DFQ_CONTROL                                                 0x4914
#define mmGRPH_DFQ_STATUS                                                       0x1a15
#define mmDCP0_GRPH_DFQ_STATUS                                                  0x1a15
#define mmDCP1_GRPH_DFQ_STATUS                                                  0x1d15
#define mmDCP2_GRPH_DFQ_STATUS                                                  0x4015
#define mmDCP3_GRPH_DFQ_STATUS                                                  0x4315
#define mmDCP4_GRPH_DFQ_STATUS                                                  0x4615
#define mmDCP5_GRPH_DFQ_STATUS                                                  0x4915
#define mmGRPH_INTERRUPT_STATUS                                                 0x1a16
#define mmDCP0_GRPH_INTERRUPT_STATUS                                            0x1a16
#define mmDCP1_GRPH_INTERRUPT_STATUS                                            0x1d16
#define mmDCP2_GRPH_INTERRUPT_STATUS                                            0x4016
#define mmDCP3_GRPH_INTERRUPT_STATUS                                            0x4316
#define mmDCP4_GRPH_INTERRUPT_STATUS                                            0x4616
#define mmDCP5_GRPH_INTERRUPT_STATUS                                            0x4916
#define mmGRPH_INTERRUPT_CONTROL                                                0x1a17
#define mmDCP0_GRPH_INTERRUPT_CONTROL                                           0x1a17
#define mmDCP1_GRPH_INTERRUPT_CONTROL                                           0x1d17
#define mmDCP2_GRPH_INTERRUPT_CONTROL                                           0x4017
#define mmDCP3_GRPH_INTERRUPT_CONTROL                                           0x4317
#define mmDCP4_GRPH_INTERRUPT_CONTROL                                           0x4617
#define mmDCP5_GRPH_INTERRUPT_CONTROL                                           0x4917
#define mmGRPH_SURFACE_ADDRESS_HIGH_INUSE                                       0x1a18
#define mmDCP0_GRPH_SURFACE_ADDRESS_HIGH_INUSE                                  0x1a18
#define mmDCP1_GRPH_SURFACE_ADDRESS_HIGH_INUSE                                  0x1d18
#define mmDCP2_GRPH_SURFACE_ADDRESS_HIGH_INUSE                                  0x4018
#define mmDCP3_GRPH_SURFACE_ADDRESS_HIGH_INUSE                                  0x4318
#define mmDCP4_GRPH_SURFACE_ADDRESS_HIGH_INUSE                                  0x4618
#define mmDCP5_GRPH_SURFACE_ADDRESS_HIGH_INUSE                                  0x4918
#define mmGRPH_COMPRESS_SURFACE_ADDRESS                                         0x1a19
#define mmDCP0_GRPH_COMPRESS_SURFACE_ADDRESS                                    0x1a19
#define mmDCP1_GRPH_COMPRESS_SURFACE_ADDRESS                                    0x1d19
#define mmDCP2_GRPH_COMPRESS_SURFACE_ADDRESS                                    0x4019
#define mmDCP3_GRPH_COMPRESS_SURFACE_ADDRESS                                    0x4319
#define mmDCP4_GRPH_COMPRESS_SURFACE_ADDRESS                                    0x4619
#define mmDCP5_GRPH_COMPRESS_SURFACE_ADDRESS                                    0x4919
#define mmGRPH_COMPRESS_PITCH                                                   0x1a1a
#define mmDCP0_GRPH_COMPRESS_PITCH                                              0x1a1a
#define mmDCP1_GRPH_COMPRESS_PITCH                                              0x1d1a
#define mmDCP2_GRPH_COMPRESS_PITCH                                              0x401a
#define mmDCP3_GRPH_COMPRESS_PITCH                                              0x431a
#define mmDCP4_GRPH_COMPRESS_PITCH                                              0x461a
#define mmDCP5_GRPH_COMPRESS_PITCH                                              0x491a
#define mmGRPH_COMPRESS_SURFACE_ADDRESS_HIGH                                    0x1a1b
#define mmDCP0_GRPH_COMPRESS_SURFACE_ADDRESS_HIGH                               0x1a1b
#define mmDCP1_GRPH_COMPRESS_SURFACE_ADDRESS_HIGH                               0x1d1b
#define mmDCP2_GRPH_COMPRESS_SURFACE_ADDRESS_HIGH                               0x401b
#define mmDCP3_GRPH_COMPRESS_SURFACE_ADDRESS_HIGH                               0x431b
#define mmDCP4_GRPH_COMPRESS_SURFACE_ADDRESS_HIGH                               0x461b
#define mmDCP5_GRPH_COMPRESS_SURFACE_ADDRESS_HIGH                               0x491b
#define mmOVL_ENABLE                                                            0x1a1c
#define mmDCP0_OVL_ENABLE                                                       0x1a1c
#define mmDCP1_OVL_ENABLE                                                       0x1d1c
#define mmDCP2_OVL_ENABLE                                                       0x401c
#define mmDCP3_OVL_ENABLE                                                       0x431c
#define mmDCP4_OVL_ENABLE                                                       0x461c
#define mmDCP5_OVL_ENABLE                                                       0x491c
#define mmOVL_CONTROL1                                                          0x1a1d
#define mmDCP0_OVL_CONTROL1                                                     0x1a1d
#define mmDCP1_OVL_CONTROL1                                                     0x1d1d
#define mmDCP2_OVL_CONTROL1                                                     0x401d
#define mmDCP3_OVL_CONTROL1                                                     0x431d
#define mmDCP4_OVL_CONTROL1                                                     0x461d
#define mmDCP5_OVL_CONTROL1                                                     0x491d
#define mmOVL_CONTROL2                                                          0x1a1e
#define mmDCP0_OVL_CONTROL2                                                     0x1a1e
#define mmDCP1_OVL_CONTROL2                                                     0x1d1e
#define mmDCP2_OVL_CONTROL2                                                     0x401e
#define mmDCP3_OVL_CONTROL2                                                     0x431e
#define mmDCP4_OVL_CONTROL2                                                     0x461e
#define mmDCP5_OVL_CONTROL2                                                     0x491e
#define mmOVL_SWAP_CNTL                                                         0x1a1f
#define mmDCP0_OVL_SWAP_CNTL                                                    0x1a1f
#define mmDCP1_OVL_SWAP_CNTL                                                    0x1d1f
#define mmDCP2_OVL_SWAP_CNTL                                                    0x401f
#define mmDCP3_OVL_SWAP_CNTL                                                    0x431f
#define mmDCP4_OVL_SWAP_CNTL                                                    0x461f
#define mmDCP5_OVL_SWAP_CNTL                                                    0x491f
#define mmOVL_SURFACE_ADDRESS                                                   0x1a20
#define mmDCP0_OVL_SURFACE_ADDRESS                                              0x1a20
#define mmDCP1_OVL_SURFACE_ADDRESS                                              0x1d20
#define mmDCP2_OVL_SURFACE_ADDRESS                                              0x4020
#define mmDCP3_OVL_SURFACE_ADDRESS                                              0x4320
#define mmDCP4_OVL_SURFACE_ADDRESS                                              0x4620
#define mmDCP5_OVL_SURFACE_ADDRESS                                              0x4920
#define mmOVL_PITCH                                                             0x1a21
#define mmDCP0_OVL_PITCH                                                        0x1a21
#define mmDCP1_OVL_PITCH                                                        0x1d21
#define mmDCP2_OVL_PITCH                                                        0x4021
#define mmDCP3_OVL_PITCH                                                        0x4321
#define mmDCP4_OVL_PITCH                                                        0x4621
#define mmDCP5_OVL_PITCH                                                        0x4921
#define mmOVL_SURFACE_ADDRESS_HIGH                                              0x1a22
#define mmDCP0_OVL_SURFACE_ADDRESS_HIGH                                         0x1a22
#define mmDCP1_OVL_SURFACE_ADDRESS_HIGH                                         0x1d22
#define mmDCP2_OVL_SURFACE_ADDRESS_HIGH                                         0x4022
#define mmDCP3_OVL_SURFACE_ADDRESS_HIGH                                         0x4322
#define mmDCP4_OVL_SURFACE_ADDRESS_HIGH                                         0x4622
#define mmDCP5_OVL_SURFACE_ADDRESS_HIGH                                         0x4922
#define mmOVL_SURFACE_OFFSET_X                                                  0x1a23
#define mmDCP0_OVL_SURFACE_OFFSET_X                                             0x1a23
#define mmDCP1_OVL_SURFACE_OFFSET_X                                             0x1d23
#define mmDCP2_OVL_SURFACE_OFFSET_X                                             0x4023
#define mmDCP3_OVL_SURFACE_OFFSET_X                                             0x4323
#define mmDCP4_OVL_SURFACE_OFFSET_X                                             0x4623
#define mmDCP5_OVL_SURFACE_OFFSET_X                                             0x4923
#define mmOVL_SURFACE_OFFSET_Y                                                  0x1a24
#define mmDCP0_OVL_SURFACE_OFFSET_Y                                             0x1a24
#define mmDCP1_OVL_SURFACE_OFFSET_Y                                             0x1d24
#define mmDCP2_OVL_SURFACE_OFFSET_Y                                             0x4024
#define mmDCP3_OVL_SURFACE_OFFSET_Y                                             0x4324
#define mmDCP4_OVL_SURFACE_OFFSET_Y                                             0x4624
#define mmDCP5_OVL_SURFACE_OFFSET_Y                                             0x4924
#define mmOVL_START                                                             0x1a25
#define mmDCP0_OVL_START                                                        0x1a25
#define mmDCP1_OVL_START                                                        0x1d25
#define mmDCP2_OVL_START                                                        0x4025
#define mmDCP3_OVL_START                                                        0x4325
#define mmDCP4_OVL_START                                                        0x4625
#define mmDCP5_OVL_START                                                        0x4925
#define mmOVL_END                                                               0x1a26
#define mmDCP0_OVL_END                                                          0x1a26
#define mmDCP1_OVL_END                                                          0x1d26
#define mmDCP2_OVL_END                                                          0x4026
#define mmDCP3_OVL_END                                                          0x4326
#define mmDCP4_OVL_END                                                          0x4626
#define mmDCP5_OVL_END                                                          0x4926
#define mmOVL_UPDATE                                                            0x1a27
#define mmDCP0_OVL_UPDATE                                                       0x1a27
#define mmDCP1_OVL_UPDATE                                                       0x1d27
#define mmDCP2_OVL_UPDATE                                                       0x4027
#define mmDCP3_OVL_UPDATE                                                       0x4327
#define mmDCP4_OVL_UPDATE                                                       0x4627
#define mmDCP5_OVL_UPDATE                                                       0x4927
#define mmOVL_SURFACE_ADDRESS_INUSE                                             0x1a28
#define mmDCP0_OVL_SURFACE_ADDRESS_INUSE                                        0x1a28
#define mmDCP1_OVL_SURFACE_ADDRESS_INUSE                                        0x1d28
#define mmDCP2_OVL_SURFACE_ADDRESS_INUSE                                        0x4028
#define mmDCP3_OVL_SURFACE_ADDRESS_INUSE                                        0x4328
#define mmDCP4_OVL_SURFACE_ADDRESS_INUSE                                        0x4628
#define mmDCP5_OVL_SURFACE_ADDRESS_INUSE                                        0x4928
#define mmOVL_DFQ_CONTROL                                                       0x1a29
#define mmDCP0_OVL_DFQ_CONTROL                                                  0x1a29
#define mmDCP1_OVL_DFQ_CONTROL                                                  0x1d29
#define mmDCP2_OVL_DFQ_CONTROL                                                  0x4029
#define mmDCP3_OVL_DFQ_CONTROL                                                  0x4329
#define mmDCP4_OVL_DFQ_CONTROL                                                  0x4629
#define mmDCP5_OVL_DFQ_CONTROL                                                  0x4929
#define mmOVL_DFQ_STATUS                                                        0x1a2a
#define mmDCP0_OVL_DFQ_STATUS                                                   0x1a2a
#define mmDCP1_OVL_DFQ_STATUS                                                   0x1d2a
#define mmDCP2_OVL_DFQ_STATUS                                                   0x402a
#define mmDCP3_OVL_DFQ_STATUS                                                   0x432a
#define mmDCP4_OVL_DFQ_STATUS                                                   0x462a
#define mmDCP5_OVL_DFQ_STATUS                                                   0x492a
#define mmOVL_SURFACE_ADDRESS_HIGH_INUSE                                        0x1a2b
#define mmDCP0_OVL_SURFACE_ADDRESS_HIGH_INUSE                                   0x1a2b
#define mmDCP1_OVL_SURFACE_ADDRESS_HIGH_INUSE                                   0x1d2b
#define mmDCP2_OVL_SURFACE_ADDRESS_HIGH_INUSE                                   0x402b
#define mmDCP3_OVL_SURFACE_ADDRESS_HIGH_INUSE                                   0x432b
#define mmDCP4_OVL_SURFACE_ADDRESS_HIGH_INUSE                                   0x462b
#define mmDCP5_OVL_SURFACE_ADDRESS_HIGH_INUSE                                   0x492b
#define mmOVLSCL_EDGE_PIXEL_CNTL                                                0x1a2c
#define mmDCP0_OVLSCL_EDGE_PIXEL_CNTL                                           0x1a2c
#define mmDCP1_OVLSCL_EDGE_PIXEL_CNTL                                           0x1d2c
#define mmDCP2_OVLSCL_EDGE_PIXEL_CNTL                                           0x402c
#define mmDCP3_OVLSCL_EDGE_PIXEL_CNTL                                           0x432c
#define mmDCP4_OVLSCL_EDGE_PIXEL_CNTL                                           0x462c
#define mmDCP5_OVLSCL_EDGE_PIXEL_CNTL                                           0x492c
#define mmPRESCALE_GRPH_CONTROL                                                 0x1a2d
#define mmDCP0_PRESCALE_GRPH_CONTROL                                            0x1a2d
#define mmDCP1_PRESCALE_GRPH_CONTROL                                            0x1d2d
#define mmDCP2_PRESCALE_GRPH_CONTROL                                            0x402d
#define mmDCP3_PRESCALE_GRPH_CONTROL                                            0x432d
#define mmDCP4_PRESCALE_GRPH_CONTROL                                            0x462d
#define mmDCP5_PRESCALE_GRPH_CONTROL                                            0x492d
#define mmPRESCALE_VALUES_GRPH_R                                                0x1a2e
#define mmDCP0_PRESCALE_VALUES_GRPH_R                                           0x1a2e
#define mmDCP1_PRESCALE_VALUES_GRPH_R                                           0x1d2e
#define mmDCP2_PRESCALE_VALUES_GRPH_R                                           0x402e
#define mmDCP3_PRESCALE_VALUES_GRPH_R                                           0x432e
#define mmDCP4_PRESCALE_VALUES_GRPH_R                                           0x462e
#define mmDCP5_PRESCALE_VALUES_GRPH_R                                           0x492e
#define mmPRESCALE_VALUES_GRPH_G                                                0x1a2f
#define mmDCP0_PRESCALE_VALUES_GRPH_G                                           0x1a2f
#define mmDCP1_PRESCALE_VALUES_GRPH_G                                           0x1d2f
#define mmDCP2_PRESCALE_VALUES_GRPH_G                                           0x402f
#define mmDCP3_PRESCALE_VALUES_GRPH_G                                           0x432f
#define mmDCP4_PRESCALE_VALUES_GRPH_G                                           0x462f
#define mmDCP5_PRESCALE_VALUES_GRPH_G                                           0x492f
#define mmPRESCALE_VALUES_GRPH_B                                                0x1a30
#define mmDCP0_PRESCALE_VALUES_GRPH_B                                           0x1a30
#define mmDCP1_PRESCALE_VALUES_GRPH_B                                           0x1d30
#define mmDCP2_PRESCALE_VALUES_GRPH_B                                           0x4030
#define mmDCP3_PRESCALE_VALUES_GRPH_B                                           0x4330
#define mmDCP4_PRESCALE_VALUES_GRPH_B                                           0x4630
#define mmDCP5_PRESCALE_VALUES_GRPH_B                                           0x4930
#define mmPRESCALE_OVL_CONTROL                                                  0x1a31
#define mmDCP0_PRESCALE_OVL_CONTROL                                             0x1a31
#define mmDCP1_PRESCALE_OVL_CONTROL                                             0x1d31
#define mmDCP2_PRESCALE_OVL_CONTROL                                             0x4031
#define mmDCP3_PRESCALE_OVL_CONTROL                                             0x4331
#define mmDCP4_PRESCALE_OVL_CONTROL                                             0x4631
#define mmDCP5_PRESCALE_OVL_CONTROL                                             0x4931
#define mmPRESCALE_VALUES_OVL_CB                                                0x1a32
#define mmDCP0_PRESCALE_VALUES_OVL_CB                                           0x1a32
#define mmDCP1_PRESCALE_VALUES_OVL_CB                                           0x1d32
#define mmDCP2_PRESCALE_VALUES_OVL_CB                                           0x4032
#define mmDCP3_PRESCALE_VALUES_OVL_CB                                           0x4332
#define mmDCP4_PRESCALE_VALUES_OVL_CB                                           0x4632
#define mmDCP5_PRESCALE_VALUES_OVL_CB                                           0x4932
#define mmPRESCALE_VALUES_OVL_Y                                                 0x1a33
#define mmDCP0_PRESCALE_VALUES_OVL_Y                                            0x1a33
#define mmDCP1_PRESCALE_VALUES_OVL_Y                                            0x1d33
#define mmDCP2_PRESCALE_VALUES_OVL_Y                                            0x4033
#define mmDCP3_PRESCALE_VALUES_OVL_Y                                            0x4333
#define mmDCP4_PRESCALE_VALUES_OVL_Y                                            0x4633
#define mmDCP5_PRESCALE_VALUES_OVL_Y                                            0x4933
#define mmPRESCALE_VALUES_OVL_CR                                                0x1a34
#define mmDCP0_PRESCALE_VALUES_OVL_CR                                           0x1a34
#define mmDCP1_PRESCALE_VALUES_OVL_CR                                           0x1d34
#define mmDCP2_PRESCALE_VALUES_OVL_CR                                           0x4034
#define mmDCP3_PRESCALE_VALUES_OVL_CR                                           0x4334
#define mmDCP4_PRESCALE_VALUES_OVL_CR                                           0x4634
#define mmDCP5_PRESCALE_VALUES_OVL_CR                                           0x4934
#define mmINPUT_CSC_CONTROL                                                     0x1a35
#define mmDCP0_INPUT_CSC_CONTROL                                                0x1a35
#define mmDCP1_INPUT_CSC_CONTROL                                                0x1d35
#define mmDCP2_INPUT_CSC_CONTROL                                                0x4035
#define mmDCP3_INPUT_CSC_CONTROL                                                0x4335
#define mmDCP4_INPUT_CSC_CONTROL                                                0x4635
#define mmDCP5_INPUT_CSC_CONTROL                                                0x4935
#define mmINPUT_CSC_C11_C12                                                     0x1a36
#define mmDCP0_INPUT_CSC_C11_C12                                                0x1a36
#define mmDCP1_INPUT_CSC_C11_C12                                                0x1d36
#define mmDCP2_INPUT_CSC_C11_C12                                                0x4036
#define mmDCP3_INPUT_CSC_C11_C12                                                0x4336
#define mmDCP4_INPUT_CSC_C11_C12                                                0x4636
#define mmDCP5_INPUT_CSC_C11_C12                                                0x4936
#define mmINPUT_CSC_C13_C14                                                     0x1a37
#define mmDCP0_INPUT_CSC_C13_C14                                                0x1a37
#define mmDCP1_INPUT_CSC_C13_C14                                                0x1d37
#define mmDCP2_INPUT_CSC_C13_C14                                                0x4037
#define mmDCP3_INPUT_CSC_C13_C14                                                0x4337
#define mmDCP4_INPUT_CSC_C13_C14                                                0x4637
#define mmDCP5_INPUT_CSC_C13_C14                                                0x4937
#define mmINPUT_CSC_C21_C22                                                     0x1a38
#define mmDCP0_INPUT_CSC_C21_C22                                                0x1a38
#define mmDCP1_INPUT_CSC_C21_C22                                                0x1d38
#define mmDCP2_INPUT_CSC_C21_C22                                                0x4038
#define mmDCP3_INPUT_CSC_C21_C22                                                0x4338
#define mmDCP4_INPUT_CSC_C21_C22                                                0x4638
#define mmDCP5_INPUT_CSC_C21_C22                                                0x4938
#define mmINPUT_CSC_C23_C24                                                     0x1a39
#define mmDCP0_INPUT_CSC_C23_C24                                                0x1a39
#define mmDCP1_INPUT_CSC_C23_C24                                                0x1d39
#define mmDCP2_INPUT_CSC_C23_C24                                                0x4039
#define mmDCP3_INPUT_CSC_C23_C24                                                0x4339
#define mmDCP4_INPUT_CSC_C23_C24                                                0x4639
#define mmDCP5_INPUT_CSC_C23_C24                                                0x4939
#define mmINPUT_CSC_C31_C32                                                     0x1a3a
#define mmDCP0_INPUT_CSC_C31_C32                                                0x1a3a
#define mmDCP1_INPUT_CSC_C31_C32                                                0x1d3a
#define mmDCP2_INPUT_CSC_C31_C32                                                0x403a
#define mmDCP3_INPUT_CSC_C31_C32                                                0x433a
#define mmDCP4_INPUT_CSC_C31_C32                                                0x463a
#define mmDCP5_INPUT_CSC_C31_C32                                                0x493a
#define mmINPUT_CSC_C33_C34                                                     0x1a3b
#define mmDCP0_INPUT_CSC_C33_C34                                                0x1a3b
#define mmDCP1_INPUT_CSC_C33_C34                                                0x1d3b
#define mmDCP2_INPUT_CSC_C33_C34                                                0x403b
#define mmDCP3_INPUT_CSC_C33_C34                                                0x433b
#define mmDCP4_INPUT_CSC_C33_C34                                                0x463b
#define mmDCP5_INPUT_CSC_C33_C34                                                0x493b
#define mmOUTPUT_CSC_CONTROL                                                    0x1a3c
#define mmDCP0_OUTPUT_CSC_CONTROL                                               0x1a3c
#define mmDCP1_OUTPUT_CSC_CONTROL                                               0x1d3c
#define mmDCP2_OUTPUT_CSC_CONTROL                                               0x403c
#define mmDCP3_OUTPUT_CSC_CONTROL                                               0x433c
#define mmDCP4_OUTPUT_CSC_CONTROL                                               0x463c
#define mmDCP5_OUTPUT_CSC_CONTROL                                               0x493c
#define mmOUTPUT_CSC_C11_C12                                                    0x1a3d
#define mmDCP0_OUTPUT_CSC_C11_C12                                               0x1a3d
#define mmDCP1_OUTPUT_CSC_C11_C12                                               0x1d3d
#define mmDCP2_OUTPUT_CSC_C11_C12                                               0x403d
#define mmDCP3_OUTPUT_CSC_C11_C12                                               0x433d
#define mmDCP4_OUTPUT_CSC_C11_C12                                               0x463d
#define mmDCP5_OUTPUT_CSC_C11_C12                                               0x493d
#define mmOUTPUT_CSC_C13_C14                                                    0x1a3e
#define mmDCP0_OUTPUT_CSC_C13_C14                                               0x1a3e
#define mmDCP1_OUTPUT_CSC_C13_C14                                               0x1d3e
#define mmDCP2_OUTPUT_CSC_C13_C14                                               0x403e
#define mmDCP3_OUTPUT_CSC_C13_C14                                               0x433e
#define mmDCP4_OUTPUT_CSC_C13_C14                                               0x463e
#define mmDCP5_OUTPUT_CSC_C13_C14                                               0x493e
#define mmOUTPUT_CSC_C21_C22                                                    0x1a3f
#define mmDCP0_OUTPUT_CSC_C21_C22                                               0x1a3f
#define mmDCP1_OUTPUT_CSC_C21_C22                                               0x1d3f
#define mmDCP2_OUTPUT_CSC_C21_C22                                               0x403f
#define mmDCP3_OUTPUT_CSC_C21_C22                                               0x433f
#define mmDCP4_OUTPUT_CSC_C21_C22                                               0x463f
#define mmDCP5_OUTPUT_CSC_C21_C22                                               0x493f
#define mmOUTPUT_CSC_C23_C24                                                    0x1a40
#define mmDCP0_OUTPUT_CSC_C23_C24                                               0x1a40
#define mmDCP1_OUTPUT_CSC_C23_C24                                               0x1d40
#define mmDCP2_OUTPUT_CSC_C23_C24                                               0x4040
#define mmDCP3_OUTPUT_CSC_C23_C24                                               0x4340
#define mmDCP4_OUTPUT_CSC_C23_C24                                               0x4640
#define mmDCP5_OUTPUT_CSC_C23_C24                                               0x4940
#define mmOUTPUT_CSC_C31_C32                                                    0x1a41
#define mmDCP0_OUTPUT_CSC_C31_C32                                               0x1a41
#define mmDCP1_OUTPUT_CSC_C31_C32                                               0x1d41
#define mmDCP2_OUTPUT_CSC_C31_C32                                               0x4041
#define mmDCP3_OUTPUT_CSC_C31_C32                                               0x4341
#define mmDCP4_OUTPUT_CSC_C31_C32                                               0x4641
#define mmDCP5_OUTPUT_CSC_C31_C32                                               0x4941
#define mmOUTPUT_CSC_C33_C34                                                    0x1a42
#define mmDCP0_OUTPUT_CSC_C33_C34                                               0x1a42
#define mmDCP1_OUTPUT_CSC_C33_C34                                               0x1d42
#define mmDCP2_OUTPUT_CSC_C33_C34                                               0x4042
#define mmDCP3_OUTPUT_CSC_C33_C34                                               0x4342
#define mmDCP4_OUTPUT_CSC_C33_C34                                               0x4642
#define mmDCP5_OUTPUT_CSC_C33_C34                                               0x4942
#define mmCOMM_MATRIXA_TRANS_C11_C12                                            0x1a43
#define mmDCP0_COMM_MATRIXA_TRANS_C11_C12                                       0x1a43
#define mmDCP1_COMM_MATRIXA_TRANS_C11_C12                                       0x1d43
#define mmDCP2_COMM_MATRIXA_TRANS_C11_C12                                       0x4043
#define mmDCP3_COMM_MATRIXA_TRANS_C11_C12                                       0x4343
#define mmDCP4_COMM_MATRIXA_TRANS_C11_C12                                       0x4643
#define mmDCP5_COMM_MATRIXA_TRANS_C11_C12                                       0x4943
#define mmCOMM_MATRIXA_TRANS_C13_C14                                            0x1a44
#define mmDCP0_COMM_MATRIXA_TRANS_C13_C14                                       0x1a44
#define mmDCP1_COMM_MATRIXA_TRANS_C13_C14                                       0x1d44
#define mmDCP2_COMM_MATRIXA_TRANS_C13_C14                                       0x4044
#define mmDCP3_COMM_MATRIXA_TRANS_C13_C14                                       0x4344
#define mmDCP4_COMM_MATRIXA_TRANS_C13_C14                                       0x4644
#define mmDCP5_COMM_MATRIXA_TRANS_C13_C14                                       0x4944
#define mmCOMM_MATRIXA_TRANS_C21_C22                                            0x1a45
#define mmDCP0_COMM_MATRIXA_TRANS_C21_C22                                       0x1a45
#define mmDCP1_COMM_MATRIXA_TRANS_C21_C22                                       0x1d45
#define mmDCP2_COMM_MATRIXA_TRANS_C21_C22                                       0x4045
#define mmDCP3_COMM_MATRIXA_TRANS_C21_C22                                       0x4345
#define mmDCP4_COMM_MATRIXA_TRANS_C21_C22                                       0x4645
#define mmDCP5_COMM_MATRIXA_TRANS_C21_C22                                       0x4945
#define mmCOMM_MATRIXA_TRANS_C23_C24                                            0x1a46
#define mmDCP0_COMM_MATRIXA_TRANS_C23_C24                                       0x1a46
#define mmDCP1_COMM_MATRIXA_TRANS_C23_C24                                       0x1d46
#define mmDCP2_COMM_MATRIXA_TRANS_C23_C24                                       0x4046
#define mmDCP3_COMM_MATRIXA_TRANS_C23_C24                                       0x4346
#define mmDCP4_COMM_MATRIXA_TRANS_C23_C24                                       0x4646
#define mmDCP5_COMM_MATRIXA_TRANS_C23_C24                                       0x4946
#define mmCOMM_MATRIXA_TRANS_C31_C32                                            0x1a47
#define mmDCP0_COMM_MATRIXA_TRANS_C31_C32                                       0x1a47
#define mmDCP1_COMM_MATRIXA_TRANS_C31_C32                                       0x1d47
#define mmDCP2_COMM_MATRIXA_TRANS_C31_C32                                       0x4047
#define mmDCP3_COMM_MATRIXA_TRANS_C31_C32                                       0x4347
#define mmDCP4_COMM_MATRIXA_TRANS_C31_C32                                       0x4647
#define mmDCP5_COMM_MATRIXA_TRANS_C31_C32                                       0x4947
#define mmCOMM_MATRIXA_TRANS_C33_C34                                            0x1a48
#define mmDCP0_COMM_MATRIXA_TRANS_C33_C34                                       0x1a48
#define mmDCP1_COMM_MATRIXA_TRANS_C33_C34                                       0x1d48
#define mmDCP2_COMM_MATRIXA_TRANS_C33_C34                                       0x4048
#define mmDCP3_COMM_MATRIXA_TRANS_C33_C34                                       0x4348
#define mmDCP4_COMM_MATRIXA_TRANS_C33_C34                                       0x4648
#define mmDCP5_COMM_MATRIXA_TRANS_C33_C34                                       0x4948
#define mmCOMM_MATRIXB_TRANS_C11_C12                                            0x1a49
#define mmDCP0_COMM_MATRIXB_TRANS_C11_C12                                       0x1a49
#define mmDCP1_COMM_MATRIXB_TRANS_C11_C12                                       0x1d49
#define mmDCP2_COMM_MATRIXB_TRANS_C11_C12                                       0x4049
#define mmDCP3_COMM_MATRIXB_TRANS_C11_C12                                       0x4349
#define mmDCP4_COMM_MATRIXB_TRANS_C11_C12                                       0x4649
#define mmDCP5_COMM_MATRIXB_TRANS_C11_C12                                       0x4949
#define mmCOMM_MATRIXB_TRANS_C13_C14                                            0x1a4a
#define mmDCP0_COMM_MATRIXB_TRANS_C13_C14                                       0x1a4a
#define mmDCP1_COMM_MATRIXB_TRANS_C13_C14                                       0x1d4a
#define mmDCP2_COMM_MATRIXB_TRANS_C13_C14                                       0x404a
#define mmDCP3_COMM_MATRIXB_TRANS_C13_C14                                       0x434a
#define mmDCP4_COMM_MATRIXB_TRANS_C13_C14                                       0x464a
#define mmDCP5_COMM_MATRIXB_TRANS_C13_C14                                       0x494a
#define mmCOMM_MATRIXB_TRANS_C21_C22                                            0x1a4b
#define mmDCP0_COMM_MATRIXB_TRANS_C21_C22                                       0x1a4b
#define mmDCP1_COMM_MATRIXB_TRANS_C21_C22                                       0x1d4b
#define mmDCP2_COMM_MATRIXB_TRANS_C21_C22                                       0x404b
#define mmDCP3_COMM_MATRIXB_TRANS_C21_C22                                       0x434b
#define mmDCP4_COMM_MATRIXB_TRANS_C21_C22                                       0x464b
#define mmDCP5_COMM_MATRIXB_TRANS_C21_C22                                       0x494b
#define mmCOMM_MATRIXB_TRANS_C23_C24                                            0x1a4c
#define mmDCP0_COMM_MATRIXB_TRANS_C23_C24                                       0x1a4c
#define mmDCP1_COMM_MATRIXB_TRANS_C23_C24                                       0x1d4c
#define mmDCP2_COMM_MATRIXB_TRANS_C23_C24                                       0x404c
#define mmDCP3_COMM_MATRIXB_TRANS_C23_C24                                       0x434c
#define mmDCP4_COMM_MATRIXB_TRANS_C23_C24                                       0x464c
#define mmDCP5_COMM_MATRIXB_TRANS_C23_C24                                       0x494c
#define mmCOMM_MATRIXB_TRANS_C31_C32                                            0x1a4d
#define mmDCP0_COMM_MATRIXB_TRANS_C31_C32                                       0x1a4d
#define mmDCP1_COMM_MATRIXB_TRANS_C31_C32                                       0x1d4d
#define mmDCP2_COMM_MATRIXB_TRANS_C31_C32                                       0x404d
#define mmDCP3_COMM_MATRIXB_TRANS_C31_C32                                       0x434d
#define mmDCP4_COMM_MATRIXB_TRANS_C31_C32                                       0x464d
#define mmDCP5_COMM_MATRIXB_TRANS_C31_C32                                       0x494d
#define mmCOMM_MATRIXB_TRANS_C33_C34                                            0x1a4e
#define mmDCP0_COMM_MATRIXB_TRANS_C33_C34                                       0x1a4e
#define mmDCP1_COMM_MATRIXB_TRANS_C33_C34                                       0x1d4e
#define mmDCP2_COMM_MATRIXB_TRANS_C33_C34                                       0x404e
#define mmDCP3_COMM_MATRIXB_TRANS_C33_C34                                       0x434e
#define mmDCP4_COMM_MATRIXB_TRANS_C33_C34                                       0x464e
#define mmDCP5_COMM_MATRIXB_TRANS_C33_C34                                       0x494e
#define mmDENORM_CONTROL                                                        0x1a50
#define mmDCP0_DENORM_CONTROL                                                   0x1a50
#define mmDCP1_DENORM_CONTROL                                                   0x1d50
#define mmDCP2_DENORM_CONTROL                                                   0x4050
#define mmDCP3_DENORM_CONTROL                                                   0x4350
#define mmDCP4_DENORM_CONTROL                                                   0x4650
#define mmDCP5_DENORM_CONTROL                                                   0x4950
#define mmOUT_ROUND_CONTROL                                                     0x1a51
#define mmDCP0_OUT_ROUND_CONTROL                                                0x1a51
#define mmDCP1_OUT_ROUND_CONTROL                                                0x1d51
#define mmDCP2_OUT_ROUND_CONTROL                                                0x4051
#define mmDCP3_OUT_ROUND_CONTROL                                                0x4351
#define mmDCP4_OUT_ROUND_CONTROL                                                0x4651
#define mmDCP5_OUT_ROUND_CONTROL                                                0x4951
#define mmOUT_CLAMP_CONTROL_R_CR                                                0x1a52
#define mmDCP0_OUT_CLAMP_CONTROL_R_CR                                           0x1a52
#define mmDCP1_OUT_CLAMP_CONTROL_R_CR                                           0x1d52
#define mmDCP2_OUT_CLAMP_CONTROL_R_CR                                           0x4052
#define mmDCP3_OUT_CLAMP_CONTROL_R_CR                                           0x4352
#define mmDCP4_OUT_CLAMP_CONTROL_R_CR                                           0x4652
#define mmDCP5_OUT_CLAMP_CONTROL_R_CR                                           0x4952
#define mmOUT_CLAMP_CONTROL_G_Y                                                 0x1a9c
#define mmDCP0_OUT_CLAMP_CONTROL_G_Y                                            0x1a9c
#define mmDCP1_OUT_CLAMP_CONTROL_G_Y                                            0x1d9c
#define mmDCP2_OUT_CLAMP_CONTROL_G_Y                                            0x409c
#define mmDCP3_OUT_CLAMP_CONTROL_G_Y                                            0x439c
#define mmDCP4_OUT_CLAMP_CONTROL_G_Y                                            0x469c
#define mmDCP5_OUT_CLAMP_CONTROL_G_Y                                            0x499c
#define mmOUT_CLAMP_CONTROL_B_CB                                                0x1a9d
#define mmDCP0_OUT_CLAMP_CONTROL_B_CB                                           0x1a9d
#define mmDCP1_OUT_CLAMP_CONTROL_B_CB                                           0x1d9d
#define mmDCP2_OUT_CLAMP_CONTROL_B_CB                                           0x409d
#define mmDCP3_OUT_CLAMP_CONTROL_B_CB                                           0x439d
#define mmDCP4_OUT_CLAMP_CONTROL_B_CB                                           0x469d
#define mmDCP5_OUT_CLAMP_CONTROL_B_CB                                           0x499d
#define mmKEY_CONTROL                                                           0x1a53
#define mmDCP0_KEY_CONTROL                                                      0x1a53
#define mmDCP1_KEY_CONTROL                                                      0x1d53
#define mmDCP2_KEY_CONTROL                                                      0x4053
#define mmDCP3_KEY_CONTROL                                                      0x4353
#define mmDCP4_KEY_CONTROL                                                      0x4653
#define mmDCP5_KEY_CONTROL                                                      0x4953
#define mmKEY_RANGE_ALPHA                                                       0x1a54
#define mmDCP0_KEY_RANGE_ALPHA                                                  0x1a54
#define mmDCP1_KEY_RANGE_ALPHA                                                  0x1d54
#define mmDCP2_KEY_RANGE_ALPHA                                                  0x4054
#define mmDCP3_KEY_RANGE_ALPHA                                                  0x4354
#define mmDCP4_KEY_RANGE_ALPHA                                                  0x4654
#define mmDCP5_KEY_RANGE_ALPHA                                                  0x4954
#define mmKEY_RANGE_RED                                                         0x1a55
#define mmDCP0_KEY_RANGE_RED                                                    0x1a55
#define mmDCP1_KEY_RANGE_RED                                                    0x1d55
#define mmDCP2_KEY_RANGE_RED                                                    0x4055
#define mmDCP3_KEY_RANGE_RED                                                    0x4355
#define mmDCP4_KEY_RANGE_RED                                                    0x4655
#define mmDCP5_KEY_RANGE_RED                                                    0x4955
#define mmKEY_RANGE_GREEN                                                       0x1a56
#define mmDCP0_KEY_RANGE_GREEN                                                  0x1a56
#define mmDCP1_KEY_RANGE_GREEN                                                  0x1d56
#define mmDCP2_KEY_RANGE_GREEN                                                  0x4056
#define mmDCP3_KEY_RANGE_GREEN                                                  0x4356
#define mmDCP4_KEY_RANGE_GREEN                                                  0x4656
#define mmDCP5_KEY_RANGE_GREEN                                                  0x4956
#define mmKEY_RANGE_BLUE                                                        0x1a57
#define mmDCP0_KEY_RANGE_BLUE                                                   0x1a57
#define mmDCP1_KEY_RANGE_BLUE                                                   0x1d57
#define mmDCP2_KEY_RANGE_BLUE                                                   0x4057
#define mmDCP3_KEY_RANGE_BLUE                                                   0x4357
#define mmDCP4_KEY_RANGE_BLUE                                                   0x4657
#define mmDCP5_KEY_RANGE_BLUE                                                   0x4957
#define mmDEGAMMA_CONTROL                                                       0x1a58
#define mmDCP0_DEGAMMA_CONTROL                                                  0x1a58
#define mmDCP1_DEGAMMA_CONTROL                                                  0x1d58
#define mmDCP2_DEGAMMA_CONTROL                                                  0x4058
#define mmDCP3_DEGAMMA_CONTROL                                                  0x4358
#define mmDCP4_DEGAMMA_CONTROL                                                  0x4658
#define mmDCP5_DEGAMMA_CONTROL                                                  0x4958
#define mmGAMUT_REMAP_CONTROL                                                   0x1a59
#define mmDCP0_GAMUT_REMAP_CONTROL                                              0x1a59
#define mmDCP1_GAMUT_REMAP_CONTROL                                              0x1d59
#define mmDCP2_GAMUT_REMAP_CONTROL                                              0x4059
#define mmDCP3_GAMUT_REMAP_CONTROL                                              0x4359
#define mmDCP4_GAMUT_REMAP_CONTROL                                              0x4659
#define mmDCP5_GAMUT_REMAP_CONTROL                                              0x4959
#define mmGAMUT_REMAP_C11_C12                                                   0x1a5a
#define mmDCP0_GAMUT_REMAP_C11_C12                                              0x1a5a
#define mmDCP1_GAMUT_REMAP_C11_C12                                              0x1d5a
#define mmDCP2_GAMUT_REMAP_C11_C12                                              0x405a
#define mmDCP3_GAMUT_REMAP_C11_C12                                              0x435a
#define mmDCP4_GAMUT_REMAP_C11_C12                                              0x465a
#define mmDCP5_GAMUT_REMAP_C11_C12                                              0x495a
#define mmGAMUT_REMAP_C13_C14                                                   0x1a5b
#define mmDCP0_GAMUT_REMAP_C13_C14                                              0x1a5b
#define mmDCP1_GAMUT_REMAP_C13_C14                                              0x1d5b
#define mmDCP2_GAMUT_REMAP_C13_C14                                              0x405b
#define mmDCP3_GAMUT_REMAP_C13_C14                                              0x435b
#define mmDCP4_GAMUT_REMAP_C13_C14                                              0x465b
#define mmDCP5_GAMUT_REMAP_C13_C14                                              0x495b
#define mmGAMUT_REMAP_C21_C22                                                   0x1a5c
#define mmDCP0_GAMUT_REMAP_C21_C22                                              0x1a5c
#define mmDCP1_GAMUT_REMAP_C21_C22                                              0x1d5c
#define mmDCP2_GAMUT_REMAP_C21_C22                                              0x405c
#define mmDCP3_GAMUT_REMAP_C21_C22                                              0x435c
#define mmDCP4_GAMUT_REMAP_C21_C22                                              0x465c
#define mmDCP5_GAMUT_REMAP_C21_C22                                              0x495c
#define mmGAMUT_REMAP_C23_C24                                                   0x1a5d
#define mmDCP0_GAMUT_REMAP_C23_C24                                              0x1a5d
#define mmDCP1_GAMUT_REMAP_C23_C24                                              0x1d5d
#define mmDCP2_GAMUT_REMAP_C23_C24                                              0x405d
#define mmDCP3_GAMUT_REMAP_C23_C24                                              0x435d
#define mmDCP4_GAMUT_REMAP_C23_C24                                              0x465d
#define mmDCP5_GAMUT_REMAP_C23_C24                                              0x495d
#define mmGAMUT_REMAP_C31_C32                                                   0x1a5e
#define mmDCP0_GAMUT_REMAP_C31_C32                                              0x1a5e
#define mmDCP1_GAMUT_REMAP_C31_C32                                              0x1d5e
#define mmDCP2_GAMUT_REMAP_C31_C32                                              0x405e
#define mmDCP3_GAMUT_REMAP_C31_C32                                              0x435e
#define mmDCP4_GAMUT_REMAP_C31_C32                                              0x465e
#define mmDCP5_GAMUT_REMAP_C31_C32                                              0x495e
#define mmGAMUT_REMAP_C33_C34                                                   0x1a5f
#define mmDCP0_GAMUT_REMAP_C33_C34                                              0x1a5f
#define mmDCP1_GAMUT_REMAP_C33_C34                                              0x1d5f
#define mmDCP2_GAMUT_REMAP_C33_C34                                              0x405f
#define mmDCP3_GAMUT_REMAP_C33_C34                                              0x435f
#define mmDCP4_GAMUT_REMAP_C33_C34                                              0x465f
#define mmDCP5_GAMUT_REMAP_C33_C34                                              0x495f
#define mmDCP_SPATIAL_DITHER_CNTL                                               0x1a60
#define mmDCP0_DCP_SPATIAL_DITHER_CNTL                                          0x1a60
#define mmDCP1_DCP_SPATIAL_DITHER_CNTL                                          0x1d60
#define mmDCP2_DCP_SPATIAL_DITHER_CNTL                                          0x4060
#define mmDCP3_DCP_SPATIAL_DITHER_CNTL                                          0x4360
#define mmDCP4_DCP_SPATIAL_DITHER_CNTL                                          0x4660
#define mmDCP5_DCP_SPATIAL_DITHER_CNTL                                          0x4960
#define mmDCP_RANDOM_SEEDS                                                      0x1a61
#define mmDCP0_DCP_RANDOM_SEEDS                                                 0x1a61
#define mmDCP1_DCP_RANDOM_SEEDS                                                 0x1d61
#define mmDCP2_DCP_RANDOM_SEEDS                                                 0x4061
#define mmDCP3_DCP_RANDOM_SEEDS                                                 0x4361
#define mmDCP4_DCP_RANDOM_SEEDS                                                 0x4661
#define mmDCP5_DCP_RANDOM_SEEDS                                                 0x4961
#define mmDCP_FP_CONVERTED_FIELD                                                0x1a65
#define mmDCP0_DCP_FP_CONVERTED_FIELD                                           0x1a65
#define mmDCP1_DCP_FP_CONVERTED_FIELD                                           0x1d65
#define mmDCP2_DCP_FP_CONVERTED_FIELD                                           0x4065
#define mmDCP3_DCP_FP_CONVERTED_FIELD                                           0x4365
#define mmDCP4_DCP_FP_CONVERTED_FIELD                                           0x4665
#define mmDCP5_DCP_FP_CONVERTED_FIELD                                           0x4965
#define mmCUR_CONTROL                                                           0x1a66
#define mmDCP0_CUR_CONTROL                                                      0x1a66
#define mmDCP1_CUR_CONTROL                                                      0x1d66
#define mmDCP2_CUR_CONTROL                                                      0x4066
#define mmDCP3_CUR_CONTROL                                                      0x4366
#define mmDCP4_CUR_CONTROL                                                      0x4666
#define mmDCP5_CUR_CONTROL                                                      0x4966
#define mmCUR_SURFACE_ADDRESS                                                   0x1a67
#define mmDCP0_CUR_SURFACE_ADDRESS                                              0x1a67
#define mmDCP1_CUR_SURFACE_ADDRESS                                              0x1d67
#define mmDCP2_CUR_SURFACE_ADDRESS                                              0x4067
#define mmDCP3_CUR_SURFACE_ADDRESS                                              0x4367
#define mmDCP4_CUR_SURFACE_ADDRESS                                              0x4667
#define mmDCP5_CUR_SURFACE_ADDRESS                                              0x4967
#define mmCUR_SIZE                                                              0x1a68
#define mmDCP0_CUR_SIZE                                                         0x1a68
#define mmDCP1_CUR_SIZE                                                         0x1d68
#define mmDCP2_CUR_SIZE                                                         0x4068
#define mmDCP3_CUR_SIZE                                                         0x4368
#define mmDCP4_CUR_SIZE                                                         0x4668
#define mmDCP5_CUR_SIZE                                                         0x4968
#define mmCUR_SURFACE_ADDRESS_HIGH                                              0x1a69
#define mmDCP0_CUR_SURFACE_ADDRESS_HIGH                                         0x1a69
#define mmDCP1_CUR_SURFACE_ADDRESS_HIGH                                         0x1d69
#define mmDCP2_CUR_SURFACE_ADDRESS_HIGH                                         0x4069
#define mmDCP3_CUR_SURFACE_ADDRESS_HIGH                                         0x4369
#define mmDCP4_CUR_SURFACE_ADDRESS_HIGH                                         0x4669
#define mmDCP5_CUR_SURFACE_ADDRESS_HIGH                                         0x4969
#define mmCUR_POSITION                                                          0x1a6a
#define mmDCP0_CUR_POSITION                                                     0x1a6a
#define mmDCP1_CUR_POSITION                                                     0x1d6a
#define mmDCP2_CUR_POSITION                                                     0x406a
#define mmDCP3_CUR_POSITION                                                     0x436a
#define mmDCP4_CUR_POSITION                                                     0x466a
#define mmDCP5_CUR_POSITION                                                     0x496a
#define mmCUR_HOT_SPOT                                                          0x1a6b
#define mmDCP0_CUR_HOT_SPOT                                                     0x1a6b
#define mmDCP1_CUR_HOT_SPOT                                                     0x1d6b
#define mmDCP2_CUR_HOT_SPOT                                                     0x406b
#define mmDCP3_CUR_HOT_SPOT                                                     0x436b
#define mmDCP4_CUR_HOT_SPOT                                                     0x466b
#define mmDCP5_CUR_HOT_SPOT                                                     0x496b
#define mmCUR_COLOR1                                                            0x1a6c
#define mmDCP0_CUR_COLOR1                                                       0x1a6c
#define mmDCP1_CUR_COLOR1                                                       0x1d6c
#define mmDCP2_CUR_COLOR1                                                       0x406c
#define mmDCP3_CUR_COLOR1                                                       0x436c
#define mmDCP4_CUR_COLOR1                                                       0x466c
#define mmDCP5_CUR_COLOR1                                                       0x496c
#define mmCUR_COLOR2                                                            0x1a6d
#define mmDCP0_CUR_COLOR2                                                       0x1a6d
#define mmDCP1_CUR_COLOR2                                                       0x1d6d
#define mmDCP2_CUR_COLOR2                                                       0x406d
#define mmDCP3_CUR_COLOR2                                                       0x436d
#define mmDCP4_CUR_COLOR2                                                       0x466d
#define mmDCP5_CUR_COLOR2                                                       0x496d
#define mmCUR_UPDATE                                                            0x1a6e
#define mmDCP0_CUR_UPDATE                                                       0x1a6e
#define mmDCP1_CUR_UPDATE                                                       0x1d6e
#define mmDCP2_CUR_UPDATE                                                       0x406e
#define mmDCP3_CUR_UPDATE                                                       0x436e
#define mmDCP4_CUR_UPDATE                                                       0x466e
#define mmDCP5_CUR_UPDATE                                                       0x496e
#define mmCUR2_CONTROL                                                          0x1a6f
#define mmDCP0_CUR2_CONTROL                                                     0x1a6f
#define mmDCP1_CUR2_CONTROL                                                     0x1d6f
#define mmDCP2_CUR2_CONTROL                                                     0x406f
#define mmDCP3_CUR2_CONTROL                                                     0x436f
#define mmDCP4_CUR2_CONTROL                                                     0x466f
#define mmDCP5_CUR2_CONTROL                                                     0x496f
#define mmCUR2_SURFACE_ADDRESS                                                  0x1a70
#define mmDCP0_CUR2_SURFACE_ADDRESS                                             0x1a70
#define mmDCP1_CUR2_SURFACE_ADDRESS                                             0x1d70
#define mmDCP2_CUR2_SURFACE_ADDRESS                                             0x4070
#define mmDCP3_CUR2_SURFACE_ADDRESS                                             0x4370
#define mmDCP4_CUR2_SURFACE_ADDRESS                                             0x4670
#define mmDCP5_CUR2_SURFACE_ADDRESS                                             0x4970
#define mmCUR2_SIZE                                                             0x1a71
#define mmDCP0_CUR2_SIZE                                                        0x1a71
#define mmDCP1_CUR2_SIZE                                                        0x1d71
#define mmDCP2_CUR2_SIZE                                                        0x4071
#define mmDCP3_CUR2_SIZE                                                        0x4371
#define mmDCP4_CUR2_SIZE                                                        0x4671
#define mmDCP5_CUR2_SIZE                                                        0x4971
#define mmCUR2_SURFACE_ADDRESS_HIGH                                             0x1a72
#define mmDCP0_CUR2_SURFACE_ADDRESS_HIGH                                        0x1a72
#define mmDCP1_CUR2_SURFACE_ADDRESS_HIGH                                        0x1d72
#define mmDCP2_CUR2_SURFACE_ADDRESS_HIGH                                        0x4072
#define mmDCP3_CUR2_SURFACE_ADDRESS_HIGH                                        0x4372
#define mmDCP4_CUR2_SURFACE_ADDRESS_HIGH                                        0x4672
#define mmDCP5_CUR2_SURFACE_ADDRESS_HIGH                                        0x4972
#define mmCUR2_POSITION                                                         0x1a73
#define mmDCP0_CUR2_POSITION                                                    0x1a73
#define mmDCP1_CUR2_POSITION                                                    0x1d73
#define mmDCP2_CUR2_POSITION                                                    0x4073
#define mmDCP3_CUR2_POSITION                                                    0x4373
#define mmDCP4_CUR2_POSITION                                                    0x4673
#define mmDCP5_CUR2_POSITION                                                    0x4973
#define mmCUR2_HOT_SPOT                                                         0x1a74
#define mmDCP0_CUR2_HOT_SPOT                                                    0x1a74
#define mmDCP1_CUR2_HOT_SPOT                                                    0x1d74
#define mmDCP2_CUR2_HOT_SPOT                                                    0x4074
#define mmDCP3_CUR2_HOT_SPOT                                                    0x4374
#define mmDCP4_CUR2_HOT_SPOT                                                    0x4674
#define mmDCP5_CUR2_HOT_SPOT                                                    0x4974
#define mmCUR2_COLOR1                                                           0x1a75
#define mmDCP0_CUR2_COLOR1                                                      0x1a75
#define mmDCP1_CUR2_COLOR1                                                      0x1d75
#define mmDCP2_CUR2_COLOR1                                                      0x4075
#define mmDCP3_CUR2_COLOR1                                                      0x4375
#define mmDCP4_CUR2_COLOR1                                                      0x4675
#define mmDCP5_CUR2_COLOR1                                                      0x4975
#define mmCUR2_COLOR2                                                           0x1a76
#define mmDCP0_CUR2_COLOR2                                                      0x1a76
#define mmDCP1_CUR2_COLOR2                                                      0x1d76
#define mmDCP2_CUR2_COLOR2                                                      0x4076
#define mmDCP3_CUR2_COLOR2                                                      0x4376
#define mmDCP4_CUR2_COLOR2                                                      0x4676
#define mmDCP5_CUR2_COLOR2                                                      0x4976
#define mmCUR2_UPDATE                                                           0x1a77
#define mmDCP0_CUR2_UPDATE                                                      0x1a77
#define mmDCP1_CUR2_UPDATE                                                      0x1d77
#define mmDCP2_CUR2_UPDATE                                                      0x4077
#define mmDCP3_CUR2_UPDATE                                                      0x4377
#define mmDCP4_CUR2_UPDATE                                                      0x4677
#define mmDCP5_CUR2_UPDATE                                                      0x4977
#define mmCUR_REQUEST_FILTER_CNTL                                               0x1a99
#define mmDCP0_CUR_REQUEST_FILTER_CNTL                                          0x1a99
#define mmDCP1_CUR_REQUEST_FILTER_CNTL                                          0x1d99
#define mmDCP2_CUR_REQUEST_FILTER_CNTL                                          0x4099
#define mmDCP3_CUR_REQUEST_FILTER_CNTL                                          0x4399
#define mmDCP4_CUR_REQUEST_FILTER_CNTL                                          0x4699
#define mmDCP5_CUR_REQUEST_FILTER_CNTL                                          0x4999
#define mmCUR_STEREO_CONTROL                                                    0x1a9a
#define mmDCP0_CUR_STEREO_CONTROL                                               0x1a9a
#define mmDCP1_CUR_STEREO_CONTROL                                               0x1d9a
#define mmDCP2_CUR_STEREO_CONTROL                                               0x409a
#define mmDCP3_CUR_STEREO_CONTROL                                               0x439a
#define mmDCP4_CUR_STEREO_CONTROL                                               0x469a
#define mmDCP5_CUR_STEREO_CONTROL                                               0x499a
#define mmCUR2_STEREO_CONTROL                                                   0x1a9b
#define mmDCP0_CUR2_STEREO_CONTROL                                              0x1a9b
#define mmDCP1_CUR2_STEREO_CONTROL                                              0x1d9b
#define mmDCP2_CUR2_STEREO_CONTROL                                              0x409b
#define mmDCP3_CUR2_STEREO_CONTROL                                              0x439b
#define mmDCP4_CUR2_STEREO_CONTROL                                              0x469b
#define mmDCP5_CUR2_STEREO_CONTROL                                              0x499b
#define mmDC_LUT_RW_MODE                                                        0x1a78
#define mmDCP0_DC_LUT_RW_MODE                                                   0x1a78
#define mmDCP1_DC_LUT_RW_MODE                                                   0x1d78
#define mmDCP2_DC_LUT_RW_MODE                                                   0x4078
#define mmDCP3_DC_LUT_RW_MODE                                                   0x4378
#define mmDCP4_DC_LUT_RW_MODE                                                   0x4678
#define mmDCP5_DC_LUT_RW_MODE                                                   0x4978
#define mmDC_LUT_RW_INDEX                                                       0x1a79
#define mmDCP0_DC_LUT_RW_INDEX                                                  0x1a79
#define mmDCP1_DC_LUT_RW_INDEX                                                  0x1d79
#define mmDCP2_DC_LUT_RW_INDEX                                                  0x4079
#define mmDCP3_DC_LUT_RW_INDEX                                                  0x4379
#define mmDCP4_DC_LUT_RW_INDEX                                                  0x4679
#define mmDCP5_DC_LUT_RW_INDEX                                                  0x4979
#define mmDC_LUT_SEQ_COLOR                                                      0x1a7a
#define mmDCP0_DC_LUT_SEQ_COLOR                                                 0x1a7a
#define mmDCP1_DC_LUT_SEQ_COLOR                                                 0x1d7a
#define mmDCP2_DC_LUT_SEQ_COLOR                                                 0x407a
#define mmDCP3_DC_LUT_SEQ_COLOR                                                 0x437a
#define mmDCP4_DC_LUT_SEQ_COLOR                                                 0x467a
#define mmDCP5_DC_LUT_SEQ_COLOR                                                 0x497a
#define mmDC_LUT_PWL_DATA                                                       0x1a7b
#define mmDCP0_DC_LUT_PWL_DATA                                                  0x1a7b
#define mmDCP1_DC_LUT_PWL_DATA                                                  0x1d7b
#define mmDCP2_DC_LUT_PWL_DATA                                                  0x407b
#define mmDCP3_DC_LUT_PWL_DATA                                                  0x437b
#define mmDCP4_DC_LUT_PWL_DATA                                                  0x467b
#define mmDCP5_DC_LUT_PWL_DATA                                                  0x497b
#define mmDC_LUT_30_COLOR                                                       0x1a7c
#define mmDCP0_DC_LUT_30_COLOR                                                  0x1a7c
#define mmDCP1_DC_LUT_30_COLOR                                                  0x1d7c
#define mmDCP2_DC_LUT_30_COLOR                                                  0x407c
#define mmDCP3_DC_LUT_30_COLOR                                                  0x437c
#define mmDCP4_DC_LUT_30_COLOR                                                  0x467c
#define mmDCP5_DC_LUT_30_COLOR                                                  0x497c
#define mmDC_LUT_VGA_ACCESS_ENABLE                                              0x1a7d
#define mmDCP0_DC_LUT_VGA_ACCESS_ENABLE                                         0x1a7d
#define mmDCP1_DC_LUT_VGA_ACCESS_ENABLE                                         0x1d7d
#define mmDCP2_DC_LUT_VGA_ACCESS_ENABLE                                         0x407d
#define mmDCP3_DC_LUT_VGA_ACCESS_ENABLE                                         0x437d
#define mmDCP4_DC_LUT_VGA_ACCESS_ENABLE                                         0x467d
#define mmDCP5_DC_LUT_VGA_ACCESS_ENABLE                                         0x497d
#define mmDC_LUT_WRITE_EN_MASK                                                  0x1a7e
#define mmDCP0_DC_LUT_WRITE_EN_MASK                                             0x1a7e
#define mmDCP1_DC_LUT_WRITE_EN_MASK                                             0x1d7e
#define mmDCP2_DC_LUT_WRITE_EN_MASK                                             0x407e
#define mmDCP3_DC_LUT_WRITE_EN_MASK                                             0x437e
#define mmDCP4_DC_LUT_WRITE_EN_MASK                                             0x467e
#define mmDCP5_DC_LUT_WRITE_EN_MASK                                             0x497e
#define mmDC_LUT_AUTOFILL                                                       0x1a7f
#define mmDCP0_DC_LUT_AUTOFILL                                                  0x1a7f
#define mmDCP1_DC_LUT_AUTOFILL                                                  0x1d7f
#define mmDCP2_DC_LUT_AUTOFILL                                                  0x407f
#define mmDCP3_DC_LUT_AUTOFILL                                                  0x437f
#define mmDCP4_DC_LUT_AUTOFILL                                                  0x467f
#define mmDCP5_DC_LUT_AUTOFILL                                                  0x497f
#define mmDC_LUT_CONTROL                                                        0x1a80
#define mmDCP0_DC_LUT_CONTROL                                                   0x1a80
#define mmDCP1_DC_LUT_CONTROL                                                   0x1d80
#define mmDCP2_DC_LUT_CONTROL                                                   0x4080
#define mmDCP3_DC_LUT_CONTROL                                                   0x4380
#define mmDCP4_DC_LUT_CONTROL                                                   0x4680
#define mmDCP5_DC_LUT_CONTROL                                                   0x4980
#define mmDC_LUT_BLACK_OFFSET_BLUE                                              0x1a81
#define mmDCP0_DC_LUT_BLACK_OFFSET_BLUE                                         0x1a81
#define mmDCP1_DC_LUT_BLACK_OFFSET_BLUE                                         0x1d81
#define mmDCP2_DC_LUT_BLACK_OFFSET_BLUE                                         0x4081
#define mmDCP3_DC_LUT_BLACK_OFFSET_BLUE                                         0x4381
#define mmDCP4_DC_LUT_BLACK_OFFSET_BLUE                                         0x4681
#define mmDCP5_DC_LUT_BLACK_OFFSET_BLUE                                         0x4981
#define mmDC_LUT_BLACK_OFFSET_GREEN                                             0x1a82
#define mmDCP0_DC_LUT_BLACK_OFFSET_GREEN                                        0x1a82
#define mmDCP1_DC_LUT_BLACK_OFFSET_GREEN                                        0x1d82
#define mmDCP2_DC_LUT_BLACK_OFFSET_GREEN                                        0x4082
#define mmDCP3_DC_LUT_BLACK_OFFSET_GREEN                                        0x4382
#define mmDCP4_DC_LUT_BLACK_OFFSET_GREEN                                        0x4682
#define mmDCP5_DC_LUT_BLACK_OFFSET_GREEN                                        0x4982
#define mmDC_LUT_BLACK_OFFSET_RED                                               0x1a83
#define mmDCP0_DC_LUT_BLACK_OFFSET_RED                                          0x1a83
#define mmDCP1_DC_LUT_BLACK_OFFSET_RED                                          0x1d83
#define mmDCP2_DC_LUT_BLACK_OFFSET_RED                                          0x4083
#define mmDCP3_DC_LUT_BLACK_OFFSET_RED                                          0x4383
#define mmDCP4_DC_LUT_BLACK_OFFSET_RED                                          0x4683
#define mmDCP5_DC_LUT_BLACK_OFFSET_RED                                          0x4983
#define mmDC_LUT_WHITE_OFFSET_BLUE                                              0x1a84
#define mmDCP0_DC_LUT_WHITE_OFFSET_BLUE                                         0x1a84
#define mmDCP1_DC_LUT_WHITE_OFFSET_BLUE                                         0x1d84
#define mmDCP2_DC_LUT_WHITE_OFFSET_BLUE                                         0x4084
#define mmDCP3_DC_LUT_WHITE_OFFSET_BLUE                                         0x4384
#define mmDCP4_DC_LUT_WHITE_OFFSET_BLUE                                         0x4684
#define mmDCP5_DC_LUT_WHITE_OFFSET_BLUE                                         0x4984
#define mmDC_LUT_WHITE_OFFSET_GREEN                                             0x1a85
#define mmDCP0_DC_LUT_WHITE_OFFSET_GREEN                                        0x1a85
#define mmDCP1_DC_LUT_WHITE_OFFSET_GREEN                                        0x1d85
#define mmDCP2_DC_LUT_WHITE_OFFSET_GREEN                                        0x4085
#define mmDCP3_DC_LUT_WHITE_OFFSET_GREEN                                        0x4385
#define mmDCP4_DC_LUT_WHITE_OFFSET_GREEN                                        0x4685
#define mmDCP5_DC_LUT_WHITE_OFFSET_GREEN                                        0x4985
#define mmDC_LUT_WHITE_OFFSET_RED                                               0x1a86
#define mmDCP0_DC_LUT_WHITE_OFFSET_RED                                          0x1a86
#define mmDCP1_DC_LUT_WHITE_OFFSET_RED                                          0x1d86
#define mmDCP2_DC_LUT_WHITE_OFFSET_RED                                          0x4086
#define mmDCP3_DC_LUT_WHITE_OFFSET_RED                                          0x4386
#define mmDCP4_DC_LUT_WHITE_OFFSET_RED                                          0x4686
#define mmDCP5_DC_LUT_WHITE_OFFSET_RED                                          0x4986
#define mmDCP_CRC_CONTROL                                                       0x1a87
#define mmDCP0_DCP_CRC_CONTROL                                                  0x1a87
#define mmDCP1_DCP_CRC_CONTROL                                                  0x1d87
#define mmDCP2_DCP_CRC_CONTROL                                                  0x4087
#define mmDCP3_DCP_CRC_CONTROL                                                  0x4387
#define mmDCP4_DCP_CRC_CONTROL                                                  0x4687
#define mmDCP5_DCP_CRC_CONTROL                                                  0x4987
#define mmDCP_CRC_MASK                                                          0x1a88
#define mmDCP0_DCP_CRC_MASK                                                     0x1a88
#define mmDCP1_DCP_CRC_MASK                                                     0x1d88
#define mmDCP2_DCP_CRC_MASK                                                     0x4088
#define mmDCP3_DCP_CRC_MASK                                                     0x4388
#define mmDCP4_DCP_CRC_MASK                                                     0x4688
#define mmDCP5_DCP_CRC_MASK                                                     0x4988
#define mmDCP_CRC_CURRENT                                                       0x1a89
#define mmDCP0_DCP_CRC_CURRENT                                                  0x1a89
#define mmDCP1_DCP_CRC_CURRENT                                                  0x1d89
#define mmDCP2_DCP_CRC_CURRENT                                                  0x4089
#define mmDCP3_DCP_CRC_CURRENT                                                  0x4389
#define mmDCP4_DCP_CRC_CURRENT                                                  0x4689
#define mmDCP5_DCP_CRC_CURRENT                                                  0x4989
#define mmDCP_CRC_LAST                                                          0x1a8b
#define mmDCP0_DCP_CRC_LAST                                                     0x1a8b
#define mmDCP1_DCP_CRC_LAST                                                     0x1d8b
#define mmDCP2_DCP_CRC_LAST                                                     0x408b
#define mmDCP3_DCP_CRC_LAST                                                     0x438b
#define mmDCP4_DCP_CRC_LAST                                                     0x468b
#define mmDCP5_DCP_CRC_LAST                                                     0x498b
#define mmDCP_DEBUG                                                             0x1a8d
#define mmDCP0_DCP_DEBUG                                                        0x1a8d
#define mmDCP1_DCP_DEBUG                                                        0x1d8d
#define mmDCP2_DCP_DEBUG                                                        0x408d
#define mmDCP3_DCP_DEBUG                                                        0x438d
#define mmDCP4_DCP_DEBUG                                                        0x468d
#define mmDCP5_DCP_DEBUG                                                        0x498d
#define mmGRPH_FLIP_RATE_CNTL                                                   0x1a8e
#define mmDCP0_GRPH_FLIP_RATE_CNTL                                              0x1a8e
#define mmDCP1_GRPH_FLIP_RATE_CNTL                                              0x1d8e
#define mmDCP2_GRPH_FLIP_RATE_CNTL                                              0x408e
#define mmDCP3_GRPH_FLIP_RATE_CNTL                                              0x438e
#define mmDCP4_GRPH_FLIP_RATE_CNTL                                              0x468e
#define mmDCP5_GRPH_FLIP_RATE_CNTL                                              0x498e
#define mmDCP_GSL_CONTROL                                                       0x1a90
#define mmDCP0_DCP_GSL_CONTROL                                                  0x1a90
#define mmDCP1_DCP_GSL_CONTROL                                                  0x1d90
#define mmDCP2_DCP_GSL_CONTROL                                                  0x4090
#define mmDCP3_DCP_GSL_CONTROL                                                  0x4390
#define mmDCP4_DCP_GSL_CONTROL                                                  0x4690
#define mmDCP5_DCP_GSL_CONTROL                                                  0x4990
#define mmDCP_LB_DATA_GAP_BETWEEN_CHUNK                                         0x1a91
#define mmDCP0_DCP_LB_DATA_GAP_BETWEEN_CHUNK                                    0x1a91
#define mmDCP1_DCP_LB_DATA_GAP_BETWEEN_CHUNK                                    0x1d91
#define mmDCP2_DCP_LB_DATA_GAP_BETWEEN_CHUNK                                    0x4091
#define mmDCP3_DCP_LB_DATA_GAP_BETWEEN_CHUNK                                    0x4391
#define mmDCP4_DCP_LB_DATA_GAP_BETWEEN_CHUNK                                    0x4691
#define mmDCP5_DCP_LB_DATA_GAP_BETWEEN_CHUNK                                    0x4991
#define mmOVL_SECONDARY_SURFACE_ADDRESS                                         0x1a92
#define mmDCP0_OVL_SECONDARY_SURFACE_ADDRESS                                    0x1a92
#define mmDCP1_OVL_SECONDARY_SURFACE_ADDRESS                                    0x1d92
#define mmDCP2_OVL_SECONDARY_SURFACE_ADDRESS                                    0x4092
#define mmDCP3_OVL_SECONDARY_SURFACE_ADDRESS                                    0x4392
#define mmDCP4_OVL_SECONDARY_SURFACE_ADDRESS                                    0x4692
#define mmDCP5_OVL_SECONDARY_SURFACE_ADDRESS                                    0x4992
#define mmOVL_STEREOSYNC_FLIP                                                   0x1a93
#define mmDCP0_OVL_STEREOSYNC_FLIP                                              0x1a93
#define mmDCP1_OVL_STEREOSYNC_FLIP                                              0x1d93
#define mmDCP2_OVL_STEREOSYNC_FLIP                                              0x4093
#define mmDCP3_OVL_STEREOSYNC_FLIP                                              0x4393
#define mmDCP4_OVL_STEREOSYNC_FLIP                                              0x4693
#define mmDCP5_OVL_STEREOSYNC_FLIP                                              0x4993
#define mmOVL_SECONDARY_SURFACE_ADDRESS_HIGH                                    0x1a94
#define mmDCP0_OVL_SECONDARY_SURFACE_ADDRESS_HIGH                               0x1a94
#define mmDCP1_OVL_SECONDARY_SURFACE_ADDRESS_HIGH                               0x1d94
#define mmDCP2_OVL_SECONDARY_SURFACE_ADDRESS_HIGH                               0x4094
#define mmDCP3_OVL_SECONDARY_SURFACE_ADDRESS_HIGH                               0x4394
#define mmDCP4_OVL_SECONDARY_SURFACE_ADDRESS_HIGH                               0x4694
#define mmDCP5_OVL_SECONDARY_SURFACE_ADDRESS_HIGH                               0x4994
#define mmDCP_TEST_DEBUG_INDEX                                                  0x1a95
#define mmDCP0_DCP_TEST_DEBUG_INDEX                                             0x1a95
#define mmDCP1_DCP_TEST_DEBUG_INDEX                                             0x1d95
#define mmDCP2_DCP_TEST_DEBUG_INDEX                                             0x4095
#define mmDCP3_DCP_TEST_DEBUG_INDEX                                             0x4395
#define mmDCP4_DCP_TEST_DEBUG_INDEX                                             0x4695
#define mmDCP5_DCP_TEST_DEBUG_INDEX                                             0x4995
#define mmDCP_TEST_DEBUG_DATA                                                   0x1a96
#define mmDCP0_DCP_TEST_DEBUG_DATA                                              0x1a96
#define mmDCP1_DCP_TEST_DEBUG_DATA                                              0x1d96
#define mmDCP2_DCP_TEST_DEBUG_DATA                                              0x4096
#define mmDCP3_DCP_TEST_DEBUG_DATA                                              0x4396
#define mmDCP4_DCP_TEST_DEBUG_DATA                                              0x4696
#define mmDCP5_DCP_TEST_DEBUG_DATA                                              0x4996
#define mmGRPH_STEREOSYNC_FLIP                                                  0x1a97
#define mmDCP0_GRPH_STEREOSYNC_FLIP                                             0x1a97
#define mmDCP1_GRPH_STEREOSYNC_FLIP                                             0x1d97
#define mmDCP2_GRPH_STEREOSYNC_FLIP                                             0x4097
#define mmDCP3_GRPH_STEREOSYNC_FLIP                                             0x4397
#define mmDCP4_GRPH_STEREOSYNC_FLIP                                             0x4697
#define mmDCP5_GRPH_STEREOSYNC_FLIP                                             0x4997
#define mmDCP_DEBUG2                                                            0x1a98
#define mmDCP0_DCP_DEBUG2                                                       0x1a98
#define mmDCP1_DCP_DEBUG2                                                       0x1d98
#define mmDCP2_DCP_DEBUG2                                                       0x4098
#define mmDCP3_DCP_DEBUG2                                                       0x4398
#define mmDCP4_DCP_DEBUG2                                                       0x4698
#define mmDCP5_DCP_DEBUG2                                                       0x4998
#define mmHW_ROTATION                                                           0x1a9e
#define mmDCP0_HW_ROTATION                                                      0x1a9e
#define mmDCP1_HW_ROTATION                                                      0x1d9e
#define mmDCP2_HW_ROTATION                                                      0x409e
#define mmDCP3_HW_ROTATION                                                      0x439e
#define mmDCP4_HW_ROTATION                                                      0x469e
#define mmDCP5_HW_ROTATION                                                      0x499e
#define mmGRPH_XDMA_CACHE_UNDERFLOW_DET_CNTL                                    0x1a9f
#define mmDCP0_GRPH_XDMA_CACHE_UNDERFLOW_DET_CNTL                               0x1a9f
#define mmDCP1_GRPH_XDMA_CACHE_UNDERFLOW_DET_CNTL                               0x1d9f
#define mmDCP2_GRPH_XDMA_CACHE_UNDERFLOW_DET_CNTL                               0x409f
#define mmDCP3_GRPH_XDMA_CACHE_UNDERFLOW_DET_CNTL                               0x439f
#define mmDCP4_GRPH_XDMA_CACHE_UNDERFLOW_DET_CNTL                               0x469f
#define mmDCP5_GRPH_XDMA_CACHE_UNDERFLOW_DET_CNTL                               0x499f
#define mmREGAMMA_CONTROL                                                       0x1aa0
#define mmDCP0_REGAMMA_CONTROL                                                  0x1aa0
#define mmDCP1_REGAMMA_CONTROL                                                  0x1da0
#define mmDCP2_REGAMMA_CONTROL                                                  0x40a0
#define mmDCP3_REGAMMA_CONTROL                                                  0x43a0
#define mmDCP4_REGAMMA_CONTROL                                                  0x46a0
#define mmDCP5_REGAMMA_CONTROL                                                  0x49a0
#define mmREGAMMA_LUT_INDEX                                                     0x1aa1
#define mmDCP0_REGAMMA_LUT_INDEX                                                0x1aa1
#define mmDCP1_REGAMMA_LUT_INDEX                                                0x1da1
#define mmDCP2_REGAMMA_LUT_INDEX                                                0x40a1
#define mmDCP3_REGAMMA_LUT_INDEX                                                0x43a1
#define mmDCP4_REGAMMA_LUT_INDEX                                                0x46a1
#define mmDCP5_REGAMMA_LUT_INDEX                                                0x49a1
#define mmREGAMMA_LUT_DATA                                                      0x1aa2
#define mmDCP0_REGAMMA_LUT_DATA                                                 0x1aa2
#define mmDCP1_REGAMMA_LUT_DATA                                                 0x1da2
#define mmDCP2_REGAMMA_LUT_DATA                                                 0x40a2
#define mmDCP3_REGAMMA_LUT_DATA                                                 0x43a2
#define mmDCP4_REGAMMA_LUT_DATA                                                 0x46a2
#define mmDCP5_REGAMMA_LUT_DATA                                                 0x49a2
#define mmREGAMMA_LUT_WRITE_EN_MASK                                             0x1aa3
#define mmDCP0_REGAMMA_LUT_WRITE_EN_MASK                                        0x1aa3
#define mmDCP1_REGAMMA_LUT_WRITE_EN_MASK                                        0x1da3
#define mmDCP2_REGAMMA_LUT_WRITE_EN_MASK                                        0x40a3
#define mmDCP3_REGAMMA_LUT_WRITE_EN_MASK                                        0x43a3
#define mmDCP4_REGAMMA_LUT_WRITE_EN_MASK                                        0x46a3
#define mmDCP5_REGAMMA_LUT_WRITE_EN_MASK                                        0x49a3
#define mmREGAMMA_CNTLA_START_CNTL                                              0x1aa4
#define mmDCP0_REGAMMA_CNTLA_START_CNTL                                         0x1aa4
#define mmDCP1_REGAMMA_CNTLA_START_CNTL                                         0x1da4
#define mmDCP2_REGAMMA_CNTLA_START_CNTL                                         0x40a4
#define mmDCP3_REGAMMA_CNTLA_START_CNTL                                         0x43a4
#define mmDCP4_REGAMMA_CNTLA_START_CNTL                                         0x46a4
#define mmDCP5_REGAMMA_CNTLA_START_CNTL                                         0x49a4
#define mmREGAMMA_CNTLA_SLOPE_CNTL                                              0x1aa5
#define mmDCP0_REGAMMA_CNTLA_SLOPE_CNTL                                         0x1aa5
#define mmDCP1_REGAMMA_CNTLA_SLOPE_CNTL                                         0x1da5
#define mmDCP2_REGAMMA_CNTLA_SLOPE_CNTL                                         0x40a5
#define mmDCP3_REGAMMA_CNTLA_SLOPE_CNTL                                         0x43a5
#define mmDCP4_REGAMMA_CNTLA_SLOPE_CNTL                                         0x46a5
#define mmDCP5_REGAMMA_CNTLA_SLOPE_CNTL                                         0x49a5
#define mmREGAMMA_CNTLA_END_CNTL1                                               0x1aa6
#define mmDCP0_REGAMMA_CNTLA_END_CNTL1                                          0x1aa6
#define mmDCP1_REGAMMA_CNTLA_END_CNTL1                                          0x1da6
#define mmDCP2_REGAMMA_CNTLA_END_CNTL1                                          0x40a6
#define mmDCP3_REGAMMA_CNTLA_END_CNTL1                                          0x43a6
#define mmDCP4_REGAMMA_CNTLA_END_CNTL1                                          0x46a6
#define mmDCP5_REGAMMA_CNTLA_END_CNTL1                                          0x49a6
#define mmREGAMMA_CNTLA_END_CNTL2                                               0x1aa7
#define mmDCP0_REGAMMA_CNTLA_END_CNTL2                                          0x1aa7
#define mmDCP1_REGAMMA_CNTLA_END_CNTL2                                          0x1da7
#define mmDCP2_REGAMMA_CNTLA_END_CNTL2                                          0x40a7
#define mmDCP3_REGAMMA_CNTLA_END_CNTL2                                          0x43a7
#define mmDCP4_REGAMMA_CNTLA_END_CNTL2                                          0x46a7
#define mmDCP5_REGAMMA_CNTLA_END_CNTL2                                          0x49a7
#define mmREGAMMA_CNTLA_REGION_0_1                                              0x1aa8
#define mmDCP0_REGAMMA_CNTLA_REGION_0_1                                         0x1aa8
#define mmDCP1_REGAMMA_CNTLA_REGION_0_1                                         0x1da8
#define mmDCP2_REGAMMA_CNTLA_REGION_0_1                                         0x40a8
#define mmDCP3_REGAMMA_CNTLA_REGION_0_1                                         0x43a8
#define mmDCP4_REGAMMA_CNTLA_REGION_0_1                                         0x46a8
#define mmDCP5_REGAMMA_CNTLA_REGION_0_1                                         0x49a8
#define mmREGAMMA_CNTLA_REGION_2_3                                              0x1aa9
#define mmDCP0_REGAMMA_CNTLA_REGION_2_3                                         0x1aa9
#define mmDCP1_REGAMMA_CNTLA_REGION_2_3                                         0x1da9
#define mmDCP2_REGAMMA_CNTLA_REGION_2_3                                         0x40a9
#define mmDCP3_REGAMMA_CNTLA_REGION_2_3                                         0x43a9
#define mmDCP4_REGAMMA_CNTLA_REGION_2_3                                         0x46a9
#define mmDCP5_REGAMMA_CNTLA_REGION_2_3                                         0x49a9
#define mmREGAMMA_CNTLA_REGION_4_5                                              0x1aaa
#define mmDCP0_REGAMMA_CNTLA_REGION_4_5                                         0x1aaa
#define mmDCP1_REGAMMA_CNTLA_REGION_4_5                                         0x1daa
#define mmDCP2_REGAMMA_CNTLA_REGION_4_5                                         0x40aa
#define mmDCP3_REGAMMA_CNTLA_REGION_4_5                                         0x43aa
#define mmDCP4_REGAMMA_CNTLA_REGION_4_5                                         0x46aa
#define mmDCP5_REGAMMA_CNTLA_REGION_4_5                                         0x49aa
#define mmREGAMMA_CNTLA_REGION_6_7                                              0x1aab
#define mmDCP0_REGAMMA_CNTLA_REGION_6_7                                         0x1aab
#define mmDCP1_REGAMMA_CNTLA_REGION_6_7                                         0x1dab
#define mmDCP2_REGAMMA_CNTLA_REGION_6_7                                         0x40ab
#define mmDCP3_REGAMMA_CNTLA_REGION_6_7                                         0x43ab
#define mmDCP4_REGAMMA_CNTLA_REGION_6_7                                         0x46ab
#define mmDCP5_REGAMMA_CNTLA_REGION_6_7                                         0x49ab
#define mmREGAMMA_CNTLA_REGION_8_9                                              0x1aac
#define mmDCP0_REGAMMA_CNTLA_REGION_8_9                                         0x1aac
#define mmDCP1_REGAMMA_CNTLA_REGION_8_9                                         0x1dac
#define mmDCP2_REGAMMA_CNTLA_REGION_8_9                                         0x40ac
#define mmDCP3_REGAMMA_CNTLA_REGION_8_9                                         0x43ac
#define mmDCP4_REGAMMA_CNTLA_REGION_8_9                                         0x46ac
#define mmDCP5_REGAMMA_CNTLA_REGION_8_9                                         0x49ac
#define mmREGAMMA_CNTLA_REGION_10_11                                            0x1aad
#define mmDCP0_REGAMMA_CNTLA_REGION_10_11                                       0x1aad
#define mmDCP1_REGAMMA_CNTLA_REGION_10_11                                       0x1dad
#define mmDCP2_REGAMMA_CNTLA_REGION_10_11                                       0x40ad
#define mmDCP3_REGAMMA_CNTLA_REGION_10_11                                       0x43ad
#define mmDCP4_REGAMMA_CNTLA_REGION_10_11                                       0x46ad
#define mmDCP5_REGAMMA_CNTLA_REGION_10_11                                       0x49ad
#define mmREGAMMA_CNTLA_REGION_12_13                                            0x1aae
#define mmDCP0_REGAMMA_CNTLA_REGION_12_13                                       0x1aae
#define mmDCP1_REGAMMA_CNTLA_REGION_12_13                                       0x1dae
#define mmDCP2_REGAMMA_CNTLA_REGION_12_13                                       0x40ae
#define mmDCP3_REGAMMA_CNTLA_REGION_12_13                                       0x43ae
#define mmDCP4_REGAMMA_CNTLA_REGION_12_13                                       0x46ae
#define mmDCP5_REGAMMA_CNTLA_REGION_12_13                                       0x49ae
#define mmREGAMMA_CNTLA_REGION_14_15                                            0x1aaf
#define mmDCP0_REGAMMA_CNTLA_REGION_14_15                                       0x1aaf
#define mmDCP1_REGAMMA_CNTLA_REGION_14_15                                       0x1daf
#define mmDCP2_REGAMMA_CNTLA_REGION_14_15                                       0x40af
#define mmDCP3_REGAMMA_CNTLA_REGION_14_15                                       0x43af
#define mmDCP4_REGAMMA_CNTLA_REGION_14_15                                       0x46af
#define mmDCP5_REGAMMA_CNTLA_REGION_14_15                                       0x49af
#define mmREGAMMA_CNTLB_START_CNTL                                              0x1ab0
#define mmDCP0_REGAMMA_CNTLB_START_CNTL                                         0x1ab0
#define mmDCP1_REGAMMA_CNTLB_START_CNTL                                         0x1db0
#define mmDCP2_REGAMMA_CNTLB_START_CNTL                                         0x40b0
#define mmDCP3_REGAMMA_CNTLB_START_CNTL                                         0x43b0
#define mmDCP4_REGAMMA_CNTLB_START_CNTL                                         0x46b0
#define mmDCP5_REGAMMA_CNTLB_START_CNTL                                         0x49b0
#define mmREGAMMA_CNTLB_SLOPE_CNTL                                              0x1ab1
#define mmDCP0_REGAMMA_CNTLB_SLOPE_CNTL                                         0x1ab1
#define mmDCP1_REGAMMA_CNTLB_SLOPE_CNTL                                         0x1db1
#define mmDCP2_REGAMMA_CNTLB_SLOPE_CNTL                                         0x40b1
#define mmDCP3_REGAMMA_CNTLB_SLOPE_CNTL                                         0x43b1
#define mmDCP4_REGAMMA_CNTLB_SLOPE_CNTL                                         0x46b1
#define mmDCP5_REGAMMA_CNTLB_SLOPE_CNTL                                         0x49b1
#define mmREGAMMA_CNTLB_END_CNTL1                                               0x1ab2
#define mmDCP0_REGAMMA_CNTLB_END_CNTL1                                          0x1ab2
#define mmDCP1_REGAMMA_CNTLB_END_CNTL1                                          0x1db2
#define mmDCP2_REGAMMA_CNTLB_END_CNTL1                                          0x40b2
#define mmDCP3_REGAMMA_CNTLB_END_CNTL1                                          0x43b2
#define mmDCP4_REGAMMA_CNTLB_END_CNTL1                                          0x46b2
#define mmDCP5_REGAMMA_CNTLB_END_CNTL1                                          0x49b2
#define mmREGAMMA_CNTLB_END_CNTL2                                               0x1ab3
#define mmDCP0_REGAMMA_CNTLB_END_CNTL2                                          0x1ab3
#define mmDCP1_REGAMMA_CNTLB_END_CNTL2                                          0x1db3
#define mmDCP2_REGAMMA_CNTLB_END_CNTL2                                          0x40b3
#define mmDCP3_REGAMMA_CNTLB_END_CNTL2                                          0x43b3
#define mmDCP4_REGAMMA_CNTLB_END_CNTL2                                          0x46b3
#define mmDCP5_REGAMMA_CNTLB_END_CNTL2                                          0x49b3
#define mmREGAMMA_CNTLB_REGION_0_1                                              0x1ab4
#define mmDCP0_REGAMMA_CNTLB_REGION_0_1                                         0x1ab4
#define mmDCP1_REGAMMA_CNTLB_REGION_0_1                                         0x1db4
#define mmDCP2_REGAMMA_CNTLB_REGION_0_1                                         0x40b4
#define mmDCP3_REGAMMA_CNTLB_REGION_0_1                                         0x43b4
#define mmDCP4_REGAMMA_CNTLB_REGION_0_1                                         0x46b4
#define mmDCP5_REGAMMA_CNTLB_REGION_0_1                                         0x49b4
#define mmREGAMMA_CNTLB_REGION_2_3                                              0x1ab5
#define mmDCP0_REGAMMA_CNTLB_REGION_2_3                                         0x1ab5
#define mmDCP1_REGAMMA_CNTLB_REGION_2_3                                         0x1db5
#define mmDCP2_REGAMMA_CNTLB_REGION_2_3                                         0x40b5
#define mmDCP3_REGAMMA_CNTLB_REGION_2_3                                         0x43b5
#define mmDCP4_REGAMMA_CNTLB_REGION_2_3                                         0x46b5
#define mmDCP5_REGAMMA_CNTLB_REGION_2_3                                         0x49b5
#define mmREGAMMA_CNTLB_REGION_4_5                                              0x1ab6
#define mmDCP0_REGAMMA_CNTLB_REGION_4_5                                         0x1ab6
#define mmDCP1_REGAMMA_CNTLB_REGION_4_5                                         0x1db6
#define mmDCP2_REGAMMA_CNTLB_REGION_4_5                                         0x40b6
#define mmDCP3_REGAMMA_CNTLB_REGION_4_5                                         0x43b6
#define mmDCP4_REGAMMA_CNTLB_REGION_4_5                                         0x46b6
#define mmDCP5_REGAMMA_CNTLB_REGION_4_5                                         0x49b6
#define mmREGAMMA_CNTLB_REGION_6_7                                              0x1ab7
#define mmDCP0_REGAMMA_CNTLB_REGION_6_7                                         0x1ab7
#define mmDCP1_REGAMMA_CNTLB_REGION_6_7                                         0x1db7
#define mmDCP2_REGAMMA_CNTLB_REGION_6_7                                         0x40b7
#define mmDCP3_REGAMMA_CNTLB_REGION_6_7                                         0x43b7
#define mmDCP4_REGAMMA_CNTLB_REGION_6_7                                         0x46b7
#define mmDCP5_REGAMMA_CNTLB_REGION_6_7                                         0x49b7
#define mmREGAMMA_CNTLB_REGION_8_9                                              0x1ab8
#define mmDCP0_REGAMMA_CNTLB_REGION_8_9                                         0x1ab8
#define mmDCP1_REGAMMA_CNTLB_REGION_8_9                                         0x1db8
#define mmDCP2_REGAMMA_CNTLB_REGION_8_9                                         0x40b8
#define mmDCP3_REGAMMA_CNTLB_REGION_8_9                                         0x43b8
#define mmDCP4_REGAMMA_CNTLB_REGION_8_9                                         0x46b8
#define mmDCP5_REGAMMA_CNTLB_REGION_8_9                                         0x49b8
#define mmREGAMMA_CNTLB_REGION_10_11                                            0x1ab9
#define mmDCP0_REGAMMA_CNTLB_REGION_10_11                                       0x1ab9
#define mmDCP1_REGAMMA_CNTLB_REGION_10_11                                       0x1db9
#define mmDCP2_REGAMMA_CNTLB_REGION_10_11                                       0x40b9
#define mmDCP3_REGAMMA_CNTLB_REGION_10_11                                       0x43b9
#define mmDCP4_REGAMMA_CNTLB_REGION_10_11                                       0x46b9
#define mmDCP5_REGAMMA_CNTLB_REGION_10_11                                       0x49b9
#define mmREGAMMA_CNTLB_REGION_12_13                                            0x1aba
#define mmDCP0_REGAMMA_CNTLB_REGION_12_13                                       0x1aba
#define mmDCP1_REGAMMA_CNTLB_REGION_12_13                                       0x1dba
#define mmDCP2_REGAMMA_CNTLB_REGION_12_13                                       0x40ba
#define mmDCP3_REGAMMA_CNTLB_REGION_12_13                                       0x43ba
#define mmDCP4_REGAMMA_CNTLB_REGION_12_13                                       0x46ba
#define mmDCP5_REGAMMA_CNTLB_REGION_12_13                                       0x49ba
#define mmREGAMMA_CNTLB_REGION_14_15                                            0x1abb
#define mmDCP0_REGAMMA_CNTLB_REGION_14_15                                       0x1abb
#define mmDCP1_REGAMMA_CNTLB_REGION_14_15                                       0x1dbb
#define mmDCP2_REGAMMA_CNTLB_REGION_14_15                                       0x40bb
#define mmDCP3_REGAMMA_CNTLB_REGION_14_15                                       0x43bb
#define mmDCP4_REGAMMA_CNTLB_REGION_14_15                                       0x46bb
#define mmDCP5_REGAMMA_CNTLB_REGION_14_15                                       0x49bb
#define mmALPHA_CONTROL                                                         0x1abc
#define mmDCP0_ALPHA_CONTROL                                                    0x1abc
#define mmDCP1_ALPHA_CONTROL                                                    0x1dbc
#define mmDCP2_ALPHA_CONTROL                                                    0x40bc
#define mmDCP3_ALPHA_CONTROL                                                    0x43bc
#define mmDCP4_ALPHA_CONTROL                                                    0x46bc
#define mmDCP5_ALPHA_CONTROL                                                    0x49bc
#define mmGRPH_XDMA_RECOVERY_SURFACE_ADDRESS                                    0x1abd
#define mmDCP0_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS                               0x1abd
#define mmDCP1_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS                               0x1dbd
#define mmDCP2_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS                               0x40bd
#define mmDCP3_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS                               0x43bd
#define mmDCP4_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS                               0x46bd
#define mmDCP5_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS                               0x49bd
#define mmGRPH_XDMA_RECOVERY_SURFACE_ADDRESS_HIGH                               0x1abe
#define mmDCP0_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS_HIGH                          0x1abe
#define mmDCP1_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS_HIGH                          0x1dbe
#define mmDCP2_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS_HIGH                          0x40be
#define mmDCP3_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS_HIGH                          0x43be
#define mmDCP4_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS_HIGH                          0x46be
#define mmDCP5_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS_HIGH                          0x49be
#define mmGRPH_XDMA_CACHE_UNDERFLOW_DET_STATUS                                  0x1abf
#define mmDCP0_GRPH_XDMA_CACHE_UNDERFLOW_DET_STATUS                             0x1abf
#define mmDCP1_GRPH_XDMA_CACHE_UNDERFLOW_DET_STATUS                             0x1dbf
#define mmDCP2_GRPH_XDMA_CACHE_UNDERFLOW_DET_STATUS                             0x40bf
#define mmDCP3_GRPH_XDMA_CACHE_UNDERFLOW_DET_STATUS                             0x43bf
#define mmDCP4_GRPH_XDMA_CACHE_UNDERFLOW_DET_STATUS                             0x46bf
#define mmDCP5_GRPH_XDMA_CACHE_UNDERFLOW_DET_STATUS                             0x49bf
#define mmDIG_FE_CNTL                                                           0x1c00
#define mmDIG0_DIG_FE_CNTL                                                      0x1c00
#define mmDIG1_DIG_FE_CNTL                                                      0x1f00
#define mmDIG2_DIG_FE_CNTL                                                      0x4200
#define mmDIG3_DIG_FE_CNTL                                                      0x4500
#define mmDIG4_DIG_FE_CNTL                                                      0x4800
#define mmDIG5_DIG_FE_CNTL                                                      0x4b00
#define mmDIG6_DIG_FE_CNTL                                                      0x4e00
#define mmDIG_OUTPUT_CRC_CNTL                                                   0x1c01
#define mmDIG0_DIG_OUTPUT_CRC_CNTL                                              0x1c01
#define mmDIG1_DIG_OUTPUT_CRC_CNTL                                              0x1f01
#define mmDIG2_DIG_OUTPUT_CRC_CNTL                                              0x4201
#define mmDIG3_DIG_OUTPUT_CRC_CNTL                                              0x4501
#define mmDIG4_DIG_OUTPUT_CRC_CNTL                                              0x4801
#define mmDIG5_DIG_OUTPUT_CRC_CNTL                                              0x4b01
#define mmDIG6_DIG_OUTPUT_CRC_CNTL                                              0x4e01
#define mmDIG_OUTPUT_CRC_RESULT                                                 0x1c02
#define mmDIG0_DIG_OUTPUT_CRC_RESULT                                            0x1c02
#define mmDIG1_DIG_OUTPUT_CRC_RESULT                                            0x1f02
#define mmDIG2_DIG_OUTPUT_CRC_RESULT                                            0x4202
#define mmDIG3_DIG_OUTPUT_CRC_RESULT                                            0x4502
#define mmDIG4_DIG_OUTPUT_CRC_RESULT                                            0x4802
#define mmDIG5_DIG_OUTPUT_CRC_RESULT                                            0x4b02
#define mmDIG6_DIG_OUTPUT_CRC_RESULT                                            0x4e02
#define mmDIG_CLOCK_PATTERN                                                     0x1c03
#define mmDIG0_DIG_CLOCK_PATTERN                                                0x1c03
#define mmDIG1_DIG_CLOCK_PATTERN                                                0x1f03
#define mmDIG2_DIG_CLOCK_PATTERN                                                0x4203
#define mmDIG3_DIG_CLOCK_PATTERN                                                0x4503
#define mmDIG4_DIG_CLOCK_PATTERN                                                0x4803
#define mmDIG5_DIG_CLOCK_PATTERN                                                0x4b03
#define mmDIG6_DIG_CLOCK_PATTERN                                                0x4e03
#define mmDIG_TEST_PATTERN                                                      0x1c04
#define mmDIG0_DIG_TEST_PATTERN                                                 0x1c04
#define mmDIG1_DIG_TEST_PATTERN                                                 0x1f04
#define mmDIG2_DIG_TEST_PATTERN                                                 0x4204
#define mmDIG3_DIG_TEST_PATTERN                                                 0x4504
#define mmDIG4_DIG_TEST_PATTERN                                                 0x4804
#define mmDIG5_DIG_TEST_PATTERN                                                 0x4b04
#define mmDIG6_DIG_TEST_PATTERN                                                 0x4e04
#define mmDIG_RANDOM_PATTERN_SEED                                               0x1c05
#define mmDIG0_DIG_RANDOM_PATTERN_SEED                                          0x1c05
#define mmDIG1_DIG_RANDOM_PATTERN_SEED                                          0x1f05
#define mmDIG2_DIG_RANDOM_PATTERN_SEED                                          0x4205
#define mmDIG3_DIG_RANDOM_PATTERN_SEED                                          0x4505
#define mmDIG4_DIG_RANDOM_PATTERN_SEED                                          0x4805
#define mmDIG5_DIG_RANDOM_PATTERN_SEED                                          0x4b05
#define mmDIG6_DIG_RANDOM_PATTERN_SEED                                          0x4e05
#define mmDIG_FIFO_STATUS                                                       0x1c0a
#define mmDIG0_DIG_FIFO_STATUS                                                  0x1c0a
#define mmDIG1_DIG_FIFO_STATUS                                                  0x1f0a
#define mmDIG2_DIG_FIFO_STATUS                                                  0x420a
#define mmDIG3_DIG_FIFO_STATUS                                                  0x450a
#define mmDIG4_DIG_FIFO_STATUS                                                  0x480a
#define mmDIG5_DIG_FIFO_STATUS                                                  0x4b0a
#define mmDIG6_DIG_FIFO_STATUS                                                  0x4e0a
#define mmDIG_DISPCLK_SWITCH_CNTL                                               0x1c08
#define mmDIG0_DIG_DISPCLK_SWITCH_CNTL                                          0x1c08
#define mmDIG1_DIG_DISPCLK_SWITCH_CNTL                                          0x1f08
#define mmDIG2_DIG_DISPCLK_SWITCH_CNTL                                          0x4208
#define mmDIG3_DIG_DISPCLK_SWITCH_CNTL                                          0x4508
#define mmDIG4_DIG_DISPCLK_SWITCH_CNTL                                          0x4808
#define mmDIG5_DIG_DISPCLK_SWITCH_CNTL                                          0x4b08
#define mmDIG6_DIG_DISPCLK_SWITCH_CNTL                                          0x4e08
#define mmDIG_DISPCLK_SWITCH_STATUS                                             0x1c09
#define mmDIG0_DIG_DISPCLK_SWITCH_STATUS                                        0x1c09
#define mmDIG1_DIG_DISPCLK_SWITCH_STATUS                                        0x1f09
#define mmDIG2_DIG_DISPCLK_SWITCH_STATUS                                        0x4209
#define mmDIG3_DIG_DISPCLK_SWITCH_STATUS                                        0x4509
#define mmDIG4_DIG_DISPCLK_SWITCH_STATUS                                        0x4809
#define mmDIG5_DIG_DISPCLK_SWITCH_STATUS                                        0x4b09
#define mmDIG6_DIG_DISPCLK_SWITCH_STATUS                                        0x4e09
#define mmHDMI_CONTROL                                                          0x1c0c
#define mmDIG0_HDMI_CONTROL                                                     0x1c0c
#define mmDIG1_HDMI_CONTROL                                                     0x1f0c
#define mmDIG2_HDMI_CONTROL                                                     0x420c
#define mmDIG3_HDMI_CONTROL                                                     0x450c
#define mmDIG4_HDMI_CONTROL                                                     0x480c
#define mmDIG5_HDMI_CONTROL                                                     0x4b0c
#define mmDIG6_HDMI_CONTROL                                                     0x4e0c
#define mmHDMI_STATUS                                                           0x1c0d
#define mmDIG0_HDMI_STATUS                                                      0x1c0d
#define mmDIG1_HDMI_STATUS                                                      0x1f0d
#define mmDIG2_HDMI_STATUS                                                      0x420d
#define mmDIG3_HDMI_STATUS                                                      0x450d
#define mmDIG4_HDMI_STATUS                                                      0x480d
#define mmDIG5_HDMI_STATUS                                                      0x4b0d
#define mmDIG6_HDMI_STATUS                                                      0x4e0d
#define mmHDMI_AUDIO_PACKET_CONTROL                                             0x1c0e
#define mmDIG0_HDMI_AUDIO_PACKET_CONTROL                                        0x1c0e
#define mmDIG1_HDMI_AUDIO_PACKET_CONTROL                                        0x1f0e
#define mmDIG2_HDMI_AUDIO_PACKET_CONTROL                                        0x420e
#define mmDIG3_HDMI_AUDIO_PACKET_CONTROL                                        0x450e
#define mmDIG4_HDMI_AUDIO_PACKET_CONTROL                                        0x480e
#define mmDIG5_HDMI_AUDIO_PACKET_CONTROL                                        0x4b0e
#define mmDIG6_HDMI_AUDIO_PACKET_CONTROL                                        0x4e0e
#define mmHDMI_ACR_PACKET_CONTROL                                               0x1c0f
#define mmDIG0_HDMI_ACR_PACKET_CONTROL                                          0x1c0f
#define mmDIG1_HDMI_ACR_PACKET_CONTROL                                          0x1f0f
#define mmDIG2_HDMI_ACR_PACKET_CONTROL                                          0x420f
#define mmDIG3_HDMI_ACR_PACKET_CONTROL                                          0x450f
#define mmDIG4_HDMI_ACR_PACKET_CONTROL                                          0x480f
#define mmDIG5_HDMI_ACR_PACKET_CONTROL                                          0x4b0f
#define mmDIG6_HDMI_ACR_PACKET_CONTROL                                          0x4e0f
#define mmHDMI_VBI_PACKET_CONTROL                                               0x1c10
#define mmDIG0_HDMI_VBI_PACKET_CONTROL                                          0x1c10
#define mmDIG1_HDMI_VBI_PACKET_CONTROL                                          0x1f10
#define mmDIG2_HDMI_VBI_PACKET_CONTROL                                          0x4210
#define mmDIG3_HDMI_VBI_PACKET_CONTROL                                          0x4510
#define mmDIG4_HDMI_VBI_PACKET_CONTROL                                          0x4810
#define mmDIG5_HDMI_VBI_PACKET_CONTROL                                          0x4b10
#define mmDIG6_HDMI_VBI_PACKET_CONTROL                                          0x4e10
#define mmHDMI_INFOFRAME_CONTROL0                                               0x1c11
#define mmDIG0_HDMI_INFOFRAME_CONTROL0                                          0x1c11
#define mmDIG1_HDMI_INFOFRAME_CONTROL0                                          0x1f11
#define mmDIG2_HDMI_INFOFRAME_CONTROL0                                          0x4211
#define mmDIG3_HDMI_INFOFRAME_CONTROL0                                          0x4511
#define mmDIG4_HDMI_INFOFRAME_CONTROL0                                          0x4811
#define mmDIG5_HDMI_INFOFRAME_CONTROL0                                          0x4b11
#define mmDIG6_HDMI_INFOFRAME_CONTROL0                                          0x4e11
#define mmHDMI_INFOFRAME_CONTROL1                                               0x1c12
#define mmDIG0_HDMI_INFOFRAME_CONTROL1                                          0x1c12
#define mmDIG1_HDMI_INFOFRAME_CONTROL1                                          0x1f12
#define mmDIG2_HDMI_INFOFRAME_CONTROL1                                          0x4212
#define mmDIG3_HDMI_INFOFRAME_CONTROL1                                          0x4512
#define mmDIG4_HDMI_INFOFRAME_CONTROL1                                          0x4812
#define mmDIG5_HDMI_INFOFRAME_CONTROL1                                          0x4b12
#define mmDIG6_HDMI_INFOFRAME_CONTROL1                                          0x4e12
#define mmHDMI_GENERIC_PACKET_CONTROL0                                          0x1c13
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL0                                     0x1c13
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL0                                     0x1f13
#define mmDIG2_HDMI_GENERIC_PACKET_CONTROL0                                     0x4213
#define mmDIG3_HDMI_GENERIC_PACKET_CONTROL0                                     0x4513
#define mmDIG4_HDMI_GENERIC_PACKET_CONTROL0                                     0x4813
#define mmDIG5_HDMI_GENERIC_PACKET_CONTROL0                                     0x4b13
#define mmDIG6_HDMI_GENERIC_PACKET_CONTROL0                                     0x4e13
#define mmAFMT_INTERRUPT_STATUS                                                 0x1c14
#define mmDIG0_AFMT_INTERRUPT_STATUS                                            0x1c14
#define mmDIG1_AFMT_INTERRUPT_STATUS                                            0x1f14
#define mmDIG2_AFMT_INTERRUPT_STATUS                                            0x4214
#define mmDIG3_AFMT_INTERRUPT_STATUS                                            0x4514
#define mmDIG4_AFMT_INTERRUPT_STATUS                                            0x4814
#define mmDIG5_AFMT_INTERRUPT_STATUS                                            0x4b14
#define mmDIG6_AFMT_INTERRUPT_STATUS                                            0x4e14
#define mmHDMI_GC                                                               0x1c16
#define mmDIG0_HDMI_GC                                                          0x1c16
#define mmDIG1_HDMI_GC                                                          0x1f16
#define mmDIG2_HDMI_GC                                                          0x4216
#define mmDIG3_HDMI_GC                                                          0x4516
#define mmDIG4_HDMI_GC                                                          0x4816
#define mmDIG5_HDMI_GC                                                          0x4b16
#define mmDIG6_HDMI_GC                                                          0x4e16
#define mmAFMT_AUDIO_PACKET_CONTROL2                                            0x1c17
#define mmDIG0_AFMT_AUDIO_PACKET_CONTROL2                                       0x1c17
#define mmDIG1_AFMT_AUDIO_PACKET_CONTROL2                                       0x1f17
#define mmDIG2_AFMT_AUDIO_PACKET_CONTROL2                                       0x4217
#define mmDIG3_AFMT_AUDIO_PACKET_CONTROL2                                       0x4517
#define mmDIG4_AFMT_AUDIO_PACKET_CONTROL2                                       0x4817
#define mmDIG5_AFMT_AUDIO_PACKET_CONTROL2                                       0x4b17
#define mmDIG6_AFMT_AUDIO_PACKET_CONTROL2                                       0x4e17
#define mmAFMT_ISRC1_0                                                          0x1c18
#define mmDIG0_AFMT_ISRC1_0                                                     0x1c18
#define mmDIG1_AFMT_ISRC1_0                                                     0x1f18
#define mmDIG2_AFMT_ISRC1_0                                                     0x4218
#define mmDIG3_AFMT_ISRC1_0                                                     0x4518
#define mmDIG4_AFMT_ISRC1_0                                                     0x4818
#define mmDIG5_AFMT_ISRC1_0                                                     0x4b18
#define mmDIG6_AFMT_ISRC1_0                                                     0x4e18
#define mmAFMT_ISRC1_1                                                          0x1c19
#define mmDIG0_AFMT_ISRC1_1                                                     0x1c19
#define mmDIG1_AFMT_ISRC1_1                                                     0x1f19
#define mmDIG2_AFMT_ISRC1_1                                                     0x4219
#define mmDIG3_AFMT_ISRC1_1                                                     0x4519
#define mmDIG4_AFMT_ISRC1_1                                                     0x4819
#define mmDIG5_AFMT_ISRC1_1                                                     0x4b19
#define mmDIG6_AFMT_ISRC1_1                                                     0x4e19
#define mmAFMT_ISRC1_2                                                          0x1c1a
#define mmDIG0_AFMT_ISRC1_2                                                     0x1c1a
#define mmDIG1_AFMT_ISRC1_2                                                     0x1f1a
#define mmDIG2_AFMT_ISRC1_2                                                     0x421a
#define mmDIG3_AFMT_ISRC1_2                                                     0x451a
#define mmDIG4_AFMT_ISRC1_2                                                     0x481a
#define mmDIG5_AFMT_ISRC1_2                                                     0x4b1a
#define mmDIG6_AFMT_ISRC1_2                                                     0x4e1a
#define mmAFMT_ISRC1_3                                                          0x1c1b
#define mmDIG0_AFMT_ISRC1_3                                                     0x1c1b
#define mmDIG1_AFMT_ISRC1_3                                                     0x1f1b
#define mmDIG2_AFMT_ISRC1_3                                                     0x421b
#define mmDIG3_AFMT_ISRC1_3                                                     0x451b
#define mmDIG4_AFMT_ISRC1_3                                                     0x481b
#define mmDIG5_AFMT_ISRC1_3                                                     0x4b1b
#define mmDIG6_AFMT_ISRC1_3                                                     0x4e1b
#define mmAFMT_ISRC1_4                                                          0x1c1c
#define mmDIG0_AFMT_ISRC1_4                                                     0x1c1c
#define mmDIG1_AFMT_ISRC1_4                                                     0x1f1c
#define mmDIG2_AFMT_ISRC1_4                                                     0x421c
#define mmDIG3_AFMT_ISRC1_4                                                     0x451c
#define mmDIG4_AFMT_ISRC1_4                                                     0x481c
#define mmDIG5_AFMT_ISRC1_4                                                     0x4b1c
#define mmDIG6_AFMT_ISRC1_4                                                     0x4e1c
#define mmAFMT_ISRC2_0                                                          0x1c1d
#define mmDIG0_AFMT_ISRC2_0                                                     0x1c1d
#define mmDIG1_AFMT_ISRC2_0                                                     0x1f1d
#define mmDIG2_AFMT_ISRC2_0                                                     0x421d
#define mmDIG3_AFMT_ISRC2_0                                                     0x451d
#define mmDIG4_AFMT_ISRC2_0                                                     0x481d
#define mmDIG5_AFMT_ISRC2_0                                                     0x4b1d
#define mmDIG6_AFMT_ISRC2_0                                                     0x4e1d
#define mmAFMT_ISRC2_1                                                          0x1c1e
#define mmDIG0_AFMT_ISRC2_1                                                     0x1c1e
#define mmDIG1_AFMT_ISRC2_1                                                     0x1f1e
#define mmDIG2_AFMT_ISRC2_1                                                     0x421e
#define mmDIG3_AFMT_ISRC2_1                                                     0x451e
#define mmDIG4_AFMT_ISRC2_1                                                     0x481e
#define mmDIG5_AFMT_ISRC2_1                                                     0x4b1e
#define mmDIG6_AFMT_ISRC2_1                                                     0x4e1e
#define mmAFMT_ISRC2_2                                                          0x1c1f
#define mmDIG0_AFMT_ISRC2_2                                                     0x1c1f
#define mmDIG1_AFMT_ISRC2_2                                                     0x1f1f
#define mmDIG2_AFMT_ISRC2_2                                                     0x421f
#define mmDIG3_AFMT_ISRC2_2                                                     0x451f
#define mmDIG4_AFMT_ISRC2_2                                                     0x481f
#define mmDIG5_AFMT_ISRC2_2                                                     0x4b1f
#define mmDIG6_AFMT_ISRC2_2                                                     0x4e1f
#define mmAFMT_ISRC2_3                                                          0x1c20
#define mmDIG0_AFMT_ISRC2_3                                                     0x1c20
#define mmDIG1_AFMT_ISRC2_3                                                     0x1f20
#define mmDIG2_AFMT_ISRC2_3                                                     0x4220
#define mmDIG3_AFMT_ISRC2_3                                                     0x4520
#define mmDIG4_AFMT_ISRC2_3                                                     0x4820
#define mmDIG5_AFMT_ISRC2_3                                                     0x4b20
#define mmDIG6_AFMT_ISRC2_3                                                     0x4e20
#define mmAFMT_AVI_INFO0                                                        0x1c21
#define mmDIG0_AFMT_AVI_INFO0                                                   0x1c21
#define mmDIG1_AFMT_AVI_INFO0                                                   0x1f21
#define mmDIG2_AFMT_AVI_INFO0                                                   0x4221
#define mmDIG3_AFMT_AVI_INFO0                                                   0x4521
#define mmDIG4_AFMT_AVI_INFO0                                                   0x4821
#define mmDIG5_AFMT_AVI_INFO0                                                   0x4b21
#define mmDIG6_AFMT_AVI_INFO0                                                   0x4e21
#define mmAFMT_AVI_INFO1                                                        0x1c22
#define mmDIG0_AFMT_AVI_INFO1                                                   0x1c22
#define mmDIG1_AFMT_AVI_INFO1                                                   0x1f22
#define mmDIG2_AFMT_AVI_INFO1                                                   0x4222
#define mmDIG3_AFMT_AVI_INFO1                                                   0x4522
#define mmDIG4_AFMT_AVI_INFO1                                                   0x4822
#define mmDIG5_AFMT_AVI_INFO1                                                   0x4b22
#define mmDIG6_AFMT_AVI_INFO1                                                   0x4e22
#define mmAFMT_AVI_INFO2                                                        0x1c23
#define mmDIG0_AFMT_AVI_INFO2                                                   0x1c23
#define mmDIG1_AFMT_AVI_INFO2                                                   0x1f23
#define mmDIG2_AFMT_AVI_INFO2                                                   0x4223
#define mmDIG3_AFMT_AVI_INFO2                                                   0x4523
#define mmDIG4_AFMT_AVI_INFO2                                                   0x4823
#define mmDIG5_AFMT_AVI_INFO2                                                   0x4b23
#define mmDIG6_AFMT_AVI_INFO2                                                   0x4e23
#define mmAFMT_AVI_INFO3                                                        0x1c24
#define mmDIG0_AFMT_AVI_INFO3                                                   0x1c24
#define mmDIG1_AFMT_AVI_INFO3                                                   0x1f24
#define mmDIG2_AFMT_AVI_INFO3                                                   0x4224
#define mmDIG3_AFMT_AVI_INFO3                                                   0x4524
#define mmDIG4_AFMT_AVI_INFO3                                                   0x4824
#define mmDIG5_AFMT_AVI_INFO3                                                   0x4b24
#define mmDIG6_AFMT_AVI_INFO3                                                   0x4e24
#define mmAFMT_MPEG_INFO0                                                       0x1c25
#define mmDIG0_AFMT_MPEG_INFO0                                                  0x1c25
#define mmDIG1_AFMT_MPEG_INFO0                                                  0x1f25
#define mmDIG2_AFMT_MPEG_INFO0                                                  0x4225
#define mmDIG3_AFMT_MPEG_INFO0                                                  0x4525
#define mmDIG4_AFMT_MPEG_INFO0                                                  0x4825
#define mmDIG5_AFMT_MPEG_INFO0                                                  0x4b25
#define mmDIG6_AFMT_MPEG_INFO0                                                  0x4e25
#define mmAFMT_MPEG_INFO1                                                       0x1c26
#define mmDIG0_AFMT_MPEG_INFO1                                                  0x1c26
#define mmDIG1_AFMT_MPEG_INFO1                                                  0x1f26
#define mmDIG2_AFMT_MPEG_INFO1                                                  0x4226
#define mmDIG3_AFMT_MPEG_INFO1                                                  0x4526
#define mmDIG4_AFMT_MPEG_INFO1                                                  0x4826
#define mmDIG5_AFMT_MPEG_INFO1                                                  0x4b26
#define mmDIG6_AFMT_MPEG_INFO1                                                  0x4e26
#define mmAFMT_GENERIC_HDR                                                      0x1c27
#define mmDIG0_AFMT_GENERIC_HDR                                                 0x1c27
#define mmDIG1_AFMT_GENERIC_HDR                                                 0x1f27
#define mmDIG2_AFMT_GENERIC_HDR                                                 0x4227
#define mmDIG3_AFMT_GENERIC_HDR                                                 0x4527
#define mmDIG4_AFMT_GENERIC_HDR                                                 0x4827
#define mmDIG5_AFMT_GENERIC_HDR                                                 0x4b27
#define mmDIG6_AFMT_GENERIC_HDR                                                 0x4e27
#define mmAFMT_GENERIC_0                                                        0x1c28
#define mmDIG0_AFMT_GENERIC_0                                                   0x1c28
#define mmDIG1_AFMT_GENERIC_0                                                   0x1f28
#define mmDIG2_AFMT_GENERIC_0                                                   0x4228
#define mmDIG3_AFMT_GENERIC_0                                                   0x4528
#define mmDIG4_AFMT_GENERIC_0                                                   0x4828
#define mmDIG5_AFMT_GENERIC_0                                                   0x4b28
#define mmDIG6_AFMT_GENERIC_0                                                   0x4e28
#define mmAFMT_GENERIC_1                                                        0x1c29
#define mmDIG0_AFMT_GENERIC_1                                                   0x1c29
#define mmDIG1_AFMT_GENERIC_1                                                   0x1f29
#define mmDIG2_AFMT_GENERIC_1                                                   0x4229
#define mmDIG3_AFMT_GENERIC_1                                                   0x4529
#define mmDIG4_AFMT_GENERIC_1                                                   0x4829
#define mmDIG5_AFMT_GENERIC_1                                                   0x4b29
#define mmDIG6_AFMT_GENERIC_1                                                   0x4e29
#define mmAFMT_GENERIC_2                                                        0x1c2a
#define mmDIG0_AFMT_GENERIC_2                                                   0x1c2a
#define mmDIG1_AFMT_GENERIC_2                                                   0x1f2a
#define mmDIG2_AFMT_GENERIC_2                                                   0x422a
#define mmDIG3_AFMT_GENERIC_2                                                   0x452a
#define mmDIG4_AFMT_GENERIC_2                                                   0x482a
#define mmDIG5_AFMT_GENERIC_2                                                   0x4b2a
#define mmDIG6_AFMT_GENERIC_2                                                   0x4e2a
#define mmAFMT_GENERIC_3                                                        0x1c2b
#define mmDIG0_AFMT_GENERIC_3                                                   0x1c2b
#define mmDIG1_AFMT_GENERIC_3                                                   0x1f2b
#define mmDIG2_AFMT_GENERIC_3                                                   0x422b
#define mmDIG3_AFMT_GENERIC_3                                                   0x452b
#define mmDIG4_AFMT_GENERIC_3                                                   0x482b
#define mmDIG5_AFMT_GENERIC_3                                                   0x4b2b
#define mmDIG6_AFMT_GENERIC_3                                                   0x4e2b
#define mmAFMT_GENERIC_4                                                        0x1c2c
#define mmDIG0_AFMT_GENERIC_4                                                   0x1c2c
#define mmDIG1_AFMT_GENERIC_4                                                   0x1f2c
#define mmDIG2_AFMT_GENERIC_4                                                   0x422c
#define mmDIG3_AFMT_GENERIC_4                                                   0x452c
#define mmDIG4_AFMT_GENERIC_4                                                   0x482c
#define mmDIG5_AFMT_GENERIC_4                                                   0x4b2c
#define mmDIG6_AFMT_GENERIC_4                                                   0x4e2c
#define mmAFMT_GENERIC_5                                                        0x1c2d
#define mmDIG0_AFMT_GENERIC_5                                                   0x1c2d
#define mmDIG1_AFMT_GENERIC_5                                                   0x1f2d
#define mmDIG2_AFMT_GENERIC_5                                                   0x422d
#define mmDIG3_AFMT_GENERIC_5                                                   0x452d
#define mmDIG4_AFMT_GENERIC_5                                                   0x482d
#define mmDIG5_AFMT_GENERIC_5                                                   0x4b2d
#define mmDIG6_AFMT_GENERIC_5                                                   0x4e2d
#define mmAFMT_GENERIC_6                                                        0x1c2e
#define mmDIG0_AFMT_GENERIC_6                                                   0x1c2e
#define mmDIG1_AFMT_GENERIC_6                                                   0x1f2e
#define mmDIG2_AFMT_GENERIC_6                                                   0x422e
#define mmDIG3_AFMT_GENERIC_6                                                   0x452e
#define mmDIG4_AFMT_GENERIC_6                                                   0x482e
#define mmDIG5_AFMT_GENERIC_6                                                   0x4b2e
#define mmDIG6_AFMT_GENERIC_6                                                   0x4e2e
#define mmAFMT_GENERIC_7                                                        0x1c2f
#define mmDIG0_AFMT_GENERIC_7                                                   0x1c2f
#define mmDIG1_AFMT_GENERIC_7                                                   0x1f2f
#define mmDIG2_AFMT_GENERIC_7                                                   0x422f
#define mmDIG3_AFMT_GENERIC_7                                                   0x452f
#define mmDIG4_AFMT_GENERIC_7                                                   0x482f
#define mmDIG5_AFMT_GENERIC_7                                                   0x4b2f
#define mmDIG6_AFMT_GENERIC_7                                                   0x4e2f
#define mmHDMI_GENERIC_PACKET_CONTROL1                                          0x1c30
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL1                                     0x1c30
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL1                                     0x1f30
#define mmDIG2_HDMI_GENERIC_PACKET_CONTROL1                                     0x4230
#define mmDIG3_HDMI_GENERIC_PACKET_CONTROL1                                     0x4530
#define mmDIG4_HDMI_GENERIC_PACKET_CONTROL1                                     0x4830
#define mmDIG5_HDMI_GENERIC_PACKET_CONTROL1                                     0x4b30
#define mmDIG6_HDMI_GENERIC_PACKET_CONTROL1                                     0x4e30
#define mmHDMI_ACR_32_0                                                         0x1c37
#define mmDIG0_HDMI_ACR_32_0                                                    0x1c37
#define mmDIG1_HDMI_ACR_32_0                                                    0x1f37
#define mmDIG2_HDMI_ACR_32_0                                                    0x4237
#define mmDIG3_HDMI_ACR_32_0                                                    0x4537
#define mmDIG4_HDMI_ACR_32_0                                                    0x4837
#define mmDIG5_HDMI_ACR_32_0                                                    0x4b37
#define mmDIG6_HDMI_ACR_32_0                                                    0x4e37
#define mmHDMI_ACR_32_1                                                         0x1c38
#define mmDIG0_HDMI_ACR_32_1                                                    0x1c38
#define mmDIG1_HDMI_ACR_32_1                                                    0x1f38
#define mmDIG2_HDMI_ACR_32_1                                                    0x4238
#define mmDIG3_HDMI_ACR_32_1                                                    0x4538
#define mmDIG4_HDMI_ACR_32_1                                                    0x4838
#define mmDIG5_HDMI_ACR_32_1                                                    0x4b38
#define mmDIG6_HDMI_ACR_32_1                                                    0x4e38
#define mmHDMI_ACR_44_0                                                         0x1c39
#define mmDIG0_HDMI_ACR_44_0                                                    0x1c39
#define mmDIG1_HDMI_ACR_44_0                                                    0x1f39
#define mmDIG2_HDMI_ACR_44_0                                                    0x4239
#define mmDIG3_HDMI_ACR_44_0                                                    0x4539
#define mmDIG4_HDMI_ACR_44_0                                                    0x4839
#define mmDIG5_HDMI_ACR_44_0                                                    0x4b39
#define mmDIG6_HDMI_ACR_44_0                                                    0x4e39
#define mmHDMI_ACR_44_1                                                         0x1c3a
#define mmDIG0_HDMI_ACR_44_1                                                    0x1c3a
#define mmDIG1_HDMI_ACR_44_1                                                    0x1f3a
#define mmDIG2_HDMI_ACR_44_1                                                    0x423a
#define mmDIG3_HDMI_ACR_44_1                                                    0x453a
#define mmDIG4_HDMI_ACR_44_1                                                    0x483a
#define mmDIG5_HDMI_ACR_44_1                                                    0x4b3a
#define mmDIG6_HDMI_ACR_44_1                                                    0x4e3a
#define mmHDMI_ACR_48_0                                                         0x1c3b
#define mmDIG0_HDMI_ACR_48_0                                                    0x1c3b
#define mmDIG1_HDMI_ACR_48_0                                                    0x1f3b
#define mmDIG2_HDMI_ACR_48_0                                                    0x423b
#define mmDIG3_HDMI_ACR_48_0                                                    0x453b
#define mmDIG4_HDMI_ACR_48_0                                                    0x483b
#define mmDIG5_HDMI_ACR_48_0                                                    0x4b3b
#define mmDIG6_HDMI_ACR_48_0                                                    0x4e3b
#define mmHDMI_ACR_48_1                                                         0x1c3c
#define mmDIG0_HDMI_ACR_48_1                                                    0x1c3c
#define mmDIG1_HDMI_ACR_48_1                                                    0x1f3c
#define mmDIG2_HDMI_ACR_48_1                                                    0x423c
#define mmDIG3_HDMI_ACR_48_1                                                    0x453c
#define mmDIG4_HDMI_ACR_48_1                                                    0x483c
#define mmDIG5_HDMI_ACR_48_1                                                    0x4b3c
#define mmDIG6_HDMI_ACR_48_1                                                    0x4e3c
#define mmHDMI_ACR_STATUS_0                                                     0x1c3d
#define mmDIG0_HDMI_ACR_STATUS_0                                                0x1c3d
#define mmDIG1_HDMI_ACR_STATUS_0                                                0x1f3d
#define mmDIG2_HDMI_ACR_STATUS_0                                                0x423d
#define mmDIG3_HDMI_ACR_STATUS_0                                                0x453d
#define mmDIG4_HDMI_ACR_STATUS_0                                                0x483d
#define mmDIG5_HDMI_ACR_STATUS_0                                                0x4b3d
#define mmDIG6_HDMI_ACR_STATUS_0                                                0x4e3d
#define mmHDMI_ACR_STATUS_1                                                     0x1c3e
#define mmDIG0_HDMI_ACR_STATUS_1                                                0x1c3e
#define mmDIG1_HDMI_ACR_STATUS_1                                                0x1f3e
#define mmDIG2_HDMI_ACR_STATUS_1                                                0x423e
#define mmDIG3_HDMI_ACR_STATUS_1                                                0x453e
#define mmDIG4_HDMI_ACR_STATUS_1                                                0x483e
#define mmDIG5_HDMI_ACR_STATUS_1                                                0x4b3e
#define mmDIG6_HDMI_ACR_STATUS_1                                                0x4e3e
#define mmAFMT_AUDIO_INFO0                                                      0x1c3f
#define mmDIG0_AFMT_AUDIO_INFO0                                                 0x1c3f
#define mmDIG1_AFMT_AUDIO_INFO0                                                 0x1f3f
#define mmDIG2_AFMT_AUDIO_INFO0                                                 0x423f
#define mmDIG3_AFMT_AUDIO_INFO0                                                 0x453f
#define mmDIG4_AFMT_AUDIO_INFO0                                                 0x483f
#define mmDIG5_AFMT_AUDIO_INFO0                                                 0x4b3f
#define mmDIG6_AFMT_AUDIO_INFO0                                                 0x4e3f
#define mmAFMT_AUDIO_INFO1                                                      0x1c40
#define mmDIG0_AFMT_AUDIO_INFO1                                                 0x1c40
#define mmDIG1_AFMT_AUDIO_INFO1                                                 0x1f40
#define mmDIG2_AFMT_AUDIO_INFO1                                                 0x4240
#define mmDIG3_AFMT_AUDIO_INFO1                                                 0x4540
#define mmDIG4_AFMT_AUDIO_INFO1                                                 0x4840
#define mmDIG5_AFMT_AUDIO_INFO1                                                 0x4b40
#define mmDIG6_AFMT_AUDIO_INFO1                                                 0x4e40
#define mmAFMT_60958_0                                                          0x1c41
#define mmDIG0_AFMT_60958_0                                                     0x1c41
#define mmDIG1_AFMT_60958_0                                                     0x1f41
#define mmDIG2_AFMT_60958_0                                                     0x4241
#define mmDIG3_AFMT_60958_0                                                     0x4541
#define mmDIG4_AFMT_60958_0                                                     0x4841
#define mmDIG5_AFMT_60958_0                                                     0x4b41
#define mmDIG6_AFMT_60958_0                                                     0x4e41
#define mmAFMT_60958_1                                                          0x1c42
#define mmDIG0_AFMT_60958_1                                                     0x1c42
#define mmDIG1_AFMT_60958_1                                                     0x1f42
#define mmDIG2_AFMT_60958_1                                                     0x4242
#define mmDIG3_AFMT_60958_1                                                     0x4542
#define mmDIG4_AFMT_60958_1                                                     0x4842
#define mmDIG5_AFMT_60958_1                                                     0x4b42
#define mmDIG6_AFMT_60958_1                                                     0x4e42
#define mmAFMT_AUDIO_CRC_CONTROL                                                0x1c43
#define mmDIG0_AFMT_AUDIO_CRC_CONTROL                                           0x1c43
#define mmDIG1_AFMT_AUDIO_CRC_CONTROL                                           0x1f43
#define mmDIG2_AFMT_AUDIO_CRC_CONTROL                                           0x4243
#define mmDIG3_AFMT_AUDIO_CRC_CONTROL                                           0x4543
#define mmDIG4_AFMT_AUDIO_CRC_CONTROL                                           0x4843
#define mmDIG5_AFMT_AUDIO_CRC_CONTROL                                           0x4b43
#define mmDIG6_AFMT_AUDIO_CRC_CONTROL                                           0x4e43
#define mmAFMT_RAMP_CONTROL0                                                    0x1c44
#define mmDIG0_AFMT_RAMP_CONTROL0                                               0x1c44
#define mmDIG1_AFMT_RAMP_CONTROL0                                               0x1f44
#define mmDIG2_AFMT_RAMP_CONTROL0                                               0x4244
#define mmDIG3_AFMT_RAMP_CONTROL0                                               0x4544
#define mmDIG4_AFMT_RAMP_CONTROL0                                               0x4844
#define mmDIG5_AFMT_RAMP_CONTROL0                                               0x4b44
#define mmDIG6_AFMT_RAMP_CONTROL0                                               0x4e44
#define mmAFMT_RAMP_CONTROL1                                                    0x1c45
#define mmDIG0_AFMT_RAMP_CONTROL1                                               0x1c45
#define mmDIG1_AFMT_RAMP_CONTROL1                                               0x1f45
#define mmDIG2_AFMT_RAMP_CONTROL1                                               0x4245
#define mmDIG3_AFMT_RAMP_CONTROL1                                               0x4545
#define mmDIG4_AFMT_RAMP_CONTROL1                                               0x4845
#define mmDIG5_AFMT_RAMP_CONTROL1                                               0x4b45
#define mmDIG6_AFMT_RAMP_CONTROL1                                               0x4e45
#define mmAFMT_RAMP_CONTROL2                                                    0x1c46
#define mmDIG0_AFMT_RAMP_CONTROL2                                               0x1c46
#define mmDIG1_AFMT_RAMP_CONTROL2                                               0x1f46
#define mmDIG2_AFMT_RAMP_CONTROL2                                               0x4246
#define mmDIG3_AFMT_RAMP_CONTROL2                                               0x4546
#define mmDIG4_AFMT_RAMP_CONTROL2                                               0x4846
#define mmDIG5_AFMT_RAMP_CONTROL2                                               0x4b46
#define mmDIG6_AFMT_RAMP_CONTROL2                                               0x4e46
#define mmAFMT_RAMP_CONTROL3                                                    0x1c47
#define mmDIG0_AFMT_RAMP_CONTROL3                                               0x1c47
#define mmDIG1_AFMT_RAMP_CONTROL3                                               0x1f47
#define mmDIG2_AFMT_RAMP_CONTROL3                                               0x4247
#define mmDIG3_AFMT_RAMP_CONTROL3                                               0x4547
#define mmDIG4_AFMT_RAMP_CONTROL3                                               0x4847
#define mmDIG5_AFMT_RAMP_CONTROL3                                               0x4b47
#define mmDIG6_AFMT_RAMP_CONTROL3                                               0x4e47
#define mmAFMT_60958_2                                                          0x1c48
#define mmDIG0_AFMT_60958_2                                                     0x1c48
#define mmDIG1_AFMT_60958_2                                                     0x1f48
#define mmDIG2_AFMT_60958_2                                                     0x4248
#define mmDIG3_AFMT_60958_2                                                     0x4548
#define mmDIG4_AFMT_60958_2                                                     0x4848
#define mmDIG5_AFMT_60958_2                                                     0x4b48
#define mmDIG6_AFMT_60958_2                                                     0x4e48
#define mmAFMT_AUDIO_CRC_RESULT                                                 0x1c49
#define mmDIG0_AFMT_AUDIO_CRC_RESULT                                            0x1c49
#define mmDIG1_AFMT_AUDIO_CRC_RESULT                                            0x1f49
#define mmDIG2_AFMT_AUDIO_CRC_RESULT                                            0x4249
#define mmDIG3_AFMT_AUDIO_CRC_RESULT                                            0x4549
#define mmDIG4_AFMT_AUDIO_CRC_RESULT                                            0x4849
#define mmDIG5_AFMT_AUDIO_CRC_RESULT                                            0x4b49
#define mmDIG6_AFMT_AUDIO_CRC_RESULT                                            0x4e49
#define mmAFMT_STATUS                                                           0x1c4a
#define mmDIG0_AFMT_STATUS                                                      0x1c4a
#define mmDIG1_AFMT_STATUS                                                      0x1f4a
#define mmDIG2_AFMT_STATUS                                                      0x424a
#define mmDIG3_AFMT_STATUS                                                      0x454a
#define mmDIG4_AFMT_STATUS                                                      0x484a
#define mmDIG5_AFMT_STATUS                                                      0x4b4a
#define mmDIG6_AFMT_STATUS                                                      0x4e4a
#define mmAFMT_AUDIO_PACKET_CONTROL                                             0x1c4b
#define mmDIG0_AFMT_AUDIO_PACKET_CONTROL                                        0x1c4b
#define mmDIG1_AFMT_AUDIO_PACKET_CONTROL                                        0x1f4b
#define mmDIG2_AFMT_AUDIO_PACKET_CONTROL                                        0x424b
#define mmDIG3_AFMT_AUDIO_PACKET_CONTROL                                        0x454b
#define mmDIG4_AFMT_AUDIO_PACKET_CONTROL                                        0x484b
#define mmDIG5_AFMT_AUDIO_PACKET_CONTROL                                        0x4b4b
#define mmDIG6_AFMT_AUDIO_PACKET_CONTROL                                        0x4e4b
#define mmAFMT_VBI_PACKET_CONTROL                                               0x1c4c
#define mmDIG0_AFMT_VBI_PACKET_CONTROL                                          0x1c4c
#define mmDIG1_AFMT_VBI_PACKET_CONTROL                                          0x1f4c
#define mmDIG2_AFMT_VBI_PACKET_CONTROL                                          0x424c
#define mmDIG3_AFMT_VBI_PACKET_CONTROL                                          0x454c
#define mmDIG4_AFMT_VBI_PACKET_CONTROL                                          0x484c
#define mmDIG5_AFMT_VBI_PACKET_CONTROL                                          0x4b4c
#define mmDIG6_AFMT_VBI_PACKET_CONTROL                                          0x4e4c
#define mmAFMT_INFOFRAME_CONTROL0                                               0x1c4d
#define mmDIG0_AFMT_INFOFRAME_CONTROL0                                          0x1c4d
#define mmDIG1_AFMT_INFOFRAME_CONTROL0                                          0x1f4d
#define mmDIG2_AFMT_INFOFRAME_CONTROL0                                          0x424d
#define mmDIG3_AFMT_INFOFRAME_CONTROL0                                          0x454d
#define mmDIG4_AFMT_INFOFRAME_CONTROL0                                          0x484d
#define mmDIG5_AFMT_INFOFRAME_CONTROL0                                          0x4b4d
#define mmDIG6_AFMT_INFOFRAME_CONTROL0                                          0x4e4d
#define mmAFMT_AUDIO_SRC_CONTROL                                                0x1c4f
#define mmDIG0_AFMT_AUDIO_SRC_CONTROL                                           0x1c4f
#define mmDIG1_AFMT_AUDIO_SRC_CONTROL                                           0x1f4f
#define mmDIG2_AFMT_AUDIO_SRC_CONTROL                                           0x424f
#define mmDIG3_AFMT_AUDIO_SRC_CONTROL                                           0x454f
#define mmDIG4_AFMT_AUDIO_SRC_CONTROL                                           0x484f
#define mmDIG5_AFMT_AUDIO_SRC_CONTROL                                           0x4b4f
#define mmDIG6_AFMT_AUDIO_SRC_CONTROL                                           0x4e4f
#define mmAFMT_AUDIO_DBG_DTO_CNTL                                               0x1c52
#define mmDIG0_AFMT_AUDIO_DBG_DTO_CNTL                                          0x1c52
#define mmDIG1_AFMT_AUDIO_DBG_DTO_CNTL                                          0x1f52
#define mmDIG2_AFMT_AUDIO_DBG_DTO_CNTL                                          0x4252
#define mmDIG3_AFMT_AUDIO_DBG_DTO_CNTL                                          0x4552
#define mmDIG4_AFMT_AUDIO_DBG_DTO_CNTL                                          0x4852
#define mmDIG5_AFMT_AUDIO_DBG_DTO_CNTL                                          0x4b52
#define mmDIG6_AFMT_AUDIO_DBG_DTO_CNTL                                          0x4e52
#define mmDIG_BE_CNTL                                                           0x1c50
#define mmDIG0_DIG_BE_CNTL                                                      0x1c50
#define mmDIG1_DIG_BE_CNTL                                                      0x1f50
#define mmDIG2_DIG_BE_CNTL                                                      0x4250
#define mmDIG3_DIG_BE_CNTL                                                      0x4550
#define mmDIG4_DIG_BE_CNTL                                                      0x4850
#define mmDIG5_DIG_BE_CNTL                                                      0x4b50
#define mmDIG6_DIG_BE_CNTL                                                      0x4e50
#define mmDIG_BE_EN_CNTL                                                        0x1c51
#define mmDIG0_DIG_BE_EN_CNTL                                                   0x1c51
#define mmDIG1_DIG_BE_EN_CNTL                                                   0x1f51
#define mmDIG2_DIG_BE_EN_CNTL                                                   0x4251
#define mmDIG3_DIG_BE_EN_CNTL                                                   0x4551
#define mmDIG4_DIG_BE_EN_CNTL                                                   0x4851
#define mmDIG5_DIG_BE_EN_CNTL                                                   0x4b51
#define mmDIG6_DIG_BE_EN_CNTL                                                   0x4e51
#define mmTMDS_CNTL                                                             0x1c7c
#define mmDIG0_TMDS_CNTL                                                        0x1c7c
#define mmDIG1_TMDS_CNTL                                                        0x1f7c
#define mmDIG2_TMDS_CNTL                                                        0x427c
#define mmDIG3_TMDS_CNTL                                                        0x457c
#define mmDIG4_TMDS_CNTL                                                        0x487c
#define mmDIG5_TMDS_CNTL                                                        0x4b7c
#define mmDIG6_TMDS_CNTL                                                        0x4e7c
#define mmTMDS_CONTROL_CHAR                                                     0x1c7d
#define mmDIG0_TMDS_CONTROL_CHAR                                                0x1c7d
#define mmDIG1_TMDS_CONTROL_CHAR                                                0x1f7d
#define mmDIG2_TMDS_CONTROL_CHAR                                                0x427d
#define mmDIG3_TMDS_CONTROL_CHAR                                                0x457d
#define mmDIG4_TMDS_CONTROL_CHAR                                                0x487d
#define mmDIG5_TMDS_CONTROL_CHAR                                                0x4b7d
#define mmDIG6_TMDS_CONTROL_CHAR                                                0x4e7d
#define mmTMDS_CONTROL0_FEEDBACK                                                0x1c7e
#define mmDIG0_TMDS_CONTROL0_FEEDBACK                                           0x1c7e
#define mmDIG1_TMDS_CONTROL0_FEEDBACK                                           0x1f7e
#define mmDIG2_TMDS_CONTROL0_FEEDBACK                                           0x427e
#define mmDIG3_TMDS_CONTROL0_FEEDBACK                                           0x457e
#define mmDIG4_TMDS_CONTROL0_FEEDBACK                                           0x487e
#define mmDIG5_TMDS_CONTROL0_FEEDBACK                                           0x4b7e
#define mmDIG6_TMDS_CONTROL0_FEEDBACK                                           0x4e7e
#define mmTMDS_STEREOSYNC_CTL_SEL                                               0x1c7f
#define mmDIG0_TMDS_STEREOSYNC_CTL_SEL                                          0x1c7f
#define mmDIG1_TMDS_STEREOSYNC_CTL_SEL                                          0x1f7f
#define mmDIG2_TMDS_STEREOSYNC_CTL_SEL                                          0x427f
#define mmDIG3_TMDS_STEREOSYNC_CTL_SEL                                          0x457f
#define mmDIG4_TMDS_STEREOSYNC_CTL_SEL                                          0x487f
#define mmDIG5_TMDS_STEREOSYNC_CTL_SEL                                          0x4b7f
#define mmDIG6_TMDS_STEREOSYNC_CTL_SEL                                          0x4e7f
#define mmTMDS_SYNC_CHAR_PATTERN_0_1                                            0x1c80
#define mmDIG0_TMDS_SYNC_CHAR_PATTERN_0_1                                       0x1c80
#define mmDIG1_TMDS_SYNC_CHAR_PATTERN_0_1                                       0x1f80
#define mmDIG2_TMDS_SYNC_CHAR_PATTERN_0_1                                       0x4280
#define mmDIG3_TMDS_SYNC_CHAR_PATTERN_0_1                                       0x4580
#define mmDIG4_TMDS_SYNC_CHAR_PATTERN_0_1                                       0x4880
#define mmDIG5_TMDS_SYNC_CHAR_PATTERN_0_1                                       0x4b80
#define mmDIG6_TMDS_SYNC_CHAR_PATTERN_0_1                                       0x4e80
#define mmTMDS_SYNC_CHAR_PATTERN_2_3                                            0x1c81
#define mmDIG0_TMDS_SYNC_CHAR_PATTERN_2_3                                       0x1c81
#define mmDIG1_TMDS_SYNC_CHAR_PATTERN_2_3                                       0x1f81
#define mmDIG2_TMDS_SYNC_CHAR_PATTERN_2_3                                       0x4281
#define mmDIG3_TMDS_SYNC_CHAR_PATTERN_2_3                                       0x4581
#define mmDIG4_TMDS_SYNC_CHAR_PATTERN_2_3                                       0x4881
#define mmDIG5_TMDS_SYNC_CHAR_PATTERN_2_3                                       0x4b81
#define mmDIG6_TMDS_SYNC_CHAR_PATTERN_2_3                                       0x4e81
#define mmTMDS_DEBUG                                                            0x1c82
#define mmDIG0_TMDS_DEBUG                                                       0x1c82
#define mmDIG1_TMDS_DEBUG                                                       0x1f82
#define mmDIG2_TMDS_DEBUG                                                       0x4282
#define mmDIG3_TMDS_DEBUG                                                       0x4582
#define mmDIG4_TMDS_DEBUG                                                       0x4882
#define mmDIG5_TMDS_DEBUG                                                       0x4b82
#define mmDIG6_TMDS_DEBUG                                                       0x4e82
#define mmTMDS_CTL_BITS                                                         0x1c83
#define mmDIG0_TMDS_CTL_BITS                                                    0x1c83
#define mmDIG1_TMDS_CTL_BITS                                                    0x1f83
#define mmDIG2_TMDS_CTL_BITS                                                    0x4283
#define mmDIG3_TMDS_CTL_BITS                                                    0x4583
#define mmDIG4_TMDS_CTL_BITS                                                    0x4883
#define mmDIG5_TMDS_CTL_BITS                                                    0x4b83
#define mmDIG6_TMDS_CTL_BITS                                                    0x4e83
#define mmTMDS_DCBALANCER_CONTROL                                               0x1c84
#define mmDIG0_TMDS_DCBALANCER_CONTROL                                          0x1c84
#define mmDIG1_TMDS_DCBALANCER_CONTROL                                          0x1f84
#define mmDIG2_TMDS_DCBALANCER_CONTROL                                          0x4284
#define mmDIG3_TMDS_DCBALANCER_CONTROL                                          0x4584
#define mmDIG4_TMDS_DCBALANCER_CONTROL                                          0x4884
#define mmDIG5_TMDS_DCBALANCER_CONTROL                                          0x4b84
#define mmDIG6_TMDS_DCBALANCER_CONTROL                                          0x4e84
#define mmTMDS_CTL0_1_GEN_CNTL                                                  0x1c86
#define mmDIG0_TMDS_CTL0_1_GEN_CNTL                                             0x1c86
#define mmDIG1_TMDS_CTL0_1_GEN_CNTL                                             0x1f86
#define mmDIG2_TMDS_CTL0_1_GEN_CNTL                                             0x4286
#define mmDIG3_TMDS_CTL0_1_GEN_CNTL                                             0x4586
#define mmDIG4_TMDS_CTL0_1_GEN_CNTL                                             0x4886
#define mmDIG5_TMDS_CTL0_1_GEN_CNTL                                             0x4b86
#define mmDIG6_TMDS_CTL0_1_GEN_CNTL                                             0x4e86
#define mmTMDS_CTL2_3_GEN_CNTL                                                  0x1c87
#define mmDIG0_TMDS_CTL2_3_GEN_CNTL                                             0x1c87
#define mmDIG1_TMDS_CTL2_3_GEN_CNTL                                             0x1f87
#define mmDIG2_TMDS_CTL2_3_GEN_CNTL                                             0x4287
#define mmDIG3_TMDS_CTL2_3_GEN_CNTL                                             0x4587
#define mmDIG4_TMDS_CTL2_3_GEN_CNTL                                             0x4887
#define mmDIG5_TMDS_CTL2_3_GEN_CNTL                                             0x4b87
#define mmDIG6_TMDS_CTL2_3_GEN_CNTL                                             0x4e87
#define mmLVDS_DATA_CNTL                                                        0x1c8c
#define mmDIG0_LVDS_DATA_CNTL                                                   0x1c8c
#define mmDIG1_LVDS_DATA_CNTL                                                   0x1f8c
#define mmDIG2_LVDS_DATA_CNTL                                                   0x428c
#define mmDIG3_LVDS_DATA_CNTL                                                   0x458c
#define mmDIG4_LVDS_DATA_CNTL                                                   0x488c
#define mmDIG5_LVDS_DATA_CNTL                                                   0x4b8c
#define mmDIG6_LVDS_DATA_CNTL                                                   0x4e8c
#define mmDIG_LANE_ENABLE                                                       0x1c8d
#define mmDIG0_DIG_LANE_ENABLE                                                  0x1c8d
#define mmDIG1_DIG_LANE_ENABLE                                                  0x1f8d
#define mmDIG2_DIG_LANE_ENABLE                                                  0x428d
#define mmDIG3_DIG_LANE_ENABLE                                                  0x458d
#define mmDIG4_DIG_LANE_ENABLE                                                  0x488d
#define mmDIG5_DIG_LANE_ENABLE                                                  0x4b8d
#define mmDIG6_DIG_LANE_ENABLE                                                  0x4e8d
#define mmDOUT_SCRATCH0                                                         0x1844
#define mmDOUT_SCRATCH1                                                         0x1845
#define mmDOUT_SCRATCH2                                                         0x1846
#define mmDOUT_SCRATCH3                                                         0x1847
#define mmDOUT_SCRATCH4                                                         0x1848
#define mmDOUT_SCRATCH5                                                         0x1849
#define mmDOUT_SCRATCH6                                                         0x184a
#define mmDOUT_SCRATCH7                                                         0x184b
#define mmDOUT_DCE_VCE_CONTROL                                                  0x18ff
#define mmDC_HPD1_INT_STATUS                                                    0x1807
#define mmDC_HPD1_INT_CONTROL                                                   0x1808
#define mmDC_HPD1_CONTROL                                                       0x1809
#define mmDC_HPD2_INT_STATUS                                                    0x180a
#define mmDC_HPD2_INT_CONTROL                                                   0x180b
#define mmDC_HPD2_CONTROL                                                       0x180c
#define mmDC_HPD3_INT_STATUS                                                    0x180d
#define mmDC_HPD3_INT_CONTROL                                                   0x180e
#define mmDC_HPD3_CONTROL                                                       0x180f
#define mmDC_HPD4_INT_STATUS                                                    0x1810
#define mmDC_HPD4_INT_CONTROL                                                   0x1811
#define mmDC_HPD4_CONTROL                                                       0x1812
#define mmDC_HPD5_INT_STATUS                                                    0x1813
#define mmDC_HPD5_INT_CONTROL                                                   0x1814
#define mmDC_HPD5_CONTROL                                                       0x1815
#define mmDC_HPD6_INT_STATUS                                                    0x1816
#define mmDC_HPD6_INT_CONTROL                                                   0x1817
#define mmDC_HPD6_CONTROL                                                       0x1818
#define mmDC_HPD1_FAST_TRAIN_CNTL                                               0x1864
#define mmDC_HPD2_FAST_TRAIN_CNTL                                               0x1865
#define mmDC_HPD3_FAST_TRAIN_CNTL                                               0x1866
#define mmDC_HPD4_FAST_TRAIN_CNTL                                               0x1867
#define mmDC_HPD5_FAST_TRAIN_CNTL                                               0x1868
#define mmDC_HPD6_FAST_TRAIN_CNTL                                               0x1869
#define mmDC_HPD1_TOGGLE_FILT_CNTL                                              0x18bc
#define mmDC_HPD2_TOGGLE_FILT_CNTL                                              0x18bd
#define mmDC_HPD3_TOGGLE_FILT_CNTL                                              0x18be
#define mmDC_HPD4_TOGGLE_FILT_CNTL                                              0x18fc
#define mmDC_HPD5_TOGGLE_FILT_CNTL                                              0x18fd
#define mmDC_HPD6_TOGGLE_FILT_CNTL                                              0x18fe
#define mmDC_I2C_CONTROL                                                        0x1819
#define mmDC_I2C_ARBITRATION                                                    0x181a
#define mmDC_I2C_INTERRUPT_CONTROL                                              0x181b
#define mmDC_I2C_SW_STATUS                                                      0x181c
#define mmDC_I2C_DDC1_HW_STATUS                                                 0x181d
#define mmDC_I2C_DDC2_HW_STATUS                                                 0x181e
#define mmDC_I2C_DDC3_HW_STATUS                                                 0x181f
#define mmDC_I2C_DDC4_HW_STATUS                                                 0x1820
#define mmDC_I2C_DDC5_HW_STATUS                                                 0x1821
#define mmDC_I2C_DDC6_HW_STATUS                                                 0x1822
#define mmDC_I2C_DDC1_SPEED                                                     0x1823
#define mmDC_I2C_DDC1_SETUP                                                     0x1824
#define mmDC_I2C_DDC2_SPEED                                                     0x1825
#define mmDC_I2C_DDC2_SETUP                                                     0x1826
#define mmDC_I2C_DDC3_SPEED                                                     0x1827
#define mmDC_I2C_DDC3_SETUP                                                     0x1828
#define mmDC_I2C_DDC4_SPEED                                                     0x1829
#define mmDC_I2C_DDC4_SETUP                                                     0x182a
#define mmDC_I2C_DDC5_SPEED                                                     0x182b
#define mmDC_I2C_DDC5_SETUP                                                     0x182c
#define mmDC_I2C_DDC6_SPEED                                                     0x182d
#define mmDC_I2C_DDC6_SETUP                                                     0x182e
#define mmDC_I2C_TRANSACTION0                                                   0x182f
#define mmDC_I2C_TRANSACTION1                                                   0x1830
#define mmDC_I2C_TRANSACTION2                                                   0x1831
#define mmDC_I2C_TRANSACTION3                                                   0x1832
#define mmDC_I2C_DATA                                                           0x1833
#define mmGENERIC_I2C_CONTROL                                                   0x1834
#define mmGENERIC_I2C_INTERRUPT_CONTROL                                         0x1835
#define mmGENERIC_I2C_STATUS                                                    0x1836
#define mmGENERIC_I2C_SPEED                                                     0x1837
#define mmGENERIC_I2C_SETUP                                                     0x1838
#define mmGENERIC_I2C_TRANSACTION                                               0x1839
#define mmGENERIC_I2C_DATA                                                      0x183a
#define mmGENERIC_I2C_PIN_SELECTION                                             0x183b
#define mmGENERIC_I2C_PIN_DEBUG                                                 0x183c
#define mmDISP_INTERRUPT_STATUS                                                 0x183d
#define mmDISP_INTERRUPT_STATUS_CONTINUE                                        0x183e
#define mmDISP_INTERRUPT_STATUS_CONTINUE2                                       0x183f
#define mmDISP_INTERRUPT_STATUS_CONTINUE3                                       0x1840
#define mmDISP_INTERRUPT_STATUS_CONTINUE4                                       0x1853
#define mmDISP_INTERRUPT_STATUS_CONTINUE5                                       0x1854
#define mmDISP_INTERRUPT_STATUS_CONTINUE6                                       0x19e0
#define mmDISP_INTERRUPT_STATUS_CONTINUE7                                       0x19e1
#define mmDISP_INTERRUPT_STATUS_CONTINUE8                                       0x19e2
#define mmDISP_INTERRUPT_STATUS_CONTINUE9                                       0x19e3
#define mmDOUT_POWER_MANAGEMENT_CNTL                                            0x1841
#define mmDISP_TIMER_CONTROL                                                    0x1842
#define mmDC_I2C_DDCVGA_HW_STATUS                                               0x1855
#define mmDC_I2C_DDCVGA_SPEED                                                   0x1856
#define mmDC_I2C_DDCVGA_SETUP                                                   0x1857
#define mmDC_I2C_EDID_DETECT_CTRL                                               0x186f
#define mmDISPOUT_STEREOSYNC_SEL                                                0x18bf
#define mmDOUT_TEST_DEBUG_INDEX                                                 0x184d
#define mmDOUT_TEST_DEBUG_DATA                                                  0x184e
#define ixDP_AUX1_DEBUG_A                                                       0x10
#define ixDP_AUX1_DEBUG_B                                                       0x11
#define ixDP_AUX1_DEBUG_C                                                       0x12
#define ixDP_AUX1_DEBUG_D                                                       0x13
#define ixDP_AUX1_DEBUG_E                                                       0x14
#define ixDP_AUX1_DEBUG_F                                                       0x15
#define ixDP_AUX1_DEBUG_G                                                       0x16
#define ixDP_AUX1_DEBUG_H                                                       0x17
#define ixDP_AUX1_DEBUG_I                                                       0x18
#define ixDP_AUX1_DEBUG_J                                                       0x19
#define ixDP_AUX1_DEBUG_K                                                       0x1a
#define ixDP_AUX1_DEBUG_L                                                       0x1b
#define ixDP_AUX1_DEBUG_M                                                       0x1c
#define ixDP_AUX1_DEBUG_N                                                       0x1d
#define ixDP_AUX1_DEBUG_O                                                       0x1e
#define ixDP_AUX1_DEBUG_P                                                       0x1f
#define ixDP_AUX1_DEBUG_Q                                                       0x90
#define ixDP_AUX2_DEBUG_A                                                       0x20
#define ixDP_AUX2_DEBUG_B                                                       0x21
#define ixDP_AUX2_DEBUG_C                                                       0x22
#define ixDP_AUX2_DEBUG_D                                                       0x23
#define ixDP_AUX2_DEBUG_E                                                       0x24
#define ixDP_AUX2_DEBUG_F                                                       0x25
#define ixDP_AUX2_DEBUG_G                                                       0x26
#define ixDP_AUX2_DEBUG_H                                                       0x27
#define ixDP_AUX2_DEBUG_I                                                       0x28
#define ixDP_AUX2_DEBUG_J                                                       0x29
#define ixDP_AUX2_DEBUG_K                                                       0x2a
#define ixDP_AUX2_DEBUG_L                                                       0x2b
#define ixDP_AUX2_DEBUG_M                                                       0x2c
#define ixDP_AUX2_DEBUG_N                                                       0x2d
#define ixDP_AUX2_DEBUG_O                                                       0x2e
#define ixDP_AUX2_DEBUG_P                                                       0x2f
#define ixDP_AUX2_DEBUG_Q                                                       0x91
#define ixDP_AUX3_DEBUG_A                                                       0x30
#define ixDP_AUX3_DEBUG_B                                                       0x31
#define ixDP_AUX3_DEBUG_C                                                       0x32
#define ixDP_AUX3_DEBUG_D                                                       0x33
#define ixDP_AUX3_DEBUG_E                                                       0x34
#define ixDP_AUX3_DEBUG_F                                                       0x35
#define ixDP_AUX3_DEBUG_G                                                       0x36
#define ixDP_AUX3_DEBUG_H                                                       0x37
#define ixDP_AUX3_DEBUG_I                                                       0x38
#define ixDP_AUX3_DEBUG_J                                                       0x39
#define ixDP_AUX3_DEBUG_K                                                       0x3a
#define ixDP_AUX3_DEBUG_L                                                       0x3b
#define ixDP_AUX3_DEBUG_M                                                       0x3c
#define ixDP_AUX3_DEBUG_N                                                       0x3d
#define ixDP_AUX3_DEBUG_O                                                       0x3e
#define ixDP_AUX3_DEBUG_P                                                       0x3f
#define ixDP_AUX3_DEBUG_Q                                                       0x92
#define ixDP_AUX4_DEBUG_A                                                       0x40
#define ixDP_AUX4_DEBUG_B                                                       0x41
#define ixDP_AUX4_DEBUG_C                                                       0x42
#define ixDP_AUX4_DEBUG_D                                                       0x43
#define ixDP_AUX4_DEBUG_E                                                       0x44
#define ixDP_AUX4_DEBUG_F                                                       0x45
#define ixDP_AUX4_DEBUG_G                                                       0x46
#define ixDP_AUX4_DEBUG_H                                                       0x47
#define ixDP_AUX4_DEBUG_I                                                       0x48
#define ixDP_AUX4_DEBUG_J                                                       0x49
#define ixDP_AUX4_DEBUG_K                                                       0x4a
#define ixDP_AUX4_DEBUG_L                                                       0x4b
#define ixDP_AUX4_DEBUG_M                                                       0x4c
#define ixDP_AUX4_DEBUG_N                                                       0x4d
#define ixDP_AUX4_DEBUG_O                                                       0x4e
#define ixDP_AUX4_DEBUG_P                                                       0x4f
#define ixDP_AUX4_DEBUG_Q                                                       0x93
#define ixDP_AUX5_DEBUG_A                                                       0x70
#define ixDP_AUX5_DEBUG_B                                                       0x71
#define ixDP_AUX5_DEBUG_C                                                       0x72
#define ixDP_AUX5_DEBUG_D                                                       0x73
#define ixDP_AUX5_DEBUG_E                                                       0x74
#define ixDP_AUX5_DEBUG_F                                                       0x75
#define ixDP_AUX5_DEBUG_G                                                       0x76
#define ixDP_AUX5_DEBUG_H                                                       0x77
#define ixDP_AUX5_DEBUG_I                                                       0x78
#define ixDP_AUX5_DEBUG_J                                                       0x79
#define ixDP_AUX5_DEBUG_K                                                       0x7a
#define ixDP_AUX5_DEBUG_L                                                       0x7b
#define ixDP_AUX5_DEBUG_M                                                       0x7c
#define ixDP_AUX5_DEBUG_N                                                       0x7d
#define ixDP_AUX5_DEBUG_O                                                       0x7f
#define ixDP_AUX5_DEBUG_P                                                       0x94
#define ixDP_AUX5_DEBUG_Q                                                       0x95
#define ixDP_AUX6_DEBUG_A                                                       0x80
#define ixDP_AUX6_DEBUG_B                                                       0x81
#define ixDP_AUX6_DEBUG_C                                                       0x82
#define ixDP_AUX6_DEBUG_D                                                       0x83
#define ixDP_AUX6_DEBUG_E                                                       0x84
#define ixDP_AUX6_DEBUG_F                                                       0x85
#define ixDP_AUX6_DEBUG_G                                                       0x86
#define ixDP_AUX6_DEBUG_H                                                       0x87
#define ixDP_AUX6_DEBUG_I                                                       0x88
#define ixDP_AUX6_DEBUG_J                                                       0x89
#define ixDP_AUX6_DEBUG_K                                                       0x8a
#define ixDP_AUX6_DEBUG_L                                                       0x8b
#define ixDP_AUX6_DEBUG_M                                                       0x8c
#define ixDP_AUX6_DEBUG_N                                                       0x8d
#define ixDP_AUX6_DEBUG_O                                                       0x8f
#define ixDP_AUX6_DEBUG_P                                                       0x96
#define ixDP_AUX6_DEBUG_Q                                                       0x97
#define mmDMCU_CTRL                                                             0x1600
#define mmDMCU_STATUS                                                           0x1601
#define mmDMCU_PC_START_ADDR                                                    0x1602
#define mmDMCU_FW_START_ADDR                                                    0x1603
#define mmDMCU_FW_END_ADDR                                                      0x1604
#define mmDMCU_FW_ISR_START_ADDR                                                0x1605
#define mmDMCU_FW_CS_HI                                                         0x1606
#define mmDMCU_FW_CS_LO                                                         0x1607
#define mmDMCU_RAM_ACCESS_CTRL                                                  0x1608
#define mmDMCU_ERAM_WR_CTRL                                                     0x1609
#define mmDMCU_ERAM_WR_DATA                                                     0x160a
#define mmDMCU_ERAM_RD_CTRL                                                     0x160b
#define mmDMCU_ERAM_RD_DATA                                                     0x160c
#define mmDMCU_IRAM_WR_CTRL                                                     0x160d
#define mmDMCU_IRAM_WR_DATA                                                     0x160e
#define mmDMCU_IRAM_RD_CTRL                                                     0x160f
#define mmDMCU_IRAM_RD_DATA                                                     0x1610
#define mmDMCU_EVENT_TRIGGER                                                    0x1611
#define mmDMCU_UC_INTERNAL_INT_STATUS                                           0x1612
#define mmDMCU_SS_INTERRUPT_CNTL_STATUS                                         0x1613
#define mmDMCU_INTERRUPT_STATUS                                                 0x1614
#define mmDMCU_INTERRUPT_TO_HOST_EN_MASK                                        0x1615
#define mmDMCU_INTERRUPT_TO_UC_EN_MASK                                          0x1616
#define mmDMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL                                     0x1617
#define mmDC_DMCU_SCRATCH                                                       0x1618
#define mmDMCU_INT_CNT                                                          0x1619
#define mmDMCU_FW_CHECKSUM_SMPL_BYTE_POS                                        0x161a
#define mmDMCU_UC_CLK_GATING_CNTL                                               0x161b
#define mmMASTER_COMM_DATA_REG1                                                 0x161c
#define mmMASTER_COMM_DATA_REG2                                                 0x161d
#define mmMASTER_COMM_DATA_REG3                                                 0x161e
#define mmMASTER_COMM_CMD_REG                                                   0x161f
#define mmMASTER_COMM_CNTL_REG                                                  0x1620
#define mmSLAVE_COMM_DATA_REG1                                                  0x1621
#define mmSLAVE_COMM_DATA_REG2                                                  0x1622
#define mmSLAVE_COMM_DATA_REG3                                                  0x1623
#define mmSLAVE_COMM_CMD_REG                                                    0x1624
#define mmSLAVE_COMM_CNTL_REG                                                   0x1625
#define mmDMCU_TEST_DEBUG_INDEX                                                 0x1626
#define mmDMCU_TEST_DEBUG_DATA                                                  0x1627
#define mmDMCU_PERFMON_INTERRUPT_STATUS1                                        0x1750
#define mmDMCU_PERFMON_INTERRUPT_STATUS2                                        0x1751
#define mmDMCU_PERFMON_INTERRUPT_STATUS3                                        0x1752
#define mmDMCU_PERFMON_INTERRUPT_STATUS4                                        0x1753
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1                                 0x1754
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2                                 0x1755
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3                                 0x1756
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4                                 0x1757
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1                            0x1758
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2                            0x1759
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3                            0x175a
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4                            0x175b
#define mmDMCU_PERFMON_INTERRUPT_TO_HOST_EN_MASK1                               0x175c
#define mmDMCU_PERFMON_INTERRUPT_TO_HOST_EN_MASK2                               0x175d
#define mmDMCU_PERFMON_INTERRUPT_TO_HOST_EN_MASK3                               0x175e
#define mmDMCU_PERFMON_INTERRUPT_TO_HOST_EN_MASK4                               0x175f
#define mmDP_LINK_CNTL                                                          0x1cc0
#define mmDP0_DP_LINK_CNTL                                                      0x1cc0
#define mmDP1_DP_LINK_CNTL                                                      0x1fc0
#define mmDP2_DP_LINK_CNTL                                                      0x42c0
#define mmDP3_DP_LINK_CNTL                                                      0x45c0
#define mmDP4_DP_LINK_CNTL                                                      0x48c0
#define mmDP5_DP_LINK_CNTL                                                      0x4bc0
#define mmDP6_DP_LINK_CNTL                                                      0x4ec0
#define mmDP_PIXEL_FORMAT                                                       0x1cc1
#define mmDP0_DP_PIXEL_FORMAT                                                   0x1cc1
#define mmDP1_DP_PIXEL_FORMAT                                                   0x1fc1
#define mmDP2_DP_PIXEL_FORMAT                                                   0x42c1
#define mmDP3_DP_PIXEL_FORMAT                                                   0x45c1
#define mmDP4_DP_PIXEL_FORMAT                                                   0x48c1
#define mmDP5_DP_PIXEL_FORMAT                                                   0x4bc1
#define mmDP6_DP_PIXEL_FORMAT                                                   0x4ec1
#define mmDP_MSA_COLORIMETRY                                                    0x1cda
#define mmDP0_DP_MSA_COLORIMETRY                                                0x1cda
#define mmDP1_DP_MSA_COLORIMETRY                                                0x1fda
#define mmDP2_DP_MSA_COLORIMETRY                                                0x42da
#define mmDP3_DP_MSA_COLORIMETRY                                                0x45da
#define mmDP4_DP_MSA_COLORIMETRY                                                0x48da
#define mmDP5_DP_MSA_COLORIMETRY                                                0x4bda
#define mmDP6_DP_MSA_COLORIMETRY                                                0x4eda
#define mmDP_CONFIG                                                             0x1cc2
#define mmDP0_DP_CONFIG                                                         0x1cc2
#define mmDP1_DP_CONFIG                                                         0x1fc2
#define mmDP2_DP_CONFIG                                                         0x42c2
#define mmDP3_DP_CONFIG                                                         0x45c2
#define mmDP4_DP_CONFIG                                                         0x48c2
#define mmDP5_DP_CONFIG                                                         0x4bc2
#define mmDP6_DP_CONFIG                                                         0x4ec2
#define mmDP_VID_STREAM_CNTL                                                    0x1cc3
#define mmDP0_DP_VID_STREAM_CNTL                                                0x1cc3
#define mmDP1_DP_VID_STREAM_CNTL                                                0x1fc3
#define mmDP2_DP_VID_STREAM_CNTL                                                0x42c3
#define mmDP3_DP_VID_STREAM_CNTL                                                0x45c3
#define mmDP4_DP_VID_STREAM_CNTL                                                0x48c3
#define mmDP5_DP_VID_STREAM_CNTL                                                0x4bc3
#define mmDP6_DP_VID_STREAM_CNTL                                                0x4ec3
#define mmDP_STEER_FIFO                                                         0x1cc4
#define mmDP0_DP_STEER_FIFO                                                     0x1cc4
#define mmDP1_DP_STEER_FIFO                                                     0x1fc4
#define mmDP2_DP_STEER_FIFO                                                     0x42c4
#define mmDP3_DP_STEER_FIFO                                                     0x45c4
#define mmDP4_DP_STEER_FIFO                                                     0x48c4
#define mmDP5_DP_STEER_FIFO                                                     0x4bc4
#define mmDP6_DP_STEER_FIFO                                                     0x4ec4
#define mmDP_MSA_MISC                                                           0x1cc5
#define mmDP0_DP_MSA_MISC                                                       0x1cc5
#define mmDP1_DP_MSA_MISC                                                       0x1fc5
#define mmDP2_DP_MSA_MISC                                                       0x42c5
#define mmDP3_DP_MSA_MISC                                                       0x45c5
#define mmDP4_DP_MSA_MISC                                                       0x48c5
#define mmDP5_DP_MSA_MISC                                                       0x4bc5
#define mmDP6_DP_MSA_MISC                                                       0x4ec5
#define mmDP_VID_TIMING                                                         0x1cc9
#define mmDP0_DP_VID_TIMING                                                     0x1cc9
#define mmDP1_DP_VID_TIMING                                                     0x1fc9
#define mmDP2_DP_VID_TIMING                                                     0x42c9
#define mmDP3_DP_VID_TIMING                                                     0x45c9
#define mmDP4_DP_VID_TIMING                                                     0x48c9
#define mmDP5_DP_VID_TIMING                                                     0x4bc9
#define mmDP6_DP_VID_TIMING                                                     0x4ec9
#define mmDP_VID_N                                                              0x1cca
#define mmDP0_DP_VID_N                                                          0x1cca
#define mmDP1_DP_VID_N                                                          0x1fca
#define mmDP2_DP_VID_N                                                          0x42ca
#define mmDP3_DP_VID_N                                                          0x45ca
#define mmDP4_DP_VID_N                                                          0x48ca
#define mmDP5_DP_VID_N                                                          0x4bca
#define mmDP6_DP_VID_N                                                          0x4eca
#define mmDP_VID_M                                                              0x1ccb
#define mmDP0_DP_VID_M                                                          0x1ccb
#define mmDP1_DP_VID_M                                                          0x1fcb
#define mmDP2_DP_VID_M                                                          0x42cb
#define mmDP3_DP_VID_M                                                          0x45cb
#define mmDP4_DP_VID_M                                                          0x48cb
#define mmDP5_DP_VID_M                                                          0x4bcb
#define mmDP6_DP_VID_M                                                          0x4ecb
#define mmDP_LINK_FRAMING_CNTL                                                  0x1ccc
#define mmDP0_DP_LINK_FRAMING_CNTL                                              0x1ccc
#define mmDP1_DP_LINK_FRAMING_CNTL                                              0x1fcc
#define mmDP2_DP_LINK_FRAMING_CNTL                                              0x42cc
#define mmDP3_DP_LINK_FRAMING_CNTL                                              0x45cc
#define mmDP4_DP_LINK_FRAMING_CNTL                                              0x48cc
#define mmDP5_DP_LINK_FRAMING_CNTL                                              0x4bcc
#define mmDP6_DP_LINK_FRAMING_CNTL                                              0x4ecc
#define mmDP_HBR2_EYE_PATTERN                                                   0x1cc8
#define mmDP0_DP_HBR2_EYE_PATTERN                                               0x1cc8
#define mmDP1_DP_HBR2_EYE_PATTERN                                               0x1fc8
#define mmDP2_DP_HBR2_EYE_PATTERN                                               0x42c8
#define mmDP3_DP_HBR2_EYE_PATTERN                                               0x45c8
#define mmDP4_DP_HBR2_EYE_PATTERN                                               0x48c8
#define mmDP5_DP_HBR2_EYE_PATTERN                                               0x4bc8
#define mmDP6_DP_HBR2_EYE_PATTERN                                               0x4ec8
#define mmDP_VID_MSA_VBID                                                       0x1ccd
#define mmDP0_DP_VID_MSA_VBID                                                   0x1ccd
#define mmDP1_DP_VID_MSA_VBID                                                   0x1fcd
#define mmDP2_DP_VID_MSA_VBID                                                   0x42cd
#define mmDP3_DP_VID_MSA_VBID                                                   0x45cd
#define mmDP4_DP_VID_MSA_VBID                                                   0x48cd
#define mmDP5_DP_VID_MSA_VBID                                                   0x4bcd
#define mmDP6_DP_VID_MSA_VBID                                                   0x4ecd
#define mmDP_VID_INTERRUPT_CNTL                                                 0x1ccf
#define mmDP0_DP_VID_INTERRUPT_CNTL                                             0x1ccf
#define mmDP1_DP_VID_INTERRUPT_CNTL                                             0x1fcf
#define mmDP2_DP_VID_INTERRUPT_CNTL                                             0x42cf
#define mmDP3_DP_VID_INTERRUPT_CNTL                                             0x45cf
#define mmDP4_DP_VID_INTERRUPT_CNTL                                             0x48cf
#define mmDP5_DP_VID_INTERRUPT_CNTL                                             0x4bcf
#define mmDP6_DP_VID_INTERRUPT_CNTL                                             0x4ecf
#define mmDP_DPHY_CNTL                                                          0x1cd0
#define mmDP0_DP_DPHY_CNTL                                                      0x1cd0
#define mmDP1_DP_DPHY_CNTL                                                      0x1fd0
#define mmDP2_DP_DPHY_CNTL                                                      0x42d0
#define mmDP3_DP_DPHY_CNTL                                                      0x45d0
#define mmDP4_DP_DPHY_CNTL                                                      0x48d0
#define mmDP5_DP_DPHY_CNTL                                                      0x4bd0
#define mmDP6_DP_DPHY_CNTL                                                      0x4ed0
#define mmDP_DPHY_TRAINING_PATTERN_SEL                                          0x1cd1
#define mmDP0_DP_DPHY_TRAINING_PATTERN_SEL                                      0x1cd1
#define mmDP1_DP_DPHY_TRAINING_PATTERN_SEL                                      0x1fd1
#define mmDP2_DP_DPHY_TRAINING_PATTERN_SEL                                      0x42d1
#define mmDP3_DP_DPHY_TRAINING_PATTERN_SEL                                      0x45d1
#define mmDP4_DP_DPHY_TRAINING_PATTERN_SEL                                      0x48d1
#define mmDP5_DP_DPHY_TRAINING_PATTERN_SEL                                      0x4bd1
#define mmDP6_DP_DPHY_TRAINING_PATTERN_SEL                                      0x4ed1
#define mmDP_DPHY_SYM0                                                          0x1cd2
#define mmDP0_DP_DPHY_SYM0                                                      0x1cd2
#define mmDP1_DP_DPHY_SYM0                                                      0x1fd2
#define mmDP2_DP_DPHY_SYM0                                                      0x42d2
#define mmDP3_DP_DPHY_SYM0                                                      0x45d2
#define mmDP4_DP_DPHY_SYM0                                                      0x48d2
#define mmDP5_DP_DPHY_SYM0                                                      0x4bd2
#define mmDP6_DP_DPHY_SYM0                                                      0x4ed2
#define mmDP_DPHY_SYM1                                                          0x1ce0
#define mmDP0_DP_DPHY_SYM1                                                      0x1ce0
#define mmDP1_DP_DPHY_SYM1                                                      0x1fe0
#define mmDP2_DP_DPHY_SYM1                                                      0x42e0
#define mmDP3_DP_DPHY_SYM1                                                      0x45e0
#define mmDP4_DP_DPHY_SYM1                                                      0x48e0
#define mmDP5_DP_DPHY_SYM1                                                      0x4be0
#define mmDP6_DP_DPHY_SYM1                                                      0x4ee0
#define mmDP_DPHY_SYM2                                                          0x1cdf
#define mmDP0_DP_DPHY_SYM2                                                      0x1cdf
#define mmDP1_DP_DPHY_SYM2                                                      0x1fdf
#define mmDP2_DP_DPHY_SYM2                                                      0x42df
#define mmDP3_DP_DPHY_SYM2                                                      0x45df
#define mmDP4_DP_DPHY_SYM2                                                      0x48df
#define mmDP5_DP_DPHY_SYM2                                                      0x4bdf
#define mmDP6_DP_DPHY_SYM2                                                      0x4edf
#define mmDP_DPHY_8B10B_CNTL                                                    0x1cd3
#define mmDP0_DP_DPHY_8B10B_CNTL                                                0x1cd3
#define mmDP1_DP_DPHY_8B10B_CNTL                                                0x1fd3
#define mmDP2_DP_DPHY_8B10B_CNTL                                                0x42d3
#define mmDP3_DP_DPHY_8B10B_CNTL                                                0x45d3
#define mmDP4_DP_DPHY_8B10B_CNTL                                                0x48d3
#define mmDP5_DP_DPHY_8B10B_CNTL                                                0x4bd3
#define mmDP6_DP_DPHY_8B10B_CNTL                                                0x4ed3
#define mmDP_DPHY_PRBS_CNTL                                                     0x1cd4
#define mmDP0_DP_DPHY_PRBS_CNTL                                                 0x1cd4
#define mmDP1_DP_DPHY_PRBS_CNTL                                                 0x1fd4
#define mmDP2_DP_DPHY_PRBS_CNTL                                                 0x42d4
#define mmDP3_DP_DPHY_PRBS_CNTL                                                 0x45d4
#define mmDP4_DP_DPHY_PRBS_CNTL                                                 0x48d4
#define mmDP5_DP_DPHY_PRBS_CNTL                                                 0x4bd4
#define mmDP6_DP_DPHY_PRBS_CNTL                                                 0x4ed4
#define mmDP_DPHY_SCRAM_CNTL                                                    0x1cd5
#define mmDP0_DP_DPHY_SCRAM_CNTL                                                0x1cd5
#define mmDP1_DP_DPHY_SCRAM_CNTL                                                0x1fd5
#define mmDP2_DP_DPHY_SCRAM_CNTL                                                0x42d5
#define mmDP3_DP_DPHY_SCRAM_CNTL                                                0x45d5
#define mmDP4_DP_DPHY_SCRAM_CNTL                                                0x48d5
#define mmDP5_DP_DPHY_SCRAM_CNTL                                                0x4bd5
#define mmDP6_DP_DPHY_SCRAM_CNTL                                                0x4ed5
#define mmDP_DPHY_CRC_EN                                                        0x1cd6
#define mmDP0_DP_DPHY_CRC_EN                                                    0x1cd6
#define mmDP1_DP_DPHY_CRC_EN                                                    0x1fd6
#define mmDP2_DP_DPHY_CRC_EN                                                    0x42d6
#define mmDP3_DP_DPHY_CRC_EN                                                    0x45d6
#define mmDP4_DP_DPHY_CRC_EN                                                    0x48d6
#define mmDP5_DP_DPHY_CRC_EN                                                    0x4bd6
#define mmDP6_DP_DPHY_CRC_EN                                                    0x4ed6
#define mmDP_DPHY_CRC_CNTL                                                      0x1cd7
#define mmDP0_DP_DPHY_CRC_CNTL                                                  0x1cd7
#define mmDP1_DP_DPHY_CRC_CNTL                                                  0x1fd7
#define mmDP2_DP_DPHY_CRC_CNTL                                                  0x42d7
#define mmDP3_DP_DPHY_CRC_CNTL                                                  0x45d7
#define mmDP4_DP_DPHY_CRC_CNTL                                                  0x48d7
#define mmDP5_DP_DPHY_CRC_CNTL                                                  0x4bd7
#define mmDP6_DP_DPHY_CRC_CNTL                                                  0x4ed7
#define mmDP_DPHY_CRC_RESULT                                                    0x1cd8
#define mmDP0_DP_DPHY_CRC_RESULT                                                0x1cd8
#define mmDP1_DP_DPHY_CRC_RESULT                                                0x1fd8
#define mmDP2_DP_DPHY_CRC_RESULT                                                0x42d8
#define mmDP3_DP_DPHY_CRC_RESULT                                                0x45d8
#define mmDP4_DP_DPHY_CRC_RESULT                                                0x48d8
#define mmDP5_DP_DPHY_CRC_RESULT                                                0x4bd8
#define mmDP6_DP_DPHY_CRC_RESULT                                                0x4ed8
#define mmDP_DPHY_CRC_MST_CNTL                                                  0x1cc6
#define mmDP0_DP_DPHY_CRC_MST_CNTL                                              0x1cc6
#define mmDP1_DP_DPHY_CRC_MST_CNTL                                              0x1fc6
#define mmDP2_DP_DPHY_CRC_MST_CNTL                                              0x42c6
#define mmDP3_DP_DPHY_CRC_MST_CNTL                                              0x45c6
#define mmDP4_DP_DPHY_CRC_MST_CNTL                                              0x48c6
#define mmDP5_DP_DPHY_CRC_MST_CNTL                                              0x4bc6
#define mmDP6_DP_DPHY_CRC_MST_CNTL                                              0x4ec6
#define mmDP_DPHY_CRC_MST_STATUS                                                0x1cc7
#define mmDP0_DP_DPHY_CRC_MST_STATUS                                            0x1cc7
#define mmDP1_DP_DPHY_CRC_MST_STATUS                                            0x1fc7
#define mmDP2_DP_DPHY_CRC_MST_STATUS                                            0x42c7
#define mmDP3_DP_DPHY_CRC_MST_STATUS                                            0x45c7
#define mmDP4_DP_DPHY_CRC_MST_STATUS                                            0x48c7
#define mmDP5_DP_DPHY_CRC_MST_STATUS                                            0x4bc7
#define mmDP6_DP_DPHY_CRC_MST_STATUS                                            0x4ec7
#define mmDP_DPHY_FAST_TRAINING                                                 0x1cce
#define mmDP0_DP_DPHY_FAST_TRAINING                                             0x1cce
#define mmDP1_DP_DPHY_FAST_TRAINING                                             0x1fce
#define mmDP2_DP_DPHY_FAST_TRAINING                                             0x42ce
#define mmDP3_DP_DPHY_FAST_TRAINING                                             0x45ce
#define mmDP4_DP_DPHY_FAST_TRAINING                                             0x48ce
#define mmDP5_DP_DPHY_FAST_TRAINING                                             0x4bce
#define mmDP6_DP_DPHY_FAST_TRAINING                                             0x4ece
#define mmDP_DPHY_FAST_TRAINING_STATUS                                          0x1ce9
#define mmDP0_DP_DPHY_FAST_TRAINING_STATUS                                      0x1ce9
#define mmDP1_DP_DPHY_FAST_TRAINING_STATUS                                      0x1fe9
#define mmDP2_DP_DPHY_FAST_TRAINING_STATUS                                      0x42e9
#define mmDP3_DP_DPHY_FAST_TRAINING_STATUS                                      0x45e9
#define mmDP4_DP_DPHY_FAST_TRAINING_STATUS                                      0x48e9
#define mmDP5_DP_DPHY_FAST_TRAINING_STATUS                                      0x4be9
#define mmDP6_DP_DPHY_FAST_TRAINING_STATUS                                      0x4ee9
#define mmDP_MSA_V_TIMING_OVERRIDE1                                             0x1cea
#define mmDP0_DP_MSA_V_TIMING_OVERRIDE1                                         0x1cea
#define mmDP1_DP_MSA_V_TIMING_OVERRIDE1                                         0x1fea
#define mmDP2_DP_MSA_V_TIMING_OVERRIDE1                                         0x42ea
#define mmDP3_DP_MSA_V_TIMING_OVERRIDE1                                         0x45ea
#define mmDP4_DP_MSA_V_TIMING_OVERRIDE1                                         0x48ea
#define mmDP5_DP_MSA_V_TIMING_OVERRIDE1                                         0x4bea
#define mmDP6_DP_MSA_V_TIMING_OVERRIDE1                                         0x4eea
#define mmDP_MSA_V_TIMING_OVERRIDE2                                             0x1ceb
#define mmDP0_DP_MSA_V_TIMING_OVERRIDE2                                         0x1ceb
#define mmDP1_DP_MSA_V_TIMING_OVERRIDE2                                         0x1feb
#define mmDP2_DP_MSA_V_TIMING_OVERRIDE2                                         0x42eb
#define mmDP3_DP_MSA_V_TIMING_OVERRIDE2                                         0x45eb
#define mmDP4_DP_MSA_V_TIMING_OVERRIDE2                                         0x48eb
#define mmDP5_DP_MSA_V_TIMING_OVERRIDE2                                         0x4beb
#define mmDP6_DP_MSA_V_TIMING_OVERRIDE2                                         0x4eeb
#define mmDP_SEC_CNTL                                                           0x1ca0
#define mmDP0_DP_SEC_CNTL                                                       0x1ca0
#define mmDP1_DP_SEC_CNTL                                                       0x1fa0
#define mmDP2_DP_SEC_CNTL                                                       0x42a0
#define mmDP3_DP_SEC_CNTL                                                       0x45a0
#define mmDP4_DP_SEC_CNTL                                                       0x48a0
#define mmDP5_DP_SEC_CNTL                                                       0x4ba0
#define mmDP6_DP_SEC_CNTL                                                       0x4ea0
#define mmDP_SEC_CNTL1                                                          0x1cab
#define mmDP0_DP_SEC_CNTL1                                                      0x1cab
#define mmDP1_DP_SEC_CNTL1                                                      0x1fab
#define mmDP2_DP_SEC_CNTL1                                                      0x42ab
#define mmDP3_DP_SEC_CNTL1                                                      0x45ab
#define mmDP4_DP_SEC_CNTL1                                                      0x48ab
#define mmDP5_DP_SEC_CNTL1                                                      0x4bab
#define mmDP6_DP_SEC_CNTL1                                                      0x4eab
#define mmDP_SEC_FRAMING1                                                       0x1ca1
#define mmDP0_DP_SEC_FRAMING1                                                   0x1ca1
#define mmDP1_DP_SEC_FRAMING1                                                   0x1fa1
#define mmDP2_DP_SEC_FRAMING1                                                   0x42a1
#define mmDP3_DP_SEC_FRAMING1                                                   0x45a1
#define mmDP4_DP_SEC_FRAMING1                                                   0x48a1
#define mmDP5_DP_SEC_FRAMING1                                                   0x4ba1
#define mmDP6_DP_SEC_FRAMING1                                                   0x4ea1
#define mmDP_SEC_FRAMING2                                                       0x1ca2
#define mmDP0_DP_SEC_FRAMING2                                                   0x1ca2
#define mmDP1_DP_SEC_FRAMING2                                                   0x1fa2
#define mmDP2_DP_SEC_FRAMING2                                                   0x42a2
#define mmDP3_DP_SEC_FRAMING2                                                   0x45a2
#define mmDP4_DP_SEC_FRAMING2                                                   0x48a2
#define mmDP5_DP_SEC_FRAMING2                                                   0x4ba2
#define mmDP6_DP_SEC_FRAMING2                                                   0x4ea2
#define mmDP_SEC_FRAMING3                                                       0x1ca3
#define mmDP0_DP_SEC_FRAMING3                                                   0x1ca3
#define mmDP1_DP_SEC_FRAMING3                                                   0x1fa3
#define mmDP2_DP_SEC_FRAMING3                                                   0x42a3
#define mmDP3_DP_SEC_FRAMING3                                                   0x45a3
#define mmDP4_DP_SEC_FRAMING3                                                   0x48a3
#define mmDP5_DP_SEC_FRAMING3                                                   0x4ba3
#define mmDP6_DP_SEC_FRAMING3                                                   0x4ea3
#define mmDP_SEC_FRAMING4                                                       0x1ca4
#define mmDP0_DP_SEC_FRAMING4                                                   0x1ca4
#define mmDP1_DP_SEC_FRAMING4                                                   0x1fa4
#define mmDP2_DP_SEC_FRAMING4                                                   0x42a4
#define mmDP3_DP_SEC_FRAMING4                                                   0x45a4
#define mmDP4_DP_SEC_FRAMING4                                                   0x48a4
#define mmDP5_DP_SEC_FRAMING4                                                   0x4ba4
#define mmDP6_DP_SEC_FRAMING4                                                   0x4ea4
#define mmDP_SEC_AUD_N                                                          0x1ca5
#define mmDP0_DP_SEC_AUD_N                                                      0x1ca5
#define mmDP1_DP_SEC_AUD_N                                                      0x1fa5
#define mmDP2_DP_SEC_AUD_N                                                      0x42a5
#define mmDP3_DP_SEC_AUD_N                                                      0x45a5
#define mmDP4_DP_SEC_AUD_N                                                      0x48a5
#define mmDP5_DP_SEC_AUD_N                                                      0x4ba5
#define mmDP6_DP_SEC_AUD_N                                                      0x4ea5
#define mmDP_SEC_AUD_N_READBACK                                                 0x1ca6
#define mmDP0_DP_SEC_AUD_N_READBACK                                             0x1ca6
#define mmDP1_DP_SEC_AUD_N_READBACK                                             0x1fa6
#define mmDP2_DP_SEC_AUD_N_READBACK                                             0x42a6
#define mmDP3_DP_SEC_AUD_N_READBACK                                             0x45a6
#define mmDP4_DP_SEC_AUD_N_READBACK                                             0x48a6
#define mmDP5_DP_SEC_AUD_N_READBACK                                             0x4ba6
#define mmDP6_DP_SEC_AUD_N_READBACK                                             0x4ea6
#define mmDP_SEC_AUD_M                                                          0x1ca7
#define mmDP0_DP_SEC_AUD_M                                                      0x1ca7
#define mmDP1_DP_SEC_AUD_M                                                      0x1fa7
#define mmDP2_DP_SEC_AUD_M                                                      0x42a7
#define mmDP3_DP_SEC_AUD_M                                                      0x45a7
#define mmDP4_DP_SEC_AUD_M                                                      0x48a7
#define mmDP5_DP_SEC_AUD_M                                                      0x4ba7
#define mmDP6_DP_SEC_AUD_M                                                      0x4ea7
#define mmDP_SEC_AUD_M_READBACK                                                 0x1ca8
#define mmDP0_DP_SEC_AUD_M_READBACK                                             0x1ca8
#define mmDP1_DP_SEC_AUD_M_READBACK                                             0x1fa8
#define mmDP2_DP_SEC_AUD_M_READBACK                                             0x42a8
#define mmDP3_DP_SEC_AUD_M_READBACK                                             0x45a8
#define mmDP4_DP_SEC_AUD_M_READBACK                                             0x48a8
#define mmDP5_DP_SEC_AUD_M_READBACK                                             0x4ba8
#define mmDP6_DP_SEC_AUD_M_READBACK                                             0x4ea8
#define mmDP_SEC_TIMESTAMP                                                      0x1ca9
#define mmDP0_DP_SEC_TIMESTAMP                                                  0x1ca9
#define mmDP1_DP_SEC_TIMESTAMP                                                  0x1fa9
#define mmDP2_DP_SEC_TIMESTAMP                                                  0x42a9
#define mmDP3_DP_SEC_TIMESTAMP                                                  0x45a9
#define mmDP4_DP_SEC_TIMESTAMP                                                  0x48a9
#define mmDP5_DP_SEC_TIMESTAMP                                                  0x4ba9
#define mmDP6_DP_SEC_TIMESTAMP                                                  0x4ea9
#define mmDP_SEC_PACKET_CNTL                                                    0x1caa
#define mmDP0_DP_SEC_PACKET_CNTL                                                0x1caa
#define mmDP1_DP_SEC_PACKET_CNTL                                                0x1faa
#define mmDP2_DP_SEC_PACKET_CNTL                                                0x42aa
#define mmDP3_DP_SEC_PACKET_CNTL                                                0x45aa
#define mmDP4_DP_SEC_PACKET_CNTL                                                0x48aa
#define mmDP5_DP_SEC_PACKET_CNTL                                                0x4baa
#define mmDP6_DP_SEC_PACKET_CNTL                                                0x4eaa
#define mmDP_MSE_RATE_CNTL                                                      0x1ce1
#define mmDP0_DP_MSE_RATE_CNTL                                                  0x1ce1
#define mmDP1_DP_MSE_RATE_CNTL                                                  0x1fe1
#define mmDP2_DP_MSE_RATE_CNTL                                                  0x42e1
#define mmDP3_DP_MSE_RATE_CNTL                                                  0x45e1
#define mmDP4_DP_MSE_RATE_CNTL                                                  0x48e1
#define mmDP5_DP_MSE_RATE_CNTL                                                  0x4be1
#define mmDP6_DP_MSE_RATE_CNTL                                                  0x4ee1
#define mmDP_MSE_RATE_UPDATE                                                    0x1ce3
#define mmDP0_DP_MSE_RATE_UPDATE                                                0x1ce3
#define mmDP1_DP_MSE_RATE_UPDATE                                                0x1fe3
#define mmDP2_DP_MSE_RATE_UPDATE                                                0x42e3
#define mmDP3_DP_MSE_RATE_UPDATE                                                0x45e3
#define mmDP4_DP_MSE_RATE_UPDATE                                                0x48e3
#define mmDP5_DP_MSE_RATE_UPDATE                                                0x4be3
#define mmDP6_DP_MSE_RATE_UPDATE                                                0x4ee3
#define mmDP_MSE_SAT0                                                           0x1ce4
#define mmDP0_DP_MSE_SAT0                                                       0x1ce4
#define mmDP1_DP_MSE_SAT0                                                       0x1fe4
#define mmDP2_DP_MSE_SAT0                                                       0x42e4
#define mmDP3_DP_MSE_SAT0                                                       0x45e4
#define mmDP4_DP_MSE_SAT0                                                       0x48e4
#define mmDP5_DP_MSE_SAT0                                                       0x4be4
#define mmDP6_DP_MSE_SAT0                                                       0x4ee4
#define mmDP_MSE_SAT1                                                           0x1ce5
#define mmDP0_DP_MSE_SAT1                                                       0x1ce5
#define mmDP1_DP_MSE_SAT1                                                       0x1fe5
#define mmDP2_DP_MSE_SAT1                                                       0x42e5
#define mmDP3_DP_MSE_SAT1                                                       0x45e5
#define mmDP4_DP_MSE_SAT1                                                       0x48e5
#define mmDP5_DP_MSE_SAT1                                                       0x4be5
#define mmDP6_DP_MSE_SAT1                                                       0x4ee5
#define mmDP_MSE_SAT2                                                           0x1ce6
#define mmDP0_DP_MSE_SAT2                                                       0x1ce6
#define mmDP1_DP_MSE_SAT2                                                       0x1fe6
#define mmDP2_DP_MSE_SAT2                                                       0x42e6
#define mmDP3_DP_MSE_SAT2                                                       0x45e6
#define mmDP4_DP_MSE_SAT2                                                       0x48e6
#define mmDP5_DP_MSE_SAT2                                                       0x4be6
#define mmDP6_DP_MSE_SAT2                                                       0x4ee6
#define mmDP_MSE_SAT_UPDATE                                                     0x1ce7
#define mmDP0_DP_MSE_SAT_UPDATE                                                 0x1ce7
#define mmDP1_DP_MSE_SAT_UPDATE                                                 0x1fe7
#define mmDP2_DP_MSE_SAT_UPDATE                                                 0x42e7
#define mmDP3_DP_MSE_SAT_UPDATE                                                 0x45e7
#define mmDP4_DP_MSE_SAT_UPDATE                                                 0x48e7
#define mmDP5_DP_MSE_SAT_UPDATE                                                 0x4be7
#define mmDP6_DP_MSE_SAT_UPDATE                                                 0x4ee7
#define mmDP_MSE_LINK_TIMING                                                    0x1ce8
#define mmDP0_DP_MSE_LINK_TIMING                                                0x1ce8
#define mmDP1_DP_MSE_LINK_TIMING                                                0x1fe8
#define mmDP2_DP_MSE_LINK_TIMING                                                0x42e8
#define mmDP3_DP_MSE_LINK_TIMING                                                0x45e8
#define mmDP4_DP_MSE_LINK_TIMING                                                0x48e8
#define mmDP5_DP_MSE_LINK_TIMING                                                0x4be8
#define mmDP6_DP_MSE_LINK_TIMING                                                0x4ee8
#define mmDP_MSE_MISC_CNTL                                                      0x1cdb
#define mmDP0_DP_MSE_MISC_CNTL                                                  0x1cdb
#define mmDP1_DP_MSE_MISC_CNTL                                                  0x1fdb
#define mmDP2_DP_MSE_MISC_CNTL                                                  0x42db
#define mmDP3_DP_MSE_MISC_CNTL                                                  0x45db
#define mmDP4_DP_MSE_MISC_CNTL                                                  0x48db
#define mmDP5_DP_MSE_MISC_CNTL                                                  0x4bdb
#define mmDP6_DP_MSE_MISC_CNTL                                                  0x4edb
#define mmDP_TEST_DEBUG_INDEX                                                   0x1cfc
#define mmDP0_DP_TEST_DEBUG_INDEX                                               0x1cfc
#define mmDP1_DP_TEST_DEBUG_INDEX                                               0x1ffc
#define mmDP2_DP_TEST_DEBUG_INDEX                                               0x42fc
#define mmDP3_DP_TEST_DEBUG_INDEX                                               0x45fc
#define mmDP4_DP_TEST_DEBUG_INDEX                                               0x48fc
#define mmDP5_DP_TEST_DEBUG_INDEX                                               0x4bfc
#define mmDP6_DP_TEST_DEBUG_INDEX                                               0x4efc
#define mmDP_TEST_DEBUG_DATA                                                    0x1cfd
#define mmDP0_DP_TEST_DEBUG_DATA                                                0x1cfd
#define mmDP1_DP_TEST_DEBUG_DATA                                                0x1ffd
#define mmDP2_DP_TEST_DEBUG_DATA                                                0x42fd
#define mmDP3_DP_TEST_DEBUG_DATA                                                0x45fd
#define mmDP4_DP_TEST_DEBUG_DATA                                                0x48fd
#define mmDP5_DP_TEST_DEBUG_DATA                                                0x4bfd
#define mmDP6_DP_TEST_DEBUG_DATA                                                0x4efd
#define mmAUX_CONTROL                                                           0x1880
#define mmDP_AUX0_AUX_CONTROL                                                   0x1880
#define mmDP_AUX1_AUX_CONTROL                                                   0x1894
#define mmDP_AUX2_AUX_CONTROL                                                   0x18a8
#define mmDP_AUX3_AUX_CONTROL                                                   0x18c0
#define mmDP_AUX4_AUX_CONTROL                                                   0x18d4
#define mmDP_AUX5_AUX_CONTROL                                                   0x18e8
#define mmAUX_SW_CONTROL                                                        0x1881
#define mmDP_AUX0_AUX_SW_CONTROL                                                0x1881
#define mmDP_AUX1_AUX_SW_CONTROL                                                0x1895
#define mmDP_AUX2_AUX_SW_CONTROL                                                0x18a9
#define mmDP_AUX3_AUX_SW_CONTROL                                                0x18c1
#define mmDP_AUX4_AUX_SW_CONTROL                                                0x18d5
#define mmDP_AUX5_AUX_SW_CONTROL                                                0x18e9
#define mmAUX_ARB_CONTROL                                                       0x1882
#define mmDP_AUX0_AUX_ARB_CONTROL                                               0x1882
#define mmDP_AUX1_AUX_ARB_CONTROL                                               0x1896
#define mmDP_AUX2_AUX_ARB_CONTROL                                               0x18aa
#define mmDP_AUX3_AUX_ARB_CONTROL                                               0x18c2
#define mmDP_AUX4_AUX_ARB_CONTROL                                               0x18d6
#define mmDP_AUX5_AUX_ARB_CONTROL                                               0x18ea
#define mmAUX_INTERRUPT_CONTROL                                                 0x1883
#define mmDP_AUX0_AUX_INTERRUPT_CONTROL                                         0x1883
#define mmDP_AUX1_AUX_INTERRUPT_CONTROL                                         0x1897
#define mmDP_AUX2_AUX_INTERRUPT_CONTROL                                         0x18ab
#define mmDP_AUX3_AUX_INTERRUPT_CONTROL                                         0x18c3
#define mmDP_AUX4_AUX_INTERRUPT_CONTROL                                         0x18d7
#define mmDP_AUX5_AUX_INTERRUPT_CONTROL                                         0x18eb
#define mmAUX_SW_STATUS                                                         0x1884
#define mmDP_AUX0_AUX_SW_STATUS                                                 0x1884
#define mmDP_AUX1_AUX_SW_STATUS                                                 0x1898
#define mmDP_AUX2_AUX_SW_STATUS                                                 0x18ac
#define mmDP_AUX3_AUX_SW_STATUS                                                 0x18c4
#define mmDP_AUX4_AUX_SW_STATUS                                                 0x18d8
#define mmDP_AUX5_AUX_SW_STATUS                                                 0x18ec
#define mmAUX_LS_STATUS                                                         0x1885
#define mmDP_AUX0_AUX_LS_STATUS                                                 0x1885
#define mmDP_AUX1_AUX_LS_STATUS                                                 0x1899
#define mmDP_AUX2_AUX_LS_STATUS                                                 0x18ad
#define mmDP_AUX3_AUX_LS_STATUS                                                 0x18c5
#define mmDP_AUX4_AUX_LS_STATUS                                                 0x18d9
#define mmDP_AUX5_AUX_LS_STATUS                                                 0x18ed
#define mmAUX_SW_DATA                                                           0x1886
#define mmDP_AUX0_AUX_SW_DATA                                                   0x1886
#define mmDP_AUX1_AUX_SW_DATA                                                   0x189a
#define mmDP_AUX2_AUX_SW_DATA                                                   0x18ae
#define mmDP_AUX3_AUX_SW_DATA                                                   0x18c6
#define mmDP_AUX4_AUX_SW_DATA                                                   0x18da
#define mmDP_AUX5_AUX_SW_DATA                                                   0x18ee
#define mmAUX_LS_DATA                                                           0x1887
#define mmDP_AUX0_AUX_LS_DATA                                                   0x1887
#define mmDP_AUX1_AUX_LS_DATA                                                   0x189b
#define mmDP_AUX2_AUX_LS_DATA                                                   0x18af
#define mmDP_AUX3_AUX_LS_DATA                                                   0x18c7
#define mmDP_AUX4_AUX_LS_DATA                                                   0x18db
#define mmDP_AUX5_AUX_LS_DATA                                                   0x18ef
#define mmAUX_DPHY_TX_REF_CONTROL                                               0x1888
#define mmDP_AUX0_AUX_DPHY_TX_REF_CONTROL                                       0x1888
#define mmDP_AUX1_AUX_DPHY_TX_REF_CONTROL                                       0x189c
#define mmDP_AUX2_AUX_DPHY_TX_REF_CONTROL                                       0x18b0
#define mmDP_AUX3_AUX_DPHY_TX_REF_CONTROL                                       0x18c8
#define mmDP_AUX4_AUX_DPHY_TX_REF_CONTROL                                       0x18dc
#define mmDP_AUX5_AUX_DPHY_TX_REF_CONTROL                                       0x18f0
#define mmAUX_DPHY_TX_CONTROL                                                   0x1889
#define mmDP_AUX0_AUX_DPHY_TX_CONTROL                                           0x1889
#define mmDP_AUX1_AUX_DPHY_TX_CONTROL                                           0x189d
#define mmDP_AUX2_AUX_DPHY_TX_CONTROL                                           0x18b1
#define mmDP_AUX3_AUX_DPHY_TX_CONTROL                                           0x18c9
#define mmDP_AUX4_AUX_DPHY_TX_CONTROL                                           0x18dd
#define mmDP_AUX5_AUX_DPHY_TX_CONTROL                                           0x18f1
#define mmAUX_DPHY_RX_CONTROL0                                                  0x188a
#define mmDP_AUX0_AUX_DPHY_RX_CONTROL0                                          0x188a
#define mmDP_AUX1_AUX_DPHY_RX_CONTROL0                                          0x189e
#define mmDP_AUX2_AUX_DPHY_RX_CONTROL0                                          0x18b2
#define mmDP_AUX3_AUX_DPHY_RX_CONTROL0                                          0x18ca
#define mmDP_AUX4_AUX_DPHY_RX_CONTROL0                                          0x18de
#define mmDP_AUX5_AUX_DPHY_RX_CONTROL0                                          0x18f2
#define mmAUX_DPHY_RX_CONTROL1                                                  0x188b
#define mmDP_AUX0_AUX_DPHY_RX_CONTROL1                                          0x188b
#define mmDP_AUX1_AUX_DPHY_RX_CONTROL1                                          0x189f
#define mmDP_AUX2_AUX_DPHY_RX_CONTROL1                                          0x18b3
#define mmDP_AUX3_AUX_DPHY_RX_CONTROL1                                          0x18cb
#define mmDP_AUX4_AUX_DPHY_RX_CONTROL1                                          0x18df
#define mmDP_AUX5_AUX_DPHY_RX_CONTROL1                                          0x18f3
#define mmAUX_DPHY_TX_STATUS                                                    0x188c
#define mmDP_AUX0_AUX_DPHY_TX_STATUS                                            0x188c
#define mmDP_AUX1_AUX_DPHY_TX_STATUS                                            0x18a0
#define mmDP_AUX2_AUX_DPHY_TX_STATUS                                            0x18b4
#define mmDP_AUX3_AUX_DPHY_TX_STATUS                                            0x18cc
#define mmDP_AUX4_AUX_DPHY_TX_STATUS                                            0x18e0
#define mmDP_AUX5_AUX_DPHY_TX_STATUS                                            0x18f4
#define mmAUX_DPHY_RX_STATUS                                                    0x188d
#define mmDP_AUX0_AUX_DPHY_RX_STATUS                                            0x188d
#define mmDP_AUX1_AUX_DPHY_RX_STATUS                                            0x18a1
#define mmDP_AUX2_AUX_DPHY_RX_STATUS                                            0x18b5
#define mmDP_AUX3_AUX_DPHY_RX_STATUS                                            0x18cd
#define mmDP_AUX4_AUX_DPHY_RX_STATUS                                            0x18e1
#define mmDP_AUX5_AUX_DPHY_RX_STATUS                                            0x18f5
#define mmAUX_GTC_SYNC_CONTROL                                                  0x188e
#define mmDP_AUX0_AUX_GTC_SYNC_CONTROL                                          0x188e
#define mmDP_AUX1_AUX_GTC_SYNC_CONTROL                                          0x18a2
#define mmDP_AUX2_AUX_GTC_SYNC_CONTROL                                          0x18b6
#define mmDP_AUX3_AUX_GTC_SYNC_CONTROL                                          0x18ce
#define mmDP_AUX4_AUX_GTC_SYNC_CONTROL                                          0x18e2
#define mmDP_AUX5_AUX_GTC_SYNC_CONTROL                                          0x18f6
#define mmAUX_GTC_SYNC_ERROR_CONTROL                                            0x188f
#define mmDP_AUX0_AUX_GTC_SYNC_ERROR_CONTROL                                    0x188f
#define mmDP_AUX1_AUX_GTC_SYNC_ERROR_CONTROL                                    0x18a3
#define mmDP_AUX2_AUX_GTC_SYNC_ERROR_CONTROL                                    0x18b7
#define mmDP_AUX3_AUX_GTC_SYNC_ERROR_CONTROL                                    0x18cf
#define mmDP_AUX4_AUX_GTC_SYNC_ERROR_CONTROL                                    0x18e3
#define mmDP_AUX5_AUX_GTC_SYNC_ERROR_CONTROL                                    0x18f7
#define mmAUX_GTC_SYNC_CONTROLLER_STATUS                                        0x1890
#define mmDP_AUX0_AUX_GTC_SYNC_CONTROLLER_STATUS                                0x1890
#define mmDP_AUX1_AUX_GTC_SYNC_CONTROLLER_STATUS                                0x18a4
#define mmDP_AUX2_AUX_GTC_SYNC_CONTROLLER_STATUS                                0x18b8
#define mmDP_AUX3_AUX_GTC_SYNC_CONTROLLER_STATUS                                0x18d0
#define mmDP_AUX4_AUX_GTC_SYNC_CONTROLLER_STATUS                                0x18e4
#define mmDP_AUX5_AUX_GTC_SYNC_CONTROLLER_STATUS                                0x18f8
#define mmAUX_GTC_SYNC_STATUS                                                   0x1891
#define mmDP_AUX0_AUX_GTC_SYNC_STATUS                                           0x1891
#define mmDP_AUX1_AUX_GTC_SYNC_STATUS                                           0x18a5
#define mmDP_AUX2_AUX_GTC_SYNC_STATUS                                           0x18b9
#define mmDP_AUX3_AUX_GTC_SYNC_STATUS                                           0x18d1
#define mmDP_AUX4_AUX_GTC_SYNC_STATUS                                           0x18e5
#define mmDP_AUX5_AUX_GTC_SYNC_STATUS                                           0x18f9
#define mmAUX_GTC_SYNC_DATA                                                     0x1892
#define mmDP_AUX0_AUX_GTC_SYNC_DATA                                             0x1892
#define mmDP_AUX1_AUX_GTC_SYNC_DATA                                             0x18a6
#define mmDP_AUX2_AUX_GTC_SYNC_DATA                                             0x18ba
#define mmDP_AUX3_AUX_GTC_SYNC_DATA                                             0x18d2
#define mmDP_AUX4_AUX_GTC_SYNC_DATA                                             0x18e6
#define mmDP_AUX5_AUX_GTC_SYNC_DATA                                             0x18fa
#define mmAUX_GTC_SYNC_PHASE_OFFSET_OVERRIDE                                    0x1893
#define mmDP_AUX0_AUX_GTC_SYNC_PHASE_OFFSET_OVERRIDE                            0x1893
#define mmDP_AUX1_AUX_GTC_SYNC_PHASE_OFFSET_OVERRIDE                            0x18a7
#define mmDP_AUX2_AUX_GTC_SYNC_PHASE_OFFSET_OVERRIDE                            0x18bb
#define mmDP_AUX3_AUX_GTC_SYNC_PHASE_OFFSET_OVERRIDE                            0x18d3
#define mmDP_AUX4_AUX_GTC_SYNC_PHASE_OFFSET_OVERRIDE                            0x18e7
#define mmDP_AUX5_AUX_GTC_SYNC_PHASE_OFFSET_OVERRIDE                            0x18fb
#define mmDVO_ENABLE                                                            0x1858
#define mmDVO_SOURCE_SELECT                                                     0x1859
#define mmDVO_OUTPUT                                                            0x185a
#define mmDVO_CONTROL                                                           0x185b
#define mmDVO_CRC_EN                                                            0x185c
#define mmDVO_CRC2_SIG_MASK                                                     0x185d
#define mmDVO_CRC2_SIG_RESULT                                                   0x185e
#define mmDVO_FIFO_ERROR_STATUS                                                 0x185f
#define mmFBC_CNTL                                                              0x16d0
#define mmFBC_IDLE_MASK                                                         0x16d1
#define mmFBC_IDLE_FORCE_CLEAR_MASK                                             0x16d2
#define mmFBC_START_STOP_DELAY                                                  0x16d3
#define mmFBC_COMP_CNTL                                                         0x16d4
#define mmFBC_COMP_MODE                                                         0x16d5
#define mmFBC_DEBUG0                                                            0x16d6
#define mmFBC_DEBUG1                                                            0x16d7
#define mmFBC_DEBUG2                                                            0x16d8
#define mmFBC_IND_LUT0                                                          0x16d9
#define mmFBC_IND_LUT1                                                          0x16da
#define mmFBC_IND_LUT2                                                          0x16db
#define mmFBC_IND_LUT3                                                          0x16dc
#define mmFBC_IND_LUT4                                                          0x16dd
#define mmFBC_IND_LUT5                                                          0x16de
#define mmFBC_IND_LUT6                                                          0x16df
#define mmFBC_IND_LUT7                                                          0x16e0
#define mmFBC_IND_LUT8                                                          0x16e1
#define mmFBC_IND_LUT9                                                          0x16e2
#define mmFBC_IND_LUT10                                                         0x16e3
#define mmFBC_IND_LUT11                                                         0x16e4
#define mmFBC_IND_LUT12                                                         0x16e5
#define mmFBC_IND_LUT13                                                         0x16e6
#define mmFBC_IND_LUT14                                                         0x16e7
#define mmFBC_IND_LUT15                                                         0x16e8
#define mmFBC_CSM_REGION_OFFSET_01                                              0x16e9
#define mmFBC_CSM_REGION_OFFSET_23                                              0x16ea
#define mmFBC_CLIENT_REGION_MASK                                                0x16eb
#define mmFBC_DEBUG_COMP                                                        0x16ec
#define mmFBC_DEBUG_CSR                                                         0x16ed
#define mmFBC_DEBUG_CSR_RDATA                                                   0x16ee
#define mmFBC_DEBUG_CSR_WDATA                                                   0x16ef
#define mmFBC_DEBUG_CSR_RDATA_HI                                                0x16f6
#define mmFBC_DEBUG_CSR_WDATA_HI                                                0x16f7
#define mmFBC_MISC                                                              0x16f0
#define mmFBC_STATUS                                                            0x16f1
#define mmFBC_TEST_DEBUG_INDEX                                                  0x16f4
#define mmFBC_TEST_DEBUG_DATA                                                   0x16f5
#define mmFMT_CLAMP_COMPONENT_R                                                 0x1be8
#define mmFMT0_FMT_CLAMP_COMPONENT_R                                            0x1be8
#define mmFMT1_FMT_CLAMP_COMPONENT_R                                            0x1ee8
#define mmFMT2_FMT_CLAMP_COMPONENT_R                                            0x41e8
#define mmFMT3_FMT_CLAMP_COMPONENT_R                                            0x44e8
#define mmFMT4_FMT_CLAMP_COMPONENT_R                                            0x47e8
#define mmFMT5_FMT_CLAMP_COMPONENT_R                                            0x4ae8
#define mmFMT_CLAMP_COMPONENT_G                                                 0x1be9
#define mmFMT0_FMT_CLAMP_COMPONENT_G                                            0x1be9
#define mmFMT1_FMT_CLAMP_COMPONENT_G                                            0x1ee9
#define mmFMT2_FMT_CLAMP_COMPONENT_G                                            0x41e9
#define mmFMT3_FMT_CLAMP_COMPONENT_G                                            0x44e9
#define mmFMT4_FMT_CLAMP_COMPONENT_G                                            0x47e9
#define mmFMT5_FMT_CLAMP_COMPONENT_G                                            0x4ae9
#define mmFMT_CLAMP_COMPONENT_B                                                 0x1bea
#define mmFMT0_FMT_CLAMP_COMPONENT_B                                            0x1bea
#define mmFMT1_FMT_CLAMP_COMPONENT_B                                            0x1eea
#define mmFMT2_FMT_CLAMP_COMPONENT_B                                            0x41ea
#define mmFMT3_FMT_CLAMP_COMPONENT_B                                            0x44ea
#define mmFMT4_FMT_CLAMP_COMPONENT_B                                            0x47ea
#define mmFMT5_FMT_CLAMP_COMPONENT_B                                            0x4aea
#define mmFMT_DYNAMIC_EXP_CNTL                                                  0x1bed
#define mmFMT0_FMT_DYNAMIC_EXP_CNTL                                             0x1bed
#define mmFMT1_FMT_DYNAMIC_EXP_CNTL                                             0x1eed
#define mmFMT2_FMT_DYNAMIC_EXP_CNTL                                             0x41ed
#define mmFMT3_FMT_DYNAMIC_EXP_CNTL                                             0x44ed
#define mmFMT4_FMT_DYNAMIC_EXP_CNTL                                             0x47ed
#define mmFMT5_FMT_DYNAMIC_EXP_CNTL                                             0x4aed
#define mmFMT_CONTROL                                                           0x1bee
#define mmFMT0_FMT_CONTROL                                                      0x1bee
#define mmFMT1_FMT_CONTROL                                                      0x1eee
#define mmFMT2_FMT_CONTROL                                                      0x41ee
#define mmFMT3_FMT_CONTROL                                                      0x44ee
#define mmFMT4_FMT_CONTROL                                                      0x47ee
#define mmFMT5_FMT_CONTROL                                                      0x4aee
#define mmFMT_FORCE_OUTPUT_CNTL                                                 0x1bef
#define mmFMT0_FMT_FORCE_OUTPUT_CNTL                                            0x1bef
#define mmFMT1_FMT_FORCE_OUTPUT_CNTL                                            0x1eef
#define mmFMT2_FMT_FORCE_OUTPUT_CNTL                                            0x41ef
#define mmFMT3_FMT_FORCE_OUTPUT_CNTL                                            0x44ef
#define mmFMT4_FMT_FORCE_OUTPUT_CNTL                                            0x47ef
#define mmFMT5_FMT_FORCE_OUTPUT_CNTL                                            0x4aef
#define mmFMT_FORCE_DATA_0_1                                                    0x1bf0
#define mmFMT0_FMT_FORCE_DATA_0_1                                               0x1bf0
#define mmFMT1_FMT_FORCE_DATA_0_1                                               0x1ef0
#define mmFMT2_FMT_FORCE_DATA_0_1                                               0x41f0
#define mmFMT3_FMT_FORCE_DATA_0_1                                               0x44f0
#define mmFMT4_FMT_FORCE_DATA_0_1                                               0x47f0
#define mmFMT5_FMT_FORCE_DATA_0_1                                               0x4af0
#define mmFMT_FORCE_DATA_2_3                                                    0x1bf1
#define mmFMT0_FMT_FORCE_DATA_2_3                                               0x1bf1
#define mmFMT1_FMT_FORCE_DATA_2_3                                               0x1ef1
#define mmFMT2_FMT_FORCE_DATA_2_3                                               0x41f1
#define mmFMT3_FMT_FORCE_DATA_2_3                                               0x44f1
#define mmFMT4_FMT_FORCE_DATA_2_3                                               0x47f1
#define mmFMT5_FMT_FORCE_DATA_2_3                                               0x4af1
#define mmFMT_BIT_DEPTH_CONTROL                                                 0x1bf2
#define mmFMT0_FMT_BIT_DEPTH_CONTROL                                            0x1bf2
#define mmFMT1_FMT_BIT_DEPTH_CONTROL                                            0x1ef2
#define mmFMT2_FMT_BIT_DEPTH_CONTROL                                            0x41f2
#define mmFMT3_FMT_BIT_DEPTH_CONTROL                                            0x44f2
#define mmFMT4_FMT_BIT_DEPTH_CONTROL                                            0x47f2
#define mmFMT5_FMT_BIT_DEPTH_CONTROL                                            0x4af2
#define mmFMT_DITHER_RAND_R_SEED                                                0x1bf3
#define mmFMT0_FMT_DITHER_RAND_R_SEED                                           0x1bf3
#define mmFMT1_FMT_DITHER_RAND_R_SEED                                           0x1ef3
#define mmFMT2_FMT_DITHER_RAND_R_SEED                                           0x41f3
#define mmFMT3_FMT_DITHER_RAND_R_SEED                                           0x44f3
#define mmFMT4_FMT_DITHER_RAND_R_SEED                                           0x47f3
#define mmFMT5_FMT_DITHER_RAND_R_SEED                                           0x4af3
#define mmFMT_DITHER_RAND_G_SEED                                                0x1bf4
#define mmFMT0_FMT_DITHER_RAND_G_SEED                                           0x1bf4
#define mmFMT1_FMT_DITHER_RAND_G_SEED                                           0x1ef4
#define mmFMT2_FMT_DITHER_RAND_G_SEED                                           0x41f4
#define mmFMT3_FMT_DITHER_RAND_G_SEED                                           0x44f4
#define mmFMT4_FMT_DITHER_RAND_G_SEED                                           0x47f4
#define mmFMT5_FMT_DITHER_RAND_G_SEED                                           0x4af4
#define mmFMT_DITHER_RAND_B_SEED                                                0x1bf5
#define mmFMT0_FMT_DITHER_RAND_B_SEED                                           0x1bf5
#define mmFMT1_FMT_DITHER_RAND_B_SEED                                           0x1ef5
#define mmFMT2_FMT_DITHER_RAND_B_SEED                                           0x41f5
#define mmFMT3_FMT_DITHER_RAND_B_SEED                                           0x44f5
#define mmFMT4_FMT_DITHER_RAND_B_SEED                                           0x47f5
#define mmFMT5_FMT_DITHER_RAND_B_SEED                                           0x4af5
#define mmFMT_TEMPORAL_DITHER_PATTERN_CONTROL                                   0x1bf6
#define mmFMT0_FMT_TEMPORAL_DITHER_PATTERN_CONTROL                              0x1bf6
#define mmFMT1_FMT_TEMPORAL_DITHER_PATTERN_CONTROL                              0x1ef6
#define mmFMT2_FMT_TEMPORAL_DITHER_PATTERN_CONTROL                              0x41f6
#define mmFMT3_FMT_TEMPORAL_DITHER_PATTERN_CONTROL                              0x44f6
#define mmFMT4_FMT_TEMPORAL_DITHER_PATTERN_CONTROL                              0x47f6
#define mmFMT5_FMT_TEMPORAL_DITHER_PATTERN_CONTROL                              0x4af6
#define mmFMT_TEMPORAL_DITHER_PROGRAMMABLE_PATTERN_S_MATRIX                     0x1bf7
#define mmFMT0_FMT_TEMPORAL_DITHER_PROGRAMMABLE_PATTERN_S_MATRIX                0x1bf7
#define mmFMT1_FMT_TEMPORAL_DITHER_PROGRAMMABLE_PATTERN_S_MATRIX                0x1ef7
#define mmFMT2_FMT_TEMPORAL_DITHER_PROGRAMMABLE_PATTERN_S_MATRIX                0x41f7
#define mmFMT3_FMT_TEMPORAL_DITHER_PROGRAMMABLE_PATTERN_S_MATRIX                0x44f7
#define mmFMT4_FMT_TEMPORAL_DITHER_PROGRAMMABLE_PATTERN_S_MATRIX                0x47f7
#define mmFMT5_FMT_TEMPORAL_DITHER_PROGRAMMABLE_PATTERN_S_MATRIX                0x4af7
#define mmFMT_TEMPORAL_DITHER_PROGRAMMABLE_PATTERN_T_MATRIX                     0x1bf8
#define mmFMT0_FMT_TEMPORAL_DITHER_PROGRAMMABLE_PATTERN_T_MATRIX                0x1bf8
#define mmFMT1_FMT_TEMPORAL_DITHER_PROGRAMMABLE_PATTERN_T_MATRIX                0x1ef8
#define mmFMT2_FMT_TEMPORAL_DITHER_PROGRAMMABLE_PATTERN_T_MATRIX                0x41f8
#define mmFMT3_FMT_TEMPORAL_DITHER_PROGRAMMABLE_PATTERN_T_MATRIX                0x44f8
#define mmFMT4_FMT_TEMPORAL_DITHER_PROGRAMMABLE_PATTERN_T_MATRIX                0x47f8
#define mmFMT5_FMT_TEMPORAL_DITHER_PROGRAMMABLE_PATTERN_T_MATRIX                0x4af8
#define mmFMT_CLAMP_CNTL                                                        0x1bf9
#define mmFMT0_FMT_CLAMP_CNTL                                                   0x1bf9
#define mmFMT1_FMT_CLAMP_CNTL                                                   0x1ef9
#define mmFMT2_FMT_CLAMP_CNTL                                                   0x41f9
#define mmFMT3_FMT_CLAMP_CNTL                                                   0x44f9
#define mmFMT4_FMT_CLAMP_CNTL                                                   0x47f9
#define mmFMT5_FMT_CLAMP_CNTL                                                   0x4af9
#define mmFMT_CRC_CNTL                                                          0x1bfa
#define mmFMT0_FMT_CRC_CNTL                                                     0x1bfa
#define mmFMT1_FMT_CRC_CNTL                                                     0x1efa
#define mmFMT2_FMT_CRC_CNTL                                                     0x41fa
#define mmFMT3_FMT_CRC_CNTL                                                     0x44fa
#define mmFMT4_FMT_CRC_CNTL                                                     0x47fa
#define mmFMT5_FMT_CRC_CNTL                                                     0x4afa
#define mmFMT_CRC_SIG_RED_GREEN_MASK                                            0x1bfb
#define mmFMT0_FMT_CRC_SIG_RED_GREEN_MASK                                       0x1bfb
#define mmFMT1_FMT_CRC_SIG_RED_GREEN_MASK                                       0x1efb
#define mmFMT2_FMT_CRC_SIG_RED_GREEN_MASK                                       0x41fb
#define mmFMT3_FMT_CRC_SIG_RED_GREEN_MASK                                       0x44fb
#define mmFMT4_FMT_CRC_SIG_RED_GREEN_MASK                                       0x47fb
#define mmFMT5_FMT_CRC_SIG_RED_GREEN_MASK                                       0x4afb
#define mmFMT_CRC_SIG_BLUE_CONTROL_MASK                                         0x1bfc
#define mmFMT0_FMT_CRC_SIG_BLUE_CONTROL_MASK                                    0x1bfc
#define mmFMT1_FMT_CRC_SIG_BLUE_CONTROL_MASK                                    0x1efc
#define mmFMT2_FMT_CRC_SIG_BLUE_CONTROL_MASK                                    0x41fc
#define mmFMT3_FMT_CRC_SIG_BLUE_CONTROL_MASK                                    0x44fc
#define mmFMT4_FMT_CRC_SIG_BLUE_CONTROL_MASK                                    0x47fc
#define mmFMT5_FMT_CRC_SIG_BLUE_CONTROL_MASK                                    0x4afc
#define mmFMT_CRC_SIG_RED_GREEN                                                 0x1bfd
#define mmFMT0_FMT_CRC_SIG_RED_GREEN                                            0x1bfd
#define mmFMT1_FMT_CRC_SIG_RED_GREEN                                            0x1efd
#define mmFMT2_FMT_CRC_SIG_RED_GREEN                                            0x41fd
#define mmFMT3_FMT_CRC_SIG_RED_GREEN                                            0x44fd
#define mmFMT4_FMT_CRC_SIG_RED_GREEN                                            0x47fd
#define mmFMT5_FMT_CRC_SIG_RED_GREEN                                            0x4afd
#define mmFMT_CRC_SIG_BLUE_CONTROL                                              0x1bfe
#define mmFMT0_FMT_CRC_SIG_BLUE_CONTROL                                         0x1bfe
#define mmFMT1_FMT_CRC_SIG_BLUE_CONTROL                                         0x1efe
#define mmFMT2_FMT_CRC_SIG_BLUE_CONTROL                                         0x41fe
#define mmFMT3_FMT_CRC_SIG_BLUE_CONTROL                                         0x44fe
#define mmFMT4_FMT_CRC_SIG_BLUE_CONTROL                                         0x47fe
#define mmFMT5_FMT_CRC_SIG_BLUE_CONTROL                                         0x4afe
#define mmFMT_DEBUG_CNTL                                                        0x1bff
#define mmFMT0_FMT_DEBUG_CNTL                                                   0x1bff
#define mmFMT1_FMT_DEBUG_CNTL                                                   0x1eff
#define mmFMT2_FMT_DEBUG_CNTL                                                   0x41ff
#define mmFMT3_FMT_DEBUG_CNTL                                                   0x44ff
#define mmFMT4_FMT_DEBUG_CNTL                                                   0x47ff
#define mmFMT5_FMT_DEBUG_CNTL                                                   0x4aff
#define mmFMT_TEST_DEBUG_INDEX                                                  0x1beb
#define mmFMT0_FMT_TEST_DEBUG_INDEX                                             0x1beb
#define mmFMT1_FMT_TEST_DEBUG_INDEX                                             0x1eeb
#define mmFMT2_FMT_TEST_DEBUG_INDEX                                             0x41eb
#define mmFMT3_FMT_TEST_DEBUG_INDEX                                             0x44eb
#define mmFMT4_FMT_TEST_DEBUG_INDEX                                             0x47eb
#define mmFMT5_FMT_TEST_DEBUG_INDEX                                             0x4aeb
#define mmFMT_TEST_DEBUG_DATA                                                   0x1bec
#define mmFMT0_FMT_TEST_DEBUG_DATA                                              0x1bec
#define mmFMT1_FMT_TEST_DEBUG_DATA                                              0x1eec
#define mmFMT2_FMT_TEST_DEBUG_DATA                                              0x41ec
#define mmFMT3_FMT_TEST_DEBUG_DATA                                              0x44ec
#define mmFMT4_FMT_TEST_DEBUG_DATA                                              0x47ec
#define mmFMT5_FMT_TEST_DEBUG_DATA                                              0x4aec
#define ixFMT_DEBUG0                                                            0x1
#define ixFMT_DEBUG1                                                            0x2
#define ixFMT_DEBUG2                                                            0x3
#define ixFMT_DEBUG_ID                                                          0x0
#define mmLB_DATA_FORMAT                                                        0x1ac0
#define mmLB0_LB_DATA_FORMAT                                                    0x1ac0
#define mmLB1_LB_DATA_FORMAT                                                    0x1dc0
#define mmLB2_LB_DATA_FORMAT                                                    0x40c0
#define mmLB3_LB_DATA_FORMAT                                                    0x43c0
#define mmLB4_LB_DATA_FORMAT                                                    0x46c0
#define mmLB5_LB_DATA_FORMAT                                                    0x49c0
#define mmLB_MEMORY_CTRL                                                        0x1ac1
#define mmLB0_LB_MEMORY_CTRL                                                    0x1ac1
#define mmLB1_LB_MEMORY_CTRL                                                    0x1dc1
#define mmLB2_LB_MEMORY_CTRL                                                    0x40c1
#define mmLB3_LB_MEMORY_CTRL                                                    0x43c1
#define mmLB4_LB_MEMORY_CTRL                                                    0x46c1
#define mmLB5_LB_MEMORY_CTRL                                                    0x49c1
#define mmLB_MEMORY_SIZE_STATUS                                                 0x1ac2
#define mmLB0_LB_MEMORY_SIZE_STATUS                                             0x1ac2
#define mmLB1_LB_MEMORY_SIZE_STATUS                                             0x1dc2
#define mmLB2_LB_MEMORY_SIZE_STATUS                                             0x40c2
#define mmLB3_LB_MEMORY_SIZE_STATUS                                             0x43c2
#define mmLB4_LB_MEMORY_SIZE_STATUS                                             0x46c2
#define mmLB5_LB_MEMORY_SIZE_STATUS                                             0x49c2
#define mmLB_DESKTOP_HEIGHT                                                     0x1ac3
#define mmLB0_LB_DESKTOP_HEIGHT                                                 0x1ac3
#define mmLB1_LB_DESKTOP_HEIGHT                                                 0x1dc3
#define mmLB2_LB_DESKTOP_HEIGHT                                                 0x40c3
#define mmLB3_LB_DESKTOP_HEIGHT                                                 0x43c3
#define mmLB4_LB_DESKTOP_HEIGHT                                                 0x46c3
#define mmLB5_LB_DESKTOP_HEIGHT                                                 0x49c3
#define mmLB_VLINE_START_END                                                    0x1ac4
#define mmLB0_LB_VLINE_START_END                                                0x1ac4
#define mmLB1_LB_VLINE_START_END                                                0x1dc4
#define mmLB2_LB_VLINE_START_END                                                0x40c4
#define mmLB3_LB_VLINE_START_END                                                0x43c4
#define mmLB4_LB_VLINE_START_END                                                0x46c4
#define mmLB5_LB_VLINE_START_END                                                0x49c4
#define mmLB_VLINE2_START_END                                                   0x1ac5
#define mmLB0_LB_VLINE2_START_END                                               0x1ac5
#define mmLB1_LB_VLINE2_START_END                                               0x1dc5
#define mmLB2_LB_VLINE2_START_END                                               0x40c5
#define mmLB3_LB_VLINE2_START_END                                               0x43c5
#define mmLB4_LB_VLINE2_START_END                                               0x46c5
#define mmLB5_LB_VLINE2_START_END                                               0x49c5
#define mmLB_V_COUNTER                                                          0x1ac6
#define mmLB0_LB_V_COUNTER                                                      0x1ac6
#define mmLB1_LB_V_COUNTER                                                      0x1dc6
#define mmLB2_LB_V_COUNTER                                                      0x40c6
#define mmLB3_LB_V_COUNTER                                                      0x43c6
#define mmLB4_LB_V_COUNTER                                                      0x46c6
#define mmLB5_LB_V_COUNTER                                                      0x49c6
#define mmLB_SNAPSHOT_V_COUNTER                                                 0x1ac7
#define mmLB0_LB_SNAPSHOT_V_COUNTER                                             0x1ac7
#define mmLB1_LB_SNAPSHOT_V_COUNTER                                             0x1dc7
#define mmLB2_LB_SNAPSHOT_V_COUNTER                                             0x40c7
#define mmLB3_LB_SNAPSHOT_V_COUNTER                                             0x43c7
#define mmLB4_LB_SNAPSHOT_V_COUNTER                                             0x46c7
#define mmLB5_LB_SNAPSHOT_V_COUNTER                                             0x49c7
#define mmLB_INTERRUPT_MASK                                                     0x1ac8
#define mmLB0_LB_INTERRUPT_MASK                                                 0x1ac8
#define mmLB1_LB_INTERRUPT_MASK                                                 0x1dc8
#define mmLB2_LB_INTERRUPT_MASK                                                 0x40c8
#define mmLB3_LB_INTERRUPT_MASK                                                 0x43c8
#define mmLB4_LB_INTERRUPT_MASK                                                 0x46c8
#define mmLB5_LB_INTERRUPT_MASK                                                 0x49c8
#define mmLB_VLINE_STATUS                                                       0x1ac9
#define mmLB0_LB_VLINE_STATUS                                                   0x1ac9
#define mmLB1_LB_VLINE_STATUS                                                   0x1dc9
#define mmLB2_LB_VLINE_STATUS                                                   0x40c9
#define mmLB3_LB_VLINE_STATUS                                                   0x43c9
#define mmLB4_LB_VLINE_STATUS                                                   0x46c9
#define mmLB5_LB_VLINE_STATUS                                                   0x49c9
#define mmLB_VLINE2_STATUS                                                      0x1aca
#define mmLB0_LB_VLINE2_STATUS                                                  0x1aca
#define mmLB1_LB_VLINE2_STATUS                                                  0x1dca
#define mmLB2_LB_VLINE2_STATUS                                                  0x40ca
#define mmLB3_LB_VLINE2_STATUS                                                  0x43ca
#define mmLB4_LB_VLINE2_STATUS                                                  0x46ca
#define mmLB5_LB_VLINE2_STATUS                                                  0x49ca
#define mmLB_VBLANK_STATUS                                                      0x1acb
#define mmLB0_LB_VBLANK_STATUS                                                  0x1acb
#define mmLB1_LB_VBLANK_STATUS                                                  0x1dcb
#define mmLB2_LB_VBLANK_STATUS                                                  0x40cb
#define mmLB3_LB_VBLANK_STATUS                                                  0x43cb
#define mmLB4_LB_VBLANK_STATUS                                                  0x46cb
#define mmLB5_LB_VBLANK_STATUS                                                  0x49cb
#define mmLB_SYNC_RESET_SEL                                                     0x1acc
#define mmLB0_LB_SYNC_RESET_SEL                                                 0x1acc
#define mmLB1_LB_SYNC_RESET_SEL                                                 0x1dcc
#define mmLB2_LB_SYNC_RESET_SEL                                                 0x40cc
#define mmLB3_LB_SYNC_RESET_SEL                                                 0x43cc
#define mmLB4_LB_SYNC_RESET_SEL                                                 0x46cc
#define mmLB5_LB_SYNC_RESET_SEL                                                 0x49cc
#define mmLB_BLACK_KEYER_R_CR                                                   0x1acd
#define mmLB0_LB_BLACK_KEYER_R_CR                                               0x1acd
#define mmLB1_LB_BLACK_KEYER_R_CR                                               0x1dcd
#define mmLB2_LB_BLACK_KEYER_R_CR                                               0x40cd
#define mmLB3_LB_BLACK_KEYER_R_CR                                               0x43cd
#define mmLB4_LB_BLACK_KEYER_R_CR                                               0x46cd
#define mmLB5_LB_BLACK_KEYER_R_CR                                               0x49cd
#define mmLB_BLACK_KEYER_G_Y                                                    0x1ace
#define mmLB0_LB_BLACK_KEYER_G_Y                                                0x1ace
#define mmLB1_LB_BLACK_KEYER_G_Y                                                0x1dce
#define mmLB2_LB_BLACK_KEYER_G_Y                                                0x40ce
#define mmLB3_LB_BLACK_KEYER_G_Y                                                0x43ce
#define mmLB4_LB_BLACK_KEYER_G_Y                                                0x46ce
#define mmLB5_LB_BLACK_KEYER_G_Y                                                0x49ce
#define mmLB_BLACK_KEYER_B_CB                                                   0x1acf
#define mmLB0_LB_BLACK_KEYER_B_CB                                               0x1acf
#define mmLB1_LB_BLACK_KEYER_B_CB                                               0x1dcf
#define mmLB2_LB_BLACK_KEYER_B_CB                                               0x40cf
#define mmLB3_LB_BLACK_KEYER_B_CB                                               0x43cf
#define mmLB4_LB_BLACK_KEYER_B_CB                                               0x46cf
#define mmLB5_LB_BLACK_KEYER_B_CB                                               0x49cf
#define mmLB_KEYER_COLOR_CTRL                                                   0x1ad0
#define mmLB0_LB_KEYER_COLOR_CTRL                                               0x1ad0
#define mmLB1_LB_KEYER_COLOR_CTRL                                               0x1dd0
#define mmLB2_LB_KEYER_COLOR_CTRL                                               0x40d0
#define mmLB3_LB_KEYER_COLOR_CTRL                                               0x43d0
#define mmLB4_LB_KEYER_COLOR_CTRL                                               0x46d0
#define mmLB5_LB_KEYER_COLOR_CTRL                                               0x49d0
#define mmLB_KEYER_COLOR_R_CR                                                   0x1ad1
#define mmLB0_LB_KEYER_COLOR_R_CR                                               0x1ad1
#define mmLB1_LB_KEYER_COLOR_R_CR                                               0x1dd1
#define mmLB2_LB_KEYER_COLOR_R_CR                                               0x40d1
#define mmLB3_LB_KEYER_COLOR_R_CR                                               0x43d1
#define mmLB4_LB_KEYER_COLOR_R_CR                                               0x46d1
#define mmLB5_LB_KEYER_COLOR_R_CR                                               0x49d1
#define mmLB_KEYER_COLOR_G_Y                                                    0x1ad2
#define mmLB0_LB_KEYER_COLOR_G_Y                                                0x1ad2
#define mmLB1_LB_KEYER_COLOR_G_Y                                                0x1dd2
#define mmLB2_LB_KEYER_COLOR_G_Y                                                0x40d2
#define mmLB3_LB_KEYER_COLOR_G_Y                                                0x43d2
#define mmLB4_LB_KEYER_COLOR_G_Y                                                0x46d2
#define mmLB5_LB_KEYER_COLOR_G_Y                                                0x49d2
#define mmLB_KEYER_COLOR_B_CB                                                   0x1ad3
#define mmLB0_LB_KEYER_COLOR_B_CB                                               0x1ad3
#define mmLB1_LB_KEYER_COLOR_B_CB                                               0x1dd3
#define mmLB2_LB_KEYER_COLOR_B_CB                                               0x40d3
#define mmLB3_LB_KEYER_COLOR_B_CB                                               0x43d3
#define mmLB4_LB_KEYER_COLOR_B_CB                                               0x46d3
#define mmLB5_LB_KEYER_COLOR_B_CB                                               0x49d3
#define mmLB_KEYER_COLOR_REP_R_CR                                               0x1ad4
#define mmLB0_LB_KEYER_COLOR_REP_R_CR                                           0x1ad4
#define mmLB1_LB_KEYER_COLOR_REP_R_CR                                           0x1dd4
#define mmLB2_LB_KEYER_COLOR_REP_R_CR                                           0x40d4
#define mmLB3_LB_KEYER_COLOR_REP_R_CR                                           0x43d4
#define mmLB4_LB_KEYER_COLOR_REP_R_CR                                           0x46d4
#define mmLB5_LB_KEYER_COLOR_REP_R_CR                                           0x49d4
#define mmLB_KEYER_COLOR_REP_G_Y                                                0x1ad5
#define mmLB0_LB_KEYER_COLOR_REP_G_Y                                            0x1ad5
#define mmLB1_LB_KEYER_COLOR_REP_G_Y                                            0x1dd5
#define mmLB2_LB_KEYER_COLOR_REP_G_Y                                            0x40d5
#define mmLB3_LB_KEYER_COLOR_REP_G_Y                                            0x43d5
#define mmLB4_LB_KEYER_COLOR_REP_G_Y                                            0x46d5
#define mmLB5_LB_KEYER_COLOR_REP_G_Y                                            0x49d5
#define mmLB_KEYER_COLOR_REP_B_CB                                               0x1ad6
#define mmLB0_LB_KEYER_COLOR_REP_B_CB                                           0x1ad6
#define mmLB1_LB_KEYER_COLOR_REP_B_CB                                           0x1dd6
#define mmLB2_LB_KEYER_COLOR_REP_B_CB                                           0x40d6
#define mmLB3_LB_KEYER_COLOR_REP_B_CB                                           0x43d6
#define mmLB4_LB_KEYER_COLOR_REP_B_CB                                           0x46d6
#define mmLB5_LB_KEYER_COLOR_REP_B_CB                                           0x49d6
#define mmLB_BUFFER_LEVEL_STATUS                                                0x1ad7
#define mmLB0_LB_BUFFER_LEVEL_STATUS                                            0x1ad7
#define mmLB1_LB_BUFFER_LEVEL_STATUS                                            0x1dd7
#define mmLB2_LB_BUFFER_LEVEL_STATUS                                            0x40d7
#define mmLB3_LB_BUFFER_LEVEL_STATUS                                            0x43d7
#define mmLB4_LB_BUFFER_LEVEL_STATUS                                            0x46d7
#define mmLB5_LB_BUFFER_LEVEL_STATUS                                            0x49d7
#define mmLB_BUFFER_URGENCY_CTRL                                                0x1ad8
#define mmLB0_LB_BUFFER_URGENCY_CTRL                                            0x1ad8
#define mmLB1_LB_BUFFER_URGENCY_CTRL                                            0x1dd8
#define mmLB2_LB_BUFFER_URGENCY_CTRL                                            0x40d8
#define mmLB3_LB_BUFFER_URGENCY_CTRL                                            0x43d8
#define mmLB4_LB_BUFFER_URGENCY_CTRL                                            0x46d8
#define mmLB5_LB_BUFFER_URGENCY_CTRL                                            0x49d8
#define mmLB_BUFFER_URGENCY_STATUS                                              0x1ad9
#define mmLB0_LB_BUFFER_URGENCY_STATUS                                          0x1ad9
#define mmLB1_LB_BUFFER_URGENCY_STATUS                                          0x1dd9
#define mmLB2_LB_BUFFER_URGENCY_STATUS                                          0x40d9
#define mmLB3_LB_BUFFER_URGENCY_STATUS                                          0x43d9
#define mmLB4_LB_BUFFER_URGENCY_STATUS                                          0x46d9
#define mmLB5_LB_BUFFER_URGENCY_STATUS                                          0x49d9
#define mmLB_BUFFER_STATUS                                                      0x1ada
#define mmLB0_LB_BUFFER_STATUS                                                  0x1ada
#define mmLB1_LB_BUFFER_STATUS                                                  0x1dda
#define mmLB2_LB_BUFFER_STATUS                                                  0x40da
#define mmLB3_LB_BUFFER_STATUS                                                  0x43da
#define mmLB4_LB_BUFFER_STATUS                                                  0x46da
#define mmLB5_LB_BUFFER_STATUS                                                  0x49da
#define mmLB_NO_OUTSTANDING_REQ_STATUS                                          0x1adc
#define mmLB0_LB_NO_OUTSTANDING_REQ_STATUS                                      0x1adc
#define mmLB1_LB_NO_OUTSTANDING_REQ_STATUS                                      0x1ddc
#define mmLB2_LB_NO_OUTSTANDING_REQ_STATUS                                      0x40dc
#define mmLB3_LB_NO_OUTSTANDING_REQ_STATUS                                      0x43dc
#define mmLB4_LB_NO_OUTSTANDING_REQ_STATUS                                      0x46dc
#define mmLB5_LB_NO_OUTSTANDING_REQ_STATUS                                      0x49dc
#define mmMVP_AFR_FLIP_MODE                                                     0x1ae0
#define mmLB0_MVP_AFR_FLIP_MODE                                                 0x1ae0
#define mmLB1_MVP_AFR_FLIP_MODE                                                 0x1de0
#define mmLB2_MVP_AFR_FLIP_MODE                                                 0x40e0
#define mmLB3_MVP_AFR_FLIP_MODE                                                 0x43e0
#define mmLB4_MVP_AFR_FLIP_MODE                                                 0x46e0
#define mmLB5_MVP_AFR_FLIP_MODE                                                 0x49e0
#define mmMVP_AFR_FLIP_FIFO_CNTL                                                0x1ae1
#define mmLB0_MVP_AFR_FLIP_FIFO_CNTL                                            0x1ae1
#define mmLB1_MVP_AFR_FLIP_FIFO_CNTL                                            0x1de1
#define mmLB2_MVP_AFR_FLIP_FIFO_CNTL                                            0x40e1
#define mmLB3_MVP_AFR_FLIP_FIFO_CNTL                                            0x43e1
#define mmLB4_MVP_AFR_FLIP_FIFO_CNTL                                            0x46e1
#define mmLB5_MVP_AFR_FLIP_FIFO_CNTL                                            0x49e1
#define mmMVP_FLIP_LINE_NUM_INSERT                                              0x1ae2
#define mmLB0_MVP_FLIP_LINE_NUM_INSERT                                          0x1ae2
#define mmLB1_MVP_FLIP_LINE_NUM_INSERT                                          0x1de2
#define mmLB2_MVP_FLIP_LINE_NUM_INSERT                                          0x40e2
#define mmLB3_MVP_FLIP_LINE_NUM_INSERT                                          0x43e2
#define mmLB4_MVP_FLIP_LINE_NUM_INSERT                                          0x46e2
#define mmLB5_MVP_FLIP_LINE_NUM_INSERT                                          0x49e2
#define mmDC_MVP_LB_CONTROL                                                     0x1ae3
#define mmLB0_DC_MVP_LB_CONTROL                                                 0x1ae3
#define mmLB1_DC_MVP_LB_CONTROL                                                 0x1de3
#define mmLB2_DC_MVP_LB_CONTROL                                                 0x40e3
#define mmLB3_DC_MVP_LB_CONTROL                                                 0x43e3
#define mmLB4_DC_MVP_LB_CONTROL                                                 0x46e3
#define mmLB5_DC_MVP_LB_CONTROL                                                 0x49e3
#define mmLB_DEBUG                                                              0x1ae4
#define mmLB0_LB_DEBUG                                                          0x1ae4
#define mmLB1_LB_DEBUG                                                          0x1de4
#define mmLB2_LB_DEBUG                                                          0x40e4
#define mmLB3_LB_DEBUG                                                          0x43e4
#define mmLB4_LB_DEBUG                                                          0x46e4
#define mmLB5_LB_DEBUG                                                          0x49e4
#define mmLB_DEBUG2                                                             0x1ae5
#define mmLB0_LB_DEBUG2                                                         0x1ae5
#define mmLB1_LB_DEBUG2                                                         0x1de5
#define mmLB2_LB_DEBUG2                                                         0x40e5
#define mmLB3_LB_DEBUG2                                                         0x43e5
#define mmLB4_LB_DEBUG2                                                         0x46e5
#define mmLB5_LB_DEBUG2                                                         0x49e5
#define mmLB_DEBUG3                                                             0x1ae6
#define mmLB0_LB_DEBUG3                                                         0x1ae6
#define mmLB1_LB_DEBUG3                                                         0x1de6
#define mmLB2_LB_DEBUG3                                                         0x40e6
#define mmLB3_LB_DEBUG3                                                         0x43e6
#define mmLB4_LB_DEBUG3                                                         0x46e6
#define mmLB5_LB_DEBUG3                                                         0x49e6
#define mmLB_TEST_DEBUG_INDEX                                                   0x1afe
#define mmLB0_LB_TEST_DEBUG_INDEX                                               0x1afe
#define mmLB1_LB_TEST_DEBUG_INDEX                                               0x1dfe
#define mmLB2_LB_TEST_DEBUG_INDEX                                               0x40fe
#define mmLB3_LB_TEST_DEBUG_INDEX                                               0x43fe
#define mmLB4_LB_TEST_DEBUG_INDEX                                               0x46fe
#define mmLB5_LB_TEST_DEBUG_INDEX                                               0x49fe
#define mmLB_TEST_DEBUG_DATA                                                    0x1aff
#define mmLB0_LB_TEST_DEBUG_DATA                                                0x1aff
#define mmLB1_LB_TEST_DEBUG_DATA                                                0x1dff
#define mmLB2_LB_TEST_DEBUG_DATA                                                0x40ff
#define mmLB3_LB_TEST_DEBUG_DATA                                                0x43ff
#define mmLB4_LB_TEST_DEBUG_DATA                                                0x46ff
#define mmLB5_LB_TEST_DEBUG_DATA                                                0x49ff
#define mmMVP_CONTROL1                                                          0x1680
#define mmMVP_CONTROL2                                                          0x1681
#define mmMVP_FIFO_CONTROL                                                      0x1682
#define mmMVP_FIFO_STATUS                                                       0x1683
#define mmMVP_SLAVE_STATUS                                                      0x1684
#define mmMVP_INBAND_CNTL_CAP                                                   0x1685
#define mmMVP_BLACK_KEYER                                                       0x1686
#define mmMVP_CRC_CNTL                                                          0x1687
#define mmMVP_CRC_RESULT_BLUE_GREEN                                             0x1688
#define mmMVP_CRC_RESULT_RED                                                    0x1689
#define mmMVP_CONTROL3                                                          0x168a
#define mmMVP_RECEIVE_CNT_CNTL1                                                 0x168b
#define mmMVP_RECEIVE_CNT_CNTL2                                                 0x168c
#define mmMVP_DEBUG                                                             0x168f
#define mmMVP_TEST_DEBUG_INDEX                                                  0x168d
#define mmMVP_TEST_DEBUG_DATA                                                   0x168e
#define ixMVP_DEBUG_12                                                          0xc
#define ixMVP_DEBUG_13                                                          0xd
#define ixMVP_DEBUG_14                                                          0xe
#define ixMVP_DEBUG_15                                                          0xf
#define ixMVP_DEBUG_16                                                          0x10
#define ixMVP_DEBUG_17                                                          0x11
#define mmSCL_COEF_RAM_SELECT                                                   0x1b40
#define mmSCL0_SCL_COEF_RAM_SELECT                                              0x1b40
#define mmSCL1_SCL_COEF_RAM_SELECT                                              0x1e40
#define mmSCL2_SCL_COEF_RAM_SELECT                                              0x4140
#define mmSCL3_SCL_COEF_RAM_SELECT                                              0x4440
#define mmSCL4_SCL_COEF_RAM_SELECT                                              0x4740
#define mmSCL5_SCL_COEF_RAM_SELECT                                              0x4a40
#define mmSCL_COEF_RAM_TAP_DATA                                                 0x1b41
#define mmSCL0_SCL_COEF_RAM_TAP_DATA                                            0x1b41
#define mmSCL1_SCL_COEF_RAM_TAP_DATA                                            0x1e41
#define mmSCL2_SCL_COEF_RAM_TAP_DATA                                            0x4141
#define mmSCL3_SCL_COEF_RAM_TAP_DATA                                            0x4441
#define mmSCL4_SCL_COEF_RAM_TAP_DATA                                            0x4741
#define mmSCL5_SCL_COEF_RAM_TAP_DATA                                            0x4a41
#define mmSCL_MODE                                                              0x1b42
#define mmSCL0_SCL_MODE                                                         0x1b42
#define mmSCL1_SCL_MODE                                                         0x1e42
#define mmSCL2_SCL_MODE                                                         0x4142
#define mmSCL3_SCL_MODE                                                         0x4442
#define mmSCL4_SCL_MODE                                                         0x4742
#define mmSCL5_SCL_MODE                                                         0x4a42
#define mmSCL_TAP_CONTROL                                                       0x1b43
#define mmSCL0_SCL_TAP_CONTROL                                                  0x1b43
#define mmSCL1_SCL_TAP_CONTROL                                                  0x1e43
#define mmSCL2_SCL_TAP_CONTROL                                                  0x4143
#define mmSCL3_SCL_TAP_CONTROL                                                  0x4443
#define mmSCL4_SCL_TAP_CONTROL                                                  0x4743
#define mmSCL5_SCL_TAP_CONTROL                                                  0x4a43
#define mmSCL_CONTROL                                                           0x1b44
#define mmSCL0_SCL_CONTROL                                                      0x1b44
#define mmSCL1_SCL_CONTROL                                                      0x1e44
#define mmSCL2_SCL_CONTROL                                                      0x4144
#define mmSCL3_SCL_CONTROL                                                      0x4444
#define mmSCL4_SCL_CONTROL                                                      0x4744
#define mmSCL5_SCL_CONTROL                                                      0x4a44
#define mmSCL_BYPASS_CONTROL                                                    0x1b45
#define mmSCL0_SCL_BYPASS_CONTROL                                               0x1b45
#define mmSCL1_SCL_BYPASS_CONTROL                                               0x1e45
#define mmSCL2_SCL_BYPASS_CONTROL                                               0x4145
#define mmSCL3_SCL_BYPASS_CONTROL                                               0x4445
#define mmSCL4_SCL_BYPASS_CONTROL                                               0x4745
#define mmSCL5_SCL_BYPASS_CONTROL                                               0x4a45
#define mmSCL_MANUAL_REPLICATE_CONTROL                                          0x1b46
#define mmSCL0_SCL_MANUAL_REPLICATE_CONTROL                                     0x1b46
#define mmSCL1_SCL_MANUAL_REPLICATE_CONTROL                                     0x1e46
#define mmSCL2_SCL_MANUAL_REPLICATE_CONTROL                                     0x4146
#define mmSCL3_SCL_MANUAL_REPLICATE_CONTROL                                     0x4446
#define mmSCL4_SCL_MANUAL_REPLICATE_CONTROL                                     0x4746
#define mmSCL5_SCL_MANUAL_REPLICATE_CONTROL                                     0x4a46
#define mmSCL_AUTOMATIC_MODE_CONTROL                                            0x1b47
#define mmSCL0_SCL_AUTOMATIC_MODE_CONTROL                                       0x1b47
#define mmSCL1_SCL_AUTOMATIC_MODE_CONTROL                                       0x1e47
#define mmSCL2_SCL_AUTOMATIC_MODE_CONTROL                                       0x4147
#define mmSCL3_SCL_AUTOMATIC_MODE_CONTROL                                       0x4447
#define mmSCL4_SCL_AUTOMATIC_MODE_CONTROL                                       0x4747
#define mmSCL5_SCL_AUTOMATIC_MODE_CONTROL                                       0x4a47
#define mmSCL_HORZ_FILTER_CONTROL                                               0x1b48
#define mmSCL0_SCL_HORZ_FILTER_CONTROL                                          0x1b48
#define mmSCL1_SCL_HORZ_FILTER_CONTROL                                          0x1e48
#define mmSCL2_SCL_HORZ_FILTER_CONTROL                                          0x4148
#define mmSCL3_SCL_HORZ_FILTER_CONTROL                                          0x4448
#define mmSCL4_SCL_HORZ_FILTER_CONTROL                                          0x4748
#define mmSCL5_SCL_HORZ_FILTER_CONTROL                                          0x4a48
#define mmSCL_HORZ_FILTER_SCALE_RATIO                                           0x1b49
#define mmSCL0_SCL_HORZ_FILTER_SCALE_RATIO                                      0x1b49
#define mmSCL1_SCL_HORZ_FILTER_SCALE_RATIO                                      0x1e49
#define mmSCL2_SCL_HORZ_FILTER_SCALE_RATIO                                      0x4149
#define mmSCL3_SCL_HORZ_FILTER_SCALE_RATIO                                      0x4449
#define mmSCL4_SCL_HORZ_FILTER_SCALE_RATIO                                      0x4749
#define mmSCL5_SCL_HORZ_FILTER_SCALE_RATIO                                      0x4a49
#define mmSCL_HORZ_FILTER_INIT                                                  0x1b4a
#define mmSCL0_SCL_HORZ_FILTER_INIT                                             0x1b4a
#define mmSCL1_SCL_HORZ_FILTER_INIT                                             0x1e4a
#define mmSCL2_SCL_HORZ_FILTER_INIT                                             0x414a
#define mmSCL3_SCL_HORZ_FILTER_INIT                                             0x444a
#define mmSCL4_SCL_HORZ_FILTER_INIT                                             0x474a
#define mmSCL5_SCL_HORZ_FILTER_INIT                                             0x4a4a
#define mmSCL_VERT_FILTER_CONTROL                                               0x1b4b
#define mmSCL0_SCL_VERT_FILTER_CONTROL                                          0x1b4b
#define mmSCL1_SCL_VERT_FILTER_CONTROL                                          0x1e4b
#define mmSCL2_SCL_VERT_FILTER_CONTROL                                          0x414b
#define mmSCL3_SCL_VERT_FILTER_CONTROL                                          0x444b
#define mmSCL4_SCL_VERT_FILTER_CONTROL                                          0x474b
#define mmSCL5_SCL_VERT_FILTER_CONTROL                                          0x4a4b
#define mmSCL_VERT_FILTER_SCALE_RATIO                                           0x1b4c
#define mmSCL0_SCL_VERT_FILTER_SCALE_RATIO                                      0x1b4c
#define mmSCL1_SCL_VERT_FILTER_SCALE_RATIO                                      0x1e4c
#define mmSCL2_SCL_VERT_FILTER_SCALE_RATIO                                      0x414c
#define mmSCL3_SCL_VERT_FILTER_SCALE_RATIO                                      0x444c
#define mmSCL4_SCL_VERT_FILTER_SCALE_RATIO                                      0x474c
#define mmSCL5_SCL_VERT_FILTER_SCALE_RATIO                                      0x4a4c
#define mmSCL_VERT_FILTER_INIT                                                  0x1b4d
#define mmSCL0_SCL_VERT_FILTER_INIT                                             0x1b4d
#define mmSCL1_SCL_VERT_FILTER_INIT                                             0x1e4d
#define mmSCL2_SCL_VERT_FILTER_INIT                                             0x414d
#define mmSCL3_SCL_VERT_FILTER_INIT                                             0x444d
#define mmSCL4_SCL_VERT_FILTER_INIT                                             0x474d
#define mmSCL5_SCL_VERT_FILTER_INIT                                             0x4a4d
#define mmSCL_VERT_FILTER_INIT_BOT                                              0x1b4e
#define mmSCL0_SCL_VERT_FILTER_INIT_BOT                                         0x1b4e
#define mmSCL1_SCL_VERT_FILTER_INIT_BOT                                         0x1e4e
#define mmSCL2_SCL_VERT_FILTER_INIT_BOT                                         0x414e
#define mmSCL3_SCL_VERT_FILTER_INIT_BOT                                         0x444e
#define mmSCL4_SCL_VERT_FILTER_INIT_BOT                                         0x474e
#define mmSCL5_SCL_VERT_FILTER_INIT_BOT                                         0x4a4e
#define mmSCL_ROUND_OFFSET                                                      0x1b4f
#define mmSCL0_SCL_ROUND_OFFSET                                                 0x1b4f
#define mmSCL1_SCL_ROUND_OFFSET                                                 0x1e4f
#define mmSCL2_SCL_ROUND_OFFSET                                                 0x414f
#define mmSCL3_SCL_ROUND_OFFSET                                                 0x444f
#define mmSCL4_SCL_ROUND_OFFSET                                                 0x474f
#define mmSCL5_SCL_ROUND_OFFSET                                                 0x4a4f
#define mmSCL_UPDATE                                                            0x1b51
#define mmSCL0_SCL_UPDATE                                                       0x1b51
#define mmSCL1_SCL_UPDATE                                                       0x1e51
#define mmSCL2_SCL_UPDATE                                                       0x4151
#define mmSCL3_SCL_UPDATE                                                       0x4451
#define mmSCL4_SCL_UPDATE                                                       0x4751
#define mmSCL5_SCL_UPDATE                                                       0x4a51
#define mmSCL_F_SHARP_CONTROL                                                   0x1b53
#define mmSCL0_SCL_F_SHARP_CONTROL                                              0x1b53
#define mmSCL1_SCL_F_SHARP_CONTROL                                              0x1e53
#define mmSCL2_SCL_F_SHARP_CONTROL                                              0x4153
#define mmSCL3_SCL_F_SHARP_CONTROL                                              0x4453
#define mmSCL4_SCL_F_SHARP_CONTROL                                              0x4753
#define mmSCL5_SCL_F_SHARP_CONTROL                                              0x4a53
#define mmSCL_ALU_CONTROL                                                       0x1b54
#define mmSCL0_SCL_ALU_CONTROL                                                  0x1b54
#define mmSCL1_SCL_ALU_CONTROL                                                  0x1e54
#define mmSCL2_SCL_ALU_CONTROL                                                  0x4154
#define mmSCL3_SCL_ALU_CONTROL                                                  0x4454
#define mmSCL4_SCL_ALU_CONTROL                                                  0x4754
#define mmSCL5_SCL_ALU_CONTROL                                                  0x4a54
#define mmSCL_COEF_RAM_CONFLICT_STATUS                                          0x1b55
#define mmSCL0_SCL_COEF_RAM_CONFLICT_STATUS                                     0x1b55
#define mmSCL1_SCL_COEF_RAM_CONFLICT_STATUS                                     0x1e55
#define mmSCL2_SCL_COEF_RAM_CONFLICT_STATUS                                     0x4155
#define mmSCL3_SCL_COEF_RAM_CONFLICT_STATUS                                     0x4455
#define mmSCL4_SCL_COEF_RAM_CONFLICT_STATUS                                     0x4755
#define mmSCL5_SCL_COEF_RAM_CONFLICT_STATUS                                     0x4a55
#define mmVIEWPORT_START                                                        0x1b5c
#define mmSCL0_VIEWPORT_START                                                   0x1b5c
#define mmSCL1_VIEWPORT_START                                                   0x1e5c
#define mmSCL2_VIEWPORT_START                                                   0x415c
#define mmSCL3_VIEWPORT_START                                                   0x445c
#define mmSCL4_VIEWPORT_START                                                   0x475c
#define mmSCL5_VIEWPORT_START                                                   0x4a5c
#define mmVIEWPORT_SIZE                                                         0x1b5d
#define mmSCL0_VIEWPORT_SIZE                                                    0x1b5d
#define mmSCL1_VIEWPORT_SIZE                                                    0x1e5d
#define mmSCL2_VIEWPORT_SIZE                                                    0x415d
#define mmSCL3_VIEWPORT_SIZE                                                    0x445d
#define mmSCL4_VIEWPORT_SIZE                                                    0x475d
#define mmSCL5_VIEWPORT_SIZE                                                    0x4a5d
#define mmEXT_OVERSCAN_LEFT_RIGHT                                               0x1b5e
#define mmSCL0_EXT_OVERSCAN_LEFT_RIGHT                                          0x1b5e
#define mmSCL1_EXT_OVERSCAN_LEFT_RIGHT                                          0x1e5e
#define mmSCL2_EXT_OVERSCAN_LEFT_RIGHT                                          0x415e
#define mmSCL3_EXT_OVERSCAN_LEFT_RIGHT                                          0x445e
#define mmSCL4_EXT_OVERSCAN_LEFT_RIGHT                                          0x475e
#define mmSCL5_EXT_OVERSCAN_LEFT_RIGHT                                          0x4a5e
#define mmEXT_OVERSCAN_TOP_BOTTOM                                               0x1b5f
#define mmSCL0_EXT_OVERSCAN_TOP_BOTTOM                                          0x1b5f
#define mmSCL1_EXT_OVERSCAN_TOP_BOTTOM                                          0x1e5f
#define mmSCL2_EXT_OVERSCAN_TOP_BOTTOM                                          0x415f
#define mmSCL3_EXT_OVERSCAN_TOP_BOTTOM                                          0x445f
#define mmSCL4_EXT_OVERSCAN_TOP_BOTTOM                                          0x475f
#define mmSCL5_EXT_OVERSCAN_TOP_BOTTOM                                          0x4a5f
#define mmSCL_MODE_CHANGE_DET1                                                  0x1b60
#define mmSCL0_SCL_MODE_CHANGE_DET1                                             0x1b60
#define mmSCL1_SCL_MODE_CHANGE_DET1                                             0x1e60
#define mmSCL2_SCL_MODE_CHANGE_DET1                                             0x4160
#define mmSCL3_SCL_MODE_CHANGE_DET1                                             0x4460
#define mmSCL4_SCL_MODE_CHANGE_DET1                                             0x4760
#define mmSCL5_SCL_MODE_CHANGE_DET1                                             0x4a60
#define mmSCL_MODE_CHANGE_DET2                                                  0x1b61
#define mmSCL0_SCL_MODE_CHANGE_DET2                                             0x1b61
#define mmSCL1_SCL_MODE_CHANGE_DET2                                             0x1e61
#define mmSCL2_SCL_MODE_CHANGE_DET2                                             0x4161
#define mmSCL3_SCL_MODE_CHANGE_DET2                                             0x4461
#define mmSCL4_SCL_MODE_CHANGE_DET2                                             0x4761
#define mmSCL5_SCL_MODE_CHANGE_DET2                                             0x4a61
#define mmSCL_MODE_CHANGE_DET3                                                  0x1b62
#define mmSCL0_SCL_MODE_CHANGE_DET3                                             0x1b62
#define mmSCL1_SCL_MODE_CHANGE_DET3                                             0x1e62
#define mmSCL2_SCL_MODE_CHANGE_DET3                                             0x4162
#define mmSCL3_SCL_MODE_CHANGE_DET3                                             0x4462
#define mmSCL4_SCL_MODE_CHANGE_DET3                                             0x4762
#define mmSCL5_SCL_MODE_CHANGE_DET3                                             0x4a62
#define mmSCL_MODE_CHANGE_MASK                                                  0x1b63
#define mmSCL0_SCL_MODE_CHANGE_MASK                                             0x1b63
#define mmSCL1_SCL_MODE_CHANGE_MASK                                             0x1e63
#define mmSCL2_SCL_MODE_CHANGE_MASK                                             0x4163
#define mmSCL3_SCL_MODE_CHANGE_MASK                                             0x4463
#define mmSCL4_SCL_MODE_CHANGE_MASK                                             0x4763
#define mmSCL5_SCL_MODE_CHANGE_MASK                                             0x4a63
#define mmSCL_DEBUG2                                                            0x1b69
#define mmSCL0_SCL_DEBUG2                                                       0x1b69
#define mmSCL1_SCL_DEBUG2                                                       0x1e69
#define mmSCL2_SCL_DEBUG2                                                       0x4169
#define mmSCL3_SCL_DEBUG2                                                       0x4469
#define mmSCL4_SCL_DEBUG2                                                       0x4769
#define mmSCL5_SCL_DEBUG2                                                       0x4a69
#define mmSCL_DEBUG                                                             0x1b6a
#define mmSCL0_SCL_DEBUG                                                        0x1b6a
#define mmSCL1_SCL_DEBUG                                                        0x1e6a
#define mmSCL2_SCL_DEBUG                                                        0x416a
#define mmSCL3_SCL_DEBUG                                                        0x446a
#define mmSCL4_SCL_DEBUG                                                        0x476a
#define mmSCL5_SCL_DEBUG                                                        0x4a6a
#define mmSCL_TEST_DEBUG_INDEX                                                  0x1b6b
#define mmSCL0_SCL_TEST_DEBUG_INDEX                                             0x1b6b
#define mmSCL1_SCL_TEST_DEBUG_INDEX                                             0x1e6b
#define mmSCL2_SCL_TEST_DEBUG_INDEX                                             0x416b
#define mmSCL3_SCL_TEST_DEBUG_INDEX                                             0x446b
#define mmSCL4_SCL_TEST_DEBUG_INDEX                                             0x476b
#define mmSCL5_SCL_TEST_DEBUG_INDEX                                             0x4a6b
#define mmSCL_TEST_DEBUG_DATA                                                   0x1b6c
#define mmSCL0_SCL_TEST_DEBUG_DATA                                              0x1b6c
#define mmSCL1_SCL_TEST_DEBUG_DATA                                              0x1e6c
#define mmSCL2_SCL_TEST_DEBUG_DATA                                              0x416c
#define mmSCL3_SCL_TEST_DEBUG_DATA                                              0x446c
#define mmSCL4_SCL_TEST_DEBUG_DATA                                              0x476c
#define mmSCL5_SCL_TEST_DEBUG_DATA                                              0x4a6c
#define mmGENMO_WT                                                              0xf0
#define mmGENMO_RD                                                              0xf3
#define mmGENENB                                                                0xf0
#define mmGENFC_WT                                                              0xee
#define mmVGA0_GENFC_WT                                                         0xee
#define mmVGA1_GENFC_WT                                                         0xf6
#define mmGENFC_RD                                                              0xf2
#define mmGENS0                                                                 0xf0
#define mmGENS1                                                                 0xee
#define mmVGA0_GENS1                                                            0xee
#define mmVGA1_GENS1                                                            0xf6
#define mmDAC_DATA                                                              0xf2
#define mmDAC_MASK                                                              0xf1
#define mmDAC_R_INDEX                                                           0xf1
#define mmDAC_W_INDEX                                                           0xf2
#define mmSEQ8_IDX                                                              0xf1
#define mmSEQ8_DATA                                                             0xf1
#define ixSEQ00                                                                 0x0
#define ixSEQ01                                                                 0x1
#define ixSEQ02                                                                 0x2
#define ixSEQ03                                                                 0x3
#define ixSEQ04                                                                 0x4
#define mmCRTC8_IDX                                                             0xed
#define mmVGA0_CRTC8_IDX                                                        0xed
#define mmVGA1_CRTC8_IDX                                                        0xf5
#define mmCRTC8_DATA                                                            0xed
#define mmVGA0_CRTC8_DATA                                                       0xed
#define mmVGA1_CRTC8_DATA                                                       0xf5
#define ixCRT00                                                                 0x0
#define ixCRT01                                                                 0x1
#define ixCRT02                                                                 0x2
#define ixCRT03                                                                 0x3
#define ixCRT04                                                                 0x4
#define ixCRT05                                                                 0x5
#define ixCRT06                                                                 0x6
#define ixCRT07                                                                 0x7
#define ixCRT08                                                                 0x8
#define ixCRT09                                                                 0x9
#define ixCRT0A                                                                 0xa
#define ixCRT0B                                                                 0xb
#define ixCRT0C                                                                 0xc
#define ixCRT0D                                                                 0xd
#define ixCRT0E                                                                 0xe
#define ixCRT0F                                                                 0xf
#define ixCRT10                                                                 0x10
#define ixCRT11                                                                 0x11
#define ixCRT12                                                                 0x12
#define ixCRT13                                                                 0x13
#define ixCRT14                                                                 0x14
#define ixCRT15                                                                 0x15
#define ixCRT16                                                                 0x16
#define ixCRT17                                                                 0x17
#define ixCRT18                                                                 0x18
#define ixCRT1E                                                                 0x1e
#define ixCRT1F                                                                 0x1f
#define ixCRT22                                                                 0x22
#define mmGRPH8_IDX                                                             0xf3
#define mmGRPH8_DATA                                                            0xf3
#define ixGRA00                                                                 0x0
#define ixGRA01                                                                 0x1
#define ixGRA02                                                                 0x2
#define ixGRA03                                                                 0x3
#define ixGRA04                                                                 0x4
#define ixGRA05                                                                 0x5
#define ixGRA06                                                                 0x6
#define ixGRA07                                                                 0x7
#define ixGRA08                                                                 0x8
#define mmATTRX                                                                 0xf0
#define mmATTRDW                                                                0xf0
#define mmATTRDR                                                                0xf0
#define ixATTR00                                                                0x0
#define ixATTR01                                                                0x1
#define ixATTR02                                                                0x2
#define ixATTR03                                                                0x3
#define ixATTR04                                                                0x4
#define ixATTR05                                                                0x5
#define ixATTR06                                                                0x6
#define ixATTR07                                                                0x7
#define ixATTR08                                                                0x8
#define ixATTR09                                                                0x9
#define ixATTR0A                                                                0xa
#define ixATTR0B                                                                0xb
#define ixATTR0C                                                                0xc
#define ixATTR0D                                                                0xd
#define ixATTR0E                                                                0xe
#define ixATTR0F                                                                0xf
#define ixATTR10                                                                0x10
#define ixATTR11                                                                0x11
#define ixATTR12                                                                0x12
#define ixATTR13                                                                0x13
#define ixATTR14                                                                0x14
#define mmVGA_RENDER_CONTROL                                                    0xc0
#define mmVGA_SOURCE_SELECT                                                     0xfc
#define mmVGA_SEQUENCER_RESET_CONTROL                                           0xc1
#define mmVGA_MODE_CONTROL                                                      0xc2
#define mmVGA_SURFACE_PITCH_SELECT                                              0xc3
#define mmVGA_MEMORY_BASE_ADDRESS                                               0xc4
#define mmVGA_MEMORY_BASE_ADDRESS_HIGH                                          0xc9
#define mmVGA_DISPBUF1_SURFACE_ADDR                                             0xc6
#define mmVGA_DISPBUF2_SURFACE_ADDR                                             0xc8
#define mmVGA_HDP_CONTROL                                                       0xca
#define mmVGA_CACHE_CONTROL                                                     0xcb
#define mmD1VGA_CONTROL                                                         0xcc
#define mmD2VGA_CONTROL                                                         0xce
#define mmD3VGA_CONTROL                                                         0xf8
#define mmD4VGA_CONTROL                                                         0xf9
#define mmD5VGA_CONTROL                                                         0xfa
#define mmD6VGA_CONTROL                                                         0xfb
#define mmVGA_HW_DEBUG                                                          0xcf
#define mmVGA_STATUS                                                            0xd0
#define mmVGA_INTERRUPT_CONTROL                                                 0xd1
#define mmVGA_STATUS_CLEAR                                                      0xd2
#define mmVGA_INTERRUPT_STATUS                                                  0xd3
#define mmVGA_MAIN_CONTROL                                                      0xd4
#define mmVGA_TEST_CONTROL                                                      0xd5
#define mmVGA_DEBUG_READBACK_INDEX                                              0xd6
#define mmVGA_DEBUG_READBACK_DATA                                               0xd7
#define mmVGA_MEM_WRITE_PAGE_ADDR                                               0x12
#define mmVGA_MEM_READ_PAGE_ADDR                                                0x13
#define mmVGA_TEST_DEBUG_INDEX                                                  0xc5
#define mmVGA_TEST_DEBUG_DATA                                                   0xc7
#define ixVGADCC_DBG_DCCIF_C                                                    0x7e
#define mmBPHYC_DAC_MACRO_CNTL                                                  0x19fd
#define mmBPHYC_DAC_AUTO_CALIB_CONTROL                                          0x19fe
#define mmDPG_PIPE_ARBITRATION_CONTROL1                                         0x1b30
#define mmDMIF_PG0_DPG_PIPE_ARBITRATION_CONTROL1                                0x1b30
#define mmDMIF_PG1_DPG_PIPE_ARBITRATION_CONTROL1                                0x1e30
#define mmDMIF_PG2_DPG_PIPE_ARBITRATION_CONTROL1                                0x4130
#define mmDMIF_PG3_DPG_PIPE_ARBITRATION_CONTROL1                                0x4430
#define mmDMIF_PG4_DPG_PIPE_ARBITRATION_CONTROL1                                0x4730
#define mmDMIF_PG5_DPG_PIPE_ARBITRATION_CONTROL1                                0x4a30
#define mmDPG_PIPE_ARBITRATION_CONTROL2                                         0x1b31
#define mmDMIF_PG0_DPG_PIPE_ARBITRATION_CONTROL2                                0x1b31
#define mmDMIF_PG1_DPG_PIPE_ARBITRATION_CONTROL2                                0x1e31
#define mmDMIF_PG2_DPG_PIPE_ARBITRATION_CONTROL2                                0x4131
#define mmDMIF_PG3_DPG_PIPE_ARBITRATION_CONTROL2                                0x4431
#define mmDMIF_PG4_DPG_PIPE_ARBITRATION_CONTROL2                                0x4731
#define mmDMIF_PG5_DPG_PIPE_ARBITRATION_CONTROL2                                0x4a31
#define mmDPG_WATERMARK_MASK_CONTROL                                            0x1b32
#define mmDMIF_PG0_DPG_WATERMARK_MASK_CONTROL                                   0x1b32
#define mmDMIF_PG1_DPG_WATERMARK_MASK_CONTROL                                   0x1e32
#define mmDMIF_PG2_DPG_WATERMARK_MASK_CONTROL                                   0x4132
#define mmDMIF_PG3_DPG_WATERMARK_MASK_CONTROL                                   0x4432
#define mmDMIF_PG4_DPG_WATERMARK_MASK_CONTROL                                   0x4732
#define mmDMIF_PG5_DPG_WATERMARK_MASK_CONTROL                                   0x4a32
#define mmDPG_PIPE_URGENCY_CONTROL                                              0x1b33
#define mmDMIF_PG0_DPG_PIPE_URGENCY_CONTROL                                     0x1b33
#define mmDMIF_PG1_DPG_PIPE_URGENCY_CONTROL                                     0x1e33
#define mmDMIF_PG2_DPG_PIPE_URGENCY_CONTROL                                     0x4133
#define mmDMIF_PG3_DPG_PIPE_URGENCY_CONTROL                                     0x4433
#define mmDMIF_PG4_DPG_PIPE_URGENCY_CONTROL                                     0x4733
#define mmDMIF_PG5_DPG_PIPE_URGENCY_CONTROL                                     0x4a33
#define mmDPG_PIPE_DPM_CONTROL                                                  0x1b34
#define mmDMIF_PG0_DPG_PIPE_DPM_CONTROL                                         0x1b34
#define mmDMIF_PG1_DPG_PIPE_DPM_CONTROL                                         0x1e34
#define mmDMIF_PG2_DPG_PIPE_DPM_CONTROL                                         0x4134
#define mmDMIF_PG3_DPG_PIPE_DPM_CONTROL                                         0x4434
#define mmDMIF_PG4_DPG_PIPE_DPM_CONTROL                                         0x4734
#define mmDMIF_PG5_DPG_PIPE_DPM_CONTROL                                         0x4a34
#define mmDPG_PIPE_STUTTER_CONTROL                                              0x1b35
#define mmDMIF_PG0_DPG_PIPE_STUTTER_CONTROL                                     0x1b35
#define mmDMIF_PG1_DPG_PIPE_STUTTER_CONTROL                                     0x1e35
#define mmDMIF_PG2_DPG_PIPE_STUTTER_CONTROL                                     0x4135
#define mmDMIF_PG3_DPG_PIPE_STUTTER_CONTROL                                     0x4435
#define mmDMIF_PG4_DPG_PIPE_STUTTER_CONTROL                                     0x4735
#define mmDMIF_PG5_DPG_PIPE_STUTTER_CONTROL                                     0x4a35
#define mmDPG_PIPE_NB_PSTATE_CHANGE_CONTROL                                     0x1b36
#define mmDMIF_PG0_DPG_PIPE_NB_PSTATE_CHANGE_CONTROL                            0x1b36
#define mmDMIF_PG1_DPG_PIPE_NB_PSTATE_CHANGE_CONTROL                            0x1e36
#define mmDMIF_PG2_DPG_PIPE_NB_PSTATE_CHANGE_CONTROL                            0x4136
#define mmDMIF_PG3_DPG_PIPE_NB_PSTATE_CHANGE_CONTROL                            0x4436
#define mmDMIF_PG4_DPG_PIPE_NB_PSTATE_CHANGE_CONTROL                            0x4736
#define mmDMIF_PG5_DPG_PIPE_NB_PSTATE_CHANGE_CONTROL                            0x4a36
#define mmDPG_PIPE_STUTTER_CONTROL_NONLPTCH                                     0x1b37
#define mmDMIF_PG0_DPG_PIPE_STUTTER_CONTROL_NONLPTCH                            0x1b37
#define mmDMIF_PG1_DPG_PIPE_STUTTER_CONTROL_NONLPTCH                            0x1e37
#define mmDMIF_PG2_DPG_PIPE_STUTTER_CONTROL_NONLPTCH                            0x4137
#define mmDMIF_PG3_DPG_PIPE_STUTTER_CONTROL_NONLPTCH                            0x4437
#define mmDMIF_PG4_DPG_PIPE_STUTTER_CONTROL_NONLPTCH                            0x4737
#define mmDMIF_PG5_DPG_PIPE_STUTTER_CONTROL_NONLPTCH                            0x4a37
#define mmDPG_REPEATER_PROGRAM                                                  0x1b3a
#define mmDMIF_PG0_DPG_REPEATER_PROGRAM                                         0x1b3a
#define mmDMIF_PG1_DPG_REPEATER_PROGRAM                                         0x1e3a
#define mmDMIF_PG2_DPG_REPEATER_PROGRAM                                         0x413a
#define mmDMIF_PG3_DPG_REPEATER_PROGRAM                                         0x443a
#define mmDMIF_PG4_DPG_REPEATER_PROGRAM                                         0x473a
#define mmDMIF_PG5_DPG_REPEATER_PROGRAM                                         0x4a3a
#define mmDPG_HW_DEBUG_A                                                        0x1b3b
#define mmDMIF_PG0_DPG_HW_DEBUG_A                                               0x1b3b
#define mmDMIF_PG1_DPG_HW_DEBUG_A                                               0x1e3b
#define mmDMIF_PG2_DPG_HW_DEBUG_A                                               0x413b
#define mmDMIF_PG3_DPG_HW_DEBUG_A                                               0x443b
#define mmDMIF_PG4_DPG_HW_DEBUG_A                                               0x473b
#define mmDMIF_PG5_DPG_HW_DEBUG_A                                               0x4a3b
#define mmDPG_HW_DEBUG_B                                                        0x1b3c
#define mmDMIF_PG0_DPG_HW_DEBUG_B                                               0x1b3c
#define mmDMIF_PG1_DPG_HW_DEBUG_B                                               0x1e3c
#define mmDMIF_PG2_DPG_HW_DEBUG_B                                               0x413c
#define mmDMIF_PG3_DPG_HW_DEBUG_B                                               0x443c
#define mmDMIF_PG4_DPG_HW_DEBUG_B                                               0x473c
#define mmDMIF_PG5_DPG_HW_DEBUG_B                                               0x4a3c
#define mmDPG_TEST_DEBUG_INDEX                                                  0x1b38
#define mmDMIF_PG0_DPG_TEST_DEBUG_INDEX                                         0x1b38
#define mmDMIF_PG1_DPG_TEST_DEBUG_INDEX                                         0x1e38
#define mmDMIF_PG2_DPG_TEST_DEBUG_INDEX                                         0x4138
#define mmDMIF_PG3_DPG_TEST_DEBUG_INDEX                                         0x4438
#define mmDMIF_PG4_DPG_TEST_DEBUG_INDEX                                         0x4738
#define mmDMIF_PG5_DPG_TEST_DEBUG_INDEX                                         0x4a38
#define mmDPG_TEST_DEBUG_DATA                                                   0x1b39
#define mmDMIF_PG0_DPG_TEST_DEBUG_DATA                                          0x1b39
#define mmDMIF_PG1_DPG_TEST_DEBUG_DATA                                          0x1e39
#define mmDMIF_PG2_DPG_TEST_DEBUG_DATA                                          0x4139
#define mmDMIF_PG3_DPG_TEST_DEBUG_DATA                                          0x4439
#define mmDMIF_PG4_DPG_TEST_DEBUG_DATA                                          0x4739
#define mmDMIF_PG5_DPG_TEST_DEBUG_DATA                                          0x4a39
#define mmAZROOT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_INDEX                       0x18
#define mmAZROOT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_DATA                        0x18
#define ixAZALIA_F2_CODEC_ROOT_PARAMETER_VENDOR_AND_DEVICE_ID                   0xf00
#define ixAZALIA_F2_CODEC_ROOT_PARAMETER_REVISION_ID                            0xf02
#define ixAZALIA_F2_CODEC_ROOT_PARAMETER_SUBORDINATE_NODE_COUNT                 0xf04
#define ixAZALIA_F2_CODEC_FUNCTION_PARAMETER_SUBORDINATE_NODE_COUNT             0x1f04
#define ixAZALIA_F2_CODEC_FUNCTION_PARAMETER_GROUP_TYPE                         0x1f05
#define ixAZALIA_F2_CODEC_FUNCTION_PARAMETER_SUPPORTED_SIZE_RATES               0x1f0a
#define ixAZALIA_F2_CODEC_FUNCTION_PARAMETER_STREAM_FORMATS                     0x1f0b
#define ixAZALIA_F2_CODEC_FUNCTION_PARAMETER_POWER_STATES                       0x1f0f
#define ixAZALIA_F2_CODEC_FUNCTION_CONTROL_POWER_STATE                          0x1705
#define ixAZALIA_F2_CODEC_FUNCTION_CONTROL_RESET                                0x17ff
#define ixAZALIA_F2_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID                0x1720
#define ixAZALIA_F2_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID_2              0x1721
#define ixAZALIA_F2_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID_3              0x1722
#define ixAZALIA_F2_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID_4              0x1723
#define ixAZALIA_F2_CODEC_FUNCTION_CONTROL_CONVERTER_SYNCHRONIZATION            0x1770
#define mmAZALIA_F0_CODEC_ROOT_PARAMETER_VENDOR_AND_DEVICE_ID                   0x17d2
#define mmAZALIA_F0_CODEC_ROOT_PARAMETER_REVISION_ID                            0x17d3
#define mmAZALIA_F0_CODEC_CHANNEL_COUNT_CONTROL                                 0x17d5
#define mmAZALIA_F0_CODEC_RESYNC_FIFO_CONTROL                                   0x17d6
#define mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_GROUP_TYPE                         0x17d7
#define mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_SUPPORTED_SIZE_RATES               0x17d8
#define mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_STREAM_FORMATS                     0x17d9
#define mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_POWER_STATES                       0x17da
#define mmAZALIA_F0_CODEC_FUNCTION_CONTROL_POWER_STATE                          0x17db
#define mmAZALIA_F0_CODEC_FUNCTION_CONTROL_RESET                                0x17dc
#define mmAZALIA_F0_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID                0x17dd
#define mmAZALIA_F0_CODEC_FUNCTION_CONTROL_CONVERTER_SYNCHRONIZATION            0x17de
#define mmCC_RCU_DC_AUDIO_PORT_CONNECTIVITY                                     0x17d4
#define mmAZALIA_F0_CODEC_DEBUG                                                 0x17df
#define mmAZALIA_F0_GTC_GROUP_OFFSET0                                           0x17e1
#define mmAZALIA_F0_GTC_GROUP_OFFSET1                                           0x17e2
#define mmAZALIA_F0_GTC_GROUP_OFFSET2                                           0x17e3
#define mmAZALIA_F0_GTC_GROUP_OFFSET3                                           0x17e4
#define mmAZALIA_F0_GTC_GROUP_OFFSET4                                           0x17e5
#define mmAZALIA_F0_GTC_GROUP_OFFSET5                                           0x17e6
#define mmAZALIA_F0_GTC_GROUP_OFFSET6                                           0x17e7
#define mmGLOBAL_CAPABILITIES                                                   0x0
#define mmMINOR_VERSION                                                         0x0
#define mmMAJOR_VERSION                                                         0x0
#define mmOUTPUT_PAYLOAD_CAPABILITY                                             0x1
#define mmINPUT_PAYLOAD_CAPABILITY                                              0x1
#define mmGLOBAL_CONTROL                                                        0x2
#define mmWAKE_ENABLE                                                           0x3
#define mmSTATE_CHANGE_STATUS                                                   0x3
#define mmGLOBAL_STATUS                                                         0x4
#define mmOUTPUT_STREAM_PAYLOAD_CAPABILITY                                      0x6
#define mmINTERRUPT_CONTROL                                                     0x8
#define mmINTERRUPT_STATUS                                                      0x9
#define mmWALL_CLOCK_COUNTER                                                    0xc
#define mmSTREAM_SYNCHRONIZATION                                                0xe
#define mmCORB_LOWER_BASE_ADDRESS                                               0x10
#define mmCORB_UPPER_BASE_ADDRESS                                               0x11
#define mmCORB_WRITE_POINTER                                                    0x12
#define mmCORB_READ_POINTER                                                     0x12
#define mmCORB_CONTROL                                                          0x13
#define mmCORB_STATUS                                                           0x13
#define mmCORB_SIZE                                                             0x13
#define mmRIRB_LOWER_BASE_ADDRESS                                               0x14
#define mmRIRB_UPPER_BASE_ADDRESS                                               0x15
#define mmRIRB_WRITE_POINTER                                                    0x16
#define mmRESPONSE_INTERRUPT_COUNT                                              0x16
#define mmRIRB_CONTROL                                                          0x17
#define mmRIRB_STATUS                                                           0x17
#define mmRIRB_SIZE                                                             0x17
#define mmIMMEDIATE_COMMAND_OUTPUT_INTERFACE                                    0x18
#define mmIMMEDIATE_COMMAND_OUTPUT_INTERFACE_INDEX                              0x18
#define mmIMMEDIATE_COMMAND_OUTPUT_INTERFACE_DATA                               0x18
#define mmIMMEDIATE_RESPONSE_INPUT_INTERFACE                                    0x19
#define mmIMMEDIATE_COMMAND_STATUS                                              0x1a
#define mmDMA_POSITION_LOWER_BASE_ADDRESS                                       0x1c
#define mmDMA_POSITION_UPPER_BASE_ADDRESS                                       0x1d
#define mmWALL_CLOCK_COUNTER_ALIAS                                              0x80c
#define mmOUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS                           0x20
#define mmOUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER              0x21
#define mmOUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH                         0x22
#define mmOUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX                             0x23
#define mmOUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE                                    0x24
#define mmOUTPUT_STREAM_DESCRIPTOR_FORMAT                                       0x24
#define mmOUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS               0x26
#define mmOUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS               0x27
#define mmOUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS        0x821
#define mmAZENDPOINT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_INDEX                   0x18
#define mmAZENDPOINT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_DATA                    0x18
#define ixAZALIA_F2_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES         0x2f09
#define ixAZALIA_F2_CODEC_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES              0x2f0a
#define ixAZALIA_F2_CODEC_CONVERTER_PARAMETER_STREAM_FORMATS                    0x2f0b
#define ixAZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT                    0x2200
#define ixAZALIA_F2_CODEC_CONVERTER_CONTROL_CHANNEL_STREAM_ID                   0x2706
#define ixAZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER                   0x270d
#define ixAZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_2                 0x270e
#define ixAZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_3                 0x273e
#define ixAZALIA_F2_CODEC_CONVERTER_STRIPE_CONTROL                              0x2724
#define ixAZALIA_F2_CODEC_CONVERTER_CONTROL_RAMP_RATE                           0x2770
#define ixAZALIA_F2_CODEC_CONVERTER_CONTROL_GTC_EMBEDDING                       0x2771
#define ixAZALIA_F2_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES               0x3f09
#define ixAZALIA_F2_CODEC_PIN_PARAMETER_CAPABILITIES                            0x3f0c
#define ixAZALIA_F2_CODEC_PIN_PARAMETER_CONNECTION_LIST_LENGTH                  0x3f0e
#define ixAZALIA_F2_CODEC_PIN_CONTROL_RESPONSE_CONNECTION_LIST_ENTRY            0x3702
#define ixAZALIA_F2_CODEC_PIN_CONTROL_WIDGET_CONTROL                            0x3707
#define ixAZALIA_F2_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE                      0x3708
#define ixAZALIA_F2_CODEC_PIN_CONTROL_RESPONSE_PIN_SENSE                        0x3709
#define ixAZALIA_F2_CODEC_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT            0x371c
#define ixAZALIA_F2_CODEC_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT_2          0x371d
#define ixAZALIA_F2_CODEC_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT_3          0x371e
#define ixAZALIA_F2_CODEC_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT_4          0x371f
#define ixAZALIA_F2_CODEC_PIN_CONTROL_RESPONSE_SPEAKER_ALLOCATION               0x3770
#define ixAZALIA_F2_CODEC_PIN_CONTROL_CHANNEL_ALLOCATION                        0x3771
#define ixAZALIA_F2_CODEC_PIN_CONTROL_DOWN_MIX_INFO                             0x3772
#define ixAZALIA_F2_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR                          0x3776
#define ixAZALIA_F2_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR_DATA                     0x3776
#define ixAUDIO_DESCRIPTOR0                                                     0x1
#define ixAUDIO_DESCRIPTOR1                                                     0x2
#define ixAUDIO_DESCRIPTOR2                                                     0x3
#define ixAUDIO_DESCRIPTOR3                                                     0x4
#define ixAUDIO_DESCRIPTOR4                                                     0x5
#define ixAUDIO_DESCRIPTOR5                                                     0x6
#define ixAUDIO_DESCRIPTOR6                                                     0x7
#define ixAUDIO_DESCRIPTOR7                                                     0x8
#define ixAUDIO_DESCRIPTOR8                                                     0x9
#define ixAUDIO_DESCRIPTOR9                                                     0xa
#define ixAUDIO_DESCRIPTOR10                                                    0xb
#define ixAUDIO_DESCRIPTOR11                                                    0xc
#define ixAUDIO_DESCRIPTOR12                                                    0xd
#define ixAUDIO_DESCRIPTOR13                                                    0xe
#define ixAZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL01_ENABLE                     0x3777
#define ixAZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL23_ENABLE                     0x3778
#define ixAZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL45_ENABLE                     0x3779
#define ixAZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL67_ENABLE                     0x377a
#define ixAZALIA_F2_CODEC_PIN_CONTROL_LIPSYNC                                   0x377b
#define ixAZALIA_F2_CODEC_PIN_CONTROL_HBR                                       0x377c
#define ixAZALIA_F2_CODEC_PIN_CONTROL_AUDIO_SINK_INFO_INDEX                     0x3780
#define ixAZALIA_F2_CODEC_PIN_CONTROL_AUDIO_SINK_INFO_DATA                      0x3781
#define ixAZALIA_F2_CODEC_PIN_CONTROL_MANUFACTURER_ID                           0x0
#define ixAZALIA_F2_CODEC_PIN_CONTROL_PRODUCT_ID                                0x1
#define ixAZALIA_F2_CODEC_PIN_CONTROL_SINK_DESCRIPTION_LEN                      0x2
#define ixAZALIA_F2_CODEC_PIN_CONTROL_PORTID0                                   0x3
#define ixAZALIA_F2_CODEC_PIN_CONTROL_PORTID1                                   0x4
#define ixSINK_DESCRIPTION0                                                     0x5
#define ixSINK_DESCRIPTION1                                                     0x6
#define ixSINK_DESCRIPTION2                                                     0x7
#define ixSINK_DESCRIPTION3                                                     0x8
#define ixSINK_DESCRIPTION4                                                     0x9
#define ixSINK_DESCRIPTION5                                                     0xa
#define ixSINK_DESCRIPTION6                                                     0xb
#define ixSINK_DESCRIPTION7                                                     0xc
#define ixSINK_DESCRIPTION8                                                     0xd
#define ixSINK_DESCRIPTION9                                                     0xe
#define ixSINK_DESCRIPTION10                                                    0xf
#define ixSINK_DESCRIPTION11                                                    0x10
#define ixSINK_DESCRIPTION12                                                    0x11
#define ixSINK_DESCRIPTION13                                                    0x12
#define ixSINK_DESCRIPTION14                                                    0x13
#define ixSINK_DESCRIPTION15                                                    0x14
#define ixSINK_DESCRIPTION16                                                    0x15
#define ixSINK_DESCRIPTION17                                                    0x16
#define ixAZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL1_ENABLE                      0x3785
#define ixAZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL3_ENABLE                      0x3786
#define ixAZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL5_ENABLE                      0x3787
#define ixAZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL7_ENABLE                      0x3788
#define ixAZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL_MODE                         0x3789
#define ixAZALIA_F2_PIN_CONTROL_CODEC_CS_OVERRIDE_0                             0x378a
#define ixAZALIA_F2_PIN_CONTROL_CODEC_CS_OVERRIDE_1                             0x378b
#define ixAZALIA_F2_PIN_CONTROL_CODEC_CS_OVERRIDE_2                             0x378c
#define ixAZALIA_F2_PIN_CONTROL_CODEC_CS_OVERRIDE_3                             0x378d
#define ixAZALIA_F2_PIN_CONTROL_CODEC_CS_OVERRIDE_4                             0x378e
#define ixAZALIA_F2_PIN_CONTROL_CODEC_CS_OVERRIDE_5                             0x378f
#define ixAZALIA_F2_PIN_CONTROL_CODEC_CS_OVERRIDE_6                             0x3790
#define ixAZALIA_F2_PIN_CONTROL_CODEC_CS_OVERRIDE_7                             0x3791
#define ixAZALIA_F2_PIN_CONTROL_CODEC_CS_OVERRIDE_8                             0x3792
#define ixAZALIA_F2_CODEC_PIN_ASSOCIATION_INFO                                  0x3793
#define ixAZALIA_F2_CODEC_PIN_CONTROL_DIGITAL_OUTPUT_STATUS                     0x3797
#define mmAZALIA_CONTROLLER_CLOCK_GATING                                        0x17b9
#define mmAZALIA_AUDIO_DTO                                                      0x17ba
#define mmAZALIA_AUDIO_DTO_CONTROL                                              0x17bb
#define mmAZALIA_SCLK_CONTROL                                                   0x17bc
#define mmAZALIA_UNDERFLOW_FILLER_SAMPLE                                        0x17bd
#define mmAZALIA_DATA_DMA_CONTROL                                               0x17be
#define mmAZALIA_BDL_DMA_CONTROL                                                0x17bf
#define mmAZALIA_RIRB_AND_DP_CONTROL                                            0x17c0
#define mmAZALIA_CORB_DMA_CONTROL                                               0x17c1
#define mmAZALIA_APPLICATION_POSITION_IN_CYCLIC_BUFFER                          0x17c9
#define mmAZALIA_CYCLIC_BUFFER_SYNC                                             0x17ca
#define mmAZALIA_GLOBAL_CAPABILITIES                                            0x17cb
#define mmAZALIA_OUTPUT_PAYLOAD_CAPABILITY                                      0x17cc
#define mmAZALIA_OUTPUT_STREAM_ARBITER_CONTROL                                  0x17cd
#define mmAZALIA_CONTROLLER_DEBUG                                               0x17cf
#define mmAZALIA_CRC0_CONTROL0                                                  0x17ae
#define mmAZALIA_CRC0_CONTROL1                                                  0x17af
#define mmAZALIA_CRC0_CONTROL2                                                  0x17b0
#define mmAZALIA_CRC0_CONTROL3                                                  0x17b1
#define mmAZALIA_CRC0_RESULT                                                    0x17b2
#define ixAZALIA_CRC0_CHANNEL0                                                  0x0
#define ixAZALIA_CRC0_CHANNEL1                                                  0x1
#define ixAZALIA_CRC0_CHANNEL2                                                  0x2
#define ixAZALIA_CRC0_CHANNEL3                                                  0x3
#define ixAZALIA_CRC0_CHANNEL4                                                  0x4
#define ixAZALIA_CRC0_CHANNEL5                                                  0x5
#define ixAZALIA_CRC0_CHANNEL6                                                  0x6
#define ixAZALIA_CRC0_CHANNEL7                                                  0x7
#define mmAZALIA_CRC1_CONTROL0                                                  0x17b3
#define mmAZALIA_CRC1_CONTROL1                                                  0x17b4
#define mmAZALIA_CRC1_CONTROL2                                                  0x17b5
#define mmAZALIA_CRC1_CONTROL3                                                  0x17b6
#define mmAZALIA_CRC1_RESULT                                                    0x17b7
#define ixAZALIA_CRC1_CHANNEL0                                                  0x0
#define ixAZALIA_CRC1_CHANNEL1                                                  0x1
#define ixAZALIA_CRC1_CHANNEL2                                                  0x2
#define ixAZALIA_CRC1_CHANNEL3                                                  0x3
#define ixAZALIA_CRC1_CHANNEL4                                                  0x4
#define ixAZALIA_CRC1_CHANNEL5                                                  0x5
#define ixAZALIA_CRC1_CHANNEL6                                                  0x6
#define ixAZALIA_CRC1_CHANNEL7                                                  0x7
#define mmAZ_TEST_DEBUG_INDEX                                                   0x17d0
#define mmAZ_TEST_DEBUG_DATA                                                    0x17d1
#define mmAZALIA_STREAM_INDEX                                                   0x17e8
#define mmAZF0STREAM0_AZALIA_STREAM_INDEX                                       0x17e8
#define mmAZF0STREAM1_AZALIA_STREAM_INDEX                                       0x17ec
#define mmAZF0STREAM2_AZALIA_STREAM_INDEX                                       0x17f0
#define mmAZF0STREAM3_AZALIA_STREAM_INDEX                                       0x17f4
#define mmAZF0STREAM4_AZALIA_STREAM_INDEX                                       0x17f8
#define mmAZF0STREAM5_AZALIA_STREAM_INDEX                                       0x17fc
#define mmAZALIA_STREAM_DATA                                                    0x17e9
#define mmAZF0STREAM0_AZALIA_STREAM_DATA                                        0x17e9
#define mmAZF0STREAM1_AZALIA_STREAM_DATA                                        0x17ed
#define mmAZF0STREAM2_AZALIA_STREAM_DATA                                        0x17f1
#define mmAZF0STREAM3_AZALIA_STREAM_DATA                                        0x17f5
#define mmAZF0STREAM4_AZALIA_STREAM_DATA                                        0x17f9
#define mmAZF0STREAM5_AZALIA_STREAM_DATA                                        0x17fd
#define ixAZALIA_FIFO_SIZE_CONTROL                                              0x0
#define ixAZALIA_LATENCY_COUNTER_CONTROL                                        0x1
#define ixAZALIA_WORSTCASE_LATENCY_COUNT                                        0x2
#define ixAZALIA_CUMULATIVE_LATENCY_COUNT                                       0x3
#define ixAZALIA_CUMULATIVE_REQUEST_COUNT                                       0x4
#define ixAZALIA_STREAM_DEBUG                                                   0x5
#define mmAZALIA_F0_CODEC_ENDPOINT_INDEX                                        0x1780
#define mmAZF0ENDPOINT0_AZALIA_F0_CODEC_ENDPOINT_INDEX                          0x1780
#define mmAZF0ENDPOINT1_AZALIA_F0_CODEC_ENDPOINT_INDEX                          0x1786
#define mmAZF0ENDPOINT2_AZALIA_F0_CODEC_ENDPOINT_INDEX                          0x178c
#define mmAZF0ENDPOINT3_AZALIA_F0_CODEC_ENDPOINT_INDEX                          0x1792
#define mmAZF0ENDPOINT4_AZALIA_F0_CODEC_ENDPOINT_INDEX                          0x1798
#define mmAZF0ENDPOINT5_AZALIA_F0_CODEC_ENDPOINT_INDEX                          0x179e
#define mmAZF0ENDPOINT6_AZALIA_F0_CODEC_ENDPOINT_INDEX                          0x17a4
#define mmAZALIA_F0_CODEC_ENDPOINT_DATA                                         0x1781
#define mmAZF0ENDPOINT0_AZALIA_F0_CODEC_ENDPOINT_DATA                           0x1781
#define mmAZF0ENDPOINT1_AZALIA_F0_CODEC_ENDPOINT_DATA                           0x1787
#define mmAZF0ENDPOINT2_AZALIA_F0_CODEC_ENDPOINT_DATA                           0x178d
#define mmAZF0ENDPOINT3_AZALIA_F0_CODEC_ENDPOINT_DATA                           0x1793
#define mmAZF0ENDPOINT4_AZALIA_F0_CODEC_ENDPOINT_DATA                           0x1799
#define mmAZF0ENDPOINT5_AZALIA_F0_CODEC_ENDPOINT_DATA                           0x179f
#define mmAZF0ENDPOINT6_AZALIA_F0_CODEC_ENDPOINT_DATA                           0x17a5
#define ixAZALIA_F0_CODEC_CONVERTER_PIN_DEBUG                                   0x0
#define ixAZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES         0x1
#define ixAZALIA_F0_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT                    0x2
#define ixAZALIA_F0_CODEC_CONVERTER_CONTROL_CHANNEL_STREAM_ID                   0x3
#define ixAZALIA_F0_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER                   0x4
#define ixAZALIA_F0_CODEC_CONVERTER_PARAMETER_STREAM_FORMATS                    0x5
#define ixAZALIA_F0_CODEC_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES              0x6
#define ixAZALIA_F0_CODEC_CONVERTER_STRIPE_CONTROL                              0x7
#define ixAZALIA_F0_CODEC_CONVERTER_CONTROL_RAMP_RATE                           0x8
#define ixAZALIA_F0_CODEC_CONVERTER_CONTROL_GTC_EMBEDDING                       0x9
#define ixAZALIA_F0_CODEC_CONVERTER_CONTROL_GTC_OFFSET_DEBUG                    0xa
#define ixAZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA                           0xc
#define ixAZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MIN                       0xd
#define ixAZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MAX                       0xe
#define ixAZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES               0x20
#define ixAZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES                            0x21
#define ixAZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE                      0x22
#define ixAZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_PIN_SENSE                        0x23
#define ixAZALIA_F0_CODEC_PIN_CONTROL_WIDGET_CONTROL                            0x24
#define ixAZALIA_F0_CODEC_PIN_CONTROL_CHANNEL_SPEAKER                           0x25
#define ixAZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR0                         0x28
#define ixAZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR1                         0x29
#define ixAZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR2                         0x2a
#define ixAZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR3                         0x2b
#define ixAZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR4                         0x2c
#define ixAZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR5                         0x2d
#define ixAZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR6                         0x2e
#define ixAZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR7                         0x2f
#define ixAZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR8                         0x30
#define ixAZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR9                         0x31
#define ixAZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR10                        0x32
#define ixAZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR11                        0x33
#define ixAZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR12                        0x34
#define ixAZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR13                        0x35
#define ixAZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE                       0x36
#define ixAZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE2                      0x57
#define ixAZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_MODE                         0x58
#define ixAZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_LIPSYNC                          0x37
#define ixAZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_HBR                              0x38
#define ixAZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO0                                0x3a
#define ixAZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO1                                0x3b
#define ixAZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO2                                0x3c
#define ixAZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO3                                0x3d
#define ixAZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO4                                0x3e
#define ixAZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO5                                0x3f
#define ixAZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO6                                0x40
#define ixAZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO7                                0x41
#define ixAZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO8                                0x42
#define ixAZALIA_F0_CODEC_PIN_CONTROL_HOT_PLUG_CONTROL                          0x54
#define ixAZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE_FORCE                0x55
#define ixAZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT            0x56
#define ixAZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_0                             0x59
#define ixAZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_1                             0x5a
#define ixAZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_2                             0x5b
#define ixAZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_3                             0x5c
#define ixAZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_4                             0x5d
#define ixAZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_5                             0x5e
#define ixAZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_6                             0x5f
#define ixAZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_7                             0x60
#define ixAZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_8                             0x61
#define ixAZALIA_F0_CODEC_PIN_ASSOCIATION_INFO                                  0x62
#define ixAZALIA_F0_CODEC_PIN_CONTROL_DIGITAL_OUTPUT_STATUS                     0x63
#define mmBLND_CONTROL                                                          0x1b6d
#define mmBLND0_BLND_CONTROL                                                    0x1b6d
#define mmBLND1_BLND_CONTROL                                                    0x1e6d
#define mmBLND2_BLND_CONTROL                                                    0x416d
#define mmBLND3_BLND_CONTROL                                                    0x446d
#define mmBLND4_BLND_CONTROL                                                    0x476d
#define mmBLND5_BLND_CONTROL                                                    0x4a6d
#define mmSM_CONTROL2                                                           0x1b6e
#define mmBLND0_SM_CONTROL2                                                     0x1b6e
#define mmBLND1_SM_CONTROL2                                                     0x1e6e
#define mmBLND2_SM_CONTROL2                                                     0x416e
#define mmBLND3_SM_CONTROL2                                                     0x446e
#define mmBLND4_SM_CONTROL2                                                     0x476e
#define mmBLND5_SM_CONTROL2                                                     0x4a6e
#define mmPTI_CONTROL                                                           0x1b6f
#define mmBLND0_PTI_CONTROL                                                     0x1b6f
#define mmBLND1_PTI_CONTROL                                                     0x1e6f
#define mmBLND2_PTI_CONTROL                                                     0x416f
#define mmBLND3_PTI_CONTROL                                                     0x446f
#define mmBLND4_PTI_CONTROL                                                     0x476f
#define mmBLND5_PTI_CONTROL                                                     0x4a6f
#define mmBLND_UPDATE                                                           0x1b70
#define mmBLND0_BLND_UPDATE                                                     0x1b70
#define mmBLND1_BLND_UPDATE                                                     0x1e70
#define mmBLND2_BLND_UPDATE                                                     0x4170
#define mmBLND3_BLND_UPDATE                                                     0x4470
#define mmBLND4_BLND_UPDATE                                                     0x4770
#define mmBLND5_BLND_UPDATE                                                     0x4a70
#define mmBLND_UNDERFLOW_INTERRUPT                                              0x1b71
#define mmBLND0_BLND_UNDERFLOW_INTERRUPT                                        0x1b71
#define mmBLND1_BLND_UNDERFLOW_INTERRUPT                                        0x1e71
#define mmBLND2_BLND_UNDERFLOW_INTERRUPT                                        0x4171
#define mmBLND3_BLND_UNDERFLOW_INTERRUPT                                        0x4471
#define mmBLND4_BLND_UNDERFLOW_INTERRUPT                                        0x4771
#define mmBLND5_BLND_UNDERFLOW_INTERRUPT                                        0x4a71
#define mmBLND_V_UPDATE_LOCK                                                    0x1b73
#define mmBLND0_BLND_V_UPDATE_LOCK                                              0x1b73
#define mmBLND1_BLND_V_UPDATE_LOCK                                              0x1e73
#define mmBLND2_BLND_V_UPDATE_LOCK                                              0x4173
#define mmBLND3_BLND_V_UPDATE_LOCK                                              0x4473
#define mmBLND4_BLND_V_UPDATE_LOCK                                              0x4773
#define mmBLND5_BLND_V_UPDATE_LOCK                                              0x4a73
#define mmBLND_REG_UPDATE_STATUS                                                0x1b77
#define mmBLND0_BLND_REG_UPDATE_STATUS                                          0x1b77
#define mmBLND1_BLND_REG_UPDATE_STATUS                                          0x1e77
#define mmBLND2_BLND_REG_UPDATE_STATUS                                          0x4177
#define mmBLND3_BLND_REG_UPDATE_STATUS                                          0x4477
#define mmBLND4_BLND_REG_UPDATE_STATUS                                          0x4777
#define mmBLND5_BLND_REG_UPDATE_STATUS                                          0x4a77
#define mmBLND_DEBUG                                                            0x1b74
#define mmBLND0_BLND_DEBUG                                                      0x1b74
#define mmBLND1_BLND_DEBUG                                                      0x1e74
#define mmBLND2_BLND_DEBUG                                                      0x4174
#define mmBLND3_BLND_DEBUG                                                      0x4474
#define mmBLND4_BLND_DEBUG                                                      0x4774
#define mmBLND5_BLND_DEBUG                                                      0x4a74
#define mmBLND_TEST_DEBUG_INDEX                                                 0x1b75
#define mmBLND0_BLND_TEST_DEBUG_INDEX                                           0x1b75
#define mmBLND1_BLND_TEST_DEBUG_INDEX                                           0x1e75
#define mmBLND2_BLND_TEST_DEBUG_INDEX                                           0x4175
#define mmBLND3_BLND_TEST_DEBUG_INDEX                                           0x4475
#define mmBLND4_BLND_TEST_DEBUG_INDEX                                           0x4775
#define mmBLND5_BLND_TEST_DEBUG_INDEX                                           0x4a75
#define mmBLND_TEST_DEBUG_DATA                                                  0x1b76
#define mmBLND0_BLND_TEST_DEBUG_DATA                                            0x1b76
#define mmBLND1_BLND_TEST_DEBUG_DATA                                            0x1e76
#define mmBLND2_BLND_TEST_DEBUG_DATA                                            0x4176
#define mmBLND3_BLND_TEST_DEBUG_DATA                                            0x4476
#define mmBLND4_BLND_TEST_DEBUG_DATA                                            0x4776
#define mmBLND5_BLND_TEST_DEBUG_DATA                                            0x4a76
#define mmSI_ENABLE                                                             0x4c00
#define mmSI_EC_CONFIG                                                          0x4c01
#define mmCNV_MODE                                                              0x4c02
#define mmCNV_WINDOW_START                                                      0x4c03
#define mmCNV_WINDOW_SIZE                                                       0x4c04
#define mmCNV_UPDATE                                                            0x4c05
#define mmCNV_SOURCE_SIZE                                                       0x4c06
#define mmCNV_CSC_CONTROL                                                       0x4c07
#define mmCNV_CSC_C11_C12                                                       0x4c08
#define mmCNV_CSC_C13_C14                                                       0x4c09
#define mmCNV_CSC_C21_C22                                                       0x4c0a
#define mmCNV_CSC_C23_C24                                                       0x4c0b
#define mmCNV_CSC_C31_C32                                                       0x4c0c
#define mmCNV_CSC_C33_C34                                                       0x4c0d
#define mmCNV_CSC_ROUND_OFFSET_R                                                0x4c0e
#define mmCNV_CSC_ROUND_OFFSET_G                                                0x4c0f
#define mmCNV_CSC_ROUND_OFFSET_B                                                0x4c10
#define mmCNV_CSC_CLAMP_R                                                       0x4c11
#define mmCNV_CSC_CLAMP_G                                                       0x4c12
#define mmCNV_CSC_CLAMP_B                                                       0x4c13
#define mmCNV_TEST_CNTL                                                         0x4c14
#define mmCNV_TEST_CRC_RED                                                      0x4c15
#define mmCNV_TEST_CRC_GREEN                                                    0x4c16
#define mmCNV_TEST_CRC_BLUE                                                     0x4c17
#define mmSI_DEBUG_CTRL                                                         0x4c18
#define mmSI_DBG_MODE                                                           0x4c1b
#define mmSI_HARD_DEBUG                                                         0x4c1c
#define mmCNV_TEST_DEBUG_INDEX                                                  0x4c19
#define mmCNV_TEST_DEBUG_DATA                                                   0x4c1a
#define mmSISCL_COEF_RAM_SELECT                                                 0x4c20
#define mmSISCL_COEF_RAM_TAP_DATA                                               0x4c21
#define mmSISCL_MODE                                                            0x4c22
#define mmSISCL_TAP_CONTROL                                                     0x4c23
#define mmSISCL_DEST_SIZE                                                       0x4c24
#define mmSISCL_HORZ_FILTER_SCALE_RATIO                                         0x4c25
#define mmSISCL_HORZ_FILTER_INIT_Y_RGB                                          0x4c26
#define mmSISCL_HORZ_FILTER_INIT_CBCR                                           0x4c27
#define mmSISCL_VERT_FILTER_SCALE_RATIO                                         0x4c28
#define mmSISCL_VERT_FILTER_INIT_Y_RGB                                          0x4c29
#define mmSISCL_VERT_FILTER_INIT_CBCR                                           0x4c2a
#define mmSISCL_ROUND_OFFSET                                                    0x4c2b
#define mmSISCL_CLAMP                                                           0x4c2c
#define mmSISCL_OVERFLOW_STATUS                                                 0x4c2d
#define mmSISCL_COEF_RAM_CONFLICT_STATUS                                        0x4c2e
#define mmSISCL_OUTSIDE_PIX_STRATEGY                                            0x4c2f
#define mmSISCL_TEST_CNTL                                                       0x4c30
#define mmSISCL_TEST_CRC_RED                                                    0x4c31
#define mmSISCL_TEST_CRC_GREEN                                                  0x4c32
#define mmSISCL_TEST_CRC_BLUE                                                   0x4c33
#define mmSISCL_BACKPRESSURE_CNT_EN                                             0x4c36
#define mmSISCL_MCIF_BACKPRESSURE_CNT                                           0x4c37
#define mmSISCL_TEST_DEBUG_INDEX                                                0x4c34
#define mmSISCL_TEST_DEBUG_DATA                                                 0x4c35
#define mmXDMA_MC_PCIE_CLIENT_CONFIG                                            0x3e0
#define mmXDMA_LOCAL_SURFACE_TILING1                                            0x3e1
#define mmXDMA_LOCAL_SURFACE_TILING2                                            0x3e2
#define mmXDMA_INTERRUPT                                                        0x3e3
#define mmXDMA_CLOCK_GATING_CNTL                                                0x3e4
#define mmXDMA_MEM_POWER_CNTL                                                   0x3e6
#define mmXDMA_IF_BIF_STATUS                                                    0x3e7
#define mmXDMA_PERF_MEAS_STATUS                                                 0x3e8
#define mmXDMA_IF_STATUS                                                        0x3e9
#define mmXDMA_TEST_DEBUG_INDEX                                                 0x3ea
#define mmXDMA_TEST_DEBUG_DATA                                                  0x3eb
#define mmXDMA_RBBMIF_RDWR_CNTL                                                 0x3f8
#define mmXDMA_PG_CONTROL                                                       0x3f9
#define mmXDMA_PG_WDATA                                                         0x3fa
#define mmXDMA_PG_STATUS                                                        0x3fb
#define mmXDMA_AON_TEST_DEBUG_INDEX                                             0x3fc
#define mmXDMA_AON_TEST_DEBUG_DATA                                              0x3fd

#endif /* DCE_8_0_D_H */
