/*
 * $Id: cap_sys.c,v 1.2 1997/04/28 00:57:11 morgan Exp $
 *
 * Copyright (c) 1997 Andrew G. Morgan   <morgan@parc.power.net>
 *
 * This file contains the system calls for getting and setting
 * capabilities
 */

#include "libcap.h"
#include <linux/unistd.h>

_syscall4(int, _setproccap,
	  size_t, usize,
	  __cap_s const *, iset,
	  __cap_s const *, pset,
	  __cap_s const *, eset)

_syscall4(int, _getproccap,
	  size_t, usize,
	  __cap_s *, iset,
	  __cap_s *, pset,
	  __cap_s *, eset)

/* Secondly, we have the file capabilities */

_syscall5(int, _setfilecap,
	  char const *, filename,
	  size_t, usize,
	  __cap_s const *, iset,
	  __cap_s const *, pset,
	  __cap_s const *, eset)

_syscall5(int, _getfilecap,
	  char const *, filename,
	  size_t, usize,
	  __cap_s *, iset,
	  __cap_s *, pset,
	  __cap_s *, eset)

_syscall5(int, _fsetfilecap,
	  int, fd,
	  size_t, usize,
	  __cap_s const *, iset,
	  __cap_s const *, pset,
	  __cap_s const *, eset)

_syscall5(int, _fgetfilecap,
	  int, fd,
	  size_t, usize,
	  __cap_s *, iset,
	  __cap_s *, pset,
	  __cap_s *, eset)

/*
 * $Log: cap_sys.c,v $
 * Revision 1.2  1997/04/28 00:57:11  morgan
 * fixes and zefram's patches
 *
 * Revision 1.1  1997/04/21 04:32:52  morgan
 * Initial revision
 *
 */
