// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright (c) 2000-2003,2005 Silicon Graphics, Inc.
 * All Rights Reserved.
 */

#include "libxfs.h"
#include <diskinfo.h>
#include <sys/sysmp.h>

int platform_has_uuid = 0;
extern char *progname;
extern int64_t findsize(char *);

#warning "IRIX support is deprecated and planned for removal in July 2018"
#warning "Contact linux-xfs@vger.kernel.org if you'd like to maintain this port"
#error   "Remove this line if you'd like to continue the build"

int
platform_check_ismounted(char *name, char *block, struct stat *s, int verbose)
{
	return 0;
}

int
platform_check_iswritable(char *name, char *block, struct stat *s)
{
	return 1;
}

int
platform_set_blocksize(int fd, char *path, dev_t device, int blocksize, int fatal)
{
	return fatal;
}

void
platform_flush_device(int fd, dev_t device)
{
	return;
}

void
platform_findsizes(char *path, int fd, long long *sz, int *bsz)
{
	struct stat		st;

	if (fstat(fd, &st) < 0) {
		fprintf(stderr,
			_("%s: cannot stat the device file \"%s\": %s\n"),
			progname, path, strerror(errno));
		exit(1);
	}
	if ((st.st_mode & S_IFMT) == S_IFREG) {
		*sz = (long long)(st.st_size >> 9);
	} else {
		*sz = findsize(path);
	}
	*bsz = BBSIZE;
}

char *
platform_findrawpath(char *path)
{
	return findrawpath(path);
}

char *
platform_findblockpath(char *path)
{
	return findblockpath(path);
}

int
platform_direct_blockdev(void)
{
	return 0;
}

int
platform_align_blockdev(void)
{
	return sizeof(void *);
}

int
platform_nproc(void)
{
	return sysmp(MP_NPROCS);
}

unsigned long
platform_physmem(void)
{
	struct rminfo ri;

	if (sysmp(MP_SAGET, MPSA_RMINFO, &ri, sizeof(ri)) < 0)
		fprintf(stderr, _("%s: can't determine memory size\n"),
			progname);
		exit(1);
	}
	return (ri.physmem >> 10) * getpagesize();	/* kilobytes */
}
