/* Copyright (C) 1998 Thorsten Kukuk
   Author: Thorsten Kukuk <kukuk@vt.uni-paderborn.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#if defined(HAVE_CONFIG_H)
#include "config.h"
#endif

#define _GNU_SOURCE

#include <stdio.h>
#include <unistd.h>
#include <rpc/rpc.h>
#include <rpc/key_prot.h>
#include <locale.h>
#include <libintl.h>
#ifdef HAVE_GETOPT_H
#include <getopt.h>
#else
#include "lib/compat/getopt.h"
#endif

#ifndef _
#define _(String) gettext (String)
#endif

/* Name and version of program.  */
/* Print the version information.  */
static inline void
print_version (void)
{
  fprintf (stdout, "keylogout (%s) %s\n", PACKAGE, VERSION);
  fprintf (stdout, gettext ("\
Copyright (C) %s Thorsten Kukuk.\n\
This is free software; see the source for copying conditions.  There is NO\n\
warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n\
"), "1998");
  /* fprintf (stdout, _("Written by %s.\n"), "Thorsten Kukuk"); */
}

static inline void
print_usage (void)
{
  fputs (_("Usage: keylogout [-f]\n"), stdout);
}

static void
print_help (void)
{
  print_usage ();
  fputs (_("keylogout - delete stored secret key with keyserv\n\n"),
         stdout);

  fputs (_("  -f, --force    Delete the secret key for the Super User\n"),
         stdout);
  fputs (_("  --help         Give this help list\n"), stdout);
  fputs (_("  --usage        Give a short usage message\n"), stdout);
  fputs (_("  --version      Print program version\n"), stdout);
}

static inline void
print_error (void)
{
  const char *program = "keylogout";

  fprintf (stderr,
           _("Try `%s --help' or `%s --usage' for more information.\n"),
           program, program);
}

int
main (int argc, char **argv)
{
  char empty_key[HEXKEYBYTES + 1];
  int force = 0;

  memset (&empty_key, 0, HEXKEYBYTES + 1);

  setlocale (LC_MESSAGES, "");
  bindtextdomain (PACKAGE, LOCALEDIR);
  textdomain (PACKAGE);

  while (1)
    {
      int c;
      int option_index = 0;
      static struct option long_options[] =
      {
        {"version", no_argument, NULL, '\255'},
        {"help", no_argument, NULL, '\253'},
        {"usage", no_argument, NULL, '\254'},
        {"force", no_argument, NULL, 'f'},
        {NULL, 0, NULL, '\0'}
      };

      c = getopt_long (argc, argv, "f", long_options, &option_index);
      if (c == EOF)
        break;
      switch (c)
        {
	case 'f':
	  force = 1;
	  break;
        case '\253':
	  print_help ();
	  return 0;
        case '\255':
	  print_version ();
	  return 0;
	case '\254':
	  print_usage ();
	  return 0;
        default:
	  print_error ();
	  return 1;
        }
    }
  argc -= optind;
  argv += optind;

  if (argc != 0)
    {
      fprintf (stderr, _("%s: To many arguments\n"), "keylogout");
      print_error ();
      return 1;
    }

  if (geteuid () == 0)
    {
      if (!force)
	{
	  fputs (_("keylogout by root would break all servers that use secure rpc!\n"), stderr);
	  fputs (_("root may use keylogout -f to do this (at your own risk)!\n"), stderr);
	  return -1;
	}
    }

  if (key_setsecret (empty_key) < 0)
    {
      fputs (_("Could not unset your secret key.\n"), stderr);
      fputs (_("Maybe the keyserver is down?\n"), stderr);
      return 1;
    }

  return 0;
}
