/*
    YPS-0.2, NIS-Server for Linux
    Copyright (C) 1994  Tobias Reber

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
static char rscsid[]="(#)$Id: ypgetdom.c,v 0.16 1994/01/02 22:48:22 root Exp $";

/*
 *	$Author: root $
 *	$Log: ypgetdom.c,v $
 * Revision 0.16  1994/01/02  22:48:22  root
 * Added strict prototypes
 *
 * Revision 0.15  1994/01/02  20:09:39  root
 * Added GPL notice
 *
 * Revision 0.14  1993/06/12  09:39:30  root
 * Align with include-4.4
 *
 */

#include <rpc/rpc.h>
#include <rpcsvc/yp.h>
 
#ifndef YPDIR
#define YPDIR "/var/yp"
#endif

#ifndef HAS_GETDOMAINNAME
int
getdomainname(char *d, int s)
{
	char DomainFile[1024];
	FILE *f;

	strcpy(DomainFile, YPDIR);
	strcat(DomainFile, "/");
	strcat(DomainFile, ".domainname");

	f=fopen(DomainFile, "rb");
	if (!f) return (-1);

	fgets(d, s, f);
	if (d[strlen(d)-1]=='\n')
	d[strlen(d)-1]='\0';

	fclose(f);
	return 0;
}

int
setdomainname(char *d)
{
	char DomainFile[1024];
	FILE *f;

	strcpy(DomainFile, YPDIR);
	strcat(DomainFile, "/");
	strcat(DomainFile, ".domainname");

	f=fopen(DomainFile, "wb");
	if (!f) return (-1);

	fputs(d, f);

	fclose(f);
	return 0;
}
#endif

int
yp_get_default_domain( char **DomainName)
{
   static char d[YPMAXDOMAIN+1];
   d[YPMAXDOMAIN]='\0';
   getdomainname(d, YPMAXDOMAIN);
   *DomainName=d;
   return (0);
}
