/*
 * bwmonitor.c
 *
 * Very simple bandwidth monitor using /proc/net/dev
 *
 */

#include <stdio.h>
#include <errno.h>
#include <time.h>
#include <unistd.h>
#include <sys/time.h>

#define MAXBANDWIDTH 1.0e+8	/* 100 Mbit/s */

void skipline(FILE *f)
{
  int ch;
  do {
    ch = getc(f);
  } while ( ch != '\n' && ch != EOF );
}

int main(int argc, char *argv[])
{
  FILE *pnd;
  char buffer[BUFSIZ];
  char *interface;
  struct ifinfo {
    char name[8];
    unsigned int r_bytes, r_pkt, r_err, r_drop, r_fifo, r_frame;
    unsigned int r_compr, r_mcast;
    unsigned int x_bytes, x_pkt, x_err, x_drop, x_fifo, x_coll;
    unsigned int x_carrier, x_compr;
  } ifc;
  unsigned long long bin, bout, lbin, lbout;
  int first;
  struct timeval t_now, t_last;
  double bwin, bwout, timedelta;

  if ( argc != 2 ) {
    fprintf(stderr, "Usage: %s interface\n", argv[0]);
    exit(1);
  }

  interface = argv[1];

  first = 1;
  lbin = 0; lbout = 0;
  
  while ( 1 ) {
    gettimeofday(&t_now, NULL);
    pnd = fopen("/proc/net/dev", "r");
    if ( !pnd ) {
      fprintf(stderr, "%s: /proc/net/dev: %s", argv[0], strerror(errno));
      exit(1);
    }

    /* Skip header */
    skipline(pnd);
    skipline(pnd);

    /* Get interface info */
    do {
      if ( fscanf(pnd, " %6[^:]:%u %u %u %u %u %u %u %u %u %u %u %u %u %u %u",
		  &ifc.name,
		  &ifc.r_bytes, &ifc.r_pkt, &ifc.r_err, &ifc.r_drop,
		  &ifc.r_fifo, &ifc.r_frame, &ifc.r_compr, &ifc.r_mcast,
		  &ifc.x_bytes, &ifc.x_pkt, &ifc.x_err, &ifc.x_drop,
		  &ifc.x_fifo, &ifc.x_coll, &ifc.x_carrier, &ifc.x_compr)
	   != 16 ) {
	exit(200);
      }
      skipline(pnd);
    } while ( strcmp(ifc.name, interface) );

    bin  = ifc.r_bytes + (lbin & ~0xffffffffULL);
    bout = ifc.x_bytes + (lbout & ~0xffffffffULL);

    if ( bin < lbin )
      bin += (1ULL << 32);
    if ( bout < lbout )
      bout += (1ULL << 32);

    if ( !first ) {
      char command_buf[512];
      FILE *ubar;

      timedelta = (double)(t_now.tv_sec - t_last.tv_sec) + 
	(t_now.tv_usec - t_last.tv_usec)/1000000.0;
      bwin = (bin-lbin)*8/timedelta;
      bwout = (bout-lbout)*8/timedelta;
      
      ubar = fopen("ubar1.txt", "w");
      if ( ubar ) {
	fprintf(ubar, "Current bandwidth utilization %5.1f Mbit/s\n", bwout/1000000.0);
	fclose(ubar);
	
	sprintf(command_buf, "ubar.pl %20.8g 600 4 | pnmtopng -transparent '#ffffff' > ubar1.png", bwout/MAXBANDWIDTH);
	system(command_buf);

	rename("ubar1.txt", "ubar.txt");
	rename("ubar1.png", "ubar.png");
      }
    } else {
      first = 0;
    }

    lbin = bin;  lbout = bout;  t_last = t_now;

    fclose(pnd);

    sleep(15);
  }
}
