#!/usr/bin/perl
#
# Produce a cute little utilization bar based on some certain
# percentage.  It outputs a ppm file which can be converted to
# other formats via netpbm et al.
#
# Usage:
#
#  ubar.pl perc width height > output.ppm
#

($perc, $width, $height) = @ARGV;

$perc   += 0;
$width  += 0;
$height += 0;

$spacers = 5;

$ucolor = pack("CCC", 214, 136, 131);
$ncolor = pack("CCC", 204, 204, 227);
$scolor = pack("CCC", 255, 255, 255);

print "P6\n";
printf "%d %d\n", $width, $height;
print "255\n";

for ( $j = 0 ; $j < $height ; $j++ ) {
    $spacer = 0;
    for ( $i = 1 ; $i <= $width ; $i++ ) {
	$frac = $i/$width;
	$fspacer = int($spacers*$frac);
	if ( $i < $width && $spacer < $fspacer ) {
	    print $scolor;
	} elsif ( $perc < $frac ) {
	    print $ncolor;
	} else {
	    print $ucolor;
	}
	$spacer = $fspacer;
    }
}
print "\n";

