#ifndef _I386_INIT_H
#define _I386_INIT_H

#include <linux/config.h>

#ifdef CONFIG_KERNEL_DEBUGGING
/*
 * GCC bug, -pg doesnt mix well with section attribute ... :*(
 * memleak also needs the __init functions to stay resident
 * due to ID structs (alloc_struct see mm.h) living in some init code.
 */
#define __init
#define __initdata
#define __initfunc(__arginit) __arginit
#define __INIT
#define __FINIT
#define __INITDATA

#else
/*
 * no -pg switch, we are cool and use init sections:
 */
#define __init __attribute__ ((__section__ (".text.init")))
#define __initdata __attribute__ ((__section__ (".data.init")))
#define __initfunc(__arginit) \
	__arginit __init; \
	__arginit
/* For assembly routines */
#define __INIT		.section	".text.init",#alloc,#execinstr
#define __FINIT	.previous
#define __INITDATA	.section	".data.init",#alloc,#write

#endif

#define __cacheline_aligned __attribute__ \
			 ((__section__ (".data.cacheline_aligned")))

#endif
