#ifndef _LINUX_PROFILER_H
#define _LINUX_PROFILER_H

#include <linux/config.h>
#include <linux/types.h>
#include <asm/profiler.h>
#include <asm/spinlock.h>

#ifdef __KERNEL__
#ifdef CONFIG_DEBUG_MCOUNT

extern void mcount (void);
extern int mcount_internal(profiler_pc_t self_addr);
extern atomic_t mcount_ready;		/* controls all mcount() processing */

#define SUSPEND_MCOUNT atomic_dec(&mcount_ready)
#define RESUME_MCOUNT atomic_inc(&mcount_ready)
#define SUSPEND_MCOUNT_PROC(x) ((x)->flags |= PF_NO_MCOUNT)
#define RESUME_MCOUNT_PROC(x) ((x)->flags &= ~PF_NO_MCOUNT)
#define MCOUNT() mcount()

#ifdef CONFIG_TRACE

extern atomic_t mcount_trace_ready;	/* controls just mcount() tracing */
/*
 * Protect the profiling table with a spin lock, only one cpu at a
 * time.  No point in read/write locks, almost all accesses are for
 * write.  Since this code is accessed from all contexts, use
 * spin_lock_irqsave.
 */
extern spinlock_t trace_table_lock;

/* Note: The hierarchy is mcount_ready, mcount_trace_ready, trace_table_lock */

struct trace_entry {
        profiler_pc_t pc;
#ifdef CONFIG_TRACE_TIMESTAMP
        profiler_timestamp_t timestamp;
#endif
#ifdef CONFIG_TRACE_PID
	pid_t pid;
#endif
#if defined(CONFIG_TRACE_CPU) && (defined(__SMP__) || defined(CONFIG_SMP))
	unsigned int cpu;
#endif
};

extern struct trace_table {
	unsigned int table_size;
	unsigned int curr_call;
	struct trace_entry entries[CONFIG_TRACE_SIZE];
} *trace_table;

/*
 * die_if_kernel() uses this to 'extend' the stack trace given in an Oops
 * message. You can use this when debugging special code, as a debugging aid.
 */
void print_emergency_trace (void);

#define TRACE_CALIBRATION_CALLS 20

#define SUSPEND_MCOUNT_TRACE atomic_dec(&mcount_trace_ready)
#define RESUME_MCOUNT_TRACE atomic_inc(&mcount_trace_ready)
#define LOCK_MCOUNT_TRACE(x) spin_lock_irqsave(&trace_table_lock, x);
#define UNLOCK_MCOUNT_TRACE(x) spin_unlock_irqrestore(&trace_table_lock, x);

#else /* !CONFIG_TRACE */

#define SUSPEND_MCOUNT_TRACE
#define RESUME_MCOUNT_TRACE
#define LOCK_MCOUNT_TRACE(x)
#define UNLOCK_MCOUNT_TRACE(x)

#endif /* CONFIG_TRACE */
#else /* !CONFIG_DEBUG_MCOUNT */

#define SUSPEND_MCOUNT
#define RESUME_MCOUNT
#define SUSPEND_MCOUNT_PROC(x)
#define RESUME_MCOUNT_PROC(x)
#define MCOUNT()

#endif /* CONFIG_DEBUG_MCOUNT */

#endif /* __KERNEL__ */

#endif	/* _LINUX_PROFILER_H */
