/* Test for labels in statement expressions: bugs 772 and 17913.
   goto statements must not jump into statement expressions.

   This tests all combinations of label and goto locations in a given
   function.  Each combination is tested twice, once with just that
   label and goto and once with many others in order to exercise the
   different code paths involved with excess labels.  */

/* Origin: Joseph Myers <joseph@codesourcery.com> */
/* { dg-do compile } */
/* { dg-options "" } */

void f0 (void) {  goto a; a:({ ({0;}); ({0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; }
void fa0 (void) { p0A:goto p0A; goto a; a:({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f1 (void) {  goto a; ({ a:({0;}); ({0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa1 (void) { p0A:goto p0A; goto a; P0A:goto P0A;({ a:({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f2 (void) {  goto a; ({ ({a:0;}); ({0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa2 (void) { p0A:goto p0A; goto a; P0A:goto P0A;({ P01A:goto P01A;({a:0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f3 (void) {  goto a; ({ ({0;}); a:({0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa3 (void) { p0A:goto p0A; goto a; P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); a:({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f4 (void) {  goto a; ({ ({0;}); ({a:0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa4 (void) { p0A:goto p0A; goto a; P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({a:0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f5 (void) {  goto a; ({ ({0;}); ({0;}); a:0;}); ({ ({0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa5 (void) { p0A:goto p0A; goto a; P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); a:0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f6 (void) {  goto a; ({ ({0;}); ({0;}); 0;}); a:({ ({0;}); ({0;}); 0;}); 0; }
void fa6 (void) { p0A:goto p0A; goto a; P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); a:({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f7 (void) {  goto a; ({ ({0;}); ({0;}); 0;}); ({ a:({0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa7 (void) { p0A:goto p0A; goto a; P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ a:({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f8 (void) {  goto a; ({ ({0;}); ({0;}); 0;}); ({ ({a:0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa8 (void) { p0A:goto p0A; goto a; P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({a:0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f9 (void) {  goto a; ({ ({0;}); ({0;}); 0;}); ({ ({0;}); a:({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa9 (void) { p0A:goto p0A; goto a; P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); a:({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f10 (void) {  goto a; ({ ({0;}); ({0;}); 0;}); ({ ({0;}); ({a:0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa10 (void) { p0A:goto p0A; goto a; P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({a:0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f11 (void) {  goto a; ({ ({0;}); ({0;}); 0;}); ({ ({0;}); ({0;}); a:0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa11 (void) { p0A:goto p0A; goto a; P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); a:0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f12 (void) {  goto a; ({ ({0;}); ({0;}); 0;}); ({ ({0;}); ({0;}); 0;}); a:0; }
void fa12 (void) { p0A:goto p0A; goto a; P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); a:0;P0D:goto P0D; }
void f13 (void) { a: goto a; ({ ({0;}); ({0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; }
void fa13 (void) { a: goto a; P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f14 (void) { a:({  goto a; ({0;}); ({0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; }
void fa14 (void) { a:({ p01A:goto p01A; goto a; P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f15 (void) { ({  goto a; a:({0;}); ({0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; }
void fa15 (void) { P0A:goto P0A;({ p01A:goto p01A; goto a; a:({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f16 (void) { ({  goto a; ({a:0;}); ({0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa16 (void) { P0A:goto P0A;({ p01A:goto p01A; goto a; P01A:goto P01A;({a:0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f17 (void) { ({  goto a; ({0;}); a:({0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; }
void fa17 (void) { P0A:goto P0A;({ p01A:goto p01A; goto a; P01A:goto P01A;({P012A:goto P012A;0;}); a:({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f18 (void) { ({  goto a; ({0;}); ({a:0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa18 (void) { P0A:goto P0A;({ p01A:goto p01A; goto a; P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({a:0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f19 (void) { ({  goto a; ({0;}); ({0;}); a:0;}); ({ ({0;}); ({0;}); 0;}); 0; }
void fa19 (void) { P0A:goto P0A;({ p01A:goto p01A; goto a; P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); a:0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f20 (void) { ({  goto a; ({0;}); ({0;}); 0;}); a:({ ({0;}); ({0;}); 0;}); 0; }
void fa20 (void) { P0A:goto P0A;({ p01A:goto p01A; goto a; P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); a:({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f21 (void) { ({  goto a; ({0;}); ({0;}); 0;}); ({ a:({0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa21 (void) { P0A:goto P0A;({ p01A:goto p01A; goto a; P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ a:({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f22 (void) { ({  goto a; ({0;}); ({0;}); 0;}); ({ ({a:0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa22 (void) { P0A:goto P0A;({ p01A:goto p01A; goto a; P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({a:0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f23 (void) { ({  goto a; ({0;}); ({0;}); 0;}); ({ ({0;}); a:({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa23 (void) { P0A:goto P0A;({ p01A:goto p01A; goto a; P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); a:({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f24 (void) { ({  goto a; ({0;}); ({0;}); 0;}); ({ ({0;}); ({a:0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa24 (void) { P0A:goto P0A;({ p01A:goto p01A; goto a; P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({a:0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f25 (void) { ({  goto a; ({0;}); ({0;}); 0;}); ({ ({0;}); ({0;}); a:0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa25 (void) { P0A:goto P0A;({ p01A:goto p01A; goto a; P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); a:0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f26 (void) { ({  goto a; ({0;}); ({0;}); 0;}); ({ ({0;}); ({0;}); 0;}); a:0; }
void fa26 (void) { P0A:goto P0A;({ p01A:goto p01A; goto a; P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); a:0;P0D:goto P0D; }
void f27 (void) { ({ a: goto a; ({0;}); ({0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; }
void fa27 (void) { P0A:goto P0A;({ a: goto a; P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f28 (void) { a:({ ({ goto a; 0;}); ({0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; }
void fa28 (void) { a:({ P01A:goto P01A;({p012A:goto p012A; goto a; P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f29 (void) { ({ a:({ goto a; 0;}); ({0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; }
void fa29 (void) { P0A:goto P0A;({ a:({p012A:goto p012A; goto a; P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f30 (void) { ({ ({ goto a; a:0;}); ({0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; }
void fa30 (void) { P0A:goto P0A;({ P01A:goto P01A;({p012A:goto p012A; goto a; a:0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f31 (void) { ({ ({ goto a; 0;}); a:({0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; }
void fa31 (void) { P0A:goto P0A;({ P01A:goto P01A;({p012A:goto p012A; goto a; P012A:goto P012A;0;}); a:({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f32 (void) { ({ ({ goto a; 0;}); ({a:0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa32 (void) { P0A:goto P0A;({ P01A:goto P01A;({p012A:goto p012A; goto a; P012A:goto P012A;0;}); P01B:goto P01B;({a:0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f33 (void) { ({ ({ goto a; 0;}); ({0;}); a:0;}); ({ ({0;}); ({0;}); 0;}); 0; }
void fa33 (void) { P0A:goto P0A;({ P01A:goto P01A;({p012A:goto p012A; goto a; P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); a:0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f34 (void) { ({ ({ goto a; 0;}); ({0;}); 0;}); a:({ ({0;}); ({0;}); 0;}); 0; }
void fa34 (void) { P0A:goto P0A;({ P01A:goto P01A;({p012A:goto p012A; goto a; P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); a:({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f35 (void) { ({ ({ goto a; 0;}); ({0;}); 0;}); ({ a:({0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa35 (void) { P0A:goto P0A;({ P01A:goto P01A;({p012A:goto p012A; goto a; P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ a:({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f36 (void) { ({ ({ goto a; 0;}); ({0;}); 0;}); ({ ({a:0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa36 (void) { P0A:goto P0A;({ P01A:goto P01A;({p012A:goto p012A; goto a; P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({a:0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f37 (void) { ({ ({ goto a; 0;}); ({0;}); 0;}); ({ ({0;}); a:({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa37 (void) { P0A:goto P0A;({ P01A:goto P01A;({p012A:goto p012A; goto a; P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); a:({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f38 (void) { ({ ({ goto a; 0;}); ({0;}); 0;}); ({ ({0;}); ({a:0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa38 (void) { P0A:goto P0A;({ P01A:goto P01A;({p012A:goto p012A; goto a; P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({a:0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f39 (void) { ({ ({ goto a; 0;}); ({0;}); 0;}); ({ ({0;}); ({0;}); a:0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa39 (void) { P0A:goto P0A;({ P01A:goto P01A;({p012A:goto p012A; goto a; P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); a:0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f40 (void) { ({ ({ goto a; 0;}); ({0;}); 0;}); ({ ({0;}); ({0;}); 0;}); a:0; }
void fa40 (void) { P0A:goto P0A;({ P01A:goto P01A;({p012A:goto p012A; goto a; P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); a:0;P0D:goto P0D; }
void f41 (void) { ({ ({a: goto a; 0;}); ({0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; }
void fa41 (void) { P0A:goto P0A;({ P01A:goto P01A;({a: goto a; P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f42 (void) { a:({ ({0;});  goto a; ({0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; }
void fa42 (void) { a:({ P01A:goto P01A;({P012A:goto P012A;0;}); p01B:goto p01B; goto a; P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f43 (void) { ({ a:({0;});  goto a; ({0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; }
void fa43 (void) { P0A:goto P0A;({ a:({P012A:goto P012A;0;}); p01B:goto p01B; goto a; P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f44 (void) { ({ ({a:0;});  goto a; ({0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa44 (void) { P0A:goto P0A;({ P01A:goto P01A;({a:0;}); p01B:goto p01B; goto a; P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f45 (void) { ({ ({0;});  goto a; a:({0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; }
void fa45 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); p01B:goto p01B; goto a; a:({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f46 (void) { ({ ({0;});  goto a; ({a:0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa46 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); p01B:goto p01B; goto a; P01B:goto P01B;({a:0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f47 (void) { ({ ({0;});  goto a; ({0;}); a:0;}); ({ ({0;}); ({0;}); 0;}); 0; }
void fa47 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); p01B:goto p01B; goto a; P01B:goto P01B;({P013A:goto P013A;0;}); a:0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f48 (void) { ({ ({0;});  goto a; ({0;}); 0;}); a:({ ({0;}); ({0;}); 0;}); 0; }
void fa48 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); p01B:goto p01B; goto a; P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); a:({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f49 (void) { ({ ({0;});  goto a; ({0;}); 0;}); ({ a:({0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa49 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); p01B:goto p01B; goto a; P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ a:({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f50 (void) { ({ ({0;});  goto a; ({0;}); 0;}); ({ ({a:0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa50 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); p01B:goto p01B; goto a; P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({a:0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f51 (void) { ({ ({0;});  goto a; ({0;}); 0;}); ({ ({0;}); a:({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa51 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); p01B:goto p01B; goto a; P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); a:({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f52 (void) { ({ ({0;});  goto a; ({0;}); 0;}); ({ ({0;}); ({a:0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa52 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); p01B:goto p01B; goto a; P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({a:0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f53 (void) { ({ ({0;});  goto a; ({0;}); 0;}); ({ ({0;}); ({0;}); a:0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa53 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); p01B:goto p01B; goto a; P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); a:0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f54 (void) { ({ ({0;});  goto a; ({0;}); 0;}); ({ ({0;}); ({0;}); 0;}); a:0; }
void fa54 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); p01B:goto p01B; goto a; P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); a:0;P0D:goto P0D; }
void f55 (void) { ({ ({0;}); a: goto a; ({0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; }
void fa55 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); a: goto a; P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f56 (void) { a:({ ({0;}); ({ goto a; 0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; }
void fa56 (void) { a:({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({p013A:goto p013A; goto a; P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f57 (void) { ({ a:({0;}); ({ goto a; 0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; }
void fa57 (void) { P0A:goto P0A;({ a:({P012A:goto P012A;0;}); P01B:goto P01B;({p013A:goto p013A; goto a; P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f58 (void) { ({ ({a:0;}); ({ goto a; 0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa58 (void) { P0A:goto P0A;({ P01A:goto P01A;({a:0;}); P01B:goto P01B;({p013A:goto p013A; goto a; P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f59 (void) { ({ ({0;}); a:({ goto a; 0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; }
void fa59 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); a:({p013A:goto p013A; goto a; P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f60 (void) { ({ ({0;}); ({ goto a; a:0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; }
void fa60 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({p013A:goto p013A; goto a; a:0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f61 (void) { ({ ({0;}); ({ goto a; 0;}); a:0;}); ({ ({0;}); ({0;}); 0;}); 0; }
void fa61 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({p013A:goto p013A; goto a; P013A:goto P013A;0;}); a:0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f62 (void) { ({ ({0;}); ({ goto a; 0;}); 0;}); a:({ ({0;}); ({0;}); 0;}); 0; }
void fa62 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({p013A:goto p013A; goto a; P013A:goto P013A;0;}); P01C:goto P01C;0;}); a:({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f63 (void) { ({ ({0;}); ({ goto a; 0;}); 0;}); ({ a:({0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa63 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({p013A:goto p013A; goto a; P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ a:({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f64 (void) { ({ ({0;}); ({ goto a; 0;}); 0;}); ({ ({a:0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa64 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({p013A:goto p013A; goto a; P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({a:0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f65 (void) { ({ ({0;}); ({ goto a; 0;}); 0;}); ({ ({0;}); a:({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa65 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({p013A:goto p013A; goto a; P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); a:({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f66 (void) { ({ ({0;}); ({ goto a; 0;}); 0;}); ({ ({0;}); ({a:0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa66 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({p013A:goto p013A; goto a; P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({a:0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f67 (void) { ({ ({0;}); ({ goto a; 0;}); 0;}); ({ ({0;}); ({0;}); a:0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa67 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({p013A:goto p013A; goto a; P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); a:0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f68 (void) { ({ ({0;}); ({ goto a; 0;}); 0;}); ({ ({0;}); ({0;}); 0;}); a:0; }
void fa68 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({p013A:goto p013A; goto a; P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); a:0;P0D:goto P0D; }
void f69 (void) { ({ ({0;}); ({a: goto a; 0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; }
void fa69 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({a: goto a; P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f70 (void) { a:({ ({0;}); ({0;});  goto a; 0;}); ({ ({0;}); ({0;}); 0;}); 0; }
void fa70 (void) { a:({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); p01C:goto p01C; goto a; P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f71 (void) { ({ a:({0;}); ({0;});  goto a; 0;}); ({ ({0;}); ({0;}); 0;}); 0; }
void fa71 (void) { P0A:goto P0A;({ a:({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); p01C:goto p01C; goto a; P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f72 (void) { ({ ({a:0;}); ({0;});  goto a; 0;}); ({ ({0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa72 (void) { P0A:goto P0A;({ P01A:goto P01A;({a:0;}); P01B:goto P01B;({P013A:goto P013A;0;}); p01C:goto p01C; goto a; P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f73 (void) { ({ ({0;}); a:({0;});  goto a; 0;}); ({ ({0;}); ({0;}); 0;}); 0; }
void fa73 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); a:({P013A:goto P013A;0;}); p01C:goto p01C; goto a; P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f74 (void) { ({ ({0;}); ({a:0;});  goto a; 0;}); ({ ({0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa74 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({a:0;}); p01C:goto p01C; goto a; P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f75 (void) { ({ ({0;}); ({0;});  goto a; a:0;}); ({ ({0;}); ({0;}); 0;}); 0; }
void fa75 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); p01C:goto p01C; goto a; a:0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f76 (void) { ({ ({0;}); ({0;});  goto a; 0;}); a:({ ({0;}); ({0;}); 0;}); 0; }
void fa76 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); p01C:goto p01C; goto a; P01C:goto P01C;0;}); a:({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f77 (void) { ({ ({0;}); ({0;});  goto a; 0;}); ({ a:({0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa77 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); p01C:goto p01C; goto a; P01C:goto P01C;0;}); P0B:goto P0B;({ a:({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f78 (void) { ({ ({0;}); ({0;});  goto a; 0;}); ({ ({a:0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa78 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); p01C:goto p01C; goto a; P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({a:0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f79 (void) { ({ ({0;}); ({0;});  goto a; 0;}); ({ ({0;}); a:({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa79 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); p01C:goto p01C; goto a; P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); a:({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f80 (void) { ({ ({0;}); ({0;});  goto a; 0;}); ({ ({0;}); ({a:0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa80 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); p01C:goto p01C; goto a; P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({a:0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f81 (void) { ({ ({0;}); ({0;});  goto a; 0;}); ({ ({0;}); ({0;}); a:0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa81 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); p01C:goto p01C; goto a; P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); a:0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f82 (void) { ({ ({0;}); ({0;});  goto a; 0;}); ({ ({0;}); ({0;}); 0;}); a:0; }
void fa82 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); p01C:goto p01C; goto a; P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); a:0;P0D:goto P0D; }
void f83 (void) { ({ ({0;}); ({0;}); a: goto a; 0;}); ({ ({0;}); ({0;}); 0;}); 0; }
void fa83 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); a: goto a; P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f84 (void) { a:({ ({0;}); ({0;}); 0;});  goto a; ({ ({0;}); ({0;}); 0;}); 0; }
void fa84 (void) { a:({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); p0B:goto p0B; goto a; P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f85 (void) { ({ a:({0;}); ({0;}); 0;});  goto a; ({ ({0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa85 (void) { P0A:goto P0A;({ a:({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); p0B:goto p0B; goto a; P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f86 (void) { ({ ({a:0;}); ({0;}); 0;});  goto a; ({ ({0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa86 (void) { P0A:goto P0A;({ P01A:goto P01A;({a:0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); p0B:goto p0B; goto a; P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f87 (void) { ({ ({0;}); a:({0;}); 0;});  goto a; ({ ({0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa87 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); a:({P013A:goto P013A;0;}); P01C:goto P01C;0;}); p0B:goto p0B; goto a; P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f88 (void) { ({ ({0;}); ({a:0;}); 0;});  goto a; ({ ({0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa88 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({a:0;}); P01C:goto P01C;0;}); p0B:goto p0B; goto a; P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f89 (void) { ({ ({0;}); ({0;}); a:0;});  goto a; ({ ({0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa89 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); a:0;}); p0B:goto p0B; goto a; P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f90 (void) { ({ ({0;}); ({0;}); 0;});  goto a; a:({ ({0;}); ({0;}); 0;}); 0; }
void fa90 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); p0B:goto p0B; goto a; a:({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f91 (void) { ({ ({0;}); ({0;}); 0;});  goto a; ({ a:({0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa91 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); p0B:goto p0B; goto a; P0B:goto P0B;({ a:({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f92 (void) { ({ ({0;}); ({0;}); 0;});  goto a; ({ ({a:0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa92 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); p0B:goto p0B; goto a; P0B:goto P0B;({ P02A:goto P02A;({a:0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f93 (void) { ({ ({0;}); ({0;}); 0;});  goto a; ({ ({0;}); a:({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa93 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); p0B:goto p0B; goto a; P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); a:({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f94 (void) { ({ ({0;}); ({0;}); 0;});  goto a; ({ ({0;}); ({a:0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa94 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); p0B:goto p0B; goto a; P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({a:0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f95 (void) { ({ ({0;}); ({0;}); 0;});  goto a; ({ ({0;}); ({0;}); a:0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa95 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); p0B:goto p0B; goto a; P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); a:0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f96 (void) { ({ ({0;}); ({0;}); 0;});  goto a; ({ ({0;}); ({0;}); 0;}); a:0; }
void fa96 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); p0B:goto p0B; goto a; P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); a:0;P0D:goto P0D; }
void f97 (void) { ({ ({0;}); ({0;}); 0;}); a: goto a; ({ ({0;}); ({0;}); 0;}); 0; }
void fa97 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); a: goto a; P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f98 (void) { a:({ ({0;}); ({0;}); 0;}); ({  goto a; ({0;}); ({0;}); 0;}); 0; }
void fa98 (void) { a:({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ p02A:goto p02A; goto a; P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f99 (void) { ({ a:({0;}); ({0;}); 0;}); ({  goto a; ({0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa99 (void) { P0A:goto P0A;({ a:({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ p02A:goto p02A; goto a; P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f100 (void) { ({ ({a:0;}); ({0;}); 0;}); ({  goto a; ({0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa100 (void) { P0A:goto P0A;({ P01A:goto P01A;({a:0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ p02A:goto p02A; goto a; P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f101 (void) { ({ ({0;}); a:({0;}); 0;}); ({  goto a; ({0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa101 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); a:({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ p02A:goto p02A; goto a; P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f102 (void) { ({ ({0;}); ({a:0;}); 0;}); ({  goto a; ({0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa102 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({a:0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ p02A:goto p02A; goto a; P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f103 (void) { ({ ({0;}); ({0;}); a:0;}); ({  goto a; ({0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa103 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); a:0;}); P0B:goto P0B;({ p02A:goto p02A; goto a; P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f104 (void) { ({ ({0;}); ({0;}); 0;}); a:({  goto a; ({0;}); ({0;}); 0;}); 0; }
void fa104 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); a:({ p02A:goto p02A; goto a; P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f105 (void) { ({ ({0;}); ({0;}); 0;}); ({  goto a; a:({0;}); ({0;}); 0;}); 0; }
void fa105 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ p02A:goto p02A; goto a; a:({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f106 (void) { ({ ({0;}); ({0;}); 0;}); ({  goto a; ({a:0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa106 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ p02A:goto p02A; goto a; P02A:goto P02A;({a:0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f107 (void) { ({ ({0;}); ({0;}); 0;}); ({  goto a; ({0;}); a:({0;}); 0;}); 0; }
void fa107 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ p02A:goto p02A; goto a; P02A:goto P02A;({P024A:goto P024A;0;}); a:({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f108 (void) { ({ ({0;}); ({0;}); 0;}); ({  goto a; ({0;}); ({a:0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa108 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ p02A:goto p02A; goto a; P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({a:0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f109 (void) { ({ ({0;}); ({0;}); 0;}); ({  goto a; ({0;}); ({0;}); a:0;}); 0; }
void fa109 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ p02A:goto p02A; goto a; P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); a:0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f110 (void) { ({ ({0;}); ({0;}); 0;}); ({  goto a; ({0;}); ({0;}); 0;}); a:0; }
void fa110 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ p02A:goto p02A; goto a; P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); a:0;P0D:goto P0D; }
void f111 (void) { ({ ({0;}); ({0;}); 0;}); ({ a: goto a; ({0;}); ({0;}); 0;}); 0; }
void fa111 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ a: goto a; P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f112 (void) { a:({ ({0;}); ({0;}); 0;}); ({ ({ goto a; 0;}); ({0;}); 0;}); 0; }
void fa112 (void) { a:({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({p024A:goto p024A; goto a; P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f113 (void) { ({ a:({0;}); ({0;}); 0;}); ({ ({ goto a; 0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa113 (void) { P0A:goto P0A;({ a:({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({p024A:goto p024A; goto a; P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f114 (void) { ({ ({a:0;}); ({0;}); 0;}); ({ ({ goto a; 0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa114 (void) { P0A:goto P0A;({ P01A:goto P01A;({a:0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({p024A:goto p024A; goto a; P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f115 (void) { ({ ({0;}); a:({0;}); 0;}); ({ ({ goto a; 0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa115 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); a:({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({p024A:goto p024A; goto a; P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f116 (void) { ({ ({0;}); ({a:0;}); 0;}); ({ ({ goto a; 0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa116 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({a:0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({p024A:goto p024A; goto a; P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f117 (void) { ({ ({0;}); ({0;}); a:0;}); ({ ({ goto a; 0;}); ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa117 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); a:0;}); P0B:goto P0B;({ P02A:goto P02A;({p024A:goto p024A; goto a; P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f118 (void) { ({ ({0;}); ({0;}); 0;}); a:({ ({ goto a; 0;}); ({0;}); 0;}); 0; }
void fa118 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); a:({ P02A:goto P02A;({p024A:goto p024A; goto a; P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f119 (void) { ({ ({0;}); ({0;}); 0;}); ({ a:({ goto a; 0;}); ({0;}); 0;}); 0; }
void fa119 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ a:({p024A:goto p024A; goto a; P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f120 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({ goto a; a:0;}); ({0;}); 0;}); 0; }
void fa120 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({p024A:goto p024A; goto a; a:0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f121 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({ goto a; 0;}); a:({0;}); 0;}); 0; }
void fa121 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({p024A:goto p024A; goto a; P024A:goto P024A;0;}); a:({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f122 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({ goto a; 0;}); ({a:0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa122 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({p024A:goto p024A; goto a; P024A:goto P024A;0;}); P02B:goto P02B;({a:0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f123 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({ goto a; 0;}); ({0;}); a:0;}); 0; }
void fa123 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({p024A:goto p024A; goto a; P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); a:0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f124 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({ goto a; 0;}); ({0;}); 0;}); a:0; }
void fa124 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({p024A:goto p024A; goto a; P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); a:0;P0D:goto P0D; }
void f125 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({a: goto a; 0;}); ({0;}); 0;}); 0; }
void fa125 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({a: goto a; P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f126 (void) { a:({ ({0;}); ({0;}); 0;}); ({ ({0;});  goto a; ({0;}); 0;}); 0; }
void fa126 (void) { a:({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); p02B:goto p02B; goto a; P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f127 (void) { ({ a:({0;}); ({0;}); 0;}); ({ ({0;});  goto a; ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa127 (void) { P0A:goto P0A;({ a:({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); p02B:goto p02B; goto a; P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f128 (void) { ({ ({a:0;}); ({0;}); 0;}); ({ ({0;});  goto a; ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa128 (void) { P0A:goto P0A;({ P01A:goto P01A;({a:0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); p02B:goto p02B; goto a; P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f129 (void) { ({ ({0;}); a:({0;}); 0;}); ({ ({0;});  goto a; ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa129 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); a:({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); p02B:goto p02B; goto a; P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f130 (void) { ({ ({0;}); ({a:0;}); 0;}); ({ ({0;});  goto a; ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa130 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({a:0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); p02B:goto p02B; goto a; P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f131 (void) { ({ ({0;}); ({0;}); a:0;}); ({ ({0;});  goto a; ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa131 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); a:0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); p02B:goto p02B; goto a; P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f132 (void) { ({ ({0;}); ({0;}); 0;}); a:({ ({0;});  goto a; ({0;}); 0;}); 0; }
void fa132 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); a:({ P02A:goto P02A;({P024A:goto P024A;0;}); p02B:goto p02B; goto a; P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f133 (void) { ({ ({0;}); ({0;}); 0;}); ({ a:({0;});  goto a; ({0;}); 0;}); 0; }
void fa133 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ a:({P024A:goto P024A;0;}); p02B:goto p02B; goto a; P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f134 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({a:0;});  goto a; ({0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa134 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({a:0;}); p02B:goto p02B; goto a; P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f135 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({0;});  goto a; a:({0;}); 0;}); 0; }
void fa135 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); p02B:goto p02B; goto a; a:({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f136 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({0;});  goto a; ({a:0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa136 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); p02B:goto p02B; goto a; P02B:goto P02B;({a:0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f137 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({0;});  goto a; ({0;}); a:0;}); 0; }
void fa137 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); p02B:goto p02B; goto a; P02B:goto P02B;({P025A:goto P025A;0;}); a:0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f138 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({0;});  goto a; ({0;}); 0;}); a:0; }
void fa138 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); p02B:goto p02B; goto a; P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); a:0;P0D:goto P0D; }
void f139 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({0;}); a: goto a; ({0;}); 0;}); 0; }
void fa139 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); a: goto a; P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f140 (void) { a:({ ({0;}); ({0;}); 0;}); ({ ({0;}); ({ goto a; 0;}); 0;}); 0; }
void fa140 (void) { a:({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({p025A:goto p025A; goto a; P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f141 (void) { ({ a:({0;}); ({0;}); 0;}); ({ ({0;}); ({ goto a; 0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa141 (void) { P0A:goto P0A;({ a:({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({p025A:goto p025A; goto a; P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f142 (void) { ({ ({a:0;}); ({0;}); 0;}); ({ ({0;}); ({ goto a; 0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa142 (void) { P0A:goto P0A;({ P01A:goto P01A;({a:0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({p025A:goto p025A; goto a; P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f143 (void) { ({ ({0;}); a:({0;}); 0;}); ({ ({0;}); ({ goto a; 0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa143 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); a:({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({p025A:goto p025A; goto a; P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f144 (void) { ({ ({0;}); ({a:0;}); 0;}); ({ ({0;}); ({ goto a; 0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa144 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({a:0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({p025A:goto p025A; goto a; P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f145 (void) { ({ ({0;}); ({0;}); a:0;}); ({ ({0;}); ({ goto a; 0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa145 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); a:0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({p025A:goto p025A; goto a; P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f146 (void) { ({ ({0;}); ({0;}); 0;}); a:({ ({0;}); ({ goto a; 0;}); 0;}); 0; }
void fa146 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); a:({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({p025A:goto p025A; goto a; P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f147 (void) { ({ ({0;}); ({0;}); 0;}); ({ a:({0;}); ({ goto a; 0;}); 0;}); 0; }
void fa147 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ a:({P024A:goto P024A;0;}); P02B:goto P02B;({p025A:goto p025A; goto a; P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f148 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({a:0;}); ({ goto a; 0;}); 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa148 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({a:0;}); P02B:goto P02B;({p025A:goto p025A; goto a; P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f149 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({0;}); a:({ goto a; 0;}); 0;}); 0; }
void fa149 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); a:({p025A:goto p025A; goto a; P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f150 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({0;}); ({ goto a; a:0;}); 0;}); 0; }
void fa150 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({p025A:goto p025A; goto a; a:0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f151 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({0;}); ({ goto a; 0;}); a:0;}); 0; }
void fa151 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({p025A:goto p025A; goto a; P025A:goto P025A;0;}); a:0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f152 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({0;}); ({ goto a; 0;}); 0;}); a:0; }
void fa152 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({p025A:goto p025A; goto a; P025A:goto P025A;0;}); P02C:goto P02C;0;}); a:0;P0D:goto P0D; }
void f153 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({0;}); ({a: goto a; 0;}); 0;}); 0; }
void fa153 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({a: goto a; P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f154 (void) { a:({ ({0;}); ({0;}); 0;}); ({ ({0;}); ({0;});  goto a; 0;}); 0; }
void fa154 (void) { a:({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); p02C:goto p02C; goto a; P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f155 (void) { ({ a:({0;}); ({0;}); 0;}); ({ ({0;}); ({0;});  goto a; 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa155 (void) { P0A:goto P0A;({ a:({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); p02C:goto p02C; goto a; P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f156 (void) { ({ ({a:0;}); ({0;}); 0;}); ({ ({0;}); ({0;});  goto a; 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa156 (void) { P0A:goto P0A;({ P01A:goto P01A;({a:0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); p02C:goto p02C; goto a; P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f157 (void) { ({ ({0;}); a:({0;}); 0;}); ({ ({0;}); ({0;});  goto a; 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa157 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); a:({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); p02C:goto p02C; goto a; P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f158 (void) { ({ ({0;}); ({a:0;}); 0;}); ({ ({0;}); ({0;});  goto a; 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa158 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({a:0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); p02C:goto p02C; goto a; P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f159 (void) { ({ ({0;}); ({0;}); a:0;}); ({ ({0;}); ({0;});  goto a; 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa159 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); a:0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); p02C:goto p02C; goto a; P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f160 (void) { ({ ({0;}); ({0;}); 0;}); a:({ ({0;}); ({0;});  goto a; 0;}); 0; }
void fa160 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); a:({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); p02C:goto p02C; goto a; P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f161 (void) { ({ ({0;}); ({0;}); 0;}); ({ a:({0;}); ({0;});  goto a; 0;}); 0; }
void fa161 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ a:({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); p02C:goto p02C; goto a; P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f162 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({a:0;}); ({0;});  goto a; 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa162 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({a:0;}); P02B:goto P02B;({P025A:goto P025A;0;}); p02C:goto p02C; goto a; P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f163 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({0;}); a:({0;});  goto a; 0;}); 0; }
void fa163 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); a:({P025A:goto P025A;0;}); p02C:goto p02C; goto a; P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f164 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({0;}); ({a:0;});  goto a; 0;}); 0; } /* { dg-error "jump into statement expression" } */
void fa164 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({a:0;}); p02C:goto p02C; goto a; P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f165 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({0;}); ({0;});  goto a; a:0;}); 0; }
void fa165 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); p02C:goto p02C; goto a; a:0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f166 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({0;}); ({0;});  goto a; 0;}); a:0; }
void fa166 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); p02C:goto p02C; goto a; P02C:goto P02C;0;}); a:0;P0D:goto P0D; }
void f167 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({0;}); ({0;}); a: goto a; 0;}); 0; }
void fa167 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); a: goto a; P02C:goto P02C;0;}); P0C:goto P0C;0;P0D:goto P0D; }
void f168 (void) { a:({ ({0;}); ({0;}); 0;}); ({ ({0;}); ({0;}); 0;});  goto a; 0; }
void fa168 (void) { a:({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); p0C:goto p0C; goto a; P0C:goto P0C;0;P0D:goto P0D; }
void f169 (void) { ({ a:({0;}); ({0;}); 0;}); ({ ({0;}); ({0;}); 0;});  goto a; 0; } /* { dg-error "jump into statement expression" } */
void fa169 (void) { P0A:goto P0A;({ a:({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); p0C:goto p0C; goto a; P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f170 (void) { ({ ({a:0;}); ({0;}); 0;}); ({ ({0;}); ({0;}); 0;});  goto a; 0; } /* { dg-error "jump into statement expression" } */
void fa170 (void) { P0A:goto P0A;({ P01A:goto P01A;({a:0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); p0C:goto p0C; goto a; P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f171 (void) { ({ ({0;}); a:({0;}); 0;}); ({ ({0;}); ({0;}); 0;});  goto a; 0; } /* { dg-error "jump into statement expression" } */
void fa171 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); a:({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); p0C:goto p0C; goto a; P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f172 (void) { ({ ({0;}); ({a:0;}); 0;}); ({ ({0;}); ({0;}); 0;});  goto a; 0; } /* { dg-error "jump into statement expression" } */
void fa172 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({a:0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); p0C:goto p0C; goto a; P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f173 (void) { ({ ({0;}); ({0;}); a:0;}); ({ ({0;}); ({0;}); 0;});  goto a; 0; } /* { dg-error "jump into statement expression" } */
void fa173 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); a:0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); p0C:goto p0C; goto a; P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f174 (void) { ({ ({0;}); ({0;}); 0;}); a:({ ({0;}); ({0;}); 0;});  goto a; 0; }
void fa174 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); a:({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); p0C:goto p0C; goto a; P0C:goto P0C;0;P0D:goto P0D; }
void f175 (void) { ({ ({0;}); ({0;}); 0;}); ({ a:({0;}); ({0;}); 0;});  goto a; 0; } /* { dg-error "jump into statement expression" } */
void fa175 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ a:({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); p0C:goto p0C; goto a; P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f176 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({a:0;}); ({0;}); 0;});  goto a; 0; } /* { dg-error "jump into statement expression" } */
void fa176 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({a:0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); p0C:goto p0C; goto a; P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f177 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({0;}); a:({0;}); 0;});  goto a; 0; } /* { dg-error "jump into statement expression" } */
void fa177 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); a:({P025A:goto P025A;0;}); P02C:goto P02C;0;}); p0C:goto p0C; goto a; P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f178 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({0;}); ({a:0;}); 0;});  goto a; 0; } /* { dg-error "jump into statement expression" } */
void fa178 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({a:0;}); P02C:goto P02C;0;}); p0C:goto p0C; goto a; P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f179 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({0;}); ({0;}); a:0;});  goto a; 0; } /* { dg-error "jump into statement expression" } */
void fa179 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); a:0;}); p0C:goto p0C; goto a; P0C:goto P0C;0;P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f180 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({0;}); ({0;}); 0;});  goto a; a:0; }
void fa180 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); p0C:goto p0C; goto a; a:0;P0D:goto P0D; }
void f181 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({0;}); ({0;}); 0;}); a: goto a; 0; }
void fa181 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); a: goto a; P0C:goto P0C;0;P0D:goto P0D; }
void f182 (void) { a:({ ({0;}); ({0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; goto a;  }
void fa182 (void) { a:({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;p0D:goto p0D; goto a; P0D:goto P0D; }
void f183 (void) { ({ a:({0;}); ({0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; goto a;  } /* { dg-error "jump into statement expression" } */
void fa183 (void) { P0A:goto P0A;({ a:({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;p0D:goto p0D; goto a; P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f184 (void) { ({ ({a:0;}); ({0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; goto a;  } /* { dg-error "jump into statement expression" } */
void fa184 (void) { P0A:goto P0A;({ P01A:goto P01A;({a:0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;p0D:goto p0D; goto a; P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f185 (void) { ({ ({0;}); a:({0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; goto a;  } /* { dg-error "jump into statement expression" } */
void fa185 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); a:({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;p0D:goto p0D; goto a; P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f186 (void) { ({ ({0;}); ({a:0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0; goto a;  } /* { dg-error "jump into statement expression" } */
void fa186 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({a:0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;p0D:goto p0D; goto a; P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f187 (void) { ({ ({0;}); ({0;}); a:0;}); ({ ({0;}); ({0;}); 0;}); 0; goto a;  } /* { dg-error "jump into statement expression" } */
void fa187 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); a:0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;p0D:goto p0D; goto a; P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f188 (void) { ({ ({0;}); ({0;}); 0;}); a:({ ({0;}); ({0;}); 0;}); 0; goto a;  }
void fa188 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); a:({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;p0D:goto p0D; goto a; P0D:goto P0D; }
void f189 (void) { ({ ({0;}); ({0;}); 0;}); ({ a:({0;}); ({0;}); 0;}); 0; goto a;  } /* { dg-error "jump into statement expression" } */
void fa189 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ a:({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;p0D:goto p0D; goto a; P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f190 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({a:0;}); ({0;}); 0;}); 0; goto a;  } /* { dg-error "jump into statement expression" } */
void fa190 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({a:0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;p0D:goto p0D; goto a; P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f191 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({0;}); a:({0;}); 0;}); 0; goto a;  } /* { dg-error "jump into statement expression" } */
void fa191 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); a:({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;p0D:goto p0D; goto a; P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f192 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({0;}); ({a:0;}); 0;}); 0; goto a;  } /* { dg-error "jump into statement expression" } */
void fa192 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({a:0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;p0D:goto p0D; goto a; P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f193 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({0;}); ({0;}); a:0;}); 0; goto a;  } /* { dg-error "jump into statement expression" } */
void fa193 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); a:0;}); P0C:goto P0C;0;p0D:goto p0D; goto a; P0D:goto P0D; } /* { dg-error "jump into statement expression" } */
void f194 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({0;}); ({0;}); 0;}); a:0; goto a;  }
void fa194 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); a:0;p0D:goto p0D; goto a; P0D:goto P0D; }
void f195 (void) { ({ ({0;}); ({0;}); 0;}); ({ ({0;}); ({0;}); 0;}); 0;a: goto a;  }
void fa195 (void) { P0A:goto P0A;({ P01A:goto P01A;({P012A:goto P012A;0;}); P01B:goto P01B;({P013A:goto P013A;0;}); P01C:goto P01C;0;}); P0B:goto P0B;({ P02A:goto P02A;({P024A:goto P024A;0;}); P02B:goto P02B;({P025A:goto P025A;0;}); P02C:goto P02C;0;}); P0C:goto P0C;0;a: goto a; P0D:goto P0D; }

/* Match extra informative notes.  */
/* { dg-message "note: label '\[^\n'\]*' defined here" "note: expected" { target *-*-* } 0 } */
