find_path(LZ4_INCLUDE_DIRS NAMES lz4.h)
find_library(LZ4_LIBRARIES NAMES lz4)

if(LZ4_INCLUDE_DIRS AND EXISTS "${LZ4_INCLUDE_DIRS}/lz4.h")
  file(STRINGS "${LZ4_INCLUDE_DIRS}/lz4.h" LZ4_H REGEX "^#define LZ4_VERSION_[MR]")
  string(REGEX REPLACE "LZ4_VERSION" "" LZ4_H "${LZ4_H}")
  string(REGEX MATCHALL "[0-9]+" LZ4_H "${LZ4_H}")
  string(REGEX REPLACE ";" "." LZ4_VERSION_STRING "${LZ4_H}")
endif()

include(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(
    LZ4
    REQUIRED_VARS LZ4_LIBRARIES LZ4_INCLUDE_DIRS
    VERSION_VAR LZ4_VERSION_STRING)

mark_as_advanced(LZ4_INCLUDE_DIRS LZ4_LIBRARIES)
