/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;

public class Initializer
extends BodyDeclaration {
    private static final int LEGAL_MODIFIERS = 8;
    private Block body = null;

    Initializer(AST ast) {
        super(ast);
    }

    public int getNodeType() {
        return 28;
    }

    ASTNode clone(AST target) {
        Initializer result = new Initializer(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setModifiers(this.getModifiers());
        result.setJavadoc((Javadoc)ASTNode.copySubtree(target, this.getJavadoc()));
        result.setBody((Block)this.getBody().clone(target));
        return result;
    }

    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getJavadoc());
            this.acceptChild(visitor, this.getBody());
        }
        visitor.endVisit(this);
    }

    public int getModifiers() {
        return super.getModifiers();
    }

    public void setModifiers(int modifiers) {
        if ((modifiers & 0xFFFFFFF7) != 0) {
            throw new IllegalArgumentException();
        }
        super.setModifiers(modifiers);
    }

    public Block getBody() {
        if (this.body == null) {
            long count = this.getAST().modificationCount();
            this.setBody(new Block(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.body;
    }

    public void setBody(Block body) {
        if (body == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.body, body, true);
        this.body = body;
    }

    int memSize() {
        return super.memSize() + 4;
    }

    int treeSize() {
        return this.memSize() + (this.getJavadoc() == null ? 0 : this.getJavadoc().treeSize()) + (this.body == null ? 0 : this.getBody().treeSize());
    }
}

