/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import org.eclipse.core.internal.jobs.ImplicitJobs;
import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.jobs.Worker;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

class WorkerPool {
    private static final int BEST_BEFORE = 60000;
    private static final int DEFAULT_MAX_THREADS = 25;
    private static final int MIN_THREADS = 1;
    private int busyThreads = 0;
    private JobManager manager;
    private int MAX_THREADS = 25;
    private int numThreads = 0;
    private int sleepingThreads = 0;
    private Worker[] threads = new Worker[10];

    protected WorkerPool(JobManager manager) {
        this.manager = manager;
        this.computeMaxThreads();
    }

    private synchronized void add(Worker worker) {
        int size = this.threads.length;
        if (this.numThreads + 1 > size) {
            Worker[] newThreads = new Worker[2 * size];
            System.arraycopy(this.threads, 0, newThreads, 0, size);
            this.threads = newThreads;
        }
        this.threads[this.numThreads++] = worker;
    }

    protected void computeMaxThreads() {
        int speed = 5;
        switch (speed) {
            case 1: {
                this.MAX_THREADS = 5;
                break;
            }
            case 2: {
                this.MAX_THREADS = 12;
                break;
            }
            case 4: {
                this.MAX_THREADS = 50;
                break;
            }
            case 5: {
                this.MAX_THREADS = 125;
                break;
            }
            default: {
                this.MAX_THREADS = 25;
            }
        }
    }

    private synchronized void decrementBusyThreads() {
        --this.busyThreads;
    }

    protected void endJob(InternalJob job, IStatus result) {
        this.decrementBusyThreads();
        if (job.getRule() != null && !(job instanceof ImplicitJobs.ThreadJob)) {
            this.manager.getLockManager().removeLockCompletely(Thread.currentThread(), job.getRule());
        }
        this.manager.endJob(job, result, true);
    }

    protected synchronized void endWorker(Worker worker) {
        if (this.remove(worker) && JobManager.DEBUG) {
            JobManager.debug("worker removed from pool: " + worker);
        }
    }

    private synchronized void incrementBusyThreads() {
        ++this.busyThreads;
    }

    protected synchronized void jobQueued(InternalJob job) {
        if (this.sleepingThreads > 0) {
            if (JobManager.DEBUG) {
                JobManager.debug("notifiying a worker");
            }
            this.notify();
            return;
        }
        int threadCount = this.numThreads;
        if (this.busyThreads >= threadCount && (threadCount < this.MAX_THREADS || job != null && job.getPriority() == 10)) {
            Worker worker = new Worker(this);
            this.add(worker);
            if (JobManager.DEBUG) {
                JobManager.debug("worker added to pool: " + worker);
            }
            worker.start();
            return;
        }
        if (threadCount > this.MAX_THREADS) {
            String msg = "The job manager has stopped allocating worker threads because too many background tasks are running.";
            InternalPlatform.getDefault().log(new Status(4, "org.eclipse.core.runtime", 1, msg, null));
        }
    }

    private boolean remove(Worker worker) {
        int i = 0;
        while (i < this.threads.length) {
            if (this.threads[i] == worker) {
                System.arraycopy(this.threads, i + 1, this.threads, i, this.numThreads - i - 1);
                this.threads[--this.numThreads] = null;
                return true;
            }
            ++i;
        }
        return false;
    }

    protected synchronized void shutdown() {
        this.notifyAll();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void sleep(long duration) {
        ++this.sleepingThreads;
        if (JobManager.DEBUG) {
            JobManager.debug("worker sleeping for: " + duration + "ms");
        }
        try {
            try {
                this.wait(duration);
            }
            catch (InterruptedException interruptedException) {
                if (JobManager.DEBUG) {
                    JobManager.debug("worker interrupted while waiting... :-|");
                }
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            --this.sleepingThreads;
            throw throwable;
        }
        {
            Object var3_4 = null;
            --this.sleepingThreads;
            return;
        }
    }

    protected InternalJob startJob(Worker worker) {
        WorkerPool workerPool = this;
        synchronized (workerPool) {
            if (!this.manager.isActive() || this.numThreads > this.MAX_THREADS) {
                this.endWorker(worker);
                return null;
            }
        }
        Job job = this.manager.startJob();
        long idleStart = System.currentTimeMillis();
        while (this.manager.isActive() && job == null) {
            long hint = this.manager.sleepHint();
            if (hint > 0L) {
                this.sleep(Math.min(hint, 60000L));
            }
            job = this.manager.startJob();
            WorkerPool workerPool2 = this;
            synchronized (workerPool2) {
                if (job == null && System.currentTimeMillis() - idleStart > 60000L && this.numThreads - this.busyThreads > 1) {
                    this.endWorker(worker);
                    return null;
                }
            }
        }
        if (job != null) {
            this.incrementBusyThreads();
            if (job.getRule() != null && !(job instanceof ImplicitJobs.ThreadJob)) {
                this.manager.getLockManager().addLockThread(Thread.currentThread(), job.getRule());
            }
            if (this.manager.sleepHint() <= 0L) {
                this.jobQueued(null);
            }
        }
        return job;
    }

    protected synchronized void startup() {
        this.computeMaxThreads();
    }
}

