/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Buffer;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.Field;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.MysqlIO;
import com.mysql.jdbc.MysqlParameterMetadata;
import com.mysql.jdbc.NotImplemented;
import com.mysql.jdbc.PreparedStatement;
import com.mysql.jdbc.ResultSet;
import com.mysql.jdbc.ResultSetMetaData;
import com.mysql.jdbc.SQLError;
import com.mysql.jdbc.Statement;
import com.mysql.jdbc.StringUtils;
import com.mysql.jdbc.TimeUtil;
import com.mysql.jdbc.exceptions.MySQLTimeoutException;
import com.mysql.jdbc.profiler.ProfileEventSink;
import com.mysql.jdbc.profiler.ProfilerEvent;
import com.mysql.jdbc.trace.Tracer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.TimerTask;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class ServerPreparedStatement
extends PreparedStatement {
    protected static final int BLOB_STREAM_READ_BUF_SIZE = 8192;
    private static final byte MAX_DATE_REP_LENGTH = 5;
    private static final byte MAX_DATETIME_REP_LENGTH = 12;
    private static final byte MAX_TIME_REP_LENGTH = 13;
    private boolean detectedLongParameterSwitch = false;
    private int fieldCount;
    private boolean invalid = false;
    private SQLException invalidationException;
    private boolean isSelectQuery;
    private Buffer outByteBuffer;
    private BindValue[] parameterBindings;
    private Field[] parameterFields;
    private Field[] resultFields;
    private boolean sendTypesToServer = false;
    private long serverStatementId;
    private int stringTypeCode = 254;
    private boolean serverNeedsResetBeforeEachExecution;
    protected boolean isCached = false;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;
    private static final JoinPoint.StaticPart ajc$tjp_14;
    private static final JoinPoint.StaticPart ajc$tjp_15;
    private static final JoinPoint.StaticPart ajc$tjp_16;
    private static final JoinPoint.StaticPart ajc$tjp_17;
    private static final JoinPoint.StaticPart ajc$tjp_18;
    private static final JoinPoint.StaticPart ajc$tjp_19;
    private static final JoinPoint.StaticPart ajc$tjp_20;
    private static final JoinPoint.StaticPart ajc$tjp_21;
    private static final JoinPoint.StaticPart ajc$tjp_22;
    private static final JoinPoint.StaticPart ajc$tjp_23;
    private static final JoinPoint.StaticPart ajc$tjp_24;
    private static final JoinPoint.StaticPart ajc$tjp_25;
    private static final JoinPoint.StaticPart ajc$tjp_26;
    private static final JoinPoint.StaticPart ajc$tjp_27;
    private static final JoinPoint.StaticPart ajc$tjp_28;
    private static final JoinPoint.StaticPart ajc$tjp_29;
    private static final JoinPoint.StaticPart ajc$tjp_30;
    private static final JoinPoint.StaticPart ajc$tjp_31;
    private static final JoinPoint.StaticPart ajc$tjp_32;
    private static final JoinPoint.StaticPart ajc$tjp_33;
    private static final JoinPoint.StaticPart ajc$tjp_34;
    private static final JoinPoint.StaticPart ajc$tjp_35;
    private static final JoinPoint.StaticPart ajc$tjp_36;
    private static final JoinPoint.StaticPart ajc$tjp_37;
    private static final JoinPoint.StaticPart ajc$tjp_38;
    private static final JoinPoint.StaticPart ajc$tjp_39;
    private static final JoinPoint.StaticPart ajc$tjp_40;
    private static final JoinPoint.StaticPart ajc$tjp_41;
    private static final JoinPoint.StaticPart ajc$tjp_42;
    private static final JoinPoint.StaticPart ajc$tjp_43;
    private static final JoinPoint.StaticPart ajc$tjp_44;
    private static final JoinPoint.StaticPart ajc$tjp_45;
    private static final JoinPoint.StaticPart ajc$tjp_46;
    private static final JoinPoint.StaticPart ajc$tjp_47;
    private static final JoinPoint.StaticPart ajc$tjp_48;
    private static final JoinPoint.StaticPart ajc$tjp_49;
    private static final JoinPoint.StaticPart ajc$tjp_50;
    private static final JoinPoint.StaticPart ajc$tjp_51;
    private static final JoinPoint.StaticPart ajc$tjp_52;
    private static final JoinPoint.StaticPart ajc$tjp_53;
    private static final JoinPoint.StaticPart ajc$tjp_54;
    private static final JoinPoint.StaticPart ajc$tjp_55;
    private static final JoinPoint.StaticPart ajc$tjp_56;
    private static final JoinPoint.StaticPart ajc$tjp_57;
    private static final JoinPoint.StaticPart ajc$tjp_58;
    private static final JoinPoint.StaticPart ajc$tjp_59;
    private static final JoinPoint.StaticPart ajc$tjp_60;
    private static final JoinPoint.StaticPart ajc$tjp_61;
    private static final JoinPoint.StaticPart ajc$tjp_62;
    private static final JoinPoint.StaticPart ajc$tjp_63;
    private static final JoinPoint.StaticPart ajc$tjp_64;
    private static final JoinPoint.StaticPart ajc$tjp_65;
    private static final JoinPoint.StaticPart ajc$tjp_66;
    private static final JoinPoint.StaticPart ajc$tjp_67;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storeTime(Buffer buffer, Time time) throws SQLException {
        Calendar sessionCalendar;
        void intoBuf;
        Buffer buffer2 = buffer;
        Time time2 = time;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)buffer2, (Object)time2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        intoBuf.ensureCapacity(9);
        intoBuf.writeByte((byte)8);
        intoBuf.writeByte((byte)0);
        intoBuf.writeLong(0L);
        Calendar calendar = sessionCalendar = this.getCalendarInstanceForSessionOrNew();
        synchronized (calendar) {
            java.util.Date oldTime = sessionCalendar.getTime();
            try {
                void tm;
                sessionCalendar.setTime((java.util.Date)tm);
                intoBuf.writeByte((byte)sessionCalendar.get(11));
                intoBuf.writeByte((byte)sessionCalendar.get(12));
                intoBuf.writeByte((byte)sessionCalendar.get(13));
                Object var6_11 = null;
                sessionCalendar.setTime(oldTime);
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                sessionCalendar.setTime(oldTime);
                throw throwable;
            }
        }
        Object var11_12 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var11_12, joinPoint);
    }

    public ServerPreparedStatement(Connection conn, String sql, String catalog, int resultSetType, int resultSetConcurrency) throws SQLException {
        super(conn, catalog);
        this.checkNullOrEmptyQuery(sql);
        this.isSelectQuery = StringUtils.startsWithIgnoreCaseAndWs(sql, "SELECT");
        this.serverNeedsResetBeforeEachExecution = this.connection.versionMeetsMinimum(5, 0, 0) ? !this.connection.versionMeetsMinimum(5, 0, 3) : !this.connection.versionMeetsMinimum(4, 1, 10);
        this.useTrueBoolean = this.connection.versionMeetsMinimum(3, 21, 23);
        this.hasLimitClause = StringUtils.indexOfIgnoreCase(sql, "LIMIT") != -1;
        this.firstCharOfStmt = StringUtils.firstNonWsCharUc(sql);
        this.originalSql = sql;
        this.stringTypeCode = this.connection.versionMeetsMinimum(4, 1, 2) ? 253 : 254;
        try {
            this.serverPrepare(sql);
        }
        catch (SQLException sqlEx) {
            this.realClose(false, true);
            throw sqlEx;
        }
        catch (Exception ex) {
            this.realClose(false, true);
            throw SQLError.createSQLException(ex.toString(), "S1000");
        }
        this.setResultSetType(resultSetType);
        this.setResultSetConcurrency(resultSetConcurrency);
    }

    public synchronized void addBatch() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.checkClosed();
        if (this.batchedArgs == null) {
            this.batchedArgs = new ArrayList();
        }
        this.batchedArgs.add(new BatchedBindValues(this.parameterBindings));
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String asSql(boolean bl) throws SQLException {
        String string;
        JoinPoint joinPoint;
        block21: {
            String string2;
            block18: {
                block20: {
                    boolean bl2 = bl;
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
                    Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
                    if (!this.isClosed) break block20;
                    string = "statement has been closed, no further internal information available";
                    break block21;
                }
                PreparedStatement pStmtForSub = null;
                try {
                    pStmtForSub = new PreparedStatement(this.connection, this.originalSql, this.currentCatalog);
                    int numParameters = pStmtForSub.parameterCount;
                    int ourNumParameters = this.parameterCount;
                    int i = 0;
                    while (true) {
                        if (i >= numParameters || i >= ourNumParameters) {
                            void quoteStreamsAndUnknowns;
                            string2 = pStmtForSub.asSql((boolean)quoteStreamsAndUnknowns);
                            Object var7_10 = null;
                            if (pStmtForSub == null) break block18;
                            break;
                        }
                        if (this.parameterBindings[i] != null) {
                            if (this.parameterBindings[i].isNull) {
                                pStmtForSub.setNull(i + 1, 0);
                            } else {
                                BindValue bindValue = this.parameterBindings[i];
                                switch (bindValue.bufferType) {
                                    case 1: {
                                        pStmtForSub.setByte(i + 1, bindValue.byteBinding);
                                        break;
                                    }
                                    case 2: {
                                        pStmtForSub.setShort(i + 1, bindValue.shortBinding);
                                        break;
                                    }
                                    case 3: {
                                        pStmtForSub.setInt(i + 1, bindValue.intBinding);
                                        break;
                                    }
                                    case 8: {
                                        pStmtForSub.setLong(i + 1, bindValue.longBinding);
                                        break;
                                    }
                                    case 4: {
                                        pStmtForSub.setFloat(i + 1, bindValue.floatBinding);
                                        break;
                                    }
                                    case 5: {
                                        pStmtForSub.setDouble(i + 1, bindValue.doubleBinding);
                                        break;
                                    }
                                    default: {
                                        pStmtForSub.setObject(i + 1, this.parameterBindings[i].value);
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    if (pStmtForSub == null) throw throwable;
                    try {
                        pStmtForSub.close();
                        throw throwable;
                    }
                    catch (SQLException sQLException) {}
                    throw throwable;
                }
                try {}
                catch (SQLException sQLException) {}
                pStmtForSub.close();
            }
            string = string2;
        }
        String string3 = string;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string3, joinPoint);
        return string;
    }

    protected void checkClosed() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.invalid) {
            throw this.invalidationException;
        }
        super.checkClosed();
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    public void clearParameters() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.checkClosed();
        this.clearParametersInternal(true);
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    private void clearParametersInternal(boolean bl) throws SQLException {
        void clearServerParameters;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean hadLongData = false;
        if (this.parameterBindings != null) {
            int i = 0;
            while (i < this.parameterCount) {
                if (this.parameterBindings[i] != null && this.parameterBindings[i].isLongData) {
                    hadLongData = true;
                }
                this.parameterBindings[i].reset();
                ++i;
            }
        }
        if (clearServerParameters != false && hadLongData) {
            this.serverResetStatement();
            this.detectedLongParameterSwitch = false;
        }
        Object var6_6 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var6_6, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    protected void setClosed(boolean bl) {
        void flag;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.isClosed = flag;
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    public void close() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.isCached) {
            this.isClosed = true;
            this.connection.recachePreparedStatement(this);
        } else {
            this.realClose(true, true);
        }
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    private void dumpCloseForTestcase() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        StringBuffer buf = new StringBuffer();
        this.connection.generateConnectionCommentBlock(buf);
        buf.append("DEALLOCATE PREPARE debug_stmt_");
        buf.append(this.statementId);
        buf.append(";\n");
        this.connection.dumpTestcaseQuery(buf.toString());
        Object var3_3 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var3_3, joinPoint);
    }

    private void dumpExecuteForTestcase() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.parameterCount) {
            this.connection.generateConnectionCommentBlock(buf);
            buf.append("SET @debug_stmt_param");
            buf.append(this.statementId);
            buf.append("_");
            buf.append(i);
            buf.append("=");
            if (this.parameterBindings[i].isNull) {
                buf.append("NULL");
            } else {
                buf.append(this.parameterBindings[i].toString(true));
            }
            buf.append(";\n");
            ++i;
        }
        this.connection.generateConnectionCommentBlock(buf);
        buf.append("EXECUTE debug_stmt_");
        buf.append(this.statementId);
        if (this.parameterCount > 0) {
            buf.append(" USING ");
            i = 0;
            while (i < this.parameterCount) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append("@debug_stmt_param");
                buf.append(this.statementId);
                buf.append("_");
                buf.append(i);
                ++i;
            }
        }
        buf.append(";\n");
        this.connection.dumpTestcaseQuery(buf.toString());
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    private void dumpPrepareForTestcase() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        StringBuffer buf = new StringBuffer(this.originalSql.length() + 64);
        this.connection.generateConnectionCommentBlock(buf);
        buf.append("PREPARE debug_stmt_");
        buf.append(this.statementId);
        buf.append(" FROM \"");
        buf.append(this.originalSql);
        buf.append("\";\n");
        this.connection.dumpTestcaseQuery(buf.toString());
        Object var3_3 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var3_3, joinPoint);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int[] executeBatchSerially() throws SQLException {
        int[] nArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.connection.isReadOnly()) {
            throw SQLError.createSQLException(String.valueOf(Messages.getString("ServerPreparedStatement.2")) + Messages.getString("ServerPreparedStatement.3"), "S1009");
        }
        this.checkClosed();
        Object object = this.connection.getMutex();
        synchronized (object) {
            this.clearWarnings();
            BindValue[] oldBindValues = this.parameterBindings;
            try {
                int[] updateCounts = null;
                if (this.batchedArgs != null) {
                    int nbrCommands = this.batchedArgs.size();
                    updateCounts = new int[nbrCommands];
                    if (this.retrieveGeneratedKeys) {
                        this.batchedGeneratedKeys = new ArrayList(nbrCommands);
                    }
                    int i = 0;
                    while (i < nbrCommands) {
                        updateCounts[i] = -3;
                        ++i;
                    }
                    Throwable sqlEx = null;
                    int commandIndex = 0;
                    BindValue[] previousBindValuesForBatch = null;
                    commandIndex = 0;
                    while (commandIndex < nbrCommands) {
                        block28: {
                            Object arg = this.batchedArgs.get(commandIndex);
                            if (arg instanceof String) {
                                updateCounts[commandIndex] = this.executeUpdate((String)arg);
                            } else {
                                this.parameterBindings = ((BatchedBindValues)arg).batchedParameterValues;
                                try {
                                    Object var10_15;
                                    java.sql.ResultSet rs;
                                    if (previousBindValuesForBatch != null) {
                                        int j = 0;
                                        while (j < this.parameterBindings.length) {
                                            if (this.parameterBindings[j].bufferType != previousBindValuesForBatch[j].bufferType) {
                                                this.sendTypesToServer = true;
                                                break;
                                            }
                                            ++j;
                                        }
                                    }
                                    try {
                                        updateCounts[commandIndex] = this.executeUpdate(false, true);
                                        Object j = null;
                                        previousBindValuesForBatch = this.parameterBindings;
                                        if (!this.retrieveGeneratedKeys) break block28;
                                        rs = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object j = null;
                                        previousBindValuesForBatch = this.parameterBindings;
                                        throw throwable;
                                    }
                                    try {
                                        rs = this.getGeneratedKeysInternal();
                                        while (rs.next()) {
                                            this.batchedGeneratedKeys.add(new byte[][]{rs.getBytes(1)});
                                        }
                                        var10_15 = null;
                                        if (rs != null) {
                                            rs.close();
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        var10_15 = null;
                                        if (rs != null) {
                                            rs.close();
                                        }
                                        throw throwable;
                                    }
                                }
                                catch (SQLException ex) {
                                    updateCounts[commandIndex] = -3;
                                    if (!this.continueBatchOnError) {
                                        int[] newUpdateCounts = new int[commandIndex];
                                        System.arraycopy(updateCounts, 0, newUpdateCounts, 0, commandIndex);
                                        throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), newUpdateCounts);
                                    }
                                    sqlEx = ex;
                                }
                            }
                        }
                        ++commandIndex;
                    }
                    if (sqlEx != null) {
                        throw new BatchUpdateException(sqlEx.getMessage(), ((SQLException)sqlEx).getSQLState(), ((SQLException)sqlEx).getErrorCode(), updateCounts);
                    }
                }
                int[] nArray2 = updateCounts != null ? updateCounts : new int[]{};
                Object var12_19 = null;
                this.parameterBindings = oldBindValues;
                this.sendTypesToServer = true;
                this.clearBatch();
                // MONITOREXIT @DISABLED, blocks:[0, 1, 7] lbl89 : MonitorExitStatement: MONITOREXIT : var1_2
                nArray = nArray2;
            }
            catch (Throwable throwable) {
                Object var12_20 = null;
                this.parameterBindings = oldBindValues;
                this.sendTypesToServer = true;
                this.clearBatch();
                throw throwable;
            }
        }
        int[] nArray3 = nArray;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(nArray3, joinPoint);
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    protected ResultSet executeInternal(int n, Buffer buffer, boolean bl, boolean bl2, boolean bl3, Field[] fieldArray, boolean bl4) throws SQLException {
        ResultSet resultSet;
        int n2 = n;
        Buffer buffer2 = buffer;
        boolean bl5 = bl;
        boolean bl6 = bl2;
        boolean bl7 = bl3;
        Field[] fieldArray2 = fieldArray;
        boolean bl8 = bl4;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n2), buffer2, Conversions.booleanObject((boolean)bl5), Conversions.booleanObject((boolean)bl6), Conversions.booleanObject((boolean)bl7), fieldArray2, Conversions.booleanObject((boolean)bl8)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        ++this.numberOfExecutions;
        try {
            void metadataFromCache;
            void unpackFields;
            void createStreamingResultSet;
            void maxRowsToRetrieve;
            resultSet = this.serverExecute((int)maxRowsToRetrieve, (boolean)createStreamingResultSet, (boolean)unpackFields, (Field[])metadataFromCache);
        }
        catch (SQLException sqlEx) {
            if (this.connection.getEnablePacketDebug()) {
                this.connection.getIO().dumpPacketRingBuffer();
            }
            if (this.connection.getDumpQueriesOnException()) {
                String extractedSql = this.toString();
                StringBuffer messageBuf = new StringBuffer(extractedSql.length() + 32);
                messageBuf.append("\n\nQuery being executed when exception was thrown:\n\n");
                messageBuf.append(extractedSql);
                sqlEx = Connection.appendMessageToException(sqlEx, messageBuf.toString());
            }
            throw sqlEx;
        }
        catch (Exception ex) {
            if (this.connection.getEnablePacketDebug()) {
                this.connection.getIO().dumpPacketRingBuffer();
            }
            SQLException sqlEx = SQLError.createSQLException(ex.toString(), "S1000");
            if (this.connection.getDumpQueriesOnException()) {
                String extractedSql = this.toString();
                StringBuffer messageBuf = new StringBuffer(extractedSql.length() + 32);
                messageBuf.append("\n\nQuery being executed when exception was thrown:\n\n");
                messageBuf.append(extractedSql);
                sqlEx = Connection.appendMessageToException(sqlEx, messageBuf.toString());
            }
            throw sqlEx;
        }
        ResultSet resultSet2 = resultSet;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(resultSet2, joinPoint);
        return resultSet;
    }

    protected Buffer fillSendPacket() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Buffer buffer = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(buffer, joinPoint);
        return null;
    }

    protected Buffer fillSendPacket(byte[][] byArray, InputStream[] inputStreamArray, boolean[] blArray, int[] nArray) throws SQLException {
        byte[][] byArray2 = byArray;
        InputStream[] inputStreamArray2 = inputStreamArray;
        boolean[] blArray2 = blArray;
        int[] nArray2 = nArray;
        Object[] objectArray = new Object[]{byArray2, inputStreamArray2, blArray2, nArray2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Buffer buffer = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(buffer, joinPoint);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private BindValue getBinding(int n, boolean bl) throws SQLException {
        void forLongData;
        void parameterIndex;
        int n2 = n;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2), (Object)Conversions.booleanObject((boolean)bl2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.checkClosed();
        if (this.parameterBindings.length == 0) {
            throw SQLError.createSQLException(Messages.getString("ServerPreparedStatement.8"), "S1009");
        }
        if (--parameterIndex < 0 || parameterIndex >= this.parameterBindings.length) {
            throw SQLError.createSQLException(String.valueOf(Messages.getString("ServerPreparedStatement.9")) + (int)(parameterIndex + true) + Messages.getString("ServerPreparedStatement.10") + this.parameterBindings.length, "S1009");
        }
        if (this.parameterBindings[parameterIndex] == null) {
            this.parameterBindings[parameterIndex] = new BindValue();
        } else if (this.parameterBindings[parameterIndex].isLongData && forLongData == false) {
            this.detectedLongParameterSwitch = true;
        }
        this.parameterBindings[parameterIndex].isSet = true;
        this.parameterBindings[parameterIndex].boundBeforeExecutionNum = this.numberOfExecutions;
        BindValue bindValue = this.parameterBindings[parameterIndex];
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(bindValue, joinPoint);
        return bindValue;
    }

    /*
     * WARNING - void declaration
     */
    byte[] getBytes(int n) throws SQLException {
        byte[] byArray;
        void parameterIndex;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        BindValue bindValue = this.getBinding((int)parameterIndex, false);
        if (bindValue.isNull) {
            byArray = null;
        } else {
            if (bindValue.isLongData) {
                throw new NotImplemented();
            }
            if (this.outByteBuffer == null) {
                this.outByteBuffer = new Buffer(this.connection.getNetBufferLength());
            }
            this.outByteBuffer.clear();
            int originalPosition = this.outByteBuffer.getPosition();
            this.storeBinding(this.outByteBuffer, bindValue, this.connection.getIO());
            int newPosition = this.outByteBuffer.getPosition();
            int length = newPosition - originalPosition;
            byte[] valueAsBytes = new byte[length];
            System.arraycopy(this.outByteBuffer.getByteBuffer(), originalPosition, valueAsBytes, 0, length);
            byArray = valueAsBytes;
        }
        byte[] byArray2 = byArray;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(byArray2, joinPoint);
        return byArray;
    }

    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.checkClosed();
        ResultSetMetaData resultSetMetaData = this.resultFields == null ? null : new ResultSetMetaData(this.resultFields, this.connection.getUseOldAliasMetadataBehavior());
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(resultSetMetaData, joinPoint);
        return resultSetMetaData;
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.checkClosed();
        if (this.parameterMetaData == null) {
            this.parameterMetaData = new MysqlParameterMetadata(this.parameterFields, this.parameterCount);
        }
        MysqlParameterMetadata mysqlParameterMetadata = this.parameterMetaData;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(mysqlParameterMetadata, joinPoint);
        return mysqlParameterMetadata;
    }

    boolean isNull(int n) {
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        throw new IllegalArgumentException(Messages.getString("ServerPreparedStatement.7"));
    }

    /*
     * WARNING - void declaration
     */
    protected void realClose(boolean bl, boolean bl2) throws SQLException {
        boolean bl3 = bl;
        boolean bl4 = bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl3), (Object)Conversions.booleanObject((boolean)bl4));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (!this.isClosed && this.connection != null) {
            if (this.connection.getAutoGenerateTestcaseScript()) {
                this.dumpCloseForTestcase();
            }
            Object object = this.connection.getMutex();
            synchronized (object) {
                void closeOpenResults;
                void calledExplicitly;
                SQLException exceptionDuringClose = null;
                if (calledExplicitly != false) {
                    try {
                        MysqlIO mysql = this.connection.getIO();
                        Buffer packet = mysql.getSharedSendPacket();
                        packet.writeByte((byte)25);
                        packet.writeLong(this.serverStatementId);
                        mysql.sendCommand(25, null, packet, true, null);
                    }
                    catch (SQLException sqlEx) {
                        exceptionDuringClose = sqlEx;
                    }
                }
                super.realClose((boolean)calledExplicitly, (boolean)closeOpenResults);
                this.clearParametersInternal(false);
                this.parameterBindings = null;
                this.parameterFields = null;
                this.resultFields = null;
                if (exceptionDuringClose != null) {
                    throw exceptionDuringClose;
                }
            }
        }
        Object var10_11 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var10_11, joinPoint);
    }

    protected void rePrepare() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.invalidationException = null;
        try {
            this.serverPrepare(this.originalSql);
        }
        catch (SQLException sqlEx) {
            this.invalidationException = sqlEx;
        }
        catch (Exception ex) {
            this.invalidationException = SQLError.createSQLException(ex.toString(), "S1000");
        }
        if (this.invalidationException != null) {
            this.invalid = true;
            this.parameterBindings = null;
            this.parameterFields = null;
            this.resultFields = null;
            if (this.results != null) {
                try {
                    this.results.close();
                }
                catch (Exception exception) {}
            }
            if (this.connection != null) {
                if (this.maxRowsChanged) {
                    this.connection.unsetMaxRows(this);
                }
                if (!this.connection.getDontTrackOpenResources()) {
                    this.connection.unregisterStatement(this);
                }
            }
        }
        Object var3_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var3_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResultSet serverExecute(int n, boolean bl, boolean bl2, Field[] fieldArray) throws SQLException {
        ResultSet resultSet;
        int n2 = n;
        boolean bl3 = bl;
        boolean bl4 = bl2;
        Field[] fieldArray2 = fieldArray;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n2), Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4), fieldArray2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Object object = this.connection.getMutex();
        synchronized (object) {
            int i;
            if (this.detectedLongParameterSwitch) {
                boolean firstFound = false;
                long boundTimeToCheck = 0L;
                int i2 = 0;
                while (i2 < this.parameterCount - 1) {
                    if (this.parameterBindings[i2].isLongData) {
                        if (firstFound && boundTimeToCheck != this.parameterBindings[i2].boundBeforeExecutionNum) {
                            throw SQLError.createSQLException(String.valueOf(Messages.getString("ServerPreparedStatement.11")) + Messages.getString("ServerPreparedStatement.12"), "S1C00");
                        }
                        firstFound = true;
                        boundTimeToCheck = this.parameterBindings[i2].boundBeforeExecutionNum;
                    }
                    ++i2;
                }
                this.serverResetStatement();
            }
            int i3 = 0;
            while (i3 < this.parameterCount) {
                if (!this.parameterBindings[i3].isSet) {
                    throw SQLError.createSQLException(String.valueOf(Messages.getString("ServerPreparedStatement.13")) + (i3 + 1) + Messages.getString("ServerPreparedStatement.14"), "S1009");
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < this.parameterCount) {
                if (this.parameterBindings[i3].isLongData) {
                    this.serverLongData(i3, this.parameterBindings[i3]);
                }
                ++i3;
            }
            if (this.connection.getAutoGenerateTestcaseScript()) {
                this.dumpExecuteForTestcase();
            }
            MysqlIO mysql = this.connection.getIO();
            Buffer packet = mysql.getSharedSendPacket();
            packet.clear();
            packet.writeByte((byte)23);
            packet.writeLong(this.serverStatementId);
            if (this.connection.versionMeetsMinimum(4, 1, 2)) {
                if (this.resultFields != null && this.connection.isCursorFetchEnabled() && this.getResultSetType() == 1003 && this.getResultSetConcurrency() == 1007 && this.getFetchSize() > 0) {
                    packet.writeByte((byte)1);
                } else {
                    packet.writeByte((byte)0);
                }
                packet.writeLong(1L);
            }
            int nullCount = (this.parameterCount + 7) / 8;
            int nullBitsPosition = packet.getPosition();
            int i4 = 0;
            while (i4 < nullCount) {
                packet.writeByte((byte)0);
                ++i4;
            }
            byte[] nullBitsBuffer = new byte[nullCount];
            packet.writeByte(this.sendTypesToServer ? (byte)1 : 0);
            if (this.sendTypesToServer) {
                i = 0;
                while (i < this.parameterCount) {
                    packet.writeInt(this.parameterBindings[i].bufferType);
                    ++i;
                }
            }
            i = 0;
            while (i < this.parameterCount) {
                if (!this.parameterBindings[i].isLongData) {
                    if (!this.parameterBindings[i].isNull) {
                        this.storeBinding(packet, this.parameterBindings[i], mysql);
                    } else {
                        int n3 = i / 8;
                        nullBitsBuffer[n3] = (byte)(nullBitsBuffer[n3] | 1 << (i & 7));
                    }
                }
                ++i;
            }
            int endPosition = packet.getPosition();
            packet.setPosition(nullBitsPosition);
            packet.writeBytesNoNull(nullBitsBuffer);
            packet.setPosition(endPosition);
            long begin = 0L;
            boolean logSlowQueries = this.connection.getLogSlowQueries();
            boolean gatherPerformanceMetrics = this.connection.getGatherPerformanceMetrics();
            if (this.profileSQL || logSlowQueries || gatherPerformanceMetrics) {
                begin = mysql.getCurrentTimeNanosOrMillis();
            }
            Object object2 = this.cancelTimeoutMutex;
            synchronized (object2) {
                this.wasCancelled = false;
            }
            TimerTask timeoutTask = null;
            try {
                void metadataFromCache;
                void unpackFields;
                void createStreamingResultSet;
                void maxRowsToRetrieve;
                if (this.connection.getEnableQueryTimeouts() && this.timeoutInMillis != 0 && this.connection.versionMeetsMinimum(5, 0, 0)) {
                    timeoutTask = new Statement.CancelTask(this);
                    this.getClass();
                    Connection.getCancelTimer().schedule(timeoutTask, this.timeoutInMillis);
                }
                Buffer resultPacket = mysql.sendCommand(23, null, packet, false, null);
                long queryEndTime = 0L;
                if (logSlowQueries || gatherPerformanceMetrics || this.profileSQL) {
                    queryEndTime = mysql.getCurrentTimeNanosOrMillis();
                }
                if (timeoutTask != null) {
                    timeoutTask.cancel();
                    if (((Statement.CancelTask)timeoutTask).caughtWhileCancelling != null) {
                        throw ((Statement.CancelTask)timeoutTask).caughtWhileCancelling;
                    }
                    timeoutTask = null;
                }
                Object object3 = this.cancelTimeoutMutex;
                synchronized (object3) {
                    if (this.wasCancelled) {
                        this.wasCancelled = false;
                        throw new MySQLTimeoutException();
                    }
                }
                boolean queryWasSlow = false;
                if (logSlowQueries || gatherPerformanceMetrics) {
                    long elapsedTime = queryEndTime - begin;
                    if (logSlowQueries && elapsedTime >= mysql.getSlowQueryThreshold()) {
                        queryWasSlow = true;
                        StringBuffer mesgBuf = new StringBuffer(48 + this.originalSql.length());
                        mesgBuf.append(Messages.getString("ServerPreparedStatement.15"));
                        mesgBuf.append(mysql.getSlowQueryThreshold());
                        mesgBuf.append(Messages.getString("ServerPreparedStatement.15a"));
                        mesgBuf.append(elapsedTime);
                        mesgBuf.append(Messages.getString("ServerPreparedStatement.16"));
                        mesgBuf.append("as prepared: ");
                        mesgBuf.append(this.originalSql);
                        mesgBuf.append("\n\n with parameters bound:\n\n");
                        mesgBuf.append(this.asSql(true));
                        this.eventSink.consumeEvent(new ProfilerEvent(6, "", this.currentCatalog, this.connection.getId(), this.getId(), 0, System.currentTimeMillis(), elapsedTime, mysql.getQueryTimingUnits(), null, new Throwable(), mesgBuf.toString()));
                    }
                    if (gatherPerformanceMetrics) {
                        this.connection.registerQueryExecutionTime(elapsedTime);
                    }
                }
                this.connection.incrementNumberOfPreparedExecutes();
                if (this.profileSQL) {
                    this.eventSink = ProfileEventSink.getInstance(this.connection);
                    this.eventSink.consumeEvent(new ProfilerEvent(4, "", this.currentCatalog, this.connectionId, this.statementId, -1, System.currentTimeMillis(), (int)(mysql.getCurrentTimeNanosOrMillis() - begin), mysql.getQueryTimingUnits(), null, new Throwable(), this.truncateQueryToLog(this.asSql(true))));
                }
                ResultSet rs = mysql.readAllResults(this, (int)maxRowsToRetrieve, this.resultSetType, this.resultSetConcurrency, (boolean)createStreamingResultSet, this.currentCatalog, resultPacket, true, this.fieldCount, (boolean)unpackFields, (Field[])metadataFromCache);
                if (this.profileSQL) {
                    long fetchEndTime = mysql.getCurrentTimeNanosOrMillis();
                    this.eventSink.consumeEvent(new ProfilerEvent(5, "", this.currentCatalog, this.connection.getId(), this.getId(), rs.resultId, System.currentTimeMillis(), fetchEndTime - queryEndTime, mysql.getQueryTimingUnits(), null, new Throwable(), null));
                }
                if (queryWasSlow && this.connection.getExplainSlowQueries()) {
                    String queryAsString = this.asSql(true);
                    mysql.explainSlowQuery(queryAsString.getBytes(), queryAsString);
                }
                if (createStreamingResultSet == false && this.serverNeedsResetBeforeEachExecution) {
                    this.serverResetStatement();
                }
                this.sendTypesToServer = false;
                this.results = rs;
                if (mysql.hadWarnings()) {
                    mysql.scanForAndThrowDataTruncation();
                }
                ResultSet resultSet2 = rs;
                Object var24_35 = null;
                if (timeoutTask != null) {
                    timeoutTask.cancel();
                }
                // MONITOREXIT @DISABLED, blocks:[0, 2, 4] lbl170 : MonitorExitStatement: MONITOREXIT : var5_11
                resultSet = resultSet2;
            }
            catch (Throwable throwable) {
                Object var24_36 = null;
                if (timeoutTask != null) {
                    timeoutTask.cancel();
                }
                throw throwable;
            }
        }
        ResultSet resultSet3 = resultSet;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(resultSet3, joinPoint);
        return resultSet;
    }

    /*
     * WARNING - void declaration
     */
    private void serverLongData(int n, BindValue bindValue) throws SQLException {
        int n2 = n;
        BindValue bindValue2 = bindValue;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2), (Object)bindValue2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Object object = this.connection.getMutex();
        synchronized (object) {
            void parameterIndex;
            void longData;
            MysqlIO mysql = this.connection.getIO();
            Buffer packet = mysql.getSharedSendPacket();
            Object value = longData.value;
            if (value instanceof byte[]) {
                packet.clear();
                packet.writeByte((byte)24);
                packet.writeLong(this.serverStatementId);
                packet.writeInt((int)parameterIndex);
                packet.writeBytesNoNull((byte[])longData.value);
                mysql.sendCommand(24, null, packet, true, null);
            } else if (value instanceof InputStream) {
                this.storeStream(mysql, (int)parameterIndex, packet, (InputStream)value);
            } else if (value instanceof Blob) {
                this.storeStream(mysql, (int)parameterIndex, packet, ((Blob)value).getBinaryStream());
            } else if (value instanceof Reader) {
                this.storeReader(mysql, (int)parameterIndex, packet, (Reader)value);
            } else {
                throw SQLError.createSQLException(String.valueOf(Messages.getString("ServerPreparedStatement.18")) + value.getClass().getName() + "'", "S1009");
            }
        }
        Object var10_10 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var10_10, joinPoint);
    }

    /*
     * Exception decompiling
     */
    private void serverPrepare(String var1_1) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [0 : 571->581)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     */
    private String truncateQueryToLog(String string) {
        void sql;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        String query = null;
        if (sql.length() > this.connection.getMaxQuerySizeToLog()) {
            StringBuffer queryBuf = new StringBuffer(this.connection.getMaxQuerySizeToLog() + 12);
            queryBuf.append(sql.substring(0, this.connection.getMaxQuerySizeToLog()));
            queryBuf.append(Messages.getString("MysqlIO.25"));
            query = queryBuf.toString();
        } else {
            query = sql;
        }
        String string3 = query;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string3, joinPoint);
        return string3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void serverResetStatement() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Object object = this.connection.getMutex();
        synchronized (object) {
            MysqlIO mysql = this.connection.getIO();
            Buffer packet = mysql.getSharedSendPacket();
            packet.clear();
            packet.writeByte((byte)26);
            packet.writeLong(this.serverStatementId);
            try {
                try {
                    mysql.sendCommand(26, null, packet, !this.connection.versionMeetsMinimum(4, 1, 2), null);
                }
                catch (SQLException sqlEx) {
                    throw sqlEx;
                }
                catch (Exception ex) {
                    throw SQLError.createSQLException(ex.toString(), "S1000");
                }
                Object var5_9 = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                mysql.clearInputStream();
                throw throwable;
            }
            mysql.clearInputStream();
        }
        Object var8_10 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var8_10, joinPoint);
    }

    public void setArray(int n, Array array) throws SQLException {
        int n2 = n;
        Array array2 = array;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2), (Object)array2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        throw new NotImplemented();
    }

    /*
     * WARNING - void declaration
     */
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        void parameterIndex;
        void x;
        int n3 = n;
        InputStream inputStream2 = inputStream;
        int n4 = n2;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n3), inputStream2, Conversions.intObject((int)n4)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.checkClosed();
        if (x == null) {
            this.setNull((int)parameterIndex, -2);
        } else {
            void length;
            BindValue binding = this.getBinding((int)parameterIndex, true);
            this.setType(binding, 252);
            binding.value = x;
            binding.isNull = false;
            binding.isLongData = true;
            binding.bindLength = this.connection.getUseStreamLengthsInPrepStmts() ? (long)length : -1L;
        }
        Object var10_10 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var10_10, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        void parameterIndex;
        void x;
        int n2 = n;
        BigDecimal bigDecimal2 = bigDecimal;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2), (Object)bigDecimal2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.checkClosed();
        if (x == null) {
            this.setNull((int)parameterIndex, 3);
        } else {
            BindValue binding = this.getBinding((int)parameterIndex, false);
            if (this.connection.versionMeetsMinimum(5, 0, 3)) {
                this.setType(binding, 246);
            } else {
                this.setType(binding, this.stringTypeCode);
            }
            binding.value = StringUtils.fixDecimalExponent(StringUtils.consistentToString((BigDecimal)x));
            binding.isNull = false;
            binding.isLongData = false;
        }
        Object var7_7 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var7_7, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        void parameterIndex;
        void x;
        int n3 = n;
        InputStream inputStream2 = inputStream;
        int n4 = n2;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n3), inputStream2, Conversions.intObject((int)n4)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.checkClosed();
        if (x == null) {
            this.setNull((int)parameterIndex, -2);
        } else {
            void length;
            BindValue binding = this.getBinding((int)parameterIndex, true);
            this.setType(binding, 252);
            binding.value = x;
            binding.isNull = false;
            binding.isLongData = true;
            binding.bindLength = this.connection.getUseStreamLengthsInPrepStmts() ? (long)length : -1L;
        }
        Object var10_10 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var10_10, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public void setBlob(int n, Blob blob) throws SQLException {
        void parameterIndex;
        void x;
        int n2 = n;
        Blob blob2 = blob;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2), (Object)blob2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.checkClosed();
        if (x == null) {
            this.setNull((int)parameterIndex, -2);
        } else {
            BindValue binding = this.getBinding((int)parameterIndex, true);
            this.setType(binding, 252);
            binding.value = x;
            binding.isNull = false;
            binding.isLongData = true;
            binding.bindLength = this.connection.getUseStreamLengthsInPrepStmts() ? x.length() : -1L;
        }
        Object var7_7 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var7_7, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public void setBoolean(int n, boolean bl) throws SQLException {
        void x;
        void parameterIndex;
        int n2 = n;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2), (Object)Conversions.booleanObject((boolean)bl2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.setByte((int)parameterIndex, x != false ? (byte)1 : 0);
        Object var6_6 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var6_6, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public void setByte(int n, byte by) throws SQLException {
        void x;
        void parameterIndex;
        int n2 = n;
        byte by2 = by;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2), (Object)Conversions.byteObject((byte)by2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.checkClosed();
        BindValue binding = this.getBinding((int)parameterIndex, false);
        this.setType(binding, 1);
        binding.value = null;
        binding.byteBinding = x;
        binding.isNull = false;
        binding.isLongData = false;
        Object var7_7 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var7_7, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public void setBytes(int n, byte[] byArray) throws SQLException {
        void parameterIndex;
        void x;
        int n2 = n;
        byte[] byArray2 = byArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2), (Object)byArray2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.checkClosed();
        if (x == null) {
            this.setNull((int)parameterIndex, -2);
        } else {
            BindValue binding = this.getBinding((int)parameterIndex, false);
            this.setType(binding, 253);
            binding.value = x;
            binding.isNull = false;
            binding.isLongData = false;
        }
        Object var7_7 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var7_7, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        void parameterIndex;
        void reader2;
        int n3 = n;
        Reader reader3 = reader;
        int n4 = n2;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n3), reader3, Conversions.intObject((int)n4)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.checkClosed();
        if (reader2 == null) {
            this.setNull((int)parameterIndex, -2);
        } else {
            void length;
            BindValue binding = this.getBinding((int)parameterIndex, true);
            this.setType(binding, 252);
            binding.value = reader2;
            binding.isNull = false;
            binding.isLongData = true;
            binding.bindLength = this.connection.getUseStreamLengthsInPrepStmts() ? (long)length : -1L;
        }
        Object var10_10 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var10_10, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public void setClob(int n, Clob clob) throws SQLException {
        void parameterIndex;
        void x;
        int n2 = n;
        Clob clob2 = clob;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2), (Object)clob2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.checkClosed();
        if (x == null) {
            this.setNull((int)parameterIndex, -2);
        } else {
            BindValue binding = this.getBinding((int)parameterIndex, true);
            this.setType(binding, 252);
            binding.value = x.getCharacterStream();
            binding.isNull = false;
            binding.isLongData = true;
            binding.bindLength = this.connection.getUseStreamLengthsInPrepStmts() ? x.length() : -1L;
        }
        Object var7_7 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var7_7, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public void setDate(int n, Date date) throws SQLException {
        void x;
        void parameterIndex;
        int n2 = n;
        Date date2 = date;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2), (Object)date2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.setDate((int)parameterIndex, (Date)x, null);
        Object var6_6 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var6_6, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        void parameterIndex;
        void x;
        int n2 = n;
        Date date2 = date;
        Calendar calendar2 = calendar;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n2), date2, calendar2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (x == null) {
            this.setNull((int)parameterIndex, 91);
        } else {
            BindValue binding = this.getBinding((int)parameterIndex, false);
            this.setType(binding, 10);
            binding.value = x;
            binding.isNull = false;
            binding.isLongData = false;
        }
        Object var10_10 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var10_10, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public void setDouble(int n, double d) throws SQLException {
        void parameterIndex;
        void x;
        int n2 = n;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2), (Object)Conversions.doubleObject((double)d2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.checkClosed();
        if (!this.connection.getAllowNanAndInf() && (x == Double.POSITIVE_INFINITY || x == Double.NEGATIVE_INFINITY || Double.isNaN((double)x))) {
            throw SQLError.createSQLException("'" + (double)x + "' is not a valid numeric or approximate numeric value", "S1009");
        }
        BindValue binding = this.getBinding((int)parameterIndex, false);
        this.setType(binding, 5);
        binding.value = null;
        binding.doubleBinding = x;
        binding.isNull = false;
        binding.isLongData = false;
        Object var9_7 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var9_7, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public void setFloat(int n, float f) throws SQLException {
        void x;
        void parameterIndex;
        int n2 = n;
        float f2 = f;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2), (Object)Conversions.floatObject((float)f2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.checkClosed();
        BindValue binding = this.getBinding((int)parameterIndex, false);
        this.setType(binding, 4);
        binding.value = null;
        binding.floatBinding = x;
        binding.isNull = false;
        binding.isLongData = false;
        Object var7_7 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var7_7, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public void setInt(int n, int n2) throws SQLException {
        void x;
        void parameterIndex;
        int n3 = n;
        int n4 = n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_41, (Object)this, (Object)this, (Object)Conversions.intObject((int)n3), (Object)Conversions.intObject((int)n4));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.checkClosed();
        BindValue binding = this.getBinding((int)parameterIndex, false);
        this.setType(binding, 3);
        binding.value = null;
        binding.intBinding = x;
        binding.isNull = false;
        binding.isLongData = false;
        Object var7_7 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var7_7, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public void setLong(int n, long l) throws SQLException {
        void x;
        void parameterIndex;
        int n2 = n;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_42, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2), (Object)Conversions.longObject((long)l2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.checkClosed();
        BindValue binding = this.getBinding((int)parameterIndex, false);
        this.setType(binding, 8);
        binding.value = null;
        binding.longBinding = x;
        binding.isNull = false;
        binding.isLongData = false;
        Object var9_7 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var9_7, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public void setNull(int n, int n2) throws SQLException {
        void parameterIndex;
        int n3 = n;
        int n4 = n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_43, (Object)this, (Object)this, (Object)Conversions.intObject((int)n3), (Object)Conversions.intObject((int)n4));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.checkClosed();
        BindValue binding = this.getBinding((int)parameterIndex, false);
        if (binding.bufferType == 0) {
            this.setType(binding, 6);
        }
        binding.value = null;
        binding.isNull = true;
        binding.isLongData = false;
        Object var7_7 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var7_7, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public void setNull(int n, int n2, String string) throws SQLException {
        void parameterIndex;
        int n3 = n;
        int n4 = n2;
        String string2 = string;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n3), Conversions.intObject((int)n4), string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_44, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.checkClosed();
        BindValue binding = this.getBinding((int)parameterIndex, false);
        if (binding.bufferType == 0) {
            this.setType(binding, 6);
        }
        binding.value = null;
        binding.isNull = true;
        binding.isLongData = false;
        Object var10_10 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var10_10, joinPoint);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        int n2 = n;
        Ref ref2 = ref;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_45, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2), (Object)ref2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        throw new NotImplemented();
    }

    /*
     * WARNING - void declaration
     */
    public void setShort(int n, short s) throws SQLException {
        void x;
        void parameterIndex;
        int n2 = n;
        short s2 = s;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_46, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2), (Object)Conversions.shortObject((short)s2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.checkClosed();
        BindValue binding = this.getBinding((int)parameterIndex, false);
        this.setType(binding, 2);
        binding.value = null;
        binding.shortBinding = x;
        binding.isNull = false;
        binding.isLongData = false;
        Object var7_7 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var7_7, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public void setString(int n, String string) throws SQLException {
        void parameterIndex;
        void x;
        int n2 = n;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_47, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2), (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.checkClosed();
        if (x == null) {
            this.setNull((int)parameterIndex, 1);
        } else {
            BindValue binding = this.getBinding((int)parameterIndex, false);
            this.setType(binding, this.stringTypeCode);
            binding.value = x;
            binding.isNull = false;
            binding.isLongData = false;
        }
        Object var7_7 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var7_7, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public void setTime(int n, Time time) throws SQLException {
        void x;
        void parameterIndex;
        int n2 = n;
        Time time2 = time;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_48, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2), (Object)time2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.setTimeInternal((int)parameterIndex, (Time)x, null, this.connection.getDefaultTimeZone(), false);
        Object var6_6 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var6_6, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        void cal;
        void x;
        void parameterIndex;
        int n2 = n;
        Time time2 = time;
        Calendar calendar2 = calendar;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n2), time2, calendar2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_49, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.setTimeInternal((int)parameterIndex, (Time)x, (Calendar)cal, cal.getTimeZone(), true);
        Object var9_9 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var9_9, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public void setTimeInternal(int n, Time time, Calendar calendar, TimeZone timeZone, boolean bl) throws SQLException {
        void parameterIndex;
        void x;
        int n2 = n;
        Time time2 = time;
        Calendar calendar2 = calendar;
        TimeZone timeZone2 = timeZone;
        boolean bl2 = bl;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n2), time2, calendar2, timeZone2, Conversions.booleanObject((boolean)bl2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_50, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (x == null) {
            this.setNull((int)parameterIndex, 92);
        } else {
            Calendar sessionCalendar;
            BindValue binding = this.getBinding((int)parameterIndex, false);
            this.setType(binding, 11);
            Calendar calendar3 = sessionCalendar = this.getCalendarInstanceForSessionOrNew();
            synchronized (calendar3) {
                void rollForward;
                void tz;
                void targetCalendar;
                binding.value = TimeUtil.changeTimezone(this.connection, sessionCalendar, (Calendar)targetCalendar, (Time)x, (TimeZone)tz, this.connection.getServerTimezoneTZ(), (boolean)rollForward);
            }
            binding.isNull = false;
            binding.isLongData = false;
        }
        Object var16_16 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var16_16, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        void x;
        void parameterIndex;
        int n2 = n;
        Timestamp timestamp2 = timestamp;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_51, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2), (Object)timestamp2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.setTimestampInternal((int)parameterIndex, (Timestamp)x, null, this.connection.getDefaultTimeZone(), false);
        Object var6_6 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var6_6, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        void cal;
        void x;
        void parameterIndex;
        int n2 = n;
        Timestamp timestamp2 = timestamp;
        Calendar calendar2 = calendar;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n2), timestamp2, calendar2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_52, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.setTimestampInternal((int)parameterIndex, (Timestamp)x, (Calendar)cal, cal.getTimeZone(), true);
        Object var9_9 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var9_9, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    protected void setTimestampInternal(int n, Timestamp timestamp, Calendar calendar, TimeZone timeZone, boolean bl) throws SQLException {
        void parameterIndex;
        void x;
        int n2 = n;
        Timestamp timestamp2 = timestamp;
        Calendar calendar2 = calendar;
        TimeZone timeZone2 = timeZone;
        boolean bl2 = bl;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n2), timestamp2, calendar2, timeZone2, Conversions.booleanObject((boolean)bl2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_53, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (x == null) {
            this.setNull((int)parameterIndex, 93);
        } else {
            Calendar sessionCalendar;
            BindValue binding = this.getBinding((int)parameterIndex, false);
            this.setType(binding, 12);
            Calendar calendar3 = sessionCalendar = this.connection.getUseJDBCCompliantTimezoneShift() ? this.connection.getUtcCalendar() : this.getCalendarInstanceForSessionOrNew();
            synchronized (calendar3) {
                void rollForward;
                void tz;
                void targetCalendar;
                binding.value = TimeUtil.changeTimezone(this.connection, sessionCalendar, (Calendar)targetCalendar, (Timestamp)x, (TimeZone)tz, this.connection.getServerTimezoneTZ(), (boolean)rollForward);
            }
            binding.isNull = false;
            binding.isLongData = false;
        }
        Object var16_16 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var16_16, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    private void setType(BindValue bindValue, int n) {
        void bufferType;
        void oldValue;
        BindValue bindValue2 = bindValue;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_54, (Object)this, (Object)this, (Object)bindValue2, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (oldValue.bufferType != bufferType) {
            this.sendTypesToServer = true;
        }
        oldValue.bufferType = bufferType;
        Object var6_6 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var6_6, joinPoint);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        int n3 = n;
        InputStream inputStream2 = inputStream;
        int n4 = n2;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n3), inputStream2, Conversions.intObject((int)n4)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_55, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.checkClosed();
        throw new NotImplemented();
    }

    /*
     * WARNING - void declaration
     */
    public void setURL(int n, URL uRL) throws SQLException {
        void x;
        void parameterIndex;
        int n2 = n;
        URL uRL2 = uRL;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_56, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2), (Object)uRL2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.checkClosed();
        this.setString((int)parameterIndex, x.toString());
        Object var6_6 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var6_6, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    private void storeBinding(Buffer buffer, BindValue bindValue, MysqlIO mysqlIO) throws SQLException {
        Buffer buffer2 = buffer;
        BindValue bindValue2 = bindValue;
        MysqlIO mysqlIO2 = mysqlIO;
        Object[] objectArray = new Object[]{buffer2, bindValue2, mysqlIO2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_57, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        try {
            void bindValue3;
            Object value = bindValue3.value;
            switch (bindValue3.bufferType) {
                case 1: {
                    void packet;
                    packet.writeByte(bindValue3.byteBinding);
                    break;
                }
                case 2: {
                    void packet;
                    packet.ensureCapacity(2);
                    packet.writeInt(bindValue3.shortBinding);
                    break;
                }
                case 3: {
                    void packet;
                    packet.ensureCapacity(4);
                    packet.writeLong(bindValue3.intBinding);
                    break;
                }
                case 8: {
                    void packet;
                    packet.ensureCapacity(8);
                    packet.writeLongLong(bindValue3.longBinding);
                    break;
                }
                case 4: {
                    void packet;
                    packet.ensureCapacity(4);
                    packet.writeFloat(bindValue3.floatBinding);
                    break;
                }
                case 5: {
                    void packet;
                    packet.ensureCapacity(8);
                    packet.writeDouble(bindValue3.doubleBinding);
                    break;
                }
                case 11: {
                    void packet;
                    this.storeTime((Buffer)packet, (Time)value);
                    break;
                }
                case 7: 
                case 10: 
                case 12: {
                    void mysql;
                    void packet;
                    this.storeDateTime((Buffer)packet, (java.util.Date)value, (MysqlIO)mysql);
                    break;
                }
                case 0: 
                case 15: 
                case 246: 
                case 253: 
                case 254: {
                    void packet;
                    if (value instanceof byte[]) {
                        packet.writeLenBytes((byte[])value);
                    } else if (!this.isLoadDataQuery) {
                        packet.writeLenString((String)value, this.charEncoding, this.connection.getServerCharacterEncoding(), this.charConverter, this.connection.parserKnowsUnicode(), this.connection);
                    } else {
                        packet.writeLenBytes(((String)value).getBytes());
                    }
                    break;
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw SQLError.createSQLException(String.valueOf(Messages.getString("ServerPreparedStatement.22")) + this.connection.getEncoding() + "'", "S1000");
        }
        Object var10_10 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var10_10, joinPoint);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storeDataTime412AndOlder(Buffer buffer, java.util.Date date) throws SQLException {
        Calendar sessionCalendar;
        Buffer buffer2 = buffer;
        java.util.Date date2 = date;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_58, (Object)this, (Object)this, (Object)buffer2, (Object)date2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Calendar calendar = sessionCalendar = this.getCalendarInstanceForSessionOrNew();
        synchronized (calendar) {
            java.util.Date oldTime = sessionCalendar.getTime();
            try {
                void dt;
                void intoBuf;
                intoBuf.ensureCapacity(8);
                intoBuf.writeByte((byte)7);
                sessionCalendar.setTime((java.util.Date)dt);
                int year = sessionCalendar.get(1);
                int month = sessionCalendar.get(2) + 1;
                int date3 = sessionCalendar.get(5);
                intoBuf.writeInt(year);
                intoBuf.writeByte((byte)month);
                intoBuf.writeByte((byte)date3);
                if (dt instanceof Date) {
                    intoBuf.writeByte((byte)0);
                    intoBuf.writeByte((byte)0);
                    intoBuf.writeByte((byte)0);
                } else {
                    intoBuf.writeByte((byte)sessionCalendar.get(11));
                    intoBuf.writeByte((byte)sessionCalendar.get(12));
                    intoBuf.writeByte((byte)sessionCalendar.get(13));
                }
                Object var9_14 = null;
                sessionCalendar.setTime(oldTime);
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                sessionCalendar.setTime(oldTime);
                throw throwable;
            }
        }
        Object var14_15 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var14_15, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    private void storeDateTime(Buffer buffer, java.util.Date date, MysqlIO mysqlIO) throws SQLException {
        void dt;
        void intoBuf;
        Buffer buffer2 = buffer;
        java.util.Date date2 = date;
        MysqlIO mysqlIO2 = mysqlIO;
        Object[] objectArray = new Object[]{buffer2, date2, mysqlIO2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_59, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.connection.versionMeetsMinimum(4, 1, 3)) {
            this.storeDateTime413AndNewer((Buffer)intoBuf, (java.util.Date)dt);
        } else {
            this.storeDataTime412AndOlder((Buffer)intoBuf, (java.util.Date)dt);
        }
        Object var9_9 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var9_9, joinPoint);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storeDateTime413AndNewer(Buffer buffer, java.util.Date date) throws SQLException {
        void dt;
        Calendar sessionCalendar;
        Buffer buffer2 = buffer;
        java.util.Date date2 = date;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_60, (Object)this, (Object)this, (Object)buffer2, (Object)date2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Calendar calendar = sessionCalendar = dt instanceof Timestamp && this.connection.getUseJDBCCompliantTimezoneShift() ? this.connection.getUtcCalendar() : this.getCalendarInstanceForSessionOrNew();
        synchronized (calendar) {
            java.util.Date oldTime = sessionCalendar.getTime();
            try {
                void intoBuf;
                sessionCalendar.setTime((java.util.Date)dt);
                if (dt instanceof Date) {
                    sessionCalendar.set(11, 0);
                    sessionCalendar.set(12, 0);
                    sessionCalendar.set(13, 0);
                }
                byte length = 7;
                if (dt instanceof Timestamp) {
                    length = 11;
                }
                intoBuf.ensureCapacity(length);
                intoBuf.writeByte(length);
                int year = sessionCalendar.get(1);
                int month = sessionCalendar.get(2) + 1;
                int date3 = sessionCalendar.get(5);
                intoBuf.writeInt(year);
                intoBuf.writeByte((byte)month);
                intoBuf.writeByte((byte)date3);
                if (dt instanceof Date) {
                    intoBuf.writeByte((byte)0);
                    intoBuf.writeByte((byte)0);
                    intoBuf.writeByte((byte)0);
                } else {
                    intoBuf.writeByte((byte)sessionCalendar.get(11));
                    intoBuf.writeByte((byte)sessionCalendar.get(12));
                    intoBuf.writeByte((byte)sessionCalendar.get(13));
                }
                if (length == 11) {
                    intoBuf.writeLong(((Timestamp)dt).getNanos() / 1000);
                }
                Object var10_15 = null;
                sessionCalendar.setTime(oldTime);
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                sessionCalendar.setTime(oldTime);
                throw throwable;
            }
        }
        Object var15_16 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var15_16, joinPoint);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storeReader(MysqlIO mysqlIO, int n, Buffer buffer, Reader reader) throws SQLException {
        void inStream;
        MysqlIO mysqlIO2 = mysqlIO;
        int n2 = n;
        Buffer buffer2 = buffer;
        Reader reader2 = reader;
        Object[] objectArray = new Object[]{mysqlIO2, Conversions.intObject((int)n2), buffer2, reader2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_61, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        String forcedEncoding = this.connection.getClobCharacterEncoding();
        String clobEncoding = forcedEncoding == null ? this.connection.getEncoding() : forcedEncoding;
        int maxBytesChar = 2;
        if (clobEncoding != null) {
            if (!clobEncoding.equals("UTF-16")) {
                maxBytesChar = this.connection.getMaxBytesPerChar(clobEncoding);
                if (maxBytesChar == 1) {
                    maxBytesChar = 2;
                }
            } else {
                maxBytesChar = 4;
            }
        }
        char[] buf = new char[8192 / maxBytesChar];
        int numRead = 0;
        int bytesInPacket = 0;
        int totalBytesRead = 0;
        int bytesReadAtLastSend = 0;
        int packetIsFullAt = this.connection.getBlobSendChunkSize();
        try {
            try {
                void parameterIndex;
                void packet;
                packet.clear();
                packet.writeByte((byte)24);
                packet.writeLong(this.serverStatementId);
                packet.writeInt((int)parameterIndex);
                boolean readAny = false;
                while (true) {
                    void mysql;
                    block17: {
                        if ((numRead = inStream.read(buf)) != -1) break block17;
                        if (totalBytesRead != bytesReadAtLastSend) {
                            mysql.sendCommand(24, null, (Buffer)packet, true, null);
                        }
                        if (!readAny) {
                            mysql.sendCommand(24, null, (Buffer)packet, true, null);
                        }
                        break;
                    }
                    readAny = true;
                    byte[] valueAsBytes = StringUtils.getBytes(buf, null, clobEncoding, this.connection.getServerCharacterEncoding(), 0, numRead, this.connection.parserKnowsUnicode());
                    packet.writeBytesNoNull(valueAsBytes, 0, valueAsBytes.length);
                    totalBytesRead += valueAsBytes.length;
                    if ((bytesInPacket += valueAsBytes.length) < packetIsFullAt) continue;
                    bytesReadAtLastSend = totalBytesRead;
                    mysql.sendCommand(24, null, (Buffer)packet, true, null);
                    bytesInPacket = 0;
                    packet.clear();
                    packet.writeByte((byte)24);
                    packet.writeLong(this.serverStatementId);
                    packet.writeInt((int)parameterIndex);
                }
            }
            catch (IOException ioEx) {
                throw SQLError.createSQLException(String.valueOf(Messages.getString("ServerPreparedStatement.24")) + ioEx.toString(), "S1000");
            }
        }
        catch (Throwable throwable) {
            Object var16_24 = null;
            if (!this.connection.getAutoClosePStmtStreams()) throw throwable;
            if (inStream == null) throw throwable;
            try {
                inStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var16_25 = null;
        }
        if (this.connection.getAutoClosePStmtStreams() && inStream != null) {
            try {}
            catch (IOException iOException) {}
            inStream.close();
        }
        Object var24_26 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var24_26, joinPoint);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storeStream(MysqlIO mysqlIO, int n, Buffer buffer, InputStream inputStream) throws SQLException {
        void inStream;
        MysqlIO mysqlIO2 = mysqlIO;
        int n2 = n;
        Buffer buffer2 = buffer;
        InputStream inputStream2 = inputStream;
        Object[] objectArray = new Object[]{mysqlIO2, Conversions.intObject((int)n2), buffer2, inputStream2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_62, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte[] buf = new byte[8192];
        int numRead = 0;
        try {
            try {
                void parameterIndex;
                void packet;
                int bytesInPacket = 0;
                int totalBytesRead = 0;
                int bytesReadAtLastSend = 0;
                int packetIsFullAt = this.connection.getBlobSendChunkSize();
                packet.clear();
                packet.writeByte((byte)24);
                packet.writeLong(this.serverStatementId);
                packet.writeInt((int)parameterIndex);
                boolean readAny = false;
                while (true) {
                    void mysql;
                    block13: {
                        if ((numRead = inStream.read(buf)) != -1) break block13;
                        if (totalBytesRead != bytesReadAtLastSend) {
                            mysql.sendCommand(24, null, (Buffer)packet, true, null);
                        }
                        if (!readAny) {
                            mysql.sendCommand(24, null, (Buffer)packet, true, null);
                        }
                        break;
                    }
                    readAny = true;
                    packet.writeBytesNoNull(buf, 0, numRead);
                    totalBytesRead += numRead;
                    if ((bytesInPacket += numRead) < packetIsFullAt) continue;
                    bytesReadAtLastSend = totalBytesRead;
                    mysql.sendCommand(24, null, (Buffer)packet, true, null);
                    bytesInPacket = 0;
                    packet.clear();
                    packet.writeByte((byte)24);
                    packet.writeLong(this.serverStatementId);
                    packet.writeInt((int)parameterIndex);
                }
            }
            catch (IOException ioEx) {
                throw SQLError.createSQLException(String.valueOf(Messages.getString("ServerPreparedStatement.25")) + ioEx.toString(), "S1000");
            }
        }
        catch (Throwable throwable) {
            Object var12_20 = null;
            if (!this.connection.getAutoClosePStmtStreams()) throw throwable;
            if (inStream == null) throw throwable;
            try {
                inStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var12_21 = null;
        }
        if (this.connection.getAutoClosePStmtStreams() && inStream != null) {
            try {}
            catch (IOException iOException) {}
            inStream.close();
        }
        Object var20_22 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var20_22, joinPoint);
    }

    public String toString() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_63, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        StringBuffer toStringBuf = new StringBuffer();
        toStringBuf.append("com.mysql.jdbc.ServerPreparedStatement[");
        toStringBuf.append(this.serverStatementId);
        toStringBuf.append("] - ");
        try {
            toStringBuf.append(this.asSql());
        }
        catch (SQLException sqlEx) {
            toStringBuf.append(Messages.getString("ServerPreparedStatement.6"));
            toStringBuf.append(sqlEx);
        }
        String string = toStringBuf.toString();
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    protected long getServerStatementId() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_64, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        long l = this.serverStatementId;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.longObject((long)l), joinPoint);
        return l;
    }

    public synchronized boolean canRewriteAsMultivalueInsertStatement() {
        boolean bl;
        JoinPoint joinPoint;
        block7: {
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_65, (Object)this, (Object)this);
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            if (!super.canRewriteAsMultivalueInsertStatement()) {
                bl = false;
            } else {
                BindValue[] currentBindValues = null;
                BindValue[] previousBindValues = null;
                int nbrCommands = this.batchedArgs.size();
                int commandIndex = 0;
                while (commandIndex < nbrCommands) {
                    Object arg = this.batchedArgs.get(commandIndex);
                    if (!(arg instanceof String)) {
                        currentBindValues = ((BatchedBindValues)arg).batchedParameterValues;
                        if (previousBindValues != null) {
                            int j = 0;
                            while (j < this.parameterBindings.length) {
                                if (currentBindValues[j].bufferType != previousBindValues[j].bufferType) {
                                    bl = false;
                                    break block7;
                                }
                                ++j;
                            }
                        }
                    }
                    ++commandIndex;
                }
                bl = true;
            }
        }
        boolean bl2 = bl;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl2), joinPoint);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    protected long[] computeMaxParameterSetSizeAndBatchSize(int n) {
        void numBatchedArgs;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_66, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        long sizeOfEntireBatch = 10L;
        long maxSizeOfParameterSet = 0L;
        int i = 0;
        while (i < numBatchedArgs) {
            BindValue[] paramArg = ((BatchedBindValues)this.batchedArgs.get((int)i)).batchedParameterValues;
            long sizeOfParameterSet = 0L;
            sizeOfParameterSet += (long)((this.parameterCount + 7) / 8);
            sizeOfParameterSet += (long)(this.parameterCount * 2);
            int j = 0;
            while (j < this.parameterBindings.length) {
                if (!paramArg[j].isNull) {
                    long size = paramArg[j].getBoundLength();
                    if (paramArg[j].isLongData) {
                        if (size != -1L) {
                            sizeOfParameterSet += size;
                        }
                    } else {
                        sizeOfParameterSet += size;
                    }
                }
                ++j;
            }
            sizeOfEntireBatch += sizeOfParameterSet;
            if (sizeOfParameterSet > maxSizeOfParameterSet) {
                maxSizeOfParameterSet = sizeOfParameterSet;
            }
            ++i;
        }
        long[] lArray = new long[]{maxSizeOfParameterSet, sizeOfEntireBatch};
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(lArray, joinPoint);
        return lArray;
    }

    /*
     * WARNING - void declaration
     */
    protected int setOneBatchedParameterSet(java.sql.PreparedStatement preparedStatement, int n, Object object) throws SQLException {
        void batchedParamIndex;
        void paramSet;
        java.sql.PreparedStatement preparedStatement2 = preparedStatement;
        int n2 = n;
        Object object2 = object;
        Object[] objectArray = new Object[]{preparedStatement2, Conversions.intObject((int)n2), object2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_67, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        BindValue[] paramArg = ((BatchedBindValues)paramSet).batchedParameterValues;
        int j = 0;
        while (j < paramArg.length) {
            Object value;
            void batchedStatement;
            if (paramArg[j].isNull) {
                batchedStatement.setNull((int)batchedParamIndex++, 0);
            } else if (paramArg[j].isLongData) {
                value = paramArg[j].value;
                if (value instanceof InputStream) {
                    batchedStatement.setBinaryStream((int)batchedParamIndex++, (InputStream)value, (int)paramArg[j].bindLength);
                } else {
                    batchedStatement.setCharacterStream((int)batchedParamIndex++, (Reader)value, (int)paramArg[j].bindLength);
                }
            } else {
                switch (paramArg[j].bufferType) {
                    case 1: {
                        batchedStatement.setByte((int)batchedParamIndex++, paramArg[j].byteBinding);
                        break;
                    }
                    case 2: {
                        batchedStatement.setShort((int)batchedParamIndex++, paramArg[j].shortBinding);
                        break;
                    }
                    case 3: {
                        batchedStatement.setInt((int)batchedParamIndex++, paramArg[j].intBinding);
                        break;
                    }
                    case 8: {
                        batchedStatement.setLong((int)batchedParamIndex++, paramArg[j].longBinding);
                        break;
                    }
                    case 4: {
                        batchedStatement.setFloat((int)batchedParamIndex++, paramArg[j].floatBinding);
                        break;
                    }
                    case 5: {
                        batchedStatement.setDouble((int)batchedParamIndex++, paramArg[j].doubleBinding);
                        break;
                    }
                    case 11: {
                        batchedStatement.setTime((int)batchedParamIndex++, (Time)paramArg[j].value);
                        break;
                    }
                    case 10: {
                        batchedStatement.setDate((int)batchedParamIndex++, (Date)paramArg[j].value);
                        break;
                    }
                    case 7: 
                    case 12: {
                        batchedStatement.setTimestamp((int)batchedParamIndex++, (Timestamp)paramArg[j].value);
                        break;
                    }
                    case 0: 
                    case 15: 
                    case 246: 
                    case 253: 
                    case 254: {
                        value = paramArg[j].value;
                        if (value instanceof byte[]) {
                            batchedStatement.setBytes((int)batchedParamIndex, (byte[])value);
                        } else {
                            batchedStatement.setString((int)batchedParamIndex, (String)value);
                        }
                        BindValue asBound = ((ServerPreparedStatement)batchedStatement).getBinding((int)(batchedParamIndex + true), false);
                        asBound.bufferType = paramArg[j].bufferType;
                        ++batchedParamIndex;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown type when re-binding parameter into batched statement for parameter index " + (int)batchedParamIndex);
                    }
                }
            }
            ++j;
        }
        void var13_13 = batchedParamIndex;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)var13_13), joinPoint);
        return (int)var13_13;
    }

    static {
        Factory factory = new Factory("ServerPreparedStatement.java", Class.forName("com.mysql.jdbc.ServerPreparedStatement"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-storeTime-com.mysql.jdbc.ServerPreparedStatement-com.mysql.jdbc.Buffer:java.sql.Time:-intoBuf:tm:-java.sql.SQLException:-void-"), 254);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-addBatch-com.mysql.jdbc.ServerPreparedStatement---java.sql.SQLException:-void-"), 388);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-dumpPrepareForTestcase-com.mysql.jdbc.ServerPreparedStatement---java.sql.SQLException:-void-"), 583);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-executeBatchSerially-com.mysql.jdbc.ServerPreparedStatement---java.sql.SQLException:-[I-"), 600);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-executeInternal-com.mysql.jdbc.ServerPreparedStatement-int:com.mysql.jdbc.Buffer:boolean:boolean:boolean:[Lcom.mysql.jdbc.Field;:boolean:-maxRowsToRetrieve:sendPacket:createStreamingResultSet:queryIsSelectOnly:unpackFields:metadataFromCache:isBatch:-java.sql.SQLException:-com.mysql.jdbc.ResultSet-"), 736);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-fillSendPacket-com.mysql.jdbc.ServerPreparedStatement---java.sql.SQLException:-com.mysql.jdbc.Buffer-"), 789);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-fillSendPacket-com.mysql.jdbc.ServerPreparedStatement-[[B:[Ljava.io.InputStream;:[Z:[I:-batchedParameterStrings:batchedParameterStreams:batchedIsStream:batchedStreamLengths:-java.sql.SQLException:-com.mysql.jdbc.Buffer-"), 799);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getBinding-com.mysql.jdbc.ServerPreparedStatement-int:boolean:-parameterIndex:forLongData:-java.sql.SQLException:-com.mysql.jdbc.ServerPreparedStatement$BindValue-"), 813);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-getBytes-com.mysql.jdbc.ServerPreparedStatement-int:-parameterIndex:-java.sql.SQLException:-[B-"), 852);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getMetaData-com.mysql.jdbc.ServerPreparedStatement---java.sql.SQLException:-java.sql.ResultSetMetaData-"), 887);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getParameterMetaData-com.mysql.jdbc.ServerPreparedStatement---java.sql.SQLException:-java.sql.ParameterMetaData-"), 901);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-isNull-com.mysql.jdbc.ServerPreparedStatement-int:-paramIndex:--boolean-"), 915);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-asSql-com.mysql.jdbc.ServerPreparedStatement-boolean:-quoteStreamsAndUnknowns:-java.sql.SQLException:-java.lang.String-"), 399);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-realClose-com.mysql.jdbc.ServerPreparedStatement-boolean:boolean:-calledExplicitly:closeOpenResults:-java.sql.SQLException:-void-"), 930);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-rePrepare-com.mysql.jdbc.ServerPreparedStatement---java.sql.SQLException:-void-"), 996);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-serverExecute-com.mysql.jdbc.ServerPreparedStatement-int:boolean:boolean:[Lcom.mysql.jdbc.Field;:-maxRowsToRetrieve:createStreamingResultSet:unpackFields:metadataFromCache:-java.sql.SQLException:-com.mysql.jdbc.ResultSet-"), 1072);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-serverLongData-com.mysql.jdbc.ServerPreparedStatement-int:com.mysql.jdbc.ServerPreparedStatement$BindValue:-parameterIndex:longData:-java.sql.SQLException:-void-"), 1390);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-serverPrepare-com.mysql.jdbc.ServerPreparedStatement-java.lang.String:-sql:-java.sql.SQLException:-void-"), 1424);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-truncateQueryToLog-com.mysql.jdbc.ServerPreparedStatement-java.lang.String:-sql:--java.lang.String-"), 1546);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-serverResetStatement-com.mysql.jdbc.ServerPreparedStatement---java.sql.SQLException:-void-"), 1563);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setArray-com.mysql.jdbc.ServerPreparedStatement-int:java.sql.Array:-i:x:-java.sql.SQLException:-void-"), 1591);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setAsciiStream-com.mysql.jdbc.ServerPreparedStatement-int:java.io.InputStream:int:-parameterIndex:x:length:-java.sql.SQLException:-void-"), 1600);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setBigDecimal-com.mysql.jdbc.ServerPreparedStatement-int:java.math.BigDecimal:-parameterIndex:x:-java.sql.SQLException:-void-"), 1625);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-checkClosed-com.mysql.jdbc.ServerPreparedStatement---java.sql.SQLException:-void-"), 470);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setBinaryStream-com.mysql.jdbc.ServerPreparedStatement-int:java.io.InputStream:int:-parameterIndex:x:length:-java.sql.SQLException:-void-"), 1652);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setBlob-com.mysql.jdbc.ServerPreparedStatement-int:java.sql.Blob:-parameterIndex:x:-java.sql.SQLException:-void-"), 1676);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setBoolean-com.mysql.jdbc.ServerPreparedStatement-int:boolean:-parameterIndex:x:-java.sql.SQLException:-void-"), 1700);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setByte-com.mysql.jdbc.ServerPreparedStatement-int:byte:-parameterIndex:x:-java.sql.SQLException:-void-"), 1707);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setBytes-com.mysql.jdbc.ServerPreparedStatement-int:[B:-parameterIndex:x:-java.sql.SQLException:-void-"), 1722);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setCharacterStream-com.mysql.jdbc.ServerPreparedStatement-int:java.io.Reader:int:-parameterIndex:reader:length:-java.sql.SQLException:-void-"), 1742);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setClob-com.mysql.jdbc.ServerPreparedStatement-int:java.sql.Clob:-parameterIndex:x:-java.sql.SQLException:-void-"), 1766);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setDate-com.mysql.jdbc.ServerPreparedStatement-int:java.sql.Date:-parameterIndex:x:-java.sql.SQLException:-void-"), 1799);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setDate-com.mysql.jdbc.ServerPreparedStatement-int:java.sql.Date:java.util.Calendar:-parameterIndex:x:cal:-java.sql.SQLException:-void-"), 1818);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setDouble-com.mysql.jdbc.ServerPreparedStatement-int:double:-parameterIndex:x:-java.sql.SQLException:-void-"), 1834);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-clearParameters-com.mysql.jdbc.ServerPreparedStatement---java.sql.SQLException:-void-"), 481);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setFloat-com.mysql.jdbc.ServerPreparedStatement-int:float:-parameterIndex:x:-java.sql.SQLException:-void-"), 1858);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setInt-com.mysql.jdbc.ServerPreparedStatement-int:int:-parameterIndex:x:-java.sql.SQLException:-void-"), 1873);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setLong-com.mysql.jdbc.ServerPreparedStatement-int:long:-parameterIndex:x:-java.sql.SQLException:-void-"), 1888);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setNull-com.mysql.jdbc.ServerPreparedStatement-int:int:-parameterIndex:sqlType:-java.sql.SQLException:-void-"), 1903);
        ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setNull-com.mysql.jdbc.ServerPreparedStatement-int:int:java.lang.String:-parameterIndex:sqlType:typeName:-java.sql.SQLException:-void-"), 1925);
        ajc$tjp_45 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setRef-com.mysql.jdbc.ServerPreparedStatement-int:java.sql.Ref:-i:x:-java.sql.SQLException:-void-"), 1946);
        ajc$tjp_46 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setShort-com.mysql.jdbc.ServerPreparedStatement-int:short:-parameterIndex:x:-java.sql.SQLException:-void-"), 1953);
        ajc$tjp_47 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setString-com.mysql.jdbc.ServerPreparedStatement-int:java.lang.String:-parameterIndex:x:-java.sql.SQLException:-void-"), 1968);
        ajc$tjp_48 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setTime-com.mysql.jdbc.ServerPreparedStatement-int:java.sql.Time:-parameterIndex:x:-java.sql.SQLException:-void-"), 1996);
        ajc$tjp_49 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setTime-com.mysql.jdbc.ServerPreparedStatement-int:java.sql.Time:java.util.Calendar:-parameterIndex:x:cal:-java.sql.SQLException:-void-"), 2016);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-clearParametersInternal-com.mysql.jdbc.ServerPreparedStatement-boolean:-clearServerParameters:-java.sql.SQLException:-void-"), 487);
        ajc$tjp_50 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setTimeInternal-com.mysql.jdbc.ServerPreparedStatement-int:java.sql.Time:java.util.Calendar:java.util.TimeZone:boolean:-parameterIndex:x:targetCalendar:tz:rollForward:-java.sql.SQLException:-void-"), 2037);
        ajc$tjp_51 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setTimestamp-com.mysql.jdbc.ServerPreparedStatement-int:java.sql.Timestamp:-parameterIndex:x:-java.sql.SQLException:-void-"), 2073);
        ajc$tjp_52 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setTimestamp-com.mysql.jdbc.ServerPreparedStatement-int:java.sql.Timestamp:java.util.Calendar:-parameterIndex:x:cal:-java.sql.SQLException:-void-"), 2092);
        ajc$tjp_53 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-setTimestampInternal-com.mysql.jdbc.ServerPreparedStatement-int:java.sql.Timestamp:java.util.Calendar:java.util.TimeZone:boolean:-parameterIndex:x:targetCalendar:tz:rollForward:-java.sql.SQLException:-void-"), 2099);
        ajc$tjp_54 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-setType-com.mysql.jdbc.ServerPreparedStatement-com.mysql.jdbc.ServerPreparedStatement$BindValue:int:-oldValue:bufferType:--void-"), 2124);
        ajc$tjp_55 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setUnicodeStream-com.mysql.jdbc.ServerPreparedStatement-int:java.io.InputStream:int:-parameterIndex:x:length:-java.sql.SQLException:-void-"), 2152);
        ajc$tjp_56 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setURL-com.mysql.jdbc.ServerPreparedStatement-int:java.net.URL:-parameterIndex:x:-java.sql.SQLException:-void-"), 2161);
        ajc$tjp_57 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-storeBinding-com.mysql.jdbc.ServerPreparedStatement-com.mysql.jdbc.Buffer:com.mysql.jdbc.ServerPreparedStatement$BindValue:com.mysql.jdbc.MysqlIO:-packet:bindValue:mysql:-java.sql.SQLException:-void-"), 2180);
        ajc$tjp_58 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-storeDataTime412AndOlder-com.mysql.jdbc.ServerPreparedStatement-com.mysql.jdbc.Buffer:java.util.Date:-intoBuf:dt:-java.sql.SQLException:-void-"), 2250);
        ajc$tjp_59 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-storeDateTime-com.mysql.jdbc.ServerPreparedStatement-com.mysql.jdbc.Buffer:java.util.Date:com.mysql.jdbc.MysqlIO:-intoBuf:dt:mysql:-java.sql.SQLException:-void-"), 2289);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-setClosed-com.mysql.jdbc.ServerPreparedStatement-boolean:-flag:--void-"), 510);
        ajc$tjp_60 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-storeDateTime413AndNewer-com.mysql.jdbc.ServerPreparedStatement-com.mysql.jdbc.Buffer:java.util.Date:-intoBuf:dt:-java.sql.SQLException:-void-"), 2298);
        ajc$tjp_61 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-storeReader-com.mysql.jdbc.ServerPreparedStatement-com.mysql.jdbc.MysqlIO:int:com.mysql.jdbc.Buffer:java.io.Reader:-mysql:parameterIndex:packet:inStream:-java.sql.SQLException:-void-"), 2362);
        ajc$tjp_62 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-storeStream-com.mysql.jdbc.ServerPreparedStatement-com.mysql.jdbc.MysqlIO:int:com.mysql.jdbc.Buffer:java.io.InputStream:-mysql:parameterIndex:packet:inStream:-java.sql.SQLException:-void-"), 2455);
        ajc$tjp_63 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-toString-com.mysql.jdbc.ServerPreparedStatement----java.lang.String-"), 2524);
        ajc$tjp_64 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getServerStatementId-com.mysql.jdbc.ServerPreparedStatement----long-"), 2541);
        ajc$tjp_65 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-canRewriteAsMultivalueInsertStatement-com.mysql.jdbc.ServerPreparedStatement----boolean-"), 2545);
        ajc$tjp_66 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-computeMaxParameterSetSizeAndBatchSize-com.mysql.jdbc.ServerPreparedStatement-int:-numBatchedArgs:--[J-"), 2585);
        ajc$tjp_67 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-setOneBatchedParameterSet-com.mysql.jdbc.ServerPreparedStatement-java.sql.PreparedStatement:int:java.lang.Object:-batchedStatement:batchedParamIndex:paramSet:-java.sql.SQLException:-int-"), 2625);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-close-com.mysql.jdbc.ServerPreparedStatement---java.sql.SQLException:-void-"), 516);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-dumpCloseForTestcase-com.mysql.jdbc.ServerPreparedStatement----void-"), 526);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-dumpExecuteForTestcase-com.mysql.jdbc.ServerPreparedStatement---java.sql.SQLException:-void-"), 536);
    }

    static class BatchedBindValues {
        BindValue[] batchedParameterValues;

        BatchedBindValues(BindValue[] paramVals) {
            int numParams = paramVals.length;
            this.batchedParameterValues = new BindValue[numParams];
            int i = 0;
            while (i < numParams) {
                this.batchedParameterValues[i] = new BindValue(paramVals[i]);
                ++i;
            }
        }
    }

    static class BindValue {
        long boundBeforeExecutionNum = 0L;
        long bindLength;
        int bufferType;
        byte byteBinding;
        double doubleBinding;
        float floatBinding;
        int intBinding;
        boolean isLongData;
        boolean isNull;
        boolean isSet = false;
        long longBinding;
        short shortBinding;
        Object value;
        private static final JoinPoint.StaticPart ajc$tjp_0;
        private static final JoinPoint.StaticPart ajc$tjp_1;
        private static final JoinPoint.StaticPart ajc$tjp_2;
        private static final JoinPoint.StaticPart ajc$tjp_3;

        BindValue() {
        }

        BindValue(BindValue copyMe) {
            this.value = copyMe.value;
            this.isSet = copyMe.isSet;
            this.isLongData = copyMe.isLongData;
            this.isNull = copyMe.isNull;
            this.bufferType = copyMe.bufferType;
            this.bindLength = copyMe.bindLength;
            this.byteBinding = copyMe.byteBinding;
            this.shortBinding = copyMe.shortBinding;
            this.intBinding = copyMe.intBinding;
            this.longBinding = copyMe.longBinding;
            this.floatBinding = copyMe.floatBinding;
            this.doubleBinding = copyMe.doubleBinding;
        }

        void reset() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            this.isSet = false;
            this.value = null;
            this.isLongData = false;
            this.byteBinding = 0;
            this.shortBinding = 0;
            this.intBinding = 0;
            this.longBinding = 0L;
            this.floatBinding = 0.0f;
            this.doubleBinding = 0.0;
            Object var2_2 = null;
            Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
        }

        public String toString() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            String string = this.toString(false);
            Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string, joinPoint);
            return string;
        }

        /*
         * WARNING - void declaration
         */
        public String toString(boolean bl) {
            String string;
            boolean bl2 = bl;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            if (this.isLongData) {
                string = "' STREAM DATA '";
            } else {
                switch (this.bufferType) {
                    case 1: {
                        string = String.valueOf(this.byteBinding);
                        break;
                    }
                    case 2: {
                        string = String.valueOf(this.shortBinding);
                        break;
                    }
                    case 3: {
                        string = String.valueOf(this.intBinding);
                        break;
                    }
                    case 8: {
                        string = String.valueOf(this.longBinding);
                        break;
                    }
                    case 4: {
                        string = String.valueOf(this.floatBinding);
                        break;
                    }
                    case 5: {
                        string = String.valueOf(this.doubleBinding);
                        break;
                    }
                    case 7: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 15: 
                    case 253: 
                    case 254: {
                        void quoteIfNeeded;
                        if (quoteIfNeeded != false) {
                            string = "'" + String.valueOf(this.value) + "'";
                            break;
                        }
                        string = String.valueOf(this.value);
                        break;
                    }
                    default: {
                        void quoteIfNeeded;
                        if (this.value instanceof byte[]) {
                            string = "byte data";
                            break;
                        }
                        if (quoteIfNeeded != false) {
                            string = "'" + String.valueOf(this.value) + "'";
                            break;
                        }
                        string = String.valueOf(this.value);
                        break;
                    }
                }
            }
            String string2 = string;
            Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string2, joinPoint);
            return string;
        }

        long getBoundLength() {
            long l;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            if (this.isNull) {
                l = 0L;
            } else if (this.isLongData) {
                l = this.bindLength;
            } else {
                switch (this.bufferType) {
                    case 1: {
                        l = 1L;
                        break;
                    }
                    case 2: {
                        l = 2L;
                        break;
                    }
                    case 3: {
                        l = 4L;
                        break;
                    }
                    case 8: {
                        l = 8L;
                        break;
                    }
                    case 4: {
                        l = 4L;
                        break;
                    }
                    case 5: {
                        l = 8L;
                        break;
                    }
                    case 11: {
                        l = 9L;
                        break;
                    }
                    case 10: {
                        l = 7L;
                        break;
                    }
                    case 7: 
                    case 12: {
                        l = 11L;
                        break;
                    }
                    case 0: 
                    case 15: 
                    case 246: 
                    case 253: 
                    case 254: {
                        if (this.value instanceof byte[]) {
                            l = ((byte[])this.value).length;
                            break;
                        }
                        l = ((String)this.value).length();
                        break;
                    }
                    default: {
                        l = 0L;
                        break;
                    }
                }
            }
            long l2 = l;
            Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.longObject((long)l2), joinPoint);
            return l;
        }

        static {
            Factory factory = new Factory("ServerPreparedStatement.java", Class.forName("com.mysql.jdbc.ServerPreparedStatement$BindValue"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-reset-com.mysql.jdbc.ServerPreparedStatement$BindValue----void-"), 131);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-toString-com.mysql.jdbc.ServerPreparedStatement$BindValue----java.lang.String-"), 144);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-toString-com.mysql.jdbc.ServerPreparedStatement$BindValue-boolean:-quoteIfNeeded:--java.lang.String-"), 148);
            ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-getBoundLength-com.mysql.jdbc.ServerPreparedStatement$BindValue----long-"), 192);
        }
    }
}

