/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.swing;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.aspectj.ajde.ui.swing.AjdeUIManager;
import org.aspectj.bridge.IMessage;
import org.aspectj.util.LangUtil;

public class CompilerMessagesCellRenderer
extends JLabel
implements ListCellRenderer {
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String label = "<no message>";
        String detail = null;
        IMessage.Kind kind = IMessage.ERROR;
        if (value instanceof IMessage) {
            IMessage cm = (IMessage)value;
            label = cm.getMessage();
            if (LangUtil.isEmpty(label)) {
                label = cm.getMessage().toString();
            }
            kind = cm.getKind();
            Throwable thrown = cm.getThrown();
            if (null != thrown) {
                detail = LangUtil.renderException(thrown);
            }
        } else if (null != value) {
            label = value.toString();
        }
        this.setText(label);
        if (kind.equals(IMessage.WARNING)) {
            this.setIcon(AjdeUIManager.getDefault().getIconRegistry().getWarningIcon());
        } else if (IMessage.ERROR.isSameOrLessThan(kind)) {
            this.setIcon(AjdeUIManager.getDefault().getIconRegistry().getErrorIcon());
        } else {
            this.setIcon(AjdeUIManager.getDefault().getIconRegistry().getInfoIcon());
        }
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        this.setOpaque(true);
        if (null != detail) {
            this.setToolTipText(detail);
        }
        return this;
    }
}

