/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.io.File;
import java.util.Arrays;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.IHasPosition;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.bcel.BcelObjectType;

public class BcelSourceContext
implements ISourceContext {
    private BcelObjectType inObject;
    private String sourceFileName;
    private int[] lineBreaks;

    public BcelSourceContext(BcelObjectType inObject) {
        this.inObject = inObject;
        this.sourceFileName = inObject.getJavaClass().getSourceFileName();
        if (this.sourceFileName != null && this.sourceFileName.equals("<Unknown>")) {
            this.sourceFileName = "Type '" + inObject.getResolvedTypeX().getName() + "' (no debug info available)";
        } else {
            String pname = inObject.getResolvedTypeX().getPackageName();
            if (pname != null) {
                this.sourceFileName = pname.replace('.', '/') + '/' + this.sourceFileName;
            }
        }
    }

    private File getSourceFile() {
        String fileName = this.sourceFileName;
        if (fileName == null) {
            this.inObject.getJavaClass().getFileName();
        }
        if (fileName == null) {
            fileName = this.inObject.getResolvedTypeX().getName() + ".class";
        }
        return new File(fileName);
    }

    public ISourceLocation makeSourceLocation(IHasPosition position) {
        if (this.lineBreaks != null) {
            int line = Arrays.binarySearch(this.lineBreaks, position.getStart());
            if (line < 0) {
                line = -line;
            }
            return new SourceLocation(this.getSourceFile(), line);
        }
        return new SourceLocation(this.getSourceFile(), 0);
    }

    public ISourceLocation makeSourceLocation(int line) {
        return new SourceLocation(this.getSourceFile(), line);
    }

    public void addAttributeInfo(AjAttribute.SourceContextAttribute sourceContextAttribute) {
        this.sourceFileName = sourceContextAttribute.getSourceFileName();
        this.lineBreaks = sourceContextAttribute.getLineBreaks();
    }
}

