/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.env.IBinaryNestedType;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;

public final class BinaryTypeBinding
extends SourceTypeBinding {
    private ReferenceBinding enclosingType;
    private LookupEnvironment environment;

    public BinaryTypeBinding(PackageBinding packageBinding, IBinaryType binaryType, LookupEnvironment environment) {
        this.compoundName = CharOperation.splitOn('/', binaryType.getName());
        this.computeId();
        this.tagBits |= 0x40;
        this.environment = environment;
        this.fPackage = packageBinding;
        this.fileName = binaryType.getFileName();
        char[] possibleSourceName = this.compoundName[this.compoundName.length - 1];
        int start = CharOperation.lastIndexOf('$', possibleSourceName) + 1;
        if (start == 0) {
            this.sourceName = possibleSourceName;
        } else {
            this.sourceName = new char[possibleSourceName.length - start];
            System.arraycopy(possibleSourceName, start, this.sourceName, 0, this.sourceName.length);
        }
        this.modifiers = binaryType.getModifiers();
        if (binaryType.isInterface()) {
            this.modifiers |= 0x200;
        }
        if (binaryType.isAnonymous()) {
            this.tagBits |= 0x34;
        } else if (binaryType.isLocal()) {
            this.tagBits |= 0x14;
        } else if (binaryType.isMember()) {
            this.tagBits |= 0xC;
        }
    }

    public FieldBinding[] availableFields() {
        FieldBinding[] availableFields = new FieldBinding[this.fields.length];
        int count = 0;
        int i = 0;
        while (i < this.fields.length) {
            try {
                availableFields[count] = this.resolveTypeFor(this.fields[i]);
                ++count;
            }
            catch (AbortCompilation abortCompilation) {
                // empty catch block
            }
            ++i;
        }
        FieldBinding[] fieldBindingArray = availableFields;
        availableFields = new FieldBinding[count];
        System.arraycopy(fieldBindingArray, 0, availableFields, 0, count);
        return availableFields;
    }

    public MethodBinding[] availableMethods() {
        if ((this.modifiers & 0x2000000) == 0) {
            return this.methods;
        }
        MethodBinding[] availableMethods = new MethodBinding[this.methods.length];
        int count = 0;
        int i = 0;
        while (i < this.methods.length) {
            try {
                availableMethods[count] = this.resolveTypesFor(this.methods[i]);
                ++count;
            }
            catch (AbortCompilation abortCompilation) {
                // empty catch block
            }
            ++i;
        }
        MethodBinding[] methodBindingArray = availableMethods;
        availableMethods = new MethodBinding[count];
        System.arraycopy(methodBindingArray, 0, availableMethods, 0, count);
        return availableMethods;
    }

    void cachePartsFrom(IBinaryType binaryType, boolean needFieldsAndMethods) {
        int size;
        int size2;
        char[] enclosingTypeName;
        char[] superclassName = binaryType.getSuperclassName();
        if (superclassName != null) {
            this.superclass = this.environment.getTypeFromConstantPoolName(superclassName, 0, -1);
        }
        if ((enclosingTypeName = binaryType.getEnclosingTypeName()) != null) {
            this.enclosingType = this.environment.getTypeFromConstantPoolName(enclosingTypeName, 0, -1);
            this.tagBits |= 0xC;
            if (this.enclosingType().isStrictfp()) {
                this.modifiers |= 0x800;
            }
            if (this.enclosingType().isDeprecated()) {
                this.modifiers |= 0x200000;
            }
        }
        this.memberTypes = TypeConstants.NoMemberTypes;
        IBinaryNestedType[] memberTypeStructures = binaryType.getMemberTypes();
        if (memberTypeStructures != null && (size2 = memberTypeStructures.length) > 0) {
            this.memberTypes = new ReferenceBinding[size2];
            int i = 0;
            while (i < size2) {
                this.memberTypes[i] = this.environment.getTypeFromConstantPoolName(memberTypeStructures[i].getName(), 0, -1);
                ++i;
            }
        }
        this.superInterfaces = TypeConstants.NoSuperInterfaces;
        char[][] interfaceNames = binaryType.getInterfaceNames();
        if (interfaceNames != null && (size = interfaceNames.length) > 0) {
            this.superInterfaces = new ReferenceBinding[size];
            int i = 0;
            while (i < size) {
                this.superInterfaces[i] = this.environment.getTypeFromConstantPoolName(interfaceNames[i], 0, -1);
                ++i;
            }
        }
        if (needFieldsAndMethods) {
            this.createFields(binaryType.getFields());
            this.createMethods(binaryType.getMethods());
        } else {
            this.fields = TypeConstants.NoFields;
            this.methods = TypeConstants.NoMethods;
        }
    }

    private void createFields(IBinaryField[] iFields) {
        int size;
        this.fields = TypeConstants.NoFields;
        if (iFields != null && (size = iFields.length) > 0) {
            this.fields = new FieldBinding[size];
            int i = 0;
            while (i < size) {
                IBinaryField field = iFields[i];
                this.fields[i] = new FieldBinding(field.getName(), this.environment.getTypeFromSignature(field.getTypeName(), 0, -1), field.getModifiers() | 0x2000000, this, field.getConstant());
                ++i;
            }
        }
    }

    private MethodBinding createMethod(IBinaryMethod method) {
        char nextChar;
        int size;
        int methodModifiers = method.getModifiers() | 0x2000000;
        ReferenceBinding[] exceptions = TypeConstants.NoExceptions;
        char[][] exceptionTypes = method.getExceptionTypeNames();
        if (exceptionTypes != null && (size = exceptionTypes.length) > 0) {
            exceptions = new ReferenceBinding[size];
            int i = 0;
            while (i < size) {
                exceptions[i] = this.environment.getTypeFromConstantPoolName(exceptionTypes[i], 0, -1);
                ++i;
            }
        }
        TypeBinding[] parameters = TypeConstants.NoParameters;
        char[] methodSignature = method.getMethodDescriptor();
        int numOfParams = 0;
        int index = 0;
        while ((nextChar = methodSignature[++index]) != ')') {
            if (nextChar == '[') continue;
            ++numOfParams;
            if (nextChar != 'L') continue;
            while ((nextChar = methodSignature[++index]) != ';') {
            }
        }
        int startIndex = method.isConstructor() && this.isMemberType() && !this.isStatic() ? 1 : 0;
        int size2 = numOfParams - startIndex;
        if (size2 > 0) {
            parameters = new TypeBinding[size2];
            index = 1;
            int end = 0;
            int i = 0;
            while (i < numOfParams) {
                while ((nextChar = methodSignature[++end]) == '[') {
                }
                if (nextChar == 'L') {
                    while ((nextChar = methodSignature[++end]) != ';') {
                    }
                }
                if (i >= startIndex) {
                    parameters[i - startIndex] = this.environment.getTypeFromSignature(methodSignature, index, end);
                }
                index = end + 1;
                ++i;
            }
        }
        MethodBinding binding = null;
        binding = method.isConstructor() ? new MethodBinding(methodModifiers, parameters, exceptions, this) : new MethodBinding(methodModifiers, method.getSelector(), this.environment.getTypeFromSignature(methodSignature, index + 1, -1), parameters, exceptions, this);
        return binding;
    }

    private void createMethods(IBinaryMethod[] iMethods) {
        int i;
        int total = 0;
        int initialTotal = 0;
        int iClinit = -1;
        int[] toSkip = null;
        if (iMethods != null) {
            i = total = (initialTotal = iMethods.length);
            while (--i >= 0) {
                char[] methodName;
                IBinaryMethod method = iMethods[i];
                if ((method.getModifiers() & 0x20000) != 0) {
                    if (toSkip == null) {
                        toSkip = new int[iMethods.length];
                    }
                    toSkip[i] = -1;
                    --total;
                    continue;
                }
                if (iClinit != -1 || (methodName = method.getSelector()).length != 8 || methodName[0] != '<') continue;
                iClinit = i;
                --total;
            }
        }
        if (total == 0) {
            this.methods = TypeConstants.NoMethods;
            return;
        }
        this.methods = new MethodBinding[total];
        if (total == initialTotal) {
            i = 0;
            while (i < initialTotal) {
                this.methods[i] = this.createMethod(iMethods[i]);
                ++i;
            }
        } else {
            i = 0;
            int index = 0;
            while (i < initialTotal) {
                if (iClinit != i && (toSkip == null || toSkip[i] != -1)) {
                    this.methods[index++] = this.createMethod(iMethods[i]);
                }
                ++i;
            }
        }
        this.modifiers |= 0x2000000;
    }

    public ReferenceBinding enclosingType() {
        if (this.enclosingType == null) {
            return null;
        }
        if (this.enclosingType instanceof UnresolvedReferenceBinding) {
            this.enclosingType = ((UnresolvedReferenceBinding)this.enclosingType).resolve(this.environment);
        }
        return this.enclosingType;
    }

    public FieldBinding[] fields() {
        int i = this.fields.length;
        while (--i >= 0) {
            this.resolveTypeFor(this.fields[i]);
        }
        return this.fields;
    }

    public MethodBinding getExactConstructor(TypeBinding[] argumentTypes) {
        int argCount = argumentTypes.length;
        int m = this.methods.length;
        block0: while (--m >= 0) {
            MethodBinding method = this.methods[m];
            if (method.selector != ConstructorDeclaration.ConstantPoolName || method.parameters.length != argCount) continue;
            this.resolveTypesFor(method);
            TypeBinding[] toMatch = method.parameters;
            int p = 0;
            while (p < argCount) {
                if (toMatch[p] != argumentTypes[p]) continue block0;
                ++p;
            }
            return method;
        }
        return null;
    }

    public MethodBinding getExactMethodBase(char[] selector, TypeBinding[] argumentTypes) {
        int argCount = argumentTypes.length;
        int selectorLength = selector.length;
        boolean foundNothing = true;
        int m = this.methods.length;
        block0: while (--m >= 0) {
            MethodBinding method = this.methods[m];
            if (method.selector.length != selectorLength || !CharOperation.prefixEquals(method.selector, selector)) continue;
            foundNothing = false;
            if (method.parameters.length != argCount) continue;
            this.resolveTypesFor(method);
            TypeBinding[] toMatch = method.parameters;
            int p = 0;
            while (p < argCount) {
                if (toMatch[p] != argumentTypes[p]) continue block0;
                ++p;
            }
            return method;
        }
        if (foundNothing) {
            if (this.isInterface()) {
                if (this.superInterfaces.length == 1) {
                    return this.superInterfaces[0].getExactMethod(selector, argumentTypes);
                }
            } else if (this.superclass != null) {
                return this.superclass.getExactMethod(selector, argumentTypes);
            }
        }
        return null;
    }

    public FieldBinding getFieldBase(char[] fieldName, boolean needResolve) {
        int fieldLength = fieldName.length;
        int f = this.fields.length;
        while (--f >= 0) {
            char[] name = this.fields[f].name;
            if (name.length != fieldLength || !CharOperation.prefixEquals(name, fieldName)) continue;
            return needResolve ? this.resolveTypeFor(this.fields[f]) : this.fields[f];
        }
        return null;
    }

    public MethodBinding[] getMethodsBase(char[] selector) {
        MethodBinding method;
        int count = 0;
        int lastIndex = -1;
        int selectorLength = selector.length;
        int m = 0;
        int length = this.methods.length;
        while (m < length) {
            method = this.methods[m];
            if (method.selector.length == selectorLength && CharOperation.prefixEquals(method.selector, selector)) {
                this.resolveTypesFor(method);
                ++count;
                lastIndex = m;
            }
            ++m;
        }
        if (count == 1) {
            return new MethodBinding[]{this.methods[lastIndex]};
        }
        if (count > 0) {
            MethodBinding[] result = new MethodBinding[count];
            count = 0;
            int m2 = 0;
            while (m2 <= lastIndex) {
                method = this.methods[m2];
                if (method.selector.length == selectorLength && CharOperation.prefixEquals(method.selector, selector)) {
                    result[count++] = method;
                }
                ++m2;
            }
            return result;
        }
        return TypeConstants.NoMethods;
    }

    public ReferenceBinding[] memberTypes() {
        int i = this.memberTypes.length;
        while (--i >= 0) {
            if (!(this.memberTypes[i] instanceof UnresolvedReferenceBinding)) continue;
            this.memberTypes[i] = ((UnresolvedReferenceBinding)this.memberTypes[i]).resolve(this.environment);
        }
        return this.memberTypes;
    }

    public MethodBinding[] methods() {
        if ((this.modifiers & 0x2000000) == 0) {
            return this.methods;
        }
        int i = this.methods.length;
        while (--i >= 0) {
            this.resolveTypesFor(this.methods[i]);
        }
        this.modifiers ^= 0x2000000;
        return this.methods;
    }

    TypeBinding resolveType(TypeBinding type) {
        if (type instanceof UnresolvedReferenceBinding) {
            return ((UnresolvedReferenceBinding)type).resolve(this.environment);
        }
        if (type instanceof ArrayBinding) {
            ArrayBinding array = (ArrayBinding)type;
            if (array.leafComponentType instanceof UnresolvedReferenceBinding) {
                array.leafComponentType = ((UnresolvedReferenceBinding)array.leafComponentType).resolve(this.environment);
            }
        }
        return type;
    }

    private FieldBinding resolveTypeFor(FieldBinding field) {
        if ((field.modifiers & 0x2000000) != 0) {
            field.type = this.resolveType(field.type);
            field.modifiers ^= 0x2000000;
        }
        return field;
    }

    public MethodBinding resolveTypesFor(MethodBinding method) {
        if ((method.modifiers & 0x2000000) == 0) {
            return method;
        }
        if (!method.isConstructor()) {
            method.returnType = this.resolveType(method.returnType);
        }
        int i = method.parameters.length;
        while (--i >= 0) {
            method.parameters[i] = this.resolveType(method.parameters[i]);
        }
        i = method.thrownExceptions.length;
        while (--i >= 0) {
            if (!(method.thrownExceptions[i] instanceof UnresolvedReferenceBinding)) continue;
            method.thrownExceptions[i] = ((UnresolvedReferenceBinding)method.thrownExceptions[i]).resolve(this.environment);
        }
        method.modifiers ^= 0x2000000;
        return method;
    }

    public ReferenceBinding superclass() {
        if (this.superclass == null) {
            return null;
        }
        if (this.superclass instanceof UnresolvedReferenceBinding) {
            this.superclass = ((UnresolvedReferenceBinding)this.superclass).resolve(this.environment);
        }
        return this.superclass;
    }

    public ReferenceBinding[] superInterfaces() {
        int i = this.superInterfaces.length;
        while (--i >= 0) {
            if (!(this.superInterfaces[i] instanceof UnresolvedReferenceBinding)) continue;
            this.superInterfaces[i] = ((UnresolvedReferenceBinding)this.superInterfaces[i]).resolve(this.environment);
        }
        return this.superInterfaces;
    }

    MethodBinding[] unResolvedMethods() {
        return this.methods;
    }

    public String toString() {
        int length;
        int i;
        String s = "";
        if (this.isDeprecated()) {
            s = String.valueOf(s) + "deprecated ";
        }
        if (this.isPublic()) {
            s = String.valueOf(s) + "public ";
        }
        if (this.isProtected()) {
            s = String.valueOf(s) + "protected ";
        }
        if (this.isPrivate()) {
            s = String.valueOf(s) + "private ";
        }
        if (this.isAbstract() && this.isClass()) {
            s = String.valueOf(s) + "abstract ";
        }
        if (this.isStatic() && this.isNestedType()) {
            s = String.valueOf(s) + "static ";
        }
        if (this.isFinal()) {
            s = String.valueOf(s) + "final ";
        }
        s = String.valueOf(s) + (this.isInterface() ? "interface " : "class ");
        s = String.valueOf(s) + (this.compoundName != null ? CharOperation.toString(this.compoundName) : "UNNAMED TYPE");
        s = String.valueOf(s) + "\n\textends ";
        s = String.valueOf(s) + (this.superclass != null ? this.superclass.debugName() : "NULL TYPE");
        if (this.superInterfaces != null) {
            if (this.superInterfaces != TypeConstants.NoSuperInterfaces) {
                s = String.valueOf(s) + "\n\timplements : ";
                i = 0;
                length = this.superInterfaces.length;
                while (i < length) {
                    if (i > 0) {
                        s = String.valueOf(s) + ", ";
                    }
                    s = String.valueOf(s) + (this.superInterfaces[i] != null ? this.superInterfaces[i].debugName() : "NULL TYPE");
                    ++i;
                }
            }
        } else {
            s = String.valueOf(s) + "NULL SUPERINTERFACES";
        }
        if (this.enclosingType != null) {
            s = String.valueOf(s) + "\n\tenclosing type : ";
            s = String.valueOf(s) + this.enclosingType.debugName();
        }
        if (this.fields != null) {
            if (this.fields != TypeConstants.NoFields) {
                s = String.valueOf(s) + "\n/*   fields   */";
                i = 0;
                length = this.fields.length;
                while (i < length) {
                    s = String.valueOf(s) + (this.fields[i] != null ? "\n" + this.fields[i].toString() : "\nNULL FIELD");
                    ++i;
                }
            }
        } else {
            s = String.valueOf(s) + "NULL FIELDS";
        }
        if (this.methods != null) {
            if (this.methods != TypeConstants.NoMethods) {
                s = String.valueOf(s) + "\n/*   methods   */";
                i = 0;
                length = this.methods.length;
                while (i < length) {
                    s = String.valueOf(s) + (this.methods[i] != null ? "\n" + this.methods[i].toString() : "\nNULL METHOD");
                    ++i;
                }
            }
        } else {
            s = String.valueOf(s) + "NULL METHODS";
        }
        if (this.memberTypes != null) {
            if (this.memberTypes != TypeConstants.NoMemberTypes) {
                s = String.valueOf(s) + "\n/*   members   */";
                i = 0;
                length = this.memberTypes.length;
                while (i < length) {
                    s = String.valueOf(s) + (this.memberTypes[i] != null ? "\n" + this.memberTypes[i].toString() : "\nNULL TYPE");
                    ++i;
                }
            }
        } else {
            s = String.valueOf(s) + "NULL MEMBER TYPES";
        }
        s = String.valueOf(s) + "\n\n\n";
        return s;
    }
}

