#include "cgi_form.h"

static const  int MAX_POST = 1024*1024;
int CgiForm::num_post_forms = 0;
int CgiForm::num_get_forms = 0;
/* This is a precaution against attacks that would falsely
 advertize a large content making the CGI allocate a huge buffer */

CgiForm::CgiForm()
 {
 }

CgiForm::~CgiForm()
 {
 }

void CgiForm::write_c_parse_assign(ofstream& os, unsigned int i)
 {
  os << " if(!strcmp(in_name, \"" << inputs[i].name <<
    "\"))" << endl;
  os << "  {" << endl;
  //os << "   " << inputs[i].name << "= in_val;" << endl;
  os << "    int i, c, on_hex = 0, char_code = 0; " << endl;
  os << "    for(i = 0; c = in_val[i]; i++) " << endl;
  os << "      {" << endl;
  os << "       switch(c)" << endl;
  os << "        {" << endl;
  os << "         case '%': on_hex = 2; break;" << endl;
  os << "         case '+': " << inputs[i].name << " += ' '; break;"
    << endl;
  os << "         default:  " << endl;
  os << "          if(on_hex) " << endl;
  os << "           {" << endl;
  os << "            int lower_c = tolower(c);" << endl;
  os << "            char_code = (char_code << 4)  + \
   ((lower_c <= '9') ? lower_c - '0' : lower_c - 'a' + 10);" << endl;
  os << "            if(!(--on_hex)) " <<
    inputs[i].name << " += char_code; break;" << endl;
  os << "           }" << endl;
  os << "           else " << endl;
  os << "           " << inputs[i].name
   << " += c; break;" << endl;

  os << "        }" << endl;
  os << "      }" << endl;
  os << "  }" << endl;

 }

void CgiForm::write_c_parse(ofstream& os)
 {
  unsigned int i;
  os << "char* tok  = strtok(parse_buf, \"&\");" << endl;
  os << "while(tok)" << endl;
  os << "{" << endl;
  os << " char* in_val = strchr(tok, '=');" << endl;
  os << " if(!in_val) return;" << endl;
  os << " *in_val++ = 0;" << endl;
  os << " char* in_name = tok;" << endl;
  os << endl;
  write_c_parse_assign(os, 0);
  for(i = 1; i < inputs.size(); i++)
   {
     os << "else " << endl;
     write_c_parse_assign(os, i);

   }
 
  os << " tok = strtok(NULL, \"&\"); " << endl;
  os << "}" << endl;
  os << " status = 1; " << endl;
 }

void CgiForm::write_c_parse_get(ofstream& os)
 {
  if(num_get_forms > 1)
   {
     os << "if(!content_buf)" << endl;
     os << " {" << endl;
     os << "  char* q_str = getenv(\"QUERY_STRING\");" << endl;
     os << "  if(!q_str) return;" << endl;
     os << "  content_buf = new char[(content_len = strlen(q_str)) + 1];" << endl;
     os << "  memcpy(content_buf, q_str, content_len);" << endl;
     os << " }" << endl;
     os << "parse_buf = new char[content_len + 1];" << endl;
     os << "memcpy(parse_buf, content_buf, content_len);" << endl;
     os << "parse_buf[content_len] = 0;" << endl;

   }
  else
   os << "parse_buf = getenv(\"QUERY_STRING\");" << endl;
 
  os << "if(!parse_buf)  return;" << endl;
  os << "if(!parse_buf[0])  return;" << endl;
  write_c_parse(os);

  if(num_get_forms > 1)
   os << " delete[] parse_buf;" << endl;
 }

void CgiForm::write_c_parse_post(ofstream& os)
 {
  // This will not properly handle two+ forms each with
  // the POST method. To be fixed later

  os << "char* content_len_str = getenv(\"CONTENT_LENGTH\");" << endl;
  os << "if(!content_len_str) return; " << endl;
  os << "content_len = atoi(content_len_str);" << endl;
  os << "if(!(content_len > 0 && content_len <= " << MAX_POST <<
   ")) return;" << endl;
 
  if(num_post_forms > 1)
   {
    os << "if(!content_buf)" << endl;
    os << " {" << endl;
    os << "  content_buf = new char[content_len + 1];" << endl; 
    os << "  cin.read(content_buf, content_len);" << endl;
    os << " }" << endl;
   }

  os << "parse_buf = new char[content_len + 1];" << endl;
 
  if(num_post_forms > 1)
   os << "memcpy(parse_buf, content_buf, content_len);" << endl;
  else
    os << "cin.read(parse_buf, content_len);" << endl;
   
  os << "parse_buf[content_len] = 0;" << endl;
  write_c_parse(os);
  os << "delete [] parse_buf; " << endl;
 }

void CgiForm::write_c(ofstream& os)
 {
  int i;
  string class_name = "Form_" + name;
  os << "class " << class_name  << endl;
  os << " {" << endl;
  os << "  public:" << endl;

  for(i = 0; i < size(); i++)
   {
    os << "    string " << inputs[i].name << ";" << endl;
   }

  os << "    int status;" << endl;
  os << " " << class_name << "();" << endl;
  os << "    operator void*() const { return (void*)status;}" << endl;

  os << " };" << endl;
  os <<  endl;

  os << class_name << " " << name << ";" << endl;

  os << class_name << "::" << class_name << "(): status(0)" << endl;
  os << "{" << endl;

  if(inputs.size())
  {
   os << "char* parse_buf;" << endl;
   strcasecmp(method.c_str(), "post") ?
    write_c_parse_get(os) : write_c_parse_post(os);
  }

  os << "}" << endl;
 }

 void CgiInput::infer_storage() const
  {
   //cerr << "infer_storage(): name = " << name << 
   // ",type = " << type << ", storage = " << storage << endl;

   if(storage.length()) return;

   if(type == "textarea")
    storage = "text not null";
   else if(type == "text")
    storage = "char(15) not null";
   else if(type == "checkbox")
    storage = "enum ('Y','N') not null";
   else if(type == "radio" || type == "select")
    {
     storage = "enum (";
     unsigned int i;
     if(!values.size())
      die("Cannot infer SQL type from the HTML for input 
       '%s' : will not create empty enum. Either fix your HTML 
       to state the values or specify the SQL type with 
       'storage' parameter", name.c_str());

     for(i = 0; i < values.size(); i++)
      {
       if(i)
        storage += ",";
       storage += "'" + values[i] + "'";
      }
     storage += ") not null";
    }
   else 
    die("Could not infer storage type for input %s - 
     please state explicitly with 'storage' parameter");

  }


 void CgiForm::add_input(const CgiInput& cgi_in, const char* val = "" )
  {
    const CgiInput* found_cgi_in = find_input(cgi_in);
    if(found_cgi_in)
     {
      if(cgi_in.storage.length())
       {
        if(!found_cgi_in->storage.length())
	   found_cgi_in->storage = cgi_in.storage;
        else if(!(found_cgi_in->storage == cgi_in.storage ))
         die("Conficting storage in form %s for input %s: '%s' and '%s'",
	    name.c_str(), cgi_in.name.c_str(), cgi_in.storage.c_str(),
	    found_cgi_in->storage.c_str());
       }
      
       if(val[0])
	found_cgi_in->values.insert(found_cgi_in->values.end(),
	 val);

      }
     else 
      {
        string str_val = val;
        if(val[0])
	 cgi_in.values.insert(cgi_in.values.end(),
	 val);
	inputs.insert(inputs.end(), cgi_in); 
      }
   }
  
 
 const CgiInput* CgiForm::find_input(const CgiInput& in) const
  {
  
    unsigned int i;
    for(i = 0; i < inputs.size(); ++i)
      {
       //cerr << "in.name = " << in.name  << " inputs[i].name = " << 
       // inputs[i].name << endl;
       if(in == inputs[i]) return &(inputs[i]);
      }
     return NULL;
  }

 int CgiForm::input_found(const CgiInput& in) const
    {
     unsigned int i;
     for(i = 0; i < inputs.size(); ++i)
      {
       //cerr << "in.name = " << in.name  << " inputs[i].name = " << 
       // inputs[i].name << endl;
       if(in == inputs[i]) return 1;
      }
     return 0;
    }
 
 void CgiForm::write_sql_drop_table(ofstream& os) const
  {
   os << "drop table " << name << ";" << endl;
  }

 void CgiForm::write_sql_create_table(ofstream& os) const
  {
   os << "create table " << name << "(" << endl;
   unsigned int i, field_num = 0;
   for(i = 0; i < inputs.size(); i++)
    {
     if(!strcasecmp(inputs[i].type.c_str(), "submit") 
       || !strcasecmp(inputs[i].type.c_str(), "reset")
       || !strcasecmp(inputs[i].storage.c_str(), "none")
       )
        continue;

     if(field_num)
      os << ',' << endl;
    
     inputs[i].infer_storage();
     inputs[i].write_sql_create(os);
     field_num++;
    }

   os << ");" << endl;
  }

 void CgiInput::write_sql_create(ofstream& os) const
  {
   os << name << " " << storage;
  }

