indexing

	description: "Setup class for TEST_FOX_AND_SQL, used to set user%
	             %options"
	date: "1999/06/00"
	copyright: "Copyright 1999 Michael Ravits"
	license: "Eiffel Forum Freeware License, version 1"
	
class SETUP

inherit
	FX_DIALOG_BOX
		rename
			make as make_dialog_box,
			Id_last as Dialog_id_last
		end
	MEMORY
		export
			{NONE} all
		redefine
			dispose
		end

creation
	make

feature  -- Initialization

	make( a : FX_APPLICATION ) is
			-- Initialize
		require
			not_void: a /= Void
		local
			b : FX_BUTTON
		do
			app := a
			
			make_dialog_box( app, "Setup" )

			install_message_handlers

			construct_widgets

			create setup_file.make( Setup_filename )

			load
		end

feature  -- Access

	hostname      : FX_TEXT_FIELD
	username      : FX_TEXT_FIELD
	password      : FX_TEXT_FIELD
	database_name : FX_TEXT_FIELD

feature  -- Basic operations

	load is
			-- Load setup from file
		require
			not_void: hostname /= Void
			not_void: username /= Void
			not_void: password /= Void
		do
			check
				not_void: setup_file /= Void
			end

			if setup_file.exists and setup_file.is_readable then
				setup_file.open_read
				
				setup_file.read_line
				hostname.set_text( setup_file.last_string )
				
				setup_file.read_line
				username.set_text( setup_file.last_string )
				
				setup_file.read_line
				password.set_text( setup_file.last_string )
				
				setup_file.read_line
				database_name.set_text( setup_file.last_string )
				
				setup_file.close
			else
				load_defaults
			end
		end

	save( data : FX_MESSAGE ) is
			-- Save setup to file
		require
			not_void: hostname /= Void
			not_void: username /= Void
			not_void: password /= Void
		do
			check
				not_void: setup_file /= Void
			end
			
			if not Setup_directory.exists then
				Setup_directory.create_dir
			end

			if Setup_directory.is_writable then
			
				if not setup_file.exists then
					setup_file.create_read_write
				else
					setup_file.open_write
				end

				if setup_file.is_writable then
					setup_file.put_string( hostname.text )
					setup_file.put_new_line
				
					setup_file.put_string( username.text )
					setup_file.put_new_line
				
					setup_file.put_string( password.text )
					setup_file.put_new_line
				
					setup_file.put_string( database_name.text )
					setup_file.put_new_line
					
					setup_file.flush

					setup_file.close
				end
			end
		end

	ok( data : FX_MESSAGE ) is
			-- Hide setup window
		do
			hide
		end

feature  -- Message Identifiers

	Id_save : INTEGER is do Result := Dialog_id_last     end
	Id_ok   : INTEGER is do Result := Dialog_id_last + 1 end
	Id_last : INTEGER is do Result := Dialog_id_last + 2 end
	
feature{NONE}  -- Implementation


	install_message_handlers is
			-- Set callbacks
		local
			cmd : FX_ROUTINE
		do
			create cmd.make( ~save )
			add_command( cmd, Id_save, 0 )

			create cmd.make( ~ok )
			add_command( cmd, Id_ok, 0 )
		end
		
	construct_widgets is
			-- Create GUI components
		local
			label       : FX_LABEL
			h_separator : FX_HORIZONTAL_SEPARATOR
			h_frame     : FX_HORIZONTAL_FRAME
			button      : FX_BUTTON
		do
			create main_frame.make_with_options( Current,
					<<Frame_sunken,
					Layout_fill_horizontally,
					Layout_fill_vertically,
					Layout_top,
					Layout_left>> )

			create label.make_with_options( main_frame,
					Main_frame_label,
					<<Justify_center_horizontally,
					Layout_fill_horizontally>> )
			
			create h_separator.make_with_options( main_frame,
					<<Separator_groove,
					Layout_fill_horizontally>> )
			
			create h_frame.make_with_options( main_frame,
					<<Layout_side_top,
					Layout_fill_horizontally,
					Layout_fill_vertically>> )
			
			create label.make_with_options( h_frame,
					Hostname_input_label,
					<<Justify_center_horizontally,
					Layout_fill_horizontally>> )
			
			create hostname.make_with_options( h_frame,
					20,
					<<Justify_left,
					Frame_sunken,
					Frame_thick,
					Layout_side_top,
					Layout_fill_horizontally>> )

			create h_frame.make_with_options( main_frame,
					<<Layout_side_top,
					Layout_fill_horizontally,
					Layout_fill_vertically>> )
			
			create label.make_with_options( h_frame,
					Username_input_label,
					<<Justify_center_horizontally,
					Layout_fill_horizontally>> )
			
			create username.make_with_options( h_frame,
					20,
					<<Justify_left,
					Frame_sunken,
					Frame_thick,
					Layout_side_top,
					Layout_fill_horizontally>> )

			create h_frame.make_with_options( main_frame,
					<<Layout_side_top,
					Layout_fill_horizontally,
					Layout_fill_vertically>> )
			
			create label.make_with_options( h_frame,
					Password_input_label,
					<<Justify_center_horizontally,
					Layout_fill_horizontally>> )
			
			create password.make_with_options( h_frame,
					20,
					<<Justify_left,
					Frame_sunken,
					Frame_thick,
					Layout_side_top,
					Layout_fill_horizontally>> )
			
			create h_frame.make_with_options( main_frame,
					<<Layout_side_top,
					Layout_fill_horizontally,
					Layout_fill_vertically>> )
			
			create label.make_with_options( h_frame,
					Database_name_input_label,
					<<Justify_center_horizontally,
					Layout_fill_horizontally>> )
			
			create database_name.make_with_options( h_frame,
					20,
					<<Justify_left,
					Frame_sunken,
					Frame_thick,
					Layout_side_top,
					Layout_fill_horizontally>> )
					
			create h_separator.make_with_options( main_frame,
					<<Separator_groove,
					Layout_fill_horizontally>> )
			
			create h_frame.make_with_options( main_frame,
					<<Layout_side_top,
					Layout_fill_horizontally,
					Layout_fill_vertically>> )
					
			create button.make_with_options( h_frame,
					Apply_button_label,
					<<Frame_thick,
					Frame_raised,
					Layout_fill_horizontally,
					Layout_top,
					Layout_left>> )
					
			create button.make_with_options( h_frame,
					Save_button_label,
					<<Frame_thick,
					Frame_raised,
					Layout_fill_horizontally,
					Layout_top,
					Layout_left>> )

			button.relay_messages( Current, Id_save )
					
			create button.make_with_options( h_frame,
					Ok_button_label,
					<<Frame_thick,
					Frame_raised,
					Layout_fill_horizontally,
					Layout_top,
					Layout_left>> )

			button.relay_messages( Current, Id_ok )
		end

	load_defaults is
			-- Load stup default values
		do 
		end

	dispose is
		do
			send_message( Current, Msg_command, Id_save )
		end

	Setup_filename : STRING is
			-- Name of setup file
		local
			env : EXECUTION_ENVIRONMENT
		once
			create env
			
			Result := env.home_directory_name

			Result.append( "/.fox+sql/setup" )
		end
	
	Setup_directory : DIRECTORY is
			-- Directory where setup file is stored
		local
			env : EXECUTION_ENVIRONMENT
			s   : STRING
		once
			create env
			s := env.home_directory_name
			s.append( "/.fox+sql" )
			
			create Result.make( s )
		end

feature{NONE}  -- Implementation

	app        : FX_APPLICATION
	setup_file : PLAIN_TEXT_FILE
	main_frame : FX_VERTICAL_FRAME

	Main_frame_label          : STRING is "Application setup"
	Hostname_input_label      : STRING is "Hostname"
	Username_input_label      : STRING is "Username"
	Password_input_label      : STRING is "Password"
	Database_name_input_label : STRING is "Database"
	Apply_button_label        : STRING is "&Apply"
	Save_button_label         : STRING is "&Save"
	Ok_button_label           : STRING is "&Ok"
	
end -- class SETUP
