/*
 * Decompiled with CFR 0.152.
 */
package com.ice.sqlclient;

import com.ice.sqlclient.MainPanel;
import com.ice.sqlclient.SQLClientHandler;
import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.ButtonGroup;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JMenu;
import com.sun.java.swing.JMenuBar;
import com.sun.java.swing.JMenuItem;
import com.sun.java.swing.JRadioButtonMenuItem;
import com.sun.java.swing.KeyStroke;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.UnsupportedLookAndFeelException;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;

public class MainFrame
extends JFrame
implements ActionListener {
    private static MainFrame instance;
    private JMenu dbMenu;
    private JMenuBar menuBar;
    private MainPanel mainPanel;

    public static void hideDatabaseMenu() {
        MainFrame.instance.menuBar.remove(MainFrame.instance.menuBar.getComponentIndex((Component)MainFrame.instance.dbMenu));
        ((Container)((Object)instance)).invalidate();
        ((Container)((Object)instance)).validate();
        ((Component)((Object)instance)).repaint();
    }

    public static void showDatabaseMenu(String[] stringArray, String string) {
        MainFrame.instance.dbMenu.removeAll();
        ButtonGroup buttonGroup = new ButtonGroup();
        int n = 0;
        while (n < stringArray.length) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(stringArray[n]);
            if (string != null) {
                if (string.equals(stringArray[n])) {
                    jRadioButtonMenuItem.setSelected(true);
                } else {
                    jRadioButtonMenuItem.setSelected(false);
                }
            }
            jRadioButtonMenuItem.addActionListener((ActionListener)instance);
            jRadioButtonMenuItem.setActionCommand("NEWDB:" + stringArray[n]);
            buttonGroup.add((AbstractButton)jRadioButtonMenuItem);
            MainFrame.instance.dbMenu.add((JMenuItem)jRadioButtonMenuItem);
            ++n;
        }
        MainFrame.instance.menuBar.add(MainFrame.instance.dbMenu);
        ((Container)((Object)instance)).invalidate();
        ((Container)((Object)instance)).validate();
        ((Component)((Object)instance)).repaint();
    }

    public MainFrame(String string) {
        super(string);
        instance = this;
        this.mainPanel = new MainPanel();
        this.getContentPane().add((Component)((Object)this.mainPanel));
        this.establishMenuBar();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("QUIT")) {
            System.exit(0);
            return;
        }
        if (string.startsWith("NEWDB:")) {
            String string2 = string.substring(6);
            this.changeDatabase(string2);
            return;
        }
        if (string.startsWith("PLAF:")) {
            String string3 = string.substring(5);
            this.changeLookAndFeel(string3);
            return;
        }
        System.err.println("UNKNOWN Command '" + string + "'");
    }

    private boolean changeDatabase(String string) {
        boolean bl = true;
        SQLClientHandler sQLClientHandler = SQLClientHandler.getCurrentHandler();
        if (sQLClientHandler == null) {
            this.showMessage("INTERNAL ERROR: current handler is null.");
            return false;
        }
        if (!sQLClientHandler.isOpen()) {
            this.showMessage("INTERNAL ERROR: connection is not open.");
            return false;
        }
        try {
            sQLClientHandler.setCurrentDatabase(string);
            this.mainPanel.dbHasChanged(string);
            this.showMessage("Database changed to '" + string + "'");
        }
        catch (SQLException sQLException) {
            bl = false;
            this.showMessage("SQLException: changing database to '" + string + "':\n" + sQLException.getMessage());
        }
        return bl;
    }

    private void changeLookAndFeel(String string) {
        int n = string.lastIndexOf(string);
        String string2 = n < 0 ? string : string.substring(n + 1);
        try {
            UIManager.setLookAndFeel((String)string);
            SwingUtilities.updateComponentTreeUI((Component)this.getRootPane());
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            this.lookAndFeelExMessage(string2, string, illegalAccessException.getMessage(), "could not be accessed");
            return;
        }
        catch (InstantiationException instantiationException) {
            this.lookAndFeelExMessage(string2, string, instantiationException.getMessage(), "could not be instantiated");
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.lookAndFeelExMessage(string2, string, classNotFoundException.getMessage(), "could not be located");
            return;
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            this.lookAndFeelExMessage(string2, string, unsupportedLookAndFeelException.getMessage(), "is not supported on this platform");
            return;
        }
    }

    private void showMessage(String string) {
        System.err.println(string);
    }

    private void lookAndFeelExMessage(String string, String string2, String string3, String string4) {
        System.err.println("Look and feel '" + string + "' " + string4 + ".");
        if (string3.length() > 0) {
            System.err.println("\t" + string3);
        }
    }

    private void createDBMenu() {
        this.dbMenu = new JMenu("DB");
    }

    private void establishMenuBar() {
        this.menuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        this.menuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Quit");
        jMenuItem.addActionListener((ActionListener)this);
        jMenuItem.setActionCommand("QUIT");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke((int)81, (int)2));
        jMenu.add(jMenuItem);
        this.addLookAndFeelMenu(this.menuBar);
        this.createDBMenu();
        this.setJMenuBar(this.menuBar);
    }

    private void addLookAndFeelMenu(JMenuBar jMenuBar) {
        JMenu jMenu = new JMenu("Look");
        jMenuBar.add(jMenu);
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        int n = 0;
        while (n < lookAndFeelInfoArray.length) {
            JMenuItem jMenuItem = new JMenuItem(lookAndFeelInfoArray[n].getName());
            jMenuItem.addActionListener((ActionListener)this);
            jMenuItem.setActionCommand("PLAF:" + lookAndFeelInfoArray[n].getClassName());
            jMenu.add(jMenuItem);
            ++n;
        }
    }
}

