/*
** Copyright (c) 1998 by Timothy Gerard Endres
** <mailto:time@ice.com>  <http://www.ice.com>
** 
** This program is free software.
** 
** You may redistribute it and/or modify it under the terms of the GNU
** General Public License as published by the Free Software Foundation.
** Version 2 of the license should be included with this distribution in
** the file LICENSE, as well as License.html. If the license is not
** included	with this distribution, you may find a copy at the FSF web
** site at 'www.gnu.org' or 'www.fsf.org', or you may write to the
** Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139 USA.
**
** THIS SOFTWARE IS PROVIDED AS-IS WITHOUT WARRANTY OF ANY KIND,
** NOT EVEN THE IMPLIED WARRANTY OF MERCHANTABILITY. THE AUTHOR
** OF THIS SOFTWARE, ASSUMES _NO_ RESPONSIBILITY FOR ANY
** CONSEQUENCE RESULTING FROM THE USE, MODIFICATION, OR
** REDISTRIBUTION OF THIS SOFTWARE. 
** 
*/

/**
 * An adaptor, transforming the JDBC interface
 * to the TableModel interface.
 *
 */

package com.ice.sqlclient;

import java.sql.*;
import java.util.Vector;
import com.sun.java.swing.event.TableModelEvent; 
import com.sun.java.swing.table.AbstractTableModel; 

import com.ice.util.StringUtilities; 


public class
ErrMsgAdapter extends AbstractTableModel
	{
	private Vector		msgLines = new Vector();

	public
	ErrMsgAdapter( String message )
		{
		this.setMessage( message );
		}

	public void
	fireTableUpdate()
		{
		super.fireTableChanged( null );
		}

	public void
	setMessage( String message )
		{
		String[] lines =
			StringUtilities.splitString( message, "\n" );

		this.msgLines = new Vector( lines.length );
		this.msgLines.setSize(lines.length );

		for ( int i = 0 ; i < lines.length ; ++i )
			{
			this.msgLines.setElementAt( lines[i], i );
			}

		this.fireTableChanged( null );
		}

    ////////////////////////////////////////////////////////////////////
    //
    //         Implementation of the TableModel Interface
    //
    ////////////////////////////////////////////////////////////////////

	//
    // M E T A    D A T A
	//

    public String
	getColumnName( int colIdx )
		{
		if ( colIdx != 1 )
			return "";

		return "Error Message";
		}

    public Class
	getColumnClass( int colIdx )
		{
		if ( colIdx != 1 )
			return Object.class;

		return String.class;
		}

    public boolean
	isCellEditable( int row, int colIdx )
		{
		return false;
		}

    public int
	getColumnCount()
		{
        return 1; 
		}

	//
    // D A T A    M E T H O D S
	//

    public int
	getRowCount()
		{
		return this.msgLines.size();
		}

    public Object
	getValueAt( int aRow, int aColumn )
		{
		return this.msgLines.elementAt( aRow );
		}

    public void
	setValueAt( Object value, int row, int colIdx )
		{
		}

	}
