package zxk.util;

public class testGetOpt
{
  public static void main (String[] args)
  {
    int c;
    int digit_optind = 0;
    int optind = 0;
    String[] loptName = new String[6];
    loptName[0] = new String("add");
    loptName[1] = new String("append");
    loptName[2] = new String("delete");
    loptName[3] = new String("verbose");
    loptName[4] = new String("create");
    loptName[5] = new String("file");
    int[] loptHasArg = new int[6];
    loptHasArg[0] = GetOpt.REQ_ARG;
    loptHasArg[1] = GetOpt.REQ_ARG;
    loptHasArg[2] = GetOpt.REQ_ARG;
    loptHasArg[3] = GetOpt.NO_ARG;
    loptHasArg[4] = GetOpt.REQ_ARG;
    loptHasArg[5] = GetOpt.OPT_ARG;
    int[] loptValue = new int[6];
    loptValue[0] = 0;
    loptValue[1] = 0;
    loptValue[2] = 0;
    loptValue[3] = 0;
    loptValue[4] = 0;
    loptValue[5] = 0;

    GetOpt g = new GetOpt();
    g.setInputArgs(args);
    g.setShortOption("abc:d::0123456789");
    g.setLongOptionName(loptName);
    g.setLongOptionHasArg(loptHasArg);
    g.setLongOptionValue(loptValue);
    g.setOptionMode(GetOpt.LONG_OPT);

    try
    {
      while (true)
      {
        c = g.getopt();
        optind = g.getOptind();
        int this_option_optind = optind;
        int option_index = g.getLongind();

        if (c == GetOpt.EOF)
  	  break;

        switch (c)
	{
	  case 0:
	    System.out.print ("option " + loptName[option_index]);
	    if (g.getOptarg() != null)
	      System.out.print (" with arg " + g.getOptarg());
	    else
	    {
	      if (loptName[option_index].equals("file"))
	        System.out.println("\nInput file name from tty...");
	    }
	    System.out.println ("");
	    break;

	  case '0':
	  case '1':
	  case '2':
	  case '3':
  	  case '4':
	  case '5':
	  case '6':
	  case '7':
	  case '8':
	  case '9':
	    if (digit_optind != 0 && digit_optind != this_option_optind)
	      System.out.println ("digits occur in two different argv-elements.");
	    digit_optind = this_option_optind;
	    System.out.println ("option " + c);
	    break;

	  case 'a':
	    System.out.println ("option a");
	    break;

	  case 'b':
	    System.out.println ("option b");
	    break;

	  case 'c':
	    System.out.println ("option c with value `" + g.getOptarg() + "'");
	    break;

	  case 'd':
	    System.out.println ("option d with value `" + g.getOptarg() + "'");
	    break;

	  case '?':
	    break;

	  default:
	    System.out.println ("?? getopt returned character code " + c + " ??");
	}
      }
    }
    catch (GetOptException e)
    {
      System.out.println(e.getMessage());
    }

    optind = g.getOptind();
    if (optind < args.length)
    {
      System.out.println ("non-option ARGV-elements: ");
      while (optind < args.length)
	System.out.print (args[optind++] + " ");
      System.out.println ("");
    }

  if ( args.length == 0)
    System.out.println("Usage: GetOpt -a -b -c xxx -d [xxx] -0123456789" + 
    "--add=xxx --delete=xxx --append=xxx --verbose --create=xxx --file=[xxx]");
    System.exit (0);
}
}
