#include "Connection.h"

Connection::Connection(ISqlServer *_sql, const char *pluginPath, const char *pluginName, const char *host, const char *login, const char *passwd)
  : login(strdup(login)), passwd(strdup(passwd)), host(strdup(host)), _sql(_sql), pluginName(pluginName), pluginPath(pluginPath)
  {
  }

Connection::~Connection(void)
  {
  if(_sql)
    delete _sql;
  }

ISqlServer *Connection::sql(void) const
  {
  return _sql;
  }

QString Connection::getName(void) const
  {
  QString res = login;
  res += "@";
  res += host;
	res += " (";
	res += pluginName;
	res += ")";
  return res;
  }

QueryResult Connection::connect(void)
  {
  return _sql->connect(host, login, passwd);
  }
