#include "DialogAddServer.h"

#define Inherited DialogAddServerData

DialogAddServer::DialogAddServer(PluginManager *pm, QWidget* parent, const char* name)
	:	Inherited( parent, name )
	{
	setCaption( "Add server..." );
	pluginManager = pm;
	QStrList *pluginNames = pm->getPluginNames();
	stype->clear();
	stype->insertStrList(pluginNames);
	delete pluginNames;
	}


DialogAddServer::~DialogAddServer(void)
	{
	}

Connection *DialogAddServer::result(void)
	{
	int id = pluginManager->getPluginByName(stype->text(stype->currentItem()));
	ISqlServer *sql = pluginManager->createInstance(id);
	const char *pname = pluginManager->getPluginName(id);
	const char *ppath = pluginManager->getPluginPath(id);
	return new Connection(sql, ppath, pname, host->text(), login->text(), passwd->text());
	}

