#include "DialogInput.h"

#define Inherited DialogInputData

DialogInput::DialogInput(QWidget* parent,const char* name)
  : Inherited( parent, name )
  {
  setCaption( "Caption" );
  }


DialogInput::~DialogInput()
  {
  }

void DialogInput::ok(void)
  {
  QString text = edit->text();
  if(text.isEmpty())
    QMessageBox::warning(this, "Error", "Please enter a value");
  else
    done(1);
  }

void DialogInput::cancel(void)
  {
  done(0);
  }

QString DialogInput::getText(void)
  {
  return edit->text();
  }

void DialogInput::setMessage(QString str)
  {
  message->setText(str);
  }
