#include "DialogModules.h"

#define Inherited DialogModulesData

DialogModules::DialogModules(PluginManager *aPluginManager, QWidget* parent, const char *name)
	:	Inherited(parent, name)
	{
	pluginManager = aPluginManager;
	setCaption( "Modules..." );
	connect(btnAdd, SIGNAL(clicked()), this, SLOT(addModule()));
	connect(btnInfo, SIGNAL(clicked()), this, SLOT(moduleInfo()));
	QStrList *names = pluginManager->getPluginNames();
	modules->insertStrList(names);
	delete names;
	}

	
DialogModules::~DialogModules()
	{
	}

	
void DialogModules::addModule(void)
	{
	KFileDialog *filedlg = new KFileDialog(0, 0, this, 0, true, false);
  if(filedlg->exec())
    {
    QString filename = filedlg->selectedFile();
    int id = pluginManager->registerPlugin(filename);
		modules->insertItem(pluginManager->getPluginName(id));
		//warning("%d, %s", id, pluginManager->getPluginName(id));
    }
  delete filedlg;
	}


void DialogModules::moduleInfo(void)
	{
	QString name = modules->text(modules->currentItem());
	if(!name.isEmpty())
		{
		int id = pluginManager->getPluginByName(name);
		QString info = pluginManager->getPluginInfo(id);
		QString path = pluginManager->getPluginPath(id);
		//QMessageBox::information(this, name, info);		
		DialogModuleInfo *dlg = new DialogModuleInfo(this);
		dlg->setInfo(name, path, id, info);
		dlg->exec();
		delete dlg;
		}
	}





