#include "DialogSelectBase.h"

#define Inherited DialogSelectBaseData

DialogSelectBase::DialogSelectBase(QWidget* parent, const char* name)
	: Inherited( parent, name )
  {
  setCaption( "Select database" );
  connect(btn_ok, SIGNAL(clicked()), SLOT(ok()));
  connect(btn_cancel, SIGNAL(clicked()), SLOT(cancel()));
  connect(btn_list, SIGNAL(clicked()), SLOT(list()));
  }

DialogSelectBase::~DialogSelectBase()
  {
  }

void DialogSelectBase::ok(void)
  {
  done(1);
  }

void DialogSelectBase::cancel(void)
  {
  done(0);
  }

void DialogSelectBase::list(void)
  {
  DialogBaseList dlg(this);
  dlg.setBaseList(baselist);
  if(dlg.exec())
    {
    basename->setText(dlg.getResult());
    }
  }

void DialogSelectBase::setBaseList(QStrList list)
  {
  baselist = list;
  }

const char *DialogSelectBase::getResult(void)
  {
  return basename->text();
  }

void DialogSelectBase::setField(QString s)
  {
  basename->setText(s);
  }
