#include "DialogTableField.h"

#define Inherited DialogTableFieldData

// 0 : none
// 1 : int
// 2 : double
int oValidator[] = { 1, 1, 1, 1, 1,
										 1, 2, 2, 2, 2, 
										 2, 0, 0, 0, 0, 
										 0, 0, 0, 0, 0, 
										 0, 0, 0, 0 };

bool oLength[] = { true, true, true, true, true, 
									 true, true, true, true, true, 
									 true, true, true, false, false,
									 false, false, false, false, false, 
									 false, false, false, false };

bool oLengthRequired[] = { false, false, false, false, false,
	  	                   false, false, false, false, false,
      			             false, true, true, false, false, 
            			       false, false, false, false, false,
                  			 false, false, false, false };

bool oDecimals[] = { false, false, false, false, false, 
										false, true, true, true, true,
										true, false, false, false, false,
										false, false, false, false, false,
										false, false, false, false };

bool oUnsigned[] = { true, true, true, true, true, 
										 true, true, true, true, true,
										 true, false, false, false, false,
										 false, false, false, false, false,
										 false, false, false, false };

bool oZeroFill[] = { true, true, true, true, true, 
										 true, true, true, true, true,
										 true, false, false, false, false,
										 false, false, false, false, false,
										 false, false, false, false };

bool oBinary[] = { false, false, false, false, false,
                   false, false, false, false, false,
                   false, true, true, false, false, 
                   false, false, false, false, false,
                   false, false, false, false };

DialogTableField::DialogTableField(QWidget* parent, const char* name)
  : Inherited( parent, name )
  {
  setCaption( "Table field" );
  intValidator = new QIntValidator(this);
  doubleValidator = new QDoubleValidator(this);
  btngroup->setFrameStyle(QFrame::NoFrame);
  initFields();
  }

void DialogTableField::initFields(void)
  {
  specLength->setChecked(false);
  length->setEnabled(false);
  length->setValue(1);
  specDefaultValue->setChecked(false);
  defaultValue->setEnabled(false);
  defaultValue->setText("");
  fieldName->setText("");
  fieldType->setCurrentItem(0);
  autoIncrement->setChecked(false);
  canNull->setChecked(true);
  cantNull->setChecked(false);
  typeChanged(0);
  }


DialogTableField::~DialogTableField()
  {
  }

void DialogTableField::ok(void)
	{
	if(QString(fieldName->text()).isEmpty())
	  QMessageBox::critical(this, "Table field", "Please give a name to this field");
	else
		done(1);
	}

void DialogTableField::typeChanged(int i)
  {
  specLength->setEnabled(oLength[i]);
  if(oLengthRequired[i])
  	{
  	specLength->setChecked(true);
  	specLength->setEnabled(false);
  	length->setEnabled(true);
  	}
  specLengthChanged();
  isUnsigned->setEnabled(oUnsigned[i]);
  zeroFill->setEnabled(oZeroFill[i]);
  binary->setEnabled(oBinary[i]);
  if(oValidator[i] == 0)
    defaultValue->setValidator(0);
  else if(oValidator[i] == 1)
  	defaultValue->setValidator(intValidator);
  else if(oValidator[i] == 2)
  	defaultValue->setValidator(doubleValidator);
	defaultValue->setText("");
  }

void DialogTableField::specLengthChanged(void)
  {
  length->setEnabled(specLength->isChecked());
	if(oDecimals[fieldType->currentItem()])
  	decimals->setEnabled(specLength->isChecked());
  else
  	decimals->setEnabled(false);
  }

void DialogTableField::specDefaultValueChanged(void)
  {
  defaultValue->setEnabled(specDefaultValue->isChecked());
  }

TableField *DialogTableField::result(void)
  {
  TableField *res = new TableField;
  res->name = fieldName->text();
  res->type = fieldType->currentText();
  res->specLength = length->isEnabled();
  res->length = length->value();
  res->specDecimals = decimals->isEnabled();
  res->decimals = decimals->value();
  res->specDefaultValue = specDefaultValue->isChecked();
  res->defaultValue = defaultValue->text();
  res->autoIncrement = autoIncrement->isChecked();
  res->canNull = canNull->isChecked();
  res->binary = binary->isEnabled() && binary->isChecked();
  res->zeroFill = zeroFill->isEnabled() && zeroFill->isChecked();
  res->isUnsigned = isUnsigned->isEnabled() && isUnsigned->isChecked();
  res->isKey = isKey->isChecked();
  return res;
  }
