#ifndef DialogTableField_included
#define DialogTableField_included

#include <qstring.h>
#include <qvalidator.h>
#include <qmessagebox.h>
#include "DialogTableFieldData.h"


struct TableField
  {
    QString name;
   	QString defaultValue;
    QString type;
    bool specDefaultValue;
    bool specLength;
    bool specDecimals;
    bool canNull;
    bool autoIncrement;
    int length;
    int decimals;
    bool binary;
    bool isUnsigned;
    bool zeroFill;
    bool isKey;    
  };

class DialogTableField : public DialogTableFieldData
  {
    Q_OBJECT
  public:
    DialogTableField(QWidget* parent = NULL, const char* name = NULL);
    virtual ~DialogTableField();
    TableField *result(void);
  private:
    void initFields(void);
  private slots:
    void typeChanged(int);
    void specLengthChanged();
    void specDefaultValueChanged();
    void ok(void);
  private:
  	QIntValidator *intValidator;
  	QDoubleValidator *doubleValidator;
  };

#endif 
